/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.basedata.ncm.CostCenterOrgUnitGroupInfo;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.IExpense;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.AllocStdSetByCCOCollection;
import com.kingdee.eas.ncm.bill.AllocStdSetByCCOFactory;
import com.kingdee.eas.ncm.bill.AllocStdSetByCCOInfo;
import com.kingdee.eas.ncm.bill.IAllocStdSetByCCO;
import com.kingdee.eas.ncm.common.AllocStdSetModeByCCOEnum;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class AllocStdSetByCCODataImport
extends AbstractNCMDataImport {
    private CompanyOrgUnitInfo company = null;
    private CtrlUnitInfo cu = null;
    private PeriodInfo period = null;
    private AllocStdSetModeByCCOEnum setMode = AllocStdSetModeByCCOEnum.SetByCCGroup;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AllocStdSetByCCOFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsDataBlock, Context ctx) throws TaskExternalException {
        AllocStdSetByCCOInfo allocStdSetByCCOInfo = null;
        try {
            this.initOrgUnit(ctx);
            allocStdSetByCCOInfo = this.parseData(hsDataBlock, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return allocStdSetByCCOInfo;
    }

    private AllocStdSetByCCOInfo parseData(Hashtable hsData, Context ctx) throws BOSException {
        AllocStdSetByCCOInfo allocStdSetByCCOInfo = new AllocStdSetByCCOInfo();
        allocStdSetByCCOInfo.setId(BOSUuid.create((BOSObjectType)allocStdSetByCCOInfo.getBOSType()));
        allocStdSetByCCOInfo.setCompany(this.company);
        allocStdSetByCCOInfo.setCalculatePeriod(this.period);
        Object data = this.getData(hsData, "Expense");
        if (data != null && data.toString().trim().length() > 0) {
            try {
                IExpense iExpense = ExpenseFactory.getLocalInstance((Context)ctx);
                FilterInfo dfilter = iExpense.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()), "id", "CU.id");
                allocStdSetByCCOInfo.setExpense(NCMDataImportUtil.getExpenseByNumber((Context)ctx, (String)this.getResource("EXPENSE_NUMBER", ctx), (String)data.toString(), (FilterInfo)dfilter));
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        if (this.setMode == AllocStdSetModeByCCOEnum.SetByCCGroup && (data = this.getData(hsData, "CostCenterGroup")) != null && data.toString().trim().length() > 0) {
            allocStdSetByCCOInfo.setCostCenterGroup(NCMDataImportUtil.getCostCenterGroupbyNumber((Context)ctx, (String)this.getResource("COSTCENTERGROUP_NUMBER", ctx), (String)data.toString(), (String)this.company.getId().toString()));
        }
        if ((data = this.getData(hsData, "AllocStd")) != null && data.toString().trim().length() > 0) {
            allocStdSetByCCOInfo.setAllocStd(NCMDataImportUtil.getAllocStdByNumber((Context)ctx, (String)this.getResource("AllOCSTD_NUMBER", ctx), (String)data.toString()));
        }
        this.checkData(ctx, allocStdSetByCCOInfo);
        return allocStdSetByCCOInfo;
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.cu == null || this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
            if (this.period == null) {
                try {
                    this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        if (this.company != null) {
            this.setMode = NCMUtils.getAllocStdSetModeByCCO((Context)ctx, (String)this.company.getId().toString());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        AllocStdSetByCCOInfo allocStdSetByCCOInfo = null;
        if (coreBaseInfo instanceof AllocStdSetByCCOInfo) {
            allocStdSetByCCOInfo = (AllocStdSetByCCOInfo)coreBaseInfo;
        }
        if (allocStdSetByCCOInfo == null) {
            return;
        }
        ArrayList<CoreBaseInfo> addObjList = new ArrayList<CoreBaseInfo>();
        HashMap<String, String> updateObjects = new HashMap<String, String>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this.period.getId().toString()));
        if (this.setMode == AllocStdSetModeByCCOEnum.SetByCCGroup) {
            filter.getFilterItems().add(new FilterItemInfo("costCenterGroup.id", (Object)allocStdSetByCCOInfo.getCostCenterGroup().getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("expense.id", (Object)allocStdSetByCCOInfo.getExpense().getId().toString()));
        EntityViewInfo eviData = new EntityViewInfo();
        eviData.setFilter(filter);
        try {
            IAllocStdSetByCCO coreBase = (IAllocStdSetByCCO)this.getController(ctx);
            AllocStdSetByCCOCollection collection = coreBase.getAllocStdSetByCCOCollection(eviData);
            String allocStdInfo = "";
            if (allocStdSetByCCOInfo.getAllocStd() != null) {
                allocStdInfo = allocStdSetByCCOInfo.getAllocStd().getId().toString();
            }
            if (collection.size() != 0 && this.isSltImportUpdate()) {
                AllocStdSetByCCOInfo Info = collection.get(0);
                updateObjects.put(Info.getId().toString(), allocStdInfo);
            } else if (!this.isSltImportUpdate()) {
                addObjList.add(coreBaseInfo);
            } else if (collection.size() == 0 && this.isSltImportUpdate()) {
                addObjList.add(coreBaseInfo);
            }
            HashMap<String, AllocStdSetModeByCCOEnum> paramEx = new HashMap<String, AllocStdSetModeByCCOEnum>();
            paramEx.put("SetMode", this.setMode);
            coreBase.updateAllocStdSetting(updateObjects, new ArrayList(), addObjList, paramEx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
        AllocStdSetModeByCCOEnum theSetMode = null;
        try {
            theSetMode = NCMUtils.getAllocStdSetModeByCCO((Context)ctx, (String)context.getCurrentCompany().getId().toString());
        }
        catch (BOSException e1) {
            throw new TaskExternalException("\u8bfb\u53d6\u53c2\u6570\u5931\u8d25", (Throwable)e1);
        }
        try {
            String allocStd = "";
            String allocStdName = "";
            if (rs.getString("AllocStd.number") != null) {
                allocStd = rs.getString("AllocStd.number");
            }
            if (rs.getString("AllocStd.name") != null) {
                allocStdName = rs.getString("AllocStd.name");
            }
            result.put("Expense", rs.getString("expense.number"));
            result.put("ExpenseName", rs.getString("expense.name"));
            if (theSetMode == AllocStdSetModeByCCOEnum.SetByCCGroup) {
                result.put("CostCenterGroup", rs.getString("CostCenterGroup.number"));
                result.put("CostCenterGroupName", rs.getString("CostCenterGroup.name"));
            }
            result.put("AllocStd", allocStd);
            result.put("AllocStdName", allocStdName);
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void checkData(Context ctx, AllocStdSetByCCOInfo allocStdSetByCCOInfo) throws BOSException {
        this.checkExpense(ctx, allocStdSetByCCOInfo);
        if (this.setMode == AllocStdSetModeByCCOEnum.SetByCCGroup) {
            this.checkCostCenterGroup(ctx, allocStdSetByCCOInfo);
        }
        this.checkAllocStd(ctx, allocStdSetByCCOInfo);
    }

    private void checkExpense(Context ctx, AllocStdSetByCCOInfo allocStdSetByCCOInfo) throws BOSException {
        ExpenseInfo expense = allocStdSetByCCOInfo.getExpense();
        if (expense == null) {
            throw new BOSException(this.getResource("EXPENSE_CHECK_ISEMPTY", ctx));
        }
        NCMDataImportUtil.checkDataBaseDPermission((Context)ctx, (String)this.cu.getId().toString(), (String)expense.getCU().getId().toString(), (String)"4A255827", (String)expense.getId().toString(), (String)expense.getNumber(), (String)this.getResource("EXPENSE", ctx));
    }

    private void checkCostCenterGroup(Context ctx, AllocStdSetByCCOInfo allocStdSetByCCOInfo) throws BOSException {
        CostCenterOrgUnitGroupInfo costCenterOrgInfo = allocStdSetByCCOInfo.getCostCenterGroup();
        if (costCenterOrgInfo == null) {
            throw new BOSException(this.getResource("COSTCENTERGROUP_CHECK_ISEMPTY", ctx));
        }
        String costCenterOrgCompId = costCenterOrgInfo.getCompanyOrgUnit().getId().toString();
        String companyId = this.company.getId().toString();
        if (!companyId.equals(costCenterOrgCompId)) {
            throw new BOSException(costCenterOrgInfo.getNumber() + this.getResource("COSTCENTERGROUP_CHECK_CU", ctx));
        }
    }

    private void checkAllocStd(Context ctx, AllocStdSetByCCOInfo allocStdSetByCCOInfo) throws BOSException {
        AllocStdInfo allocStdInfo = allocStdSetByCCOInfo.getAllocStd();
        if (allocStdInfo == null) {
            return;
        }
        AllocStdTypeEnum allocStdType = allocStdInfo.getAllocStdType();
        if (!allocStdType.equals((Object)AllocStdTypeEnum.INNERCC)) {
            throw new BOSException(allocStdInfo.getNumber() + this.getResource("ALLOCSTD_CHECK_BY_CCO", ctx));
        }
    }
}

