/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.AllocStdSetByClassCollection;
import com.kingdee.eas.ncm.bill.AllocStdSetByClassFactory;
import com.kingdee.eas.ncm.bill.AllocStdSetByClassInfo;
import com.kingdee.eas.ncm.bill.IAllocStdSetByClass;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class AllocStdSetByClassDataImport
extends AbstractNCMDataImport {
    private CompanyOrgUnitInfo company = null;
    private CtrlUnitInfo cu = null;
    private PeriodInfo period = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AllocStdSetByClassFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        AllocStdSetByClassInfo allocStdSetByClassInfo = null;
        try {
            this.initOrgUnit(ctx);
            allocStdSetByClassInfo = this.parseData(hsData, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return allocStdSetByClassInfo;
    }

    private AllocStdSetByClassInfo parseData(Hashtable hsData, Context ctx) throws BOSException {
        AllocStdSetByClassInfo allocStdSetByClassInfo = new AllocStdSetByClassInfo();
        allocStdSetByClassInfo.setId(BOSUuid.create((BOSObjectType)allocStdSetByClassInfo.getBOSType()));
        allocStdSetByClassInfo.setCompany(this.company);
        allocStdSetByClassInfo.setCalculatePeriod(this.period);
        Object data = this.getData(hsData, "CostObject");
        if (data != null && data.toString().trim().length() > 0) {
            allocStdSetByClassInfo.setCostObject(NCMDataImportUtil.getCostObjectbyNumber((Context)ctx, (String)this.getResource("COSTOBJECT_NUMBER", ctx), (String)data.toString(), (String)this.company.getId().toString()));
        }
        if ((data = this.getData(hsData, "AllocStd")) != null && data.toString().trim().length() > 0) {
            allocStdSetByClassInfo.setAllocStd(NCMDataImportUtil.getAllocStdByNumber((Context)ctx, (String)this.getResource("AllOCSTD_NUMBER", ctx), (String)data.toString()));
        }
        this.checkData(ctx, allocStdSetByClassInfo);
        return allocStdSetByClassInfo;
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.cu == null || this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
            if (this.period == null) {
                try {
                    this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        AllocStdSetByClassInfo allocStdSetByClassInfo = null;
        if (coreBaseInfo instanceof AllocStdSetByClassInfo) {
            allocStdSetByClassInfo = (AllocStdSetByClassInfo)coreBaseInfo;
        }
        if (allocStdSetByClassInfo == null) {
            return;
        }
        ArrayList<CoreBaseInfo> addObjList = new ArrayList<CoreBaseInfo>();
        HashMap<String, String> updateObjects = new HashMap<String, String>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this.period.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costObject.id", (Object)allocStdSetByClassInfo.getCostObject().getId().toString()));
        EntityViewInfo eviData = new EntityViewInfo();
        eviData.setFilter(filter);
        try {
            IAllocStdSetByClass coreBase = (IAllocStdSetByClass)this.getController(ctx);
            AllocStdSetByClassCollection collection = coreBase.getAllocStdSetByClassCollection(eviData);
            String allocStdInfo = "";
            if (allocStdSetByClassInfo.getAllocStd() != null) {
                allocStdInfo = allocStdSetByClassInfo.getAllocStd().getId().toString();
            }
            if (collection.size() != 0 && this.isSltImportUpdate()) {
                AllocStdSetByClassInfo Info = collection.get(0);
                updateObjects.put(Info.getId().toString(), allocStdInfo);
            } else if (!this.isSltImportUpdate()) {
                addObjList.add(coreBaseInfo);
            } else if (collection.size() == 0 && this.isSltImportUpdate()) {
                addObjList.add(coreBaseInfo);
            }
            coreBase.updateAllocStdSetting(updateObjects, new ArrayList(), addObjList);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            String allocStd = "";
            String allocStdName = "";
            if (rs.getString("AllocStd.number") != null) {
                allocStd = rs.getString("AllocStd.number");
            }
            if (rs.getString("AllocStd.name") != null) {
                allocStdName = rs.getString("AllocStd.name");
            }
            result.put("CostObject", rs.getString("CostObject.number"));
            result.put("CostObjectName", rs.getString("CostObject.name"));
            result.put("AllocStd", allocStd);
            result.put("AllocStdName", allocStdName);
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void checkData(Context ctx, AllocStdSetByClassInfo allocStdSetByClassInfo) throws BOSException {
        this.checkCostObject(ctx, allocStdSetByClassInfo);
        this.checkAllocStd(ctx, allocStdSetByClassInfo);
    }

    private void checkCostObject(Context ctx, AllocStdSetByClassInfo allocStdSetByClassInfo) throws BOSException {
        CostObjectInfo costObject = allocStdSetByClassInfo.getCostObject();
        if (costObject == null) {
            throw new BOSException(this.getResource("COSTOBJECT_NUMBER_CANNOT_EMPTY", ctx));
        }
        String costObjectCompId = costObject.getCompany().getId().toString();
        String companyId = this.company.getId().toString();
        if (!companyId.equals(costObjectCompId)) {
            throw new BOSException(costObject.getNumber() + this.getResource("COSTOBJECT_CHECK_CU", ctx));
        }
        CalculateModeEnum calaulateMode = costObject.getCalculateMode();
        boolean isForbiden = costObject.isIsForbiden();
        if (isForbiden || !CalculateModeEnum.BYCLASS.equals((Object)calaulateMode)) {
            throw new BOSException(costObject.getNumber() + this.getResource("COSTOBJECT_CHECK_ISCLASSTYPE", ctx));
        }
    }

    private void checkAllocStd(Context ctx, AllocStdSetByClassInfo allocStdSetByClassInfo) throws BOSException {
        AllocStdInfo allocStdInfo = allocStdSetByClassInfo.getAllocStd();
        if (allocStdInfo == null) {
            return;
        }
        AllocStdTypeEnum allocStdType = allocStdInfo.getAllocStdType();
        if (!allocStdType.equals((Object)AllocStdTypeEnum.CLASSI)) {
            throw new BOSException(allocStdInfo.getNumber() + this.getResource("ALLOCSTD_CHECK_BY_CLASS", ctx));
        }
    }
}

