/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.AllocStdTypeEnum;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.IExpense;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.AllocStdSetByPrdCollection;
import com.kingdee.eas.ncm.bill.AllocStdSetByPrdFactory;
import com.kingdee.eas.ncm.bill.AllocStdSetByPrdInfo;
import com.kingdee.eas.ncm.bill.IAllocStdSetByPrd;
import com.kingdee.eas.ncm.common.AllocStdSetModeByPrdEnum;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class AllocStdSetByPrdDataImport
extends AbstractNCMDataImport {
    protected CompanyOrgUnitInfo company = null;
    protected CtrlUnitInfo cu = null;
    protected PeriodInfo period = null;
    private AllocStdSetModeByPrdEnum setMode = AllocStdSetModeByPrdEnum.SetByCC;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AllocStdSetByPrdFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsDataBlock, Context ctx) throws TaskExternalException {
        AllocStdSetByPrdInfo allocStdSetByPrdInfo = null;
        try {
            this.initOrgUnit(ctx);
            allocStdSetByPrdInfo = this.parseData(hsDataBlock, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return allocStdSetByPrdInfo;
    }

    protected AllocStdSetByPrdInfo parseData(Hashtable hsData, Context ctx) throws BOSException {
        AllocStdSetByPrdInfo allocStdSetByPrdInfo = new AllocStdSetByPrdInfo();
        allocStdSetByPrdInfo.setId(BOSUuid.create((BOSObjectType)allocStdSetByPrdInfo.getBOSType()));
        allocStdSetByPrdInfo.setCompany(this.company);
        allocStdSetByPrdInfo.setCalculatePeriod(this.period);
        Object data = this.getData(hsData, "Expense");
        if (data != null && data.toString().trim().length() > 0) {
            try {
                IExpense iExpense = ExpenseFactory.getLocalInstance((Context)ctx);
                FilterInfo dfilter = iExpense.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId()), "id", "CU.id");
                allocStdSetByPrdInfo.setExpense(NCMDataImportUtil.getExpenseByNumber((Context)ctx, (String)this.getResource("EXPENSE_NUMBER", ctx), (String)data.toString(), (FilterInfo)dfilter));
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        if (this.setMode == AllocStdSetModeByPrdEnum.SetByCC && (data = this.getData(hsData, "CostCenter")) != null && data.toString().trim().length() > 0) {
            allocStdSetByPrdInfo.setCostCenter(NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)this.getResource("COSTCENTER_NUMBER", ctx), (String)data.toString()));
        }
        if ((data = this.getData(hsData, "AllocStd")) != null && data.toString().trim().length() > 0) {
            allocStdSetByPrdInfo.setAllocStd(NCMDataImportUtil.getAllocStdByNumber((Context)ctx, (String)this.getResource("AllOCSTD_NUMBER", ctx), (String)data.toString()));
        }
        this.checkData(ctx, allocStdSetByPrdInfo);
        return allocStdSetByPrdInfo;
    }

    protected void initOrgUnit(Context ctx) throws BOSException {
        if (this.cu == null || this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
            if (this.period == null) {
                try {
                    this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        if (this.company != null) {
            this.setMode = NCMUtils.getAllocStdSetModeByPrd((Context)ctx, (String)this.company.getId().toString());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        AllocStdSetByPrdInfo allocStdSetByPrdInfo = null;
        if (coreBaseInfo instanceof AllocStdSetByPrdInfo) {
            allocStdSetByPrdInfo = (AllocStdSetByPrdInfo)coreBaseInfo;
        }
        if (allocStdSetByPrdInfo == null) {
            return;
        }
        ArrayList<CoreBaseInfo> addObjList = new ArrayList<CoreBaseInfo>();
        HashMap<String, String> updateObjects = new HashMap<String, String>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)this.period.getId().toString()));
        if (this.setMode == AllocStdSetModeByPrdEnum.SetByCC) {
            filter.getFilterItems().add(new FilterItemInfo("costCenter.id", (Object)allocStdSetByPrdInfo.getCostCenter().getId().toString()));
        }
        filter.getFilterItems().add(new FilterItemInfo("expense.id", (Object)allocStdSetByPrdInfo.getExpense().getId().toString()));
        EntityViewInfo eviData = new EntityViewInfo();
        eviData.setFilter(filter);
        try {
            IAllocStdSetByPrd coreBase = (IAllocStdSetByPrd)this.getController(ctx);
            AllocStdSetByPrdCollection collection = coreBase.getAllocStdSetByPrdCollection(eviData);
            String allocStdInfo = "";
            if (allocStdSetByPrdInfo.getAllocStd() != null) {
                allocStdInfo = allocStdSetByPrdInfo.getAllocStd().getId().toString();
            }
            if (collection.size() != 0 && this.isSltImportUpdate()) {
                AllocStdSetByPrdInfo Info = collection.get(0);
                updateObjects.put(Info.getId().toString(), allocStdInfo);
            } else if (!this.isSltImportUpdate()) {
                addObjList.add(coreBaseInfo);
            } else if (collection.size() == 0 && this.isSltImportUpdate()) {
                addObjList.add(coreBaseInfo);
            }
            HashMap<String, AllocStdSetModeByPrdEnum> paramEx = new HashMap<String, AllocStdSetModeByPrdEnum>();
            paramEx.put("SetMode", this.setMode);
            coreBase.UpdateAllocStdSetting(updateObjects, new ArrayList(), addObjList, paramEx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
        AllocStdSetModeByPrdEnum theSetMode = null;
        try {
            theSetMode = NCMUtils.getAllocStdSetModeByPrd((Context)ctx, (String)context.getCurrentCompany().getId().toString());
        }
        catch (BOSException e1) {
            throw new TaskExternalException("\u8bfb\u53d6\u53c2\u6570\u5931\u8d25", (Throwable)e1);
        }
        try {
            String allocStd = "";
            String allocStdName = "";
            if (rs.getString("AllocStd.number") != null) {
                allocStd = rs.getString("AllocStd.number");
            }
            if (rs.getString("AllocStd.name") != null) {
                allocStdName = rs.getString("AllocStd.name");
            }
            result.put("Expense", rs.getString("expense.number"));
            result.put("ExpenseName", rs.getString("expense.name"));
            if (theSetMode == AllocStdSetModeByPrdEnum.SetByCC) {
                result.put("CostCenter", rs.getString("CostCenter.number"));
                result.put("CostCenterName", rs.getString("CostCenter.name"));
            }
            result.put("AllocStd", allocStd);
            result.put("AllocStdName", allocStdName);
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    protected void checkData(Context ctx, AllocStdSetByPrdInfo allocStdSetByPrdInfo) throws BOSException {
        this.checkExpense(ctx, allocStdSetByPrdInfo);
        if (this.setMode == AllocStdSetModeByPrdEnum.SetByCC) {
            this.checkCostCenter(ctx, allocStdSetByPrdInfo);
        }
        this.checkAllocStd(ctx, allocStdSetByPrdInfo);
    }

    protected void checkExpense(Context ctx, AllocStdSetByPrdInfo allocStdSetByPrdInfo) throws BOSException {
        ExpenseInfo expense = allocStdSetByPrdInfo.getExpense();
        if (expense == null) {
            throw new BOSException(this.getResource("EXPENSE_CHECK_ISEMPTY", ctx));
        }
        NCMDataImportUtil.checkDataBaseDPermission((Context)ctx, (String)this.cu.getId().toString(), (String)expense.getCU().getId().toString(), (String)"4A255827", (String)expense.getId().toString(), (String)expense.getNumber(), (String)this.getResource("EXPENSE", ctx));
    }

    protected void checkCostCenter(Context ctx, AllocStdSetByPrdInfo allocStdSetByPrdInfo) throws BOSException {
        CostCenterOrgUnitInfo costCenterInfo = allocStdSetByPrdInfo.getCostCenter();
        if (costCenterInfo == null) {
            throw new BOSException(this.getResource("COSTCENTER_NUMBER_CANNOT_EMPTY", ctx));
        }
        String companyId = this.company.getId().toString();
        NCMDataImportUtil.checkCostCenter((Context)ctx, (CostCenterOrgUnitInfo)costCenterInfo, (String)companyId);
    }

    protected void checkAllocStd(Context ctx, AllocStdSetByPrdInfo allocStdSetByPrdInfo) throws BOSException {
        AllocStdInfo allocStdInfo = allocStdSetByPrdInfo.getAllocStd();
        if (allocStdInfo == null) {
            return;
        }
        AllocStdTypeEnum allocStdType = allocStdInfo.getAllocStdType();
        if (!allocStdType.equals((Object)AllocStdTypeEnum.INNERPRD)) {
            throw new BOSException(allocStdInfo.getNumber() + this.getResource("ALLOCSTD_CHECK_BY_PRD", ctx));
        }
    }
}

