/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CostItemEnum;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.IMaterialCost;
import com.kingdee.eas.basedata.master.material.MaterialCostCollection;
import com.kingdee.eas.basedata.master.material.MaterialCostFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostEntryCollection;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostEntryInfo;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostFactory;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostInfo;
import com.kingdee.eas.ncm.bill.BoPInvSFPCostMatDetailInfo;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.RecoveryModelEnum;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.RecoveryUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BoPInvSFPCostDataImport
extends AbstractNCMDataImport {
    private static Logger logger = Logger.getLogger((String)BoPInvSFPCostDataImport.class.getName());
    private CompanyOrgUnitInfo company = null;
    private CtrlUnitInfo cu = null;
    private PeriodInfo period = null;
    private UserInfo currUser = null;

    public int getSubmitType() {
        return 1;
    }

    public String getMainField() {
        return "number";
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return BoPInvSFPCostFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsDataBlock, Context ctx) throws TaskExternalException {
        BoPInvSFPCostInfo head = null;
        BoPInvSFPCostEntryInfo entry = null;
        BoPInvSFPCostMatDetailInfo matDetailInfo = null;
        try {
            this.initOrgUnit(ctx);
            HashMap<String, BoPInvSFPCostEntryInfo> costItemMap = new HashMap<String, BoPInvSFPCostEntryInfo>();
            for (int i = 0; i < hsDataBlock.size(); ++i) {
                Hashtable hsData = (Hashtable)hsDataBlock.get(i);
                if (i == 0) {
                    head = this.parseHead(hsData, ctx);
                    this.verifyHead(ctx, head);
                }
                entry = this.parseEntry(hsData, ctx);
                this.verifyEntry(ctx, entry);
                matDetailInfo = this.parseMatDetail(hsData, ctx, entry);
                String costItemNumber = entry.getCostItem().getNumber();
                if (!costItemMap.containsKey(costItemNumber)) {
                    entry.getEntrys2().add(matDetailInfo);
                    head.getEntrys().add(entry);
                    costItemMap.put(costItemNumber, entry);
                    continue;
                }
                BoPInvSFPCostEntryInfo entryInfo = (BoPInvSFPCostEntryInfo)costItemMap.get(costItemNumber);
                entryInfo.getEntrys2().add(matDetailInfo);
            }
            this.calcAmount(ctx, head);
            this.verifyBlocks(ctx, head);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return head;
    }

    private void calcAmount(Context ctx, BoPInvSFPCostInfo head) throws BOSException {
        BoPInvSFPCostEntryCollection entryColl = head.getEntrys();
        BigDecimal costItemAmount = new BigDecimal("0.0");
        for (int i = 0; i < entryColl.size(); ++i) {
            BoPInvSFPCostEntryInfo entryInfo = entryColl.get(i);
            if (CostItemEnum.STUFF.equals((Object)entryInfo.getCostItem().getItemType()) && entryInfo.getEntrys2().size() > 0) {
                BigDecimal matDetailAmountTotal = new BigDecimal("0.0");
                for (int j = 0; j < entryInfo.getEntrys2().size(); ++j) {
                    BoPInvSFPCostMatDetailInfo matDetailInfo = entryInfo.getEntrys2().get(j);
                    if (matDetailInfo.getAmount() == null) continue;
                    matDetailAmountTotal = matDetailAmountTotal.add(matDetailInfo.getAmount());
                }
                entryInfo.setAmount(matDetailAmountTotal);
            }
            costItemAmount = costItemAmount.add(entryInfo.getAmount());
        }
        head.setAmount(costItemAmount);
    }

    private void verifyBlocks(Context ctx, BoPInvSFPCostInfo head) throws BOSException {
        HashMap<String, String> infoMap = new HashMap<String, String>();
        BoPInvSFPCostEntryCollection coll = head.getEntrys();
        for (int i = 0; i < coll.size(); ++i) {
            if (infoMap.containsKey(coll.get(i).getCostItem().getId().toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"146_InitBalanceDataImport", (Locale)ctx.getLocale()));
            }
            infoMap.put(coll.get(i).getCostItem().getId().toString(), coll.get(i).getCostItem().getId().toString());
        }
    }

    private void verifyEntry(Context ctx, BoPInvSFPCostEntryInfo entry) throws BOSException {
        this.checkCostItem(ctx, entry);
    }

    private void checkCostItem(Context ctx, BoPInvSFPCostEntryInfo entry) throws BOSException {
        CostItemInfo costItem = entry.getCostItem();
        NCMDataImportUtil.checkDataBaseDPermission((Context)ctx, (String)this.cu.getId().toString(), (String)costItem.getCU().getId().toString(), (String)"548C5A91", (String)costItem.getId().toString(), (String)costItem.getNumber(), (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"137_ExpenseCompanyInfoDataImport", (Locale)ctx.getLocale()));
    }

    private void verifyHead(Context ctx, BoPInvSFPCostInfo head) {
    }

    private BoPInvSFPCostEntryInfo parseEntry(Hashtable hsData, Context ctx) throws BOSException, EASBizException {
        BoPInvSFPCostEntryInfo entry = new BoPInvSFPCostEntryInfo();
        Object data = this.getData(hsData, "costItem.number");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"84_CostItemDataImport", (Locale)ctx.getLocale()));
        }
        entry.setCostItem(this.getCostItemByNumber(ctx, data.toString()));
        BigDecimal qty = null;
        BigDecimal price = null;
        BigDecimal amount = null;
        if (entry.getCostItem().isIsAllocateQty()) {
            qty = this.getTheInputQty(ctx, hsData, entry, "costItem.qty", "\u6d88\u8017\u6570\u91cf");
            entry.setQty(qty);
            price = this.getTheInputQty(ctx, hsData, entry, "costItem.price", "\u6d88\u8017\u5355\u4ef7");
            entry.setPrice(price);
        }
        if ((amount = this.getTheInputQty(ctx, hsData, entry, "costItem.amount", "\u6d88\u8017\u91d1\u989d")) != null) {
            amount = amount.setScale(NCMUtils.getCurrencyPrecision((Context)ctx, (String)this.company.getId().toString()), 4);
        }
        entry.setAmount(amount == null ? SysConstant.BIGZERO : amount);
        return entry;
    }

    private BoPInvSFPCostMatDetailInfo parseMatDetail(Hashtable hsData, Context ctx, BoPInvSFPCostEntryInfo entry) throws BOSException, EASBizException {
        BoPInvSFPCostMatDetailInfo matDetailInfo = new BoPInvSFPCostMatDetailInfo();
        Object data = this.getData(hsData, "mat.number");
        Object batchNo = this.getData(hsData, "mat.batchNo");
        Object matQty = this.getData(hsData, "mat.qty");
        Object matPrice = this.getData(hsData, "mat.price");
        Object matAmount = this.getData(hsData, "mat.amount");
        BigDecimal decMatQty = null;
        BigDecimal decMatPrice = null;
        BigDecimal decMatAmount = null;
        if (CostItemEnum.STUFF.equals((Object)entry.getCostItem().getItemType())) {
            if (data != null && data.toString().trim().length() > 0) {
                decMatQty = this.getBigDecimalValueByFeildData(ctx, "mat.qty", matQty);
                decMatAmount = this.getBigDecimalValueByFeildData(ctx, "mat.amount", matAmount);
                int qtyPrecision = 8;
                MaterialInfo matInfo = this.getMaterialByBoPInvSFPCost(data, ctx);
                String sql = "select where material.id = '" + matInfo.getId().toString() + "' and measureUnit.id = '" + matInfo.getBaseUnit().getId().toString() + "' ";
                MultiMeasureUnitCollection multUnitColl = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(sql);
                if (multUnitColl != null && multUnitColl.size() > 0) {
                    qtyPrecision = multUnitColl.get(0).getQtyPrecision();
                }
                if (decMatQty != null) {
                    decMatQty = decMatQty.setScale(qtyPrecision, 4);
                }
                if (decMatAmount != null) {
                    decMatAmount = decMatAmount.setScale(NCMUtils.getCurrencyPrecision((Context)ctx, (String)this.company.getId().toString()), 4);
                }
                if (decMatQty == null || decMatQty.compareTo(SysConstant.BIGZERO) <= 0) {
                    throw new BOSException("\u6750\u6599\u660e\u7ec6\u4e2d\u7684\u6570\u91cf\u5fc5\u987b\u5927\u4e8e\u96f6\uff01");
                }
                if (decMatAmount == null || decMatAmount.compareTo(SysConstant.BIGZERO) <= 0) {
                    throw new BOSException("\u6750\u6599\u660e\u7ec6\u4e2d\u7684\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u96f6\uff01");
                }
                matDetailInfo.setMaterial(this.getMaterialByBoPInvSFPCost(data, ctx));
                matDetailInfo.setBatchNo(batchNo.toString());
                matDetailInfo.setQty(decMatQty);
                int pricePrecision = 8;
                if (matDetailInfo.getMaterial() != null) {
                    pricePrecision = matDetailInfo.getMaterial().getPricePrecision();
                }
                decMatPrice = decMatAmount.divide(decMatQty, pricePrecision, 6);
                matDetailInfo.setPrice(decMatPrice);
                matDetailInfo.setAmount(decMatAmount);
            } else {
                if (batchNo != null && batchNo.toString().trim().length() > 0) {
                    throw new BOSException("\u6750\u6599\u7c7b\u6210\u672c\u9879\u76ee\u7684\u6750\u6599\u660e\u7ec6\u6279\u6b21\u82e5\u4e0d\u4e3a\u7a7a\uff0c\u6750\u6599\u7f16\u7801\u4e5f\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (matQty != null && matQty.toString().trim().length() > 0) {
                    throw new BOSException("\u6750\u6599\u7c7b\u6210\u672c\u9879\u76ee\u7684\u6750\u6599\u660e\u7ec6\u6570\u91cf\u82e5\u4e0d\u4e3a\u7a7a\uff0c\u6750\u6599\u7f16\u7801\u4e5f\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (matPrice != null && matPrice.toString().trim().length() > 0) {
                    throw new BOSException("\u6750\u6599\u7c7b\u6210\u672c\u9879\u76ee\u7684\u6750\u6599\u660e\u7ec6\u5355\u4ef7\u82e5\u4e0d\u4e3a\u7a7a\uff0c\u6750\u6599\u7f16\u7801\u4e5f\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (matAmount != null && matAmount.toString().trim().length() > 0) {
                    throw new BOSException("\u6750\u6599\u7c7b\u6210\u672c\u9879\u76ee\u7684\u6750\u6599\u660e\u7ec6\u91d1\u989d\u82e5\u4e0d\u4e3a\u7a7a\uff0c\u6750\u6599\u7f16\u7801\u4e5f\u4e0d\u80fd\u4e3a\u7a7a!");
                }
            }
        } else if (data != null && data.toString().trim().length() > 0 || batchNo != null && batchNo.toString().trim().length() > 0 || matQty != null && matQty.toString().trim().length() > 0 || matPrice != null && matPrice.toString().trim().length() > 0 || matAmount != null && matPrice.toString().trim().length() > 0) {
            throw new BOSException("\u975e\u6750\u6599\u7c7b\u6210\u672c\u9879\u76ee\u4e0d\u80fd\u586b\u5199\u6750\u6599\u660e\u7ec6!");
        }
        return matDetailInfo;
    }

    private MaterialInfo getMaterialByBoPInvSFPCost(Object data, Context ctx) throws BOSException {
        MaterialInfo material;
        block10: {
            material = NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"167_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()), (String)data.toString());
            StringBuffer sql = new StringBuffer();
            if (RecoveryModelEnum.ByStep.equals((Object)RecoveryUtils.getRecoveryModel((Context)ctx, (String)this.company.getId().toString()))) {
                sql.append("select 1 from T_BD_MaterialCompanyInfo where FMaterialID = ? and FCompanyID = ?");
                IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{material.getId().toString(), this.company.getId().toString()});
                try {
                    if (!rs.next()) {
                        throw new BOSException(data.toString() + "\u4e0d\u662f\u7ed3\u8f6c\u5f0f\u6210\u672c\u8fd8\u539f\u6a21\u5f0f\u7684\u5206\u7ea7\u6a21\u5f0f\u7684\u6709\u6548\u6750\u6599\u7f16\u7801\uff01");
                    }
                    break block10;
                }
                catch (SQLException e) {
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
            }
            FilterInfo filter = new FilterInfo();
            filter.appendFilterItem("id", (Object)material.getId().toString());
            filter.appendFilterItem("orgUnit.id", (Object)this.company.getId().toString());
            filter.appendFilterItem("FIInfo.calculateType", (Object)0);
            filter.appendFilterItem("FIInfo.calculateType", (Object)1);
            EntityViewInfo mcevi = new EntityViewInfo();
            FilterInfo mcFilter = new FilterInfo();
            mcFilter.appendFilterItem("orgUnit.id", (Object)this.company.getId().toString());
            mcFilter.appendFilterItem("isParticipateReduct", (Object)Boolean.FALSE);
            IMaterialCost mc = MaterialCostFactory.getLocalInstance((Context)ctx);
            mcevi.setFilter(mcFilter);
            MaterialCostCollection mcColl = mc.getMaterialCostCollection(mcevi);
            int mcSize = mcColl.size();
            if (mcSize > 0) {
                HashSet<String> mcMaterialIDSet = new HashSet<String>(mcSize);
                for (int i = 0; i < mcSize; ++i) {
                    mcMaterialIDSet.add(mcColl.get(i).getMaterial().getId().toString());
                }
                filter.appendFilterItem("FIInfo.calculateType", (Object)2);
                filter.getFilterItems().add(new FilterItemInfo("material.id", mcMaterialIDSet, CompareType.INCLUDE));
                filter.setMaskString("#0 and #1 and ( #2 or #3 or (#4 and #5) ) ");
            } else {
                filter.setMaskString("#0 and #1 and ( #2 or #3)");
            }
            String query = "com.kingdee.eas.basedata.master.material.app.F7MaterialFINoGroupQuery";
            MetaDataPK metaDataPK = new MetaDataPK(query);
            IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaDataPK);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            queryExecutor.setObjectView(evi);
            IRowSet rowSet = queryExecutor.executeQuery();
            try {
                if (!rowSet.next()) {
                    throw new BOSException(data.toString() + "\u4e0d\u662f\u7ed3\u8f6c\u5f0f\u6210\u672c\u8fd8\u539f\u6a21\u5f0f\u7684\u7ec8\u7ea7\u6a21\u5f0f\u7684\u6709\u6548\u6750\u6599\u7f16\u7801\uff01");
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        return material;
    }

    private BigDecimal getTheInputQty(Context ctx, Hashtable hsData, BoPInvSFPCostEntryInfo entry, String feild, String feildName) throws BOSException, EASBizException {
        Object data = this.getData(hsData, feild);
        BigDecimal inputQty = null;
        if (data != null && data.toString().trim().length() > 0) {
            inputQty = this.getBigDecimalValueByFeildData(ctx, feildName, data);
        }
        if (CostItemEnum.STUFF.equals((Object)entry.getCostItem().getItemType())) {
            if (inputQty != null && inputQty.compareTo(SysConstant.BIGZERO) > 0 && !"costItem.amount".equals(feild)) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"61_ActualHourDataImport", (Locale)ctx.getLocale()) + entry.getCostItem().getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"155_InitBalanceDataImport", (Locale)ctx.getLocale()) + feildName + "!");
            }
        } else {
            MeasureUnitInfo unitInfo;
            int qtyPrecision = 8;
            int pricePrcsion = 8;
            if ("costItem.qty".equals(feild) && entry.getCostItem() != null && entry.getCostItem().getUnit() != null && (unitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(entry.getCostItem().getUnit().getId().toString()))) != null && inputQty != null) {
                qtyPrecision = unitInfo.getQtyPrecision();
                inputQty = inputQty.setScale(qtyPrecision, 4);
            }
            if ("costItem.price".equals(feild) && entry.getCostItem() != null && inputQty != null) {
                pricePrcsion = entry.getCostItem().getPricePrecision();
                inputQty = inputQty.setScale(pricePrcsion, 4);
            }
            if (inputQty != null && inputQty.compareTo(SysConstant.BIGZERO) < 0 && "costItem.qty".equals(feild)) {
                throw new BOSException(feildName + "\u5fc5\u987b\u5927\u4e8e\u96f6\uff01");
            }
            if (inputQty != null && inputQty.compareTo(SysConstant.BIGZERO) < 0 && "costItem.price".equals(feild)) {
                throw new BOSException(feildName + "\u5fc5\u987b\u5927\u4e8e\u96f6\uff01");
            }
            if (inputQty != null && inputQty.compareTo(SysConstant.BIGZERO) < 0 && "costItem.amount".equals(feild)) {
                throw new BOSException(feildName + "\u5fc5\u987b\u5927\u4e8e\u96f6\uff01");
            }
        }
        return inputQty;
    }

    private BoPInvSFPCostInfo parseHead(Hashtable hsData, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        BoPInvSFPCostInfo head = new BoPInvSFPCostInfo();
        head.setCompanyOrg(this.company);
        head.setCalculatePeriod(this.period);
        this.dealWithTheNumberByImpMode(ctx, hsData, head);
        Object data = this.getData(hsData, "material.number");
        if (data != null && data.toString().trim().length() > 0) {
            MaterialInfo material = NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"257_BoPInvSFPCostDataImport", (Locale)ctx.getLocale()), (String)data.toString());
            head.setProduct(material);
            if (material != null && material.getId() != null) {
                IRowSet rst = NCMDbUtil.executeQuery((Context)ctx, (String)"select FCalculateType from T_BD_MaterialCompanyInfo where FMaterialID = ? and FCompanyID = ?", (Object[])new Object[]{material.getId().toString(), this.company.getId().toString()});
                try {
                    int calcuType;
                    if (rst.next() && 2 != (calcuType = rst.getInt(1))) {
                        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"256_BoPInvSFPCostDataImport", (Locale)ctx.getLocale()));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
            }
            if ((data = this.getData(hsData, "material.batchNo")) != null && data.toString().trim().length() > 0) {
                head.setLot(data.toString());
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"255_BoPInvSFPCostDataImport", (Locale)ctx.getLocale()));
        }
        CostObjectInfo co = null;
        co = this.getData(hsData, "material.batchNo") != null && this.getData(hsData, "material.batchNo").toString().length() > 0 ? CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectByMaterialLotAndOrder(this.company.getId().toString(), head.getProduct().getId().toString(), this.getData(hsData, "material.batchNo").toString(), null) : CostObjectFactory.getLocalInstance((Context)ctx).getCostObjectByMaterial(head.getProduct().getId().toString(), this.company.getId().toString());
        head.setCostObject(co);
        data = this.getData(hsData, "qty");
        String qtyStr = ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"157_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale());
        if (data != null && data.toString().trim().length() > 0) {
            head.setQty(this.getBigDecimalValueByFeildData(ctx, qtyStr, data));
        }
        if (head.getQty() == null || head.getQty().compareTo(SysConstant.BIGZERO) < 0) {
            throw new BOSException(qtyStr + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"156_InitBalanceDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "amount");
        String amountStr = ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"159_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale());
        if (data != null && data.toString().trim().length() > 0) {
            head.setAmount(this.getBigDecimalValueByFeildData(ctx, amountStr, data));
        }
        if (head.getAmount() == null || head.getAmount().compareTo(SysConstant.BIGZERO) < 0) {
            throw new BOSException(amountStr + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"156_InitBalanceDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "description");
        if (data != null && data.toString().trim().length() > 0) {
            head.setDescription(data.toString());
        }
        head.setBizDate(new Date());
        return head;
    }

    private void dealWithTheNumberByImpMode(Context ctx, Hashtable hsData, BoPInvSFPCostInfo info) throws BOSException, TaskExternalException {
        String number = hsData.get("number").toString();
        if (number == null || number.length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"57_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select FID, FBillStatus from T_NCM_BoPInvSFPCost").append(" where FNumber=? and FCompanyOrg=? ;");
        Object[] param = new Object[]{number, this.company.getId().toString()};
        IRowSet _Data = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
        if (_Data != null && _Data.size() >= 1) {
            if (this.isSltImportUpdate()) {
                this.checkAndDealWithEdit(ctx, info, _Data, number);
            } else {
                throw new BOSException(number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"58_ActualHourDataImport", (Locale)ctx.getLocale()));
            }
        }
        info.setNumber(number);
        info.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
    }

    private void checkAndDealWithEdit(Context ctx, BoPInvSFPCostInfo info, IRowSet data, String number) throws BOSException {
        try {
            data.first();
            if (2 != data.getInt("FBillStatus")) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"61_ActualHourDataImport", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"62_ActualHourDataImport", (Locale)ctx.getLocale()));
            }
            info.setId(BOSUuid.read((String)data.getString("FID")));
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.cu == null || this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
            if (this.period == null) {
                try {
                    this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        if (this.currUser == null) {
            this.currUser = (UserInfo)ctx.get((Object)"UserInfo");
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("number", this.getNotBlankString(rs.getString("number")));
            result.put("material.number", this.getNotBlankString(rs.getString("product.number")));
            result.put("material.name", this.getNotBlankString(rs.getString("product.name")));
            result.put("material.batchNo", this.getNotBlankString(rs.getString("lot")));
            result.put("qty", this.getNotBlankString(rs.getString("qty")));
            result.put("amount", this.getNotBlankString(rs.getString("amount")));
            result.put("description", this.getNotBlankString(rs.getString("description")));
            result.put("costItem.number", this.getNotBlankString(rs.getString("costItem.number")));
            result.put("costItem.name", this.getNotBlankString(rs.getString("costItem.name")));
            result.put("costItem.qty", this.getNotBlankString(rs.getString("entrys.qty")));
            result.put("costItem.price", this.getNotBlankString(rs.getString("entrys.price")));
            result.put("costItem.amount", this.getNotBlankString(rs.getString("entrys.amount")));
            if (rs.getString("material.number") != null) {
                result.put("mat.number", this.getNotBlankString(rs.getString("material.number")));
                result.put("mat.name", this.getNotBlankString(rs.getString("material.name")));
                result.put("mat.model", this.getNotBlankString(rs.getString("material.model")));
                result.put("mat.baseUnit", this.getNotBlankString(rs.getString("baseUnit1.name")));
                result.put("mat.batchNo", this.getNotBlankString(rs.getString("entrys2.batchNo")));
                result.put("mat.qty", this.getNotBlankString(rs.getString("entrys2.qty")));
                result.put("mat.price", this.getNotBlankString(rs.getString("entrys2.price")));
                result.put("mat.amount", this.getNotBlankString(rs.getString("entrys2.amount")));
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.ncm.bill.app.BoPInvSFPCostExportQuery";
    }
}

