/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostObjectEntryFactory;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.ClassPonderanceCollection;
import com.kingdee.eas.ncm.bill.ClassPonderanceFactory;
import com.kingdee.eas.ncm.bill.ClassPonderanceInfo;
import com.kingdee.eas.ncm.bill.IClassPonderance;
import com.kingdee.eas.ncm.bill.NcmBillException;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Hashtable;

public class ClassPonderanceDataImport
extends AbstractNCMDataImport {
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ClassPonderanceFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        ClassPonderanceInfo info = null;
        try {
            info = this.parse(ctx, hsData);
        }
        catch (TaskExternalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return info;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("costCenter.number", this.getNotBlankString(rs.getString("costCenter.number")));
            result.put("costCenter.name", this.getNotBlankString(rs.getString("costCenter.name")));
            result.put("costObject.number", this.getNotBlankString(rs.getString("costObject.number")));
            result.put("costObject.name", this.getNotBlankString(rs.getString("costObject.name")));
            result.put("material.number", this.getNotBlankString(rs.getString("material.number")));
            result.put("material.name", this.getNotBlankString(rs.getString("material.name")));
            result.put("coefficient", this.getNotBlankString(rs.getString("coefficient")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getStringValue(Hashtable hsData, String fieldName) {
        String value;
        Object data = this.getData(hsData, fieldName);
        if (data != null && (value = data.toString().trim()).length() > 0) {
            return value;
        }
        return null;
    }

    private ClassPonderanceInfo parse(Context ctx, Hashtable hsData) throws BOSException, EASBizException, TaskExternalException {
        BigDecimal coefficient;
        CostObjectInfo costObject;
        ClassPonderanceInfo info = new ClassPonderanceInfo();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String companyId = company.getId().toString();
        info.setCompany(company);
        PeriodInfo period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)company.getId().toString());
        info.setCalculatePeriod(period);
        String value = this.getStringValue(hsData, "costCenter.number");
        if (value == null) {
            throw new BOSException(this.getResource("COSTCENTER_NUMBER_CANNOT_EMPTY", ctx));
        }
        CostCenterOrgUnitInfo costCenter = NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)this.getResource("COSTCENTER_NUMBER", ctx), (String)value);
        NCMDataImportUtil.checkCostCenter((Context)ctx, (CostCenterOrgUnitInfo)costCenter, (String)companyId);
        info.setCostCenter(costCenter);
        value = this.getStringValue(hsData, "costObject.number");
        if (value != null) {
            costObject = NCMDataImportUtil.getCostObjectbyNumber((Context)ctx, (String)this.getResource("COSTOBJECT_NUMBER", ctx), (String)value, (String)companyId);
            if (!CalculateModeEnum.BYCLASS.equals((Object)costObject.getCalculateMode())) {
                throw new BOSException(this.getResource("COSTOBJECT_ISNOT_CLASS_PART1", ctx) + costObject.getNumber() + this.getResource("COSTOBJECT_ISNOT_CLASS_PART2", ctx));
            }
        } else {
            throw new BOSException(this.getResource("COSTOBJECT_NUMBER_CANNOT_EMPTY", ctx));
        }
        info.setCostObject(costObject);
        value = this.getStringValue(hsData, "material.number");
        if (value == null) {
            throw new BOSException(this.getResource("MATERIAL_NUMBER_CANNOT_EMPTY", ctx));
        }
        MaterialInfo material = NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)this.getResource("MATERIAL_NUMBER", ctx), (String)value);
        info.setMaterial(material);
        this.checkMaterialByClassCO(ctx, info);
        Object data = this.getData(hsData, "coefficient");
        if (data != null && data.toString().trim().length() > 0) {
            coefficient = this.getBigDecimalValueByFeildData(ctx, this.getResource("COST_COEFFICIENT", ctx), data);
            if (coefficient.compareTo(BigDecimal.valueOf(0L)) < 0) {
                throw new NcmBillException(NcmBillException.CHECK_POND_LESSTHAN_ZERO);
            }
        } else {
            throw new BOSException(this.getResource("COST_COEFFICIENT_CANNOT_EMPTY", ctx));
        }
        info.setCoefficient(coefficient);
        this.checkExists(ctx, info);
        return info;
    }

    private void checkMaterialByClassCO(Context ctx, ClassPonderanceInfo info) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)info.getCostObject().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("RelatedID", (Object)info.getMaterial().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isByproduct", (Object)"0"));
        boolean exist = CostObjectEntryFactory.getLocalInstance((Context)ctx).exists(filter);
        if (!exist) {
            throw new BOSException(this.getResource("MATERIAL_CHECK_ISNOT_CLASS_PART1", ctx) + " " + info.getMaterial().getNumber() + " " + this.getResource("MATERIAL_CHECK_ISNOT_CLASS_PART2", ctx) + " " + info.getCostObject().getNumber() + " " + this.getResource("MATERIAL_CHECK_ISNOT_CLASS_PART3", ctx));
        }
    }

    private void checkExists(Context ctx, ClassPonderanceInfo info) throws BOSException, TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod", (Object)info.getCalculatePeriod().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costCenter", (Object)info.getCostCenter().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costObject", (Object)info.getCostObject().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)info.getMaterial().getId().toString()));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        view.setSelector(sic);
        ClassPonderanceCollection coll = ((IClassPonderance)this.getController(ctx)).getClassPonderanceCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (this.isSltImportUpdate()) {
                info.setId(coll.get(0).getId());
            } else {
                throw new BOSException(this.getResource("CLASSPONDERENCE_CHECK_PART1", ctx) + this.getResource("CLASSPONDERENCE_CHECK_PART2", ctx) + info.getCostCenter().getNumber() + this.getResource("CLASSPONDERENCE_CHECK_PART3", ctx) + info.getCostObject().getNumber() + this.getResource("CLASSPONDERENCE_CHECK_PART4", ctx) + info.getMaterial().getNumber());
            }
        }
    }
}

