/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostObjectCollection;
import com.kingdee.eas.basedata.assistant.CostObjectEntryInfo;
import com.kingdee.eas.basedata.assistant.CostObjectFactory;
import com.kingdee.eas.basedata.assistant.CostObjectGroupInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.ICostObject;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.AUXOverheadInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.ncm.bill.app.transmission.CostObjectImportVerify;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class CostObjectDataImport
extends AbstractNCMDataImport {
    CompanyOrgUnitInfo company = null;
    private CostObjectImportVerify verify = null;

    public int getSubmitType() {
        return 1;
    }

    public String getMainField() {
        return "number";
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CostObjectFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CostObjectImportVerify getVerify() {
        if (this.verify == null) {
            this.verify = new CostObjectImportVerify();
        }
        return this.verify;
    }

    public CoreBaseInfo transmit(Hashtable hsDataBlock, Context ctx) throws TaskExternalException {
        if (this.company == null) {
            this.company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        if (this.company != null && this.company.getCU() == null) {
            try {
                this.company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.company.getId().toString()));
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (EASBizException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        CostObjectInfo head = null;
        try {
            for (int i = 0; i < hsDataBlock.size(); ++i) {
                CORelatedType relatedType;
                Hashtable hsData = (Hashtable)hsDataBlock.get(i);
                if (i == 0) {
                    head = this.parseHead(hsData, ctx);
                    this.getVerify().verifyHead(ctx, (CoreBaseInfo)head);
                }
                if (CORelatedType.Other.equals((Object)(relatedType = head.getRelatedType())) || CORelatedType.Project.equals((Object)relatedType)) continue;
                CostObjectEntryInfo entry = this.parseEntry(hsData, head, ctx);
                this.getVerify().verifyEntry(ctx, head, entry);
                head.getEntries().add(entry);
            }
            this.getVerify().verifyBlock(ctx, head, (ICostObject)this.getController(ctx));
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return head;
    }

    private CostObjectEntryInfo parseEntry(Hashtable hsData, CostObjectInfo head, Context ctx) throws BOSException {
        CostObjectEntryInfo info = new CostObjectEntryInfo();
        Object data = this.getData(hsData, "entries.RelatedNumber");
        Object[] relatedObject = null;
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"89_CostObjectDataImport", (Locale)ctx.getLocale()));
        }
        relatedObject = this.getRelatedObject(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"88_CostObjectDataImport", (Locale)ctx.getLocale()), data.toString(), head.getRelatedType());
        info.setRelatedID((BOSUuid)relatedObject[0]);
        info.setRelatedNumber((String)relatedObject[1]);
        info.setRelatedName((String)relatedObject[2]);
        if (CORelatedType.Product.equals((Object)head.getRelatedType())) {
            CalculateModeEnum calculateMode = head.getCalculateMode();
            if (CalculateModeEnum.BYCLASS.equals((Object)calculateMode)) {
                data = this.getData(hsData, "entries.isMainProduct");
                int isMainProductInt = 0;
                if (data != null && data.toString().trim().length() > 0) {
                    isMainProductInt = this.getIntValueForBooleanFeild(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"90_CostObjectDataImport", (Locale)ctx.getLocale()), data);
                }
                info.setIsMainProduct(isMainProductInt == 1);
                data = this.getData(hsData, "entries.isByproduct");
                int isByproductInt = 0;
                if (data != null && data.toString().trim().length() > 0) {
                    isByproductInt = this.getIntValueForBooleanFeild(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"91_CostObjectDataImport", (Locale)ctx.getLocale()), data);
                }
                info.setIsByproduct(isByproductInt == 1);
                data = this.getData(hsData, "entries.quotiety");
                BigDecimal quotiety = new BigDecimal("0");
                if (data != null && data.toString().trim().length() > 0) {
                    quotiety = this.getBigDecimalValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"92_CostObjectDataImport", (Locale)ctx.getLocale()), data);
                }
                info.setQuotiety(quotiety);
            } else {
                info.setIsMainProduct(true);
                info.setIsByproduct(false);
                info.setQuotiety(new BigDecimal("1.0"));
            }
            if (info.isIsMainProduct()) {
                head.setRelatedId((BOSUuid)relatedObject[0]);
                MaterialGroupInfo matGroup = new MaterialGroupInfo();
                matGroup.setId((BOSUuid)relatedObject[3]);
                head.setGroup(matGroup);
            }
        }
        return info;
    }

    private Object[] getRelatedObject(Context ctx, String fieldName, String number, CORelatedType relatedType) throws BOSException {
        Object[] object = null;
        if (CORelatedType.Product.equals((Object)relatedType)) {
            object = new Object[4];
            MaterialInfo materialInfo = NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)fieldName, (String)number);
            object[0] = materialInfo.getId();
            object[1] = materialInfo.getNumber();
            object[2] = materialInfo.getName();
            object[3] = materialInfo.getMaterialGroup().getId();
        } else {
            object = new Object[3];
            AUXOverheadInfo aUXOverheadInfo = NCMDataImportUtil.getAUXOverheadByNumber((Context)ctx, (String)fieldName, (String)number);
            object[0] = aUXOverheadInfo.getId();
            object[1] = aUXOverheadInfo.getNumber();
            object[2] = aUXOverheadInfo.getName();
        }
        return object;
    }

    private CostObjectInfo parseHead(Hashtable hsData, Context ctx) throws BOSException, TaskExternalException {
        BomInfo bom;
        CORelatedType relatedType;
        CostObjectInfo info = new CostObjectInfo();
        info.setCompany(this.company);
        this.dealWithTheNumberByImpMode(ctx, hsData, info);
        Object data = this.getData(hsData, "name");
        if (data != null && data.toString().trim().length() > 0) {
            info.setName(data.toString());
        }
        if ((data = this.getData(hsData, "description")) != null && data.toString().trim().length() > 0) {
            info.setDescription(data.toString());
        }
        if ((data = this.getData(hsData, "relatedType")) != null && data.toString().trim().length() > 0) {
            relatedType = CORelatedType.getEnum((int)this.getIntValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"93_CostObjectDataImport", (Locale)ctx.getLocale()), data));
            if (relatedType == null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"94_CostObjectDataImport", (Locale)ctx.getLocale()));
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"95_CostObjectDataImport", (Locale)ctx.getLocale()));
        }
        info.setRelatedType(relatedType);
        data = this.getData(hsData, "calculateMode");
        if (data != null && data.toString().trim().length() > 0) {
            CalculateModeEnum calculateMode = CalculateModeEnum.getEnum((int)this.getIntValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"96_CostObjectDataImport", (Locale)ctx.getLocale()), data));
            if (calculateMode != null) {
                if (calculateMode.equals((Object)CalculateModeEnum.BYORDER)) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.basedata.assistant.CostObjectResource", (String)"OrderCO_CanNot_Import", (Locale)ctx.getLocale()));
                }
                info.setCalculateMode(calculateMode);
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"97_CostObjectDataImport", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "batchNumber")) != null && data.toString().trim().length() > 0) {
            info.setBatchNumber(this.batchNumberTrim(data.toString()));
        }
        if ((data = this.getData(hsData, "CostObjectGroup")) != null && data.toString().trim().length() > 0) {
            CostObjectGroupInfo groupInfo;
            String msgStr = ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"98_CostObjectDataImport", (Locale)ctx.getLocale());
            try {
                groupInfo = NCMDataImportUtil.getCostObjectGroupByNumber((Context)ctx, (String)msgStr, (String)data.toString(), (String)this.company.getCU().getId().toString());
            }
            catch (BOSException e) {
                groupInfo = NCMDataImportUtil.getCostObjectGroupByNumber((Context)ctx, (String)msgStr, (String)data.toString());
            }
            info.setCostObjectGroup(groupInfo);
        }
        if ((data = this.getData(hsData, "Bom")) != null && data.toString().trim().length() > 0 && (bom = NCMDataImportUtil.getBomByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"99_CostObjectDataImport", (Locale)ctx.getLocale()), (String)data.toString(), (String)this.company.getId().toString())) != null) {
            info.setBomID(bom.getId().toString());
        }
        if ((data = this.getData(hsData, "isForbiden")) == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"101_CostObjectDataImport", (Locale)ctx.getLocale()));
        }
        int isForbidenInt = this.getIntValueForBooleanFeild(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"100_CostObjectDataImport", (Locale)ctx.getLocale()), data);
        info.setIsForbiden(isForbidenInt == 1);
        data = this.getData(hsData, "standardRation");
        if (data != null && data.toString().trim().length() > 0) {
            info.setStandardRation(this.getBigDecimalValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"102_CostObjectDataImport", (Locale)ctx.getLocale()), data));
        }
        return info;
    }

    private void dealWithTheNumberByImpMode(Context ctx, Hashtable hsData, CostObjectInfo info) throws BOSException, TaskExternalException {
        String number = hsData.get("number").toString();
        if (number == null || number.length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"65_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)info.getCompany().getId().toString()));
        view.setFilter(filter);
        CostObjectCollection coll = ((ICostObject)this.getController(ctx)).getCostObjectCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (this.isSltImportUpdate()) {
                this.checkReference(ctx, coll.get(0).getId(), number);
                info.setId(coll.get(0).getId());
            } else {
                throw new BOSException(number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"103_CostObjectDataImport", (Locale)ctx.getLocale()));
            }
        }
        info.setNumber(number);
    }

    private void checkReference(Context ctx, BOSUuid id, String number) throws TaskExternalException, BOSException {
        try {
            if (((ICostObject)this.getController(ctx)).checkCostObjectReference(id)) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"104_CostObjectDataImport", (Locale)ctx.getLocale()));
            }
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private String batchNumberTrim(String number) {
        String batchNumber = number;
        if (batchNumber == null) {
            return null;
        }
        batchNumber = batchNumber + " ";
        int j = 0;
        int k = 0;
        int i = 0;
        char[] stra = new char[batchNumber.length()];
        batchNumber.getChars(0, batchNumber.length(), stra, 0);
        i = batchNumber.length() - 1;
        while (i + 1 > 0 && (stra[i] == ' ' || stra[i] == '\u3000')) {
            k = i--;
        }
        batchNumber = new String(stra, j, k - j);
        return batchNumber.trim();
    }
}

