/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoCollection;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoFactory;
import com.kingdee.eas.basedata.ncm.ExpenseCompanyInfoInfo;
import com.kingdee.eas.basedata.ncm.IExpenseCompanyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import java.util.Hashtable;
import java.util.Locale;

public class ExpenseCompanyInfoDataImport
extends AbstractNCMDataImport {
    CtrlUnitInfo cu = null;
    CompanyOrgUnitInfo company = null;
    boolean isCUBDControlForUpdate = false;
    boolean isCUBDControlForAdd = false;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ExpenseCompanyInfoFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        ExpenseCompanyInfoInfo expenseCompanyInfo = null;
        try {
            this.initOrgUnit(ctx);
            expenseCompanyInfo = this.parseHead(hsData, ctx);
            this.checkExpenseCompanyInfo(ctx, expenseCompanyInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return expenseCompanyInfo;
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.cu == null || this.company == null) {
            if (this.getContextParameter("cuId") != null) {
                this.cu = new CtrlUnitInfo();
                this.cu.setId(BOSUuid.read((String)((String)this.getContextParameter("cuId"))));
            }
            if (this.getContextParameter("companyId") != null) {
                this.company = new CompanyOrgUnitInfo();
                this.company.setId(BOSUuid.read((String)((String)this.getContextParameter("companyId"))));
            }
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
            this.isCUBDControlForAdd = NCMDataImportUtil.isCUBDControlForAdd((Context)ctx, (String)"DEBB1024", (String)this.cu.getId().toString());
            this.isCUBDControlForUpdate = NCMDataImportUtil.isCUBDControlForUpdate((Context)ctx, (String)"DEBB1024", (String)this.cu.getId().toString());
        }
    }

    private void checkCUBDControlForAdd(Context ctx) throws BOSException {
        if (!this.isCUBDControlForAdd) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"70_CostItemDataImport", (Locale)ctx.getLocale()));
        }
    }

    private void checkCUBDControlForUpdate(Context ctx) throws BOSException {
        if (!this.isCUBDControlForUpdate) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"71_CostItemDataImport", (Locale)ctx.getLocale()));
        }
    }

    private ExpenseCompanyInfoInfo parseHead(Hashtable hsData, Context ctx) throws BOSException, EASBizException {
        ExpenseCompanyInfoInfo info = new ExpenseCompanyInfoInfo();
        info.setCU(this.cu);
        info.setCompanyOrgUnit(this.company);
        Object data = this.getData(hsData, "expense");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"132_ExpenseCompanyInfoDataImport", (Locale)ctx.getLocale()));
        }
        info.setExpense(NCMDataImportUtil.getExpenseByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"131_ExpenseCompanyInfoDataImport", (Locale)ctx.getLocale()), (String)data.toString()));
        data = this.getData(hsData, "kAClass");
        if (data != null && data.toString().trim().length() > 0) {
            info.setKAClass(NCMDataImportUtil.getKAClassficationByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"133_ExpenseCompanyInfoDataImport", (Locale)ctx.getLocale()), (String)data.toString()));
        }
        if ((data = this.getData(hsData, "costItem")) == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"135_ExpenseCompanyInfoDataImport", (Locale)ctx.getLocale()));
        }
        info.setCostItem(this.getCostItemByNumber(ctx, data.toString()));
        return info;
    }

    private void checkExpenseCompanyInfo(Context ctx, ExpenseCompanyInfoInfo expenseCompanyInfo) throws BOSException, TaskExternalException {
        this.checkExpense(ctx, expenseCompanyInfo);
        this.checkExistOrNot(ctx, expenseCompanyInfo);
        this.checkKAClassfication(ctx, expenseCompanyInfo);
        this.checkCostItem(ctx, expenseCompanyInfo);
    }

    private void checkExpense(Context ctx, ExpenseCompanyInfoInfo expenseCompanyInfo) throws BOSException {
        NCMDataImportUtil.checkDataBaseDPermission((Context)ctx, (String)this.cu.getId().toString(), (String)expenseCompanyInfo.getExpense().getCU().getId().toString(), (String)"4A255827", (String)expenseCompanyInfo.getExpense().getId().toString(), (String)expenseCompanyInfo.getExpense().getNumber(), (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"131_ExpenseCompanyInfoDataImport", (Locale)ctx.getLocale()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkExistOrNot(Context ctx, ExpenseCompanyInfoInfo expenseCompanyInfo) throws BOSException, TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("expense", (Object)expenseCompanyInfo.getExpense().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)expenseCompanyInfo.getCompanyOrgUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("CU", (Object)expenseCompanyInfo.getCU().getId().toString()));
        view.setFilter(filter);
        ExpenseCompanyInfoCollection coll = ((IExpenseCompanyInfo)this.getController(ctx)).getExpenseCompanyInfoCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (!this.isSltImportUpdate()) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + expenseCompanyInfo.getExpense().getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"136_ExpenseCompanyInfoDataImport", (Locale)ctx.getLocale()));
            this.checkCUBDControlForUpdate(ctx);
            expenseCompanyInfo.setId(coll.get(0).getId());
            return;
        } else {
            this.checkCUBDControlForAdd(ctx);
        }
    }

    private void checkKAClassfication(Context ctx, ExpenseCompanyInfoInfo expenseCompanyInfo) throws BOSException {
        if (expenseCompanyInfo.getKAClass() == null) {
            return;
        }
        NCMDataImportUtil.checkKAClassfication((Context)ctx, (String)this.company.getId().toString(), (KAClassficationInfo)expenseCompanyInfo.getKAClass());
    }

    private void checkCostItem(Context ctx, ExpenseCompanyInfoInfo expenseCompanyInfo) throws BOSException {
        NCMDataImportUtil.checkDataBaseDPermission((Context)ctx, (String)this.cu.getId().toString(), (String)expenseCompanyInfo.getCostItem().getCU().getId().toString(), (String)"548C5A91", (String)expenseCompanyInfo.getCostItem().getId().toString(), (String)expenseCompanyInfo.getCostItem().getNumber(), (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"137_ExpenseCompanyInfoDataImport", (Locale)ctx.getLocale()));
    }
}

