/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.ncm.ExpenseCollection;
import com.kingdee.eas.basedata.ncm.ExpenseFactory;
import com.kingdee.eas.basedata.ncm.ExpenseInfo;
import com.kingdee.eas.basedata.ncm.ExpenseTypeEnum;
import com.kingdee.eas.basedata.ncm.IExpense;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import java.util.Hashtable;
import java.util.Locale;

public class ExpenseDataImport
extends AbstractNCMDataImport {
    CtrlUnitInfo cu = null;
    boolean isCUBDControlForUpdate = false;
    boolean isCUBDControlForAdd = false;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ExpenseFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        ExpenseInfo expense = null;
        try {
            this.initData(ctx);
            expense = this.parseHead(hsData, ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return expense;
    }

    private void initData(Context ctx) throws BOSException {
        if (this.cu == null) {
            this.cu = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCtrlUnit();
            this.isCUBDControlForAdd = NCMDataImportUtil.isCUBDControlForAdd((Context)ctx, (String)"4A255827", (String)this.cu.getId().toString());
            this.isCUBDControlForUpdate = NCMDataImportUtil.isCUBDControlForUpdate((Context)ctx, (String)"4A255827", (String)this.cu.getId().toString());
        }
    }

    private void checkCUBDControlForAdd(Context ctx) throws BOSException {
        if (!this.isCUBDControlForAdd) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"70_CostItemDataImport", (Locale)ctx.getLocale()));
        }
    }

    private void checkCUBDControlForUpdate(Context ctx, String adminCUID) throws BOSException {
        if (!adminCUID.equals(this.cu.getId().toString()) && !this.isCUBDControlForUpdate) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"71_CostItemDataImport", (Locale)ctx.getLocale()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExpenseInfo parseHead(Hashtable hsData, Context ctx) throws BOSException, TaskExternalException {
        ExpenseInfo info = new ExpenseInfo();
        info.setCU(this.cu);
        this.dealWithTheNumberByImpMode(ctx, hsData, info);
        Object data = this.getData(hsData, "name");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"138_ExpenseDataImport", (Locale)ctx.getLocale()));
        }
        info.setName(data.toString());
        data = this.getData(hsData, "expenseType");
        if (data == null || data.toString().trim().length() <= 0) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"142_ExpenseDataImport", (Locale)ctx.getLocale()));
        ExpenseTypeEnum expenseType = ExpenseTypeEnum.getEnum((int)this.getIntValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"139_ExpenseDataImport", (Locale)ctx.getLocale()), data));
        if (expenseType == null) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"141_ExpenseDataImport", (Locale)ctx.getLocale()));
        if (ExpenseTypeEnum.MATERIAL.equals((Object)expenseType)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"140_ExpenseDataImport", (Locale)ctx.getLocale()));
        }
        info.setExpenseType(expenseType);
        data = this.getData(hsData, "treeNumber");
        if (data != null && data.toString().trim().length() > 0) {
            info.setTreeid(NCMDataImportUtil.getExpenseTreeByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"143_ExpenseDataImport", (Locale)ctx.getLocale()), (String)data.toString()));
        }
        data = this.getData(hsData, "isAllocateQty");
        int isForbidenInt = this.getIntValueForBooleanFeild(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"80_CostItemDataImport", (Locale)ctx.getLocale()), data);
        info.setIsAllocateQty(isForbidenInt == 1);
        data = this.getData(hsData, "unit");
        if (data != null && data.toString().trim().length() > 0) {
            info.setUnit(NCMDataImportUtil.getMeasureUnitInfoByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"81_CostItemDataImport", (Locale)ctx.getLocale()), (String)data.toString()));
        }
        data = this.getData(hsData, "pricePrecision");
        int pricePrecision = this.getIntValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"82_CostItemDataImport", (Locale)ctx.getLocale()), data);
        if (pricePrecision < 0 || pricePrecision > 12) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"83_CostItemDataImport", (Locale)ctx.getLocale()));
        }
        info.setPricePrecision(pricePrecision);
        data = this.getData(hsData, "description");
        if (data == null || data.toString().trim().length() <= 0) return info;
        if (data.toString().length() > 255) {
            info.setDescription(data.toString().substring(0, 254));
            return info;
        } else {
            info.setDescription(data.toString());
        }
        return info;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dealWithTheNumberByImpMode(Context ctx, Hashtable hsData, ExpenseInfo info) throws BOSException, TaskExternalException {
        String number = hsData.get("number").toString();
        if (number == null || number.length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"144_ExpenseDataImport", (Locale)ctx.getLocale()));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        ExpenseCollection coll = ((IExpense)this.getController(ctx)).getExpenseCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (!this.isSltImportUpdate()) throw new BOSException(number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"87_CostItemDataImport", (Locale)ctx.getLocale()));
            this.checkCUBDControlForUpdate(ctx, coll.get(0).getCU().getId().toString());
            info.setId(coll.get(0).getId());
            if (!this.checkCanEdit(ctx, info, coll.get(0))) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"145_ExpenseDataImport", (Locale)ctx.getLocale()));
            info.setId(coll.get(0).getId());
            info.setCU(coll.get(0).getCU());
        } else {
            this.checkCUBDControlForAdd(ctx);
        }
        info.setNumber(number);
    }

    private boolean checkCanEdit(Context ctx, ExpenseInfo info, ExpenseInfo compareInfo) throws BOSException {
        return NCMDataImportUtil.isDataBaseDPermission((Context)ctx, (String)this.cu.getId().toString(), (String)compareInfo.getCU().getId().toString(), (String)"4A255827", (String)compareInfo.getId().toString());
    }
}

