/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.basedata.assistant.CostItemEnum;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.EopWipAdjustInfo;
import com.kingdee.eas.ncm.bill.InitBalanceAdjustFactory;
import com.kingdee.eas.ncm.bill.InitBalanceAdjustInfo;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMBatchDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class InitBalanceAdjustDataImport
extends AbstractNCMBatchDataImport {
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.bill.AdjustBillResource";
    Set setBlock = null;
    Map mapBlock = new HashMap();
    Map mapCIBlock = new HashMap();
    Map mapNumberBlock = new HashMap();
    Map mapNumberRulBlock = new HashMap();
    Map mapEntryBlock = new HashMap();
    Map mapMatBlock = new HashMap();

    protected String getResource(Context ctx, String resName) {
        return this.getResource(ctx, resName, null);
    }

    protected String getResource(Context ctx, String resName, Object[] params) {
        if (params != null) {
            return MessageFormat.format(ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale()), params);
        }
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale());
    }

    protected String buildTempTableSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table T ( \n");
        sql.append("     FID varchar(44), \n");
        sql.append("     FCIID varchar(44), \n");
        sql.append("     FMaID varchar(44), \n");
        sql.append("     FSourceID varchar(44), \n");
        sql.append("     FCISourceID varchar(44), \n");
        sql.append("     FMaSourceID varchar(44), \n");
        sql.append("     FNumber VARCHAR(88), \n");
        sql.append("     FPeriodID varchar(44), \n");
        this.buildCostCenterSQL(sql);
        this.buildCostObjectSQL(sql);
        this.buildCostItemSQL(sql);
        this.buildMaterialSQL(sql);
        sql.append("     FBatch VARCHAR(88), \n");
        sql.append("     FDescription VARCHAR(88), \n");
        sql.append("     FCOAdjustQty decimal(28,10) default(0), \n");
        sql.append("     FCOAdjustHour decimal(28,10) default(0), \n");
        sql.append("     FCOQty decimal(28,10) default(0), \n");
        sql.append("     FCOHour decimal(28,10) default(0), \n");
        sql.append("     FCOFinishQty decimal(28,10) default(0), \n");
        sql.append("     FCOFinishHour decimal(28,10) default(0), \n");
        sql.append("     FCIAdjustQty decimal(28,10) default(0), \n");
        sql.append("     FCIAdjustAmount decimal(17,4) default(0), \n");
        sql.append("     FCIQty decimal(28,10) default(0), \n");
        sql.append("     FCIAmount decimal(17,4) default(0), \n");
        sql.append("     FCIFinishAmount decimal(17,4) default(0), \n");
        sql.append("     FCIFinishQty decimal(28,10) default(0), \n");
        sql.append("     FMaAdjustQty decimal(28,10) default(0), \n");
        sql.append("     FMaAdjustAmount decimal(17,4) default(0), \n");
        sql.append("     FMaQty decimal(28,10) default(0), \n");
        sql.append("     FMaAmount decimal(17,4) default(0), \n");
        sql.append("     FMaFinishAmount decimal(17,4) default(0), \n");
        sql.append("     FMaFinishQty decimal(28,10) default(0), \n");
        sql.append("     FBillStatus INT, \n");
        sql.append("     FIndex int default(0) \n");
        sql.append(") \n");
        return sql.toString();
    }

    protected void doProcessBlockData(Context ctx, RecordCollection coll) throws Exception {
        PreparedStatement pstmtInsert = null;
        Connection conn = null;
        Set set = this.getBillNum(ctx);
        StringBuffer sqlInsert = new StringBuffer();
        sqlInsert.append("INSERT INTO ").append(this.tempTable).append(" ( \n").append("FNumber,FPeriodID,FBillStatus,FCostCenterNumber,FCostObjectNumber, \n").append("FCostItemNumber,FMaterialNumber,FBatch,FCOAdjustQty,FCOAdjustHour,FCIAdjustQty, \n").append("FCIAdjustAmount,FMaAdjustQty,FMaAdjustAmount,FIndex,FID,FCIID,FMaID,FDescription ) \n").append(" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(sqlInsert.toString());
            for (int rowIndex = 0; rowIndex < coll.size(); ++rowIndex) {
                ++this.index;
                IRecord rowData = coll.get(rowIndex);
                String costCenterNumber = null;
                String costObjectNumber = null;
                String costItemNumber = null;
                String materialNumber = null;
                String batch = null;
                CostItemInfo costItemInfo = null;
                MaterialInfo materialInfo = null;
                String number = null;
                String ID = null;
                String CIID = null;
                String MaID = null;
                String qty = this.getData((SimpleRecord)rowData, "FCIAdjustQty");
                String amount = this.getData((SimpleRecord)rowData, "FCIAdjustAmount");
                costCenterNumber = this.getData((SimpleRecord)rowData, "FCostCenterNumber");
                CostCenterOrgUnitInfo cc = NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)this.getResource(ctx, "CostCenterNumber"), (String)costCenterNumber);
                costObjectNumber = this.getData((SimpleRecord)rowData, "FCostObjectNumber");
                CostObjectInfo co = NCMDataImportUtil.getCostObjectbyNumber((Context)ctx, (String)this.getResource(ctx, "CostObjectNumber"), (String)costObjectNumber, (String)this.companyId);
                costItemNumber = this.getData((SimpleRecord)rowData, "FCostItemNumber");
                materialNumber = this.getData((SimpleRecord)rowData, "FMaterialNumber");
                batch = this.getData((SimpleRecord)rowData, "FBatch");
                if (CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist((IObjectValue)new EopWipAdjustInfo(), this.companyId)) {
                    if (this.mapNumberRulBlock.containsKey(cc.getId().toString() + co.getId().toString())) {
                        number = this.mapNumberRulBlock.get(cc.getId().toString() + co.getId().toString()).toString();
                    } else {
                        number = InitBalanceAdjustFactory.getLocalInstance(ctx).getNewNumber((IObjectValue)new InitBalanceAdjustInfo(), this.companyId, null);
                        this.mapNumberRulBlock.put(cc.getId().toString() + co.getId().toString(), number);
                    }
                } else {
                    number = this.getData((SimpleRecord)rowData, "FNumber");
                    if (set.contains(number) && !this.isSltImportUpdate()) {
                        this.onDataError(this.index, this.getResource(ctx, "BillNumber") + number + this.getResource(ctx, "IsBeing"));
                        continue;
                    }
                    if (number == null || number.length() < 0) {
                        this.onDataError(this.index, this.getResource(ctx, "BillNumberIsNull"));
                        continue;
                    }
                    if (this.mapNumberBlock.containsKey(cc.getId().toString() + co.getId().toString())) {
                        if (!number.equals(this.mapNumberBlock.get(cc.getId().toString() + co.getId().toString()))) {
                            this.onDataError(this.index, this.getResource(ctx, "BillAndCCAndCoNumber"));
                            continue;
                        }
                    } else {
                        this.mapNumberBlock.put(cc.getId().toString() + co.getId().toString(), number);
                    }
                }
                costItemInfo = NCMDataImportUtil.getCostItemByNumber((Context)ctx, (String)this.getResource(ctx, "CostItemNumber"), (String)costItemNumber);
                if (CostItemEnum.STUFF.equals((Object)costItemInfo.getItemType())) {
                    if (materialNumber == null) {
                        this.onDataError(this.index, this.getResource(ctx, "MaterialNumberIsNull"));
                        continue;
                    }
                    materialInfo = NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)this.getResource(ctx, "MatNumber"), (String)materialNumber);
                    MaterialCompanyInfoInfo matComInfo = NCMDataImportUtil.getMaterialCompanyInfoByMaterial((Context)ctx, (String)materialNumber, (String)materialInfo.getId().toString(), (String)this.companyId);
                    if (matComInfo.getAccountType().getValue() == 5 && (batch == null || batch.equals(""))) {
                        this.onDataError(this.index, this.getResource(ctx, "BatchNoIsNull"));
                        continue;
                    }
                    if (this.mapMatBlock.containsKey(cc.getId().toString() + co.getId().toString() + costItemInfo.getId().toString() + materialInfo.getId().toString() + batch)) {
                        this.onDataError(this.index, this.getResource(ctx, "AllNumberAndBatch"));
                        continue;
                    }
                    this.mapMatBlock.put(cc.getId().toString() + co.getId().toString() + costItemInfo.getId().toString() + materialInfo.getId().toString() + batch, number);
                    MaID = BOSUuid.create((String)"060BE5CD").toString();
                } else {
                    if (!(costItemInfo.isIsAllocateQty() || qty == null || qty.equals("0") || qty.startsWith("0E"))) {
                        this.onDataError(this.index, this.getResource(ctx, "QtyCanNotAdjust"));
                        continue;
                    }
                    if (materialNumber != null) {
                        this.onDataError(this.index, this.getResource(ctx, "MaterialNumberIsNotNull"));
                        continue;
                    }
                    if (this.mapEntryBlock.containsKey(cc.getId().toString() + co.getId().toString() + costItemInfo.getId().toString())) {
                        this.onDataError(this.index, this.getResource(ctx, "CCAndCOAndCI"));
                        continue;
                    }
                    this.mapEntryBlock.put(cc.getId().toString() + co.getId().toString() + costItemInfo.getId().toString(), number);
                }
                if (this.mapBlock.containsKey(cc.getId().toString() + co.getId().toString())) {
                    ID = (String)this.mapBlock.get(cc.getId().toString() + co.getId().toString());
                } else {
                    ID = BOSUuid.create((String)"397D63E2").toString();
                    this.mapBlock.put(cc.getId().toString() + co.getId().toString(), ID);
                }
                if (this.mapCIBlock.containsKey(cc.getId().toString() + co.getId().toString() + costItemInfo.getId().toString())) {
                    CIID = (String)this.mapCIBlock.get(cc.getId().toString() + co.getId().toString() + costItemInfo.getId().toString());
                } else {
                    CIID = BOSUuid.create((String)"FB9B1E2E").toString();
                    this.mapCIBlock.put(cc.getId().toString() + co.getId().toString() + costItemInfo.getId().toString(), CIID);
                }
                pstmtInsert.setString(1, number);
                pstmtInsert.setString(2, this.periodId);
                pstmtInsert.setString(3, this.getFieldValue(false, rowData, "FBillStatus", this.getResource(ctx, "BillStatus")));
                pstmtInsert.setString(4, this.getFieldValue(false, rowData, "FCostCenterNumber", this.getResource(ctx, "CostCenterNumber")));
                pstmtInsert.setString(5, this.getFieldValue(false, rowData, "FCostObjectNumber", this.getResource(ctx, "CostObjectNumber")));
                pstmtInsert.setString(6, this.getFieldValue(false, rowData, "FCostItemNumber", this.getResource(ctx, "CostItemNumber")));
                pstmtInsert.setString(7, this.getFieldValue(true, rowData, "FMaterialNumber", this.getResource(ctx, "MatNumber")));
                pstmtInsert.setString(8, this.getFieldValue(true, rowData, "FBatch", this.getResource(ctx, "BatchNo")));
                pstmtInsert.setBigDecimal(9, new BigDecimal(this.getFieldValue(true, rowData, "FCOAdjustQty", this.getResource(ctx, "WipQtyAdjust")).equals("") ? "0" : this.getFieldValue(true, rowData, "FCOAdjustQty", this.getResource(ctx, "WipQtyAdjust"))));
                pstmtInsert.setBigDecimal(10, new BigDecimal(this.getFieldValue(true, rowData, "FCOAdjustHour", this.getResource(ctx, "WipHourAdjust")).equals("") ? "0" : this.getFieldValue(true, rowData, "FCOAdjustHour", this.getResource(ctx, "WipHourAdjust"))));
                pstmtInsert.setBigDecimal(11, new BigDecimal(this.getFieldValue(true, rowData, "FCIAdjustQty", this.getResource(ctx, "QtyAdjust")).equals("") ? "0" : this.getFieldValue(true, rowData, "FCIAdjustQty", this.getResource(ctx, "QtyAdjust"))));
                pstmtInsert.setBigDecimal(12, new BigDecimal(this.getFieldValue(true, rowData, "FCIAdjustAmount", this.getResource(ctx, "AmountAdjust")).equals("") ? "0" : this.getFieldValue(true, rowData, "FCIAdjustAmount", this.getResource(ctx, "AmountAdjust"))));
                pstmtInsert.setBigDecimal(13, new BigDecimal(this.getFieldValue(true, rowData, "FMaAdjustQty", this.getResource(ctx, "MatQtyAdjust")).equals("") ? "0" : this.getFieldValue(true, rowData, "FMaAdjustQty", this.getResource(ctx, "MatQtyAdjust"))));
                pstmtInsert.setBigDecimal(14, new BigDecimal(this.getFieldValue(true, rowData, "FMaAdjustAmount", this.getResource(ctx, "MatAmountAdjust")).equals("") ? "0" : this.getFieldValue(true, rowData, "FMaAdjustAmount", this.getResource(ctx, "MatAmountAdjust"))));
                pstmtInsert.setInt(15, this.index);
                pstmtInsert.setString(16, ID);
                pstmtInsert.setString(17, CIID);
                if (MaID != null) {
                    pstmtInsert.setString(18, MaID);
                } else {
                    pstmtInsert.setString(18, null);
                }
                pstmtInsert.setString(19, this.getFieldValue(true, rowData, "FDescription", this.getResource(ctx, "BatchNo")));
                pstmtInsert.addBatch();
            }
            pstmtInsert.executeBatch();
        }
        catch (SQLException e1) {
            try {
                throw new TaskExternalException(e1.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
    }

    private String getFieldValue(boolean isCanNUll, IRecord rowData, String fieldName, String messageName) throws TaskRunnerException {
        String returnValue = rowData.get(fieldName).toString();
        if (isCanNUll) {
            return returnValue;
        }
        if (returnValue == null || returnValue.length() == 0) {
            this.onDataError(this.index, messageName + "\u4e3a\u7a7a");
        }
        return returnValue;
    }

    protected Set getBillNum(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        HashSet<String> set = new HashSet<String>();
        String number = null;
        sql.setLength(0);
        sql.append("select Fnumber from T_NCM_InitBalanceAdjust \n");
        sql.append("where  FCompanyOrg = '" + this.companyId + "' and FCalculatePeriod = '" + this.period.getId().toString() + "';\n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            number = rs.getString("FNUmber");
            if (set.contains(number)) continue;
            set.add(number);
        }
        return set;
    }

    protected void verifyBaseStatusa(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select * from " + this.getTempTable() + " \n");
        sql.append("where  FBillStatus not in (2,3) ;\n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            this.onDataError(index, "\u5355\u636e\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u53ea\u80fd\u5f15\u5165\u4fdd\u5b58\u6216\u63d0\u4ea4\u72b6\u6001\u7684\u5355\u636e\u3002");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.getTempTable() + " \n");
            sql.append("where FBillStatus not in (2,3) \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    protected void checkData(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("select FIndex from " + this.getTempTable() + " \n");
        sql.append("where  FCOFinishQty < 0 or FCOFinishHour < 0 ;\n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasErrorRecord = false;
        while (rs.next()) {
            hasErrorRecord = true;
            int index = rs.getInt("FIndex");
            this.onDataError(index, "\u8c03\u6574\u540e\u7684\u5de5\u65f6\u3001\u6570\u91cf\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\uff01");
        }
        if (hasErrorRecord) {
            sql.setLength(0);
            sql.append("delete from " + this.getTempTable() + " \n");
            sql.append("where FCOFinishQty < 0 or FCOFinishHour < 0 or FCIFinishQty < 0 or FCIFinishAmount < 0 or FMaFinishQty < 0 or FMaFinishAmount < 0 ; \n");
            NCMDbUtil.execute((Context)ctx, (String)sql.toString());
        }
        if (!this.isSltImportUpdate()) {
            sql.setLength(0);
            sql.append("select t.FIndex FIndex,t.FCostCenterNumber FCostCenterNumber,t.FCostObjectNumber FCostObjectNumber from " + this.getTempTable() + " t \n");
            sql.append("       inner join T_NCM_InitBalanceAdjust adjust ");
            sql.append("       on adjust.FCostCenterID = t.FCostCenterID and adjust.FCostObjectID = t.FCostObjectID ");
            sql.append("          AND adjust.FCalculatePeriod = t.FPeriodID AND adjust.FCompanyOrg = '" + this.companyId + "' ; \n");
            IRowSet rs1 = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
            boolean hasErrorRecord1 = false;
            while (rs1.next()) {
                hasErrorRecord1 = true;
                int index = rs1.getInt("FIndex");
                String cc = rs1.getString("FCostCenterNumber");
                String co = rs1.getString("FCostObjectNumber");
                this.onDataError(index, "\u6570\u636e\u5e93\u4e2d\u5df2\u7ecf\u5b58\u5728\u6210\u672c\u4e2d\u5fc3[" + cc + "]\u6210\u672c\u5bf9\u8c61[" + co + "]\u7684\u7ec4\u5408\uff01");
            }
            if (hasErrorRecord1) {
                sql.setLength(0);
                sql.append("delete from " + this.getTempTable() + " \n");
                sql.append("where fid in ( \n");
                sql.append("select t.fid from " + this.getTempTable() + " t \n");
                sql.append("       inner join T_NCM_InitBalanceAdjust adjust ");
                sql.append("       on adjust.FCostCenterID = t.FCostCenterID and adjust.FCostObjectID = t.FCostObjectID ");
                sql.append("          AND adjust.FCalculatePeriod = t.FPeriodID AND adjust.FCompanyOrg = '" + this.companyId + "') ; \n");
                NCMDbUtil.execute((Context)ctx, (String)sql.toString());
            }
        } else {
            sql.setLength(0);
            sql.append("select t.FIndex FIndex,t.FCostCenterNumber FCostCenterNumber,t.FCostObjectNumber FCostObjectNumber from " + this.getTempTable() + " t \n");
            sql.append("       inner join T_NCM_InitBalanceAdjust adjust ");
            sql.append("       on adjust.FCostCenterID = t.FCostCenterID and adjust.FCostObjectID = t.FCostObjectID ");
            sql.append("          AND adjust.FCalculatePeriod = t.FPeriodID AND adjust.Fbillstatus = '4' and adjust.FCompanyOrg = '" + this.companyId + "' ; \n");
            IRowSet rs1 = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
            boolean hasErrorRecord1 = false;
            while (rs1.next()) {
                hasErrorRecord1 = true;
                int index = rs1.getInt("FIndex");
                String cc = rs1.getString("FCostCenterNumber");
                String co = rs1.getString("FCostObjectNumber");
                this.onDataError(index, "\u4e0d\u80fd\u8986\u76d6\u5df2\u7ecf\u5ba1\u6838\u7684\u6210\u672c\u4e2d\u5fc3[" + cc + "]\u6210\u672c\u5bf9\u8c61[" + co + "]\u7684\u7ec4\u5408\uff01");
            }
            if (hasErrorRecord1) {
                sql.setLength(0);
                sql.append("delete from " + this.getTempTable() + " \n");
                sql.append("where fid in ( \n");
                sql.append("select t.fid from " + this.getTempTable() + " t \n");
                sql.append("       inner join T_NCM_InitBalanceAdjust adjust ");
                sql.append("       on adjust.FCostCenterID = t.FCostCenterID and adjust.FCostObjectID = t.FCostObjectID ");
                sql.append("          AND adjust.FCalculatePeriod = t.FPeriodID AND adjust.Fbillstatus = '4' and adjust.FCompanyOrg = '" + this.companyId + "') ; \n");
                NCMDbUtil.execute((Context)ctx, (String)sql.toString());
            }
        }
    }

    protected int doProcessData(Context ctx) throws Exception {
        this.fillAndVerifyCostCenter(ctx);
        this.fillAndVerifyCostObject(ctx);
        this.fillAndVerifyMaterial(ctx);
        this.fillAndVerifyCostItem(ctx);
        this.fillWipAndFinishData(ctx);
        this.verifyBaseStatusa(ctx);
        this.fillDataByPrecision(ctx);
        this.checkData(ctx);
        return this.submitData(ctx);
    }

    private void fillWipAndFinishData(Context ctx) throws EASBizException, BOSException {
        String Balance = null;
        String BalanceEntry = null;
        String BalanceMatDetail = null;
        StringBuffer sql = new StringBuffer();
        try {
            Balance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)this.companyId, (String)"T_NCM_Balance");
            BalanceEntry = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)this.companyId, (String)"T_NCM_BalanceEntry");
            BalanceMatDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)this.companyId, (String)"T_NCM_BalanceMatDetail");
            sql.append("update ").append(this.getTempTable()).append(" set (FSourceID,FCOQty,FCOHour)=").append("(select adjust.Fid,isnull(adjust.FBopWipQty,0),isnull(adjust.FBopWipHour,0) ").append("from ").append(Balance).append(" as adjust ").append(" where ").append(this.getTempTable()).append(".FCostCenterID = adjust.FCostCenterID and ").append(this.getTempTable()).append(".FCostObjectID = adjust.FCostObjectID) ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("update ").append(this.getTempTable()).append(" set (FCISourceID,FCIQty,FCIAmount)=").append("(select adjustentry.Fid,isnull(adjustentry.FBopWipQty,0),isnull(adjustentry.FBopWipAmount,0) ").append("from ").append(Balance).append(" as adjust ").append(" inner join ").append(BalanceEntry).append(" as adjustentry ").append("  on adjust.Fid = adjustentry.Fparentid ").append(" where ").append(this.getTempTable()).append(".FCostCenterID = adjust.FCostCenterID and ").append(this.getTempTable()).append(".FCostObjectID = adjust.FCostObjectID and ").append(this.getTempTable()).append(".FcostItemID = adjustentry.FcostItemID ) ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("update ").append(this.getTempTable()).append("  set (FMaSourceID,FMaQty,FMaAmount)=").append("(select mat.Fid,isnull(mat.FQty,0),isnull(mat.FAmount,0) ").append("from ").append(Balance).append(" as adjust ").append(" inner join ").append(BalanceEntry).append(" as adjustentry ").append("  on adjust.Fid = adjustentry.Fparentid ").append(" inner join ").append(BalanceMatDetail).append(" as mat ").append("  on adjustentry.Fid = mat.Fparentid and mat.FisRework = '0' ").append(" where ").append(this.getTempTable()).append(".FCostCenterID = adjust.FCostCenterID and ").append(this.getTempTable()).append(".FCostObjectID = adjust.FCostObjectID and ").append(this.getTempTable()).append(".FcostItemID = adjustentry.FcostItemID and ").append(this.getTempTable()).append(".Fmaterialid = mat.Fmaterialid  ").append(" and isnull(").append(this.getTempTable()).append(".FBatch,' ') = isnull(mat.FBatchNo,' ') )");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("update ").append(this.getTempTable()).append(" set FCIAdjustQty=").append("(select sum(t2.FMaAdjustQty) from ").append(this.getTempTable()).append(" t2 ").append("  where ").append(this.getTempTable()).append(".Fid = t2.Fid and ").append(this.getTempTable()).append(".FCIID = t2.FCIID and ").append(this.getTempTable()).append(".FcostItemID = t2.FcostItemID)").append(" where FMaID is not null;");
            sql.append("update ").append(this.getTempTable()).append(" set FCIAdjustAmount=").append("(select sum(t2.FMaAdjustAmount) from ").append(this.getTempTable()).append(" t2 ").append("  where ").append(this.getTempTable()).append(".Fid = t2.Fid and ").append(this.getTempTable()).append(".FCIID = t2.FCIID and ").append(this.getTempTable()).append(".FcostItemID = t2.FcostItemID)").append(" where FMaID is not null;");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("update ").append(this.getTempTable()).append(" set FCOFinishQty=").append("FCOQty+FCOAdjustQty ;");
            sql.append("update ").append(this.getTempTable()).append(" set FCOFinishHour=").append("FCOHour+FCOAdjustHour ;");
            sql.append("update ").append(this.getTempTable()).append(" set FCIFinishAmount=").append("FCIAmount+FCIAdjustAmount ;");
            sql.append("update ").append(this.getTempTable()).append(" set FCIFinishQty=").append("FCIQty+FCIAdjustQty ;");
            sql.append("update ").append(this.getTempTable()).append(" set FMaFinishAmount=").append("FMaAmount+FMaAdjustAmount ;");
            sql.append("update ").append(this.getTempTable()).append(" set FMaFinishQty=").append("FMaQty+FMaAdjustQty ;");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void fillDataByPrecision(Context ctx) throws EASBizException, BOSException {
        try {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.company.getBaseCurrency().getId()));
            int curPrecision = currency == null ? 2 : currency.getPrecision();
            StringBuffer sql = new StringBuffer();
            sql.append("update ").append(this.tempTable).append(" set (FCOAdjustQty,FCOAdjustHour,FCOQty,FCOHour,FCOFinishQty,FCOFinishHour,").append("      FCIAdjustQty,FCIAdjustAmount,FCIQty,FCIAmount,FCIFinishAmount,FCIFinishQty)=").append(" (select round(").append(this.tempTable).append(".FCOAdjustQty,4),round(").append(this.tempTable).append(".FCOAdjustHour,2),").append("         round(").append(this.tempTable).append(".FCOQty,4),round(").append(this.tempTable).append(".FCOHour,2),").append("         round(").append(this.tempTable).append(".FCOFinishQty,4),round(").append(this.tempTable).append(".FCOFinishHour,2),").append("         round(").append(this.tempTable).append(".FCIAdjustQty,unit.FQtyPrecision),round(").append(this.tempTable).append(".FCIAdjustAmount,").append(curPrecision).append("),").append("         round(").append(this.tempTable).append(".FCIQty,unit.FQtyPrecision),round(").append(this.tempTable).append(".FCIAmount,").append(curPrecision).append("),").append("         round(").append(this.tempTable).append(".FCIFinishAmount,").append(curPrecision).append("),round(").append(this.tempTable).append(".FCIFinishQty,unit.FQtyPrecision) ").append("  from t_ncm_costitem item ").append("    inner join t_bd_measureunit unit on item.Funitid = unit.Fid ").append(" where item.FisAllocateQty = '1' and item.Fid = ").append(this.tempTable).append(".FCostItemID) ; \n");
            sql.append("update ").append(this.tempTable).append(" set (FMaAdjustQty,FMaAdjustAmount,FMaQty,FMaAmount,FMaFinishAmount,FMaFinishQty)=").append(" (select round(").append(this.tempTable).append(".FMaAdjustQty,mulunit.FQtyPrecision),round(").append(this.tempTable).append(".FMaAdjustAmount,").append(curPrecision).append("),").append("         round(").append(this.tempTable).append(".FMaQty,mulunit.FQtyPrecision),round(").append(this.tempTable).append(".FMaAmount,").append(curPrecision).append("),").append("         round(").append(this.tempTable).append(".FMaFinishAmount,").append(curPrecision).append("),round(").append(this.tempTable).append(".FMaFinishQty,mulunit.FQtyPrecision) ").append("  from t_bd_material material ").append("    inner join t_bd_multimeasureunit mulunit on material.Fid = mulunit.Fmaterialid and material.Fbaseunit = mulunit.Fmeasureunitid ").append(" where material.Fid = ").append(this.tempTable).append(".FMaterialID) ; \n");
            sql.append("update ").append(this.tempTable).append(" set \n");
            sql.append("FCIAdjustAmount = round(FCIAdjustAmount,").append(curPrecision).append("),\n");
            sql.append("FCIAmount = round(FCIAmount,").append(curPrecision).append("),\n");
            sql.append("FCIFinishAmount = round(FCIFinishAmount,").append(curPrecision).append("),\n");
            sql.append("FMaAdjustAmount = round(FMaAdjustAmount,").append(curPrecision).append("),\n");
            sql.append("FMaAmount = round(FMaAmount,").append(curPrecision).append("),\n");
            sql.append("FMaFinishAmount = round(FMaFinishAmount,").append(curPrecision).append(");\n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
    }

    private int submitData(Context ctx) throws Exception {
        StringBuffer sql = new StringBuffer();
        if (this.isSltImportUpdate()) {
            sql.append("delete from  T_NCM_MatDetailAdjust where Fparentid in ( \n");
            sql.append("    select entry.fid from ");
            sql.append("              T_NCM_InitBalanceEntryAdjust entry  \n");
            sql.append("    inner join T_NCM_InitBalanceAdjust bill ON bill.Fid = entry.FParentID \n");
            sql.append("    inner join " + this.tempTable + " t ON bill.FCostCenterID = t.FCostCenterID \n");
            sql.append("                                       AND bill.FCostObjectID = t.FCostObjectID \n");
            sql.append("                                       AND bill.FCompanyOrg = '" + this.companyId + "' \n");
            sql.append("                                       AND bill.FCalculatePeriod = t.FPeriodID); \n");
            sql.append("delete from  T_NCM_InitBalanceEntryAdjust  where Fparentid in (\n");
            sql.append("    select bill.fid  from T_NCM_InitBalanceAdjust bill \n");
            sql.append("    inner join " + this.tempTable + " t ON bill.FCostCenterID = t.FCostCenterID \n");
            sql.append("                                       AND bill.FCostObjectID = t.FCostObjectID \n");
            sql.append("                                       AND bill.FCompanyOrg = '" + this.companyId + "' \n");
            sql.append("                                       AND bill.FCalculatePeriod = t.FPeriodID) \n");
            sql.append("; \n");
            sql.append("delete from  T_NCM_InitBalanceAdjust where fid in  ( \n");
            sql.append("    select bill.Fid from T_NCM_InitBalanceAdjust bill ");
            sql.append("    inner join " + this.tempTable + " t ON bill.FCostCenterID = t.FCostCenterID \n");
            sql.append("                                       AND bill.FCostObjectID = t.FCostObjectID \n");
            sql.append("                                       AND bill.FCompanyOrg = '" + this.companyId + "' \n");
            sql.append("                                       AND bill.FCalculatePeriod = t.FPeriodID); \n");
        }
        sql.append("insert into T_NCM_InitBalanceAdjust ( \n");
        sql.append("    FID, \n");
        sql.append("    FCompanyOrg, \n");
        sql.append("    FCalculatePeriod, \n");
        sql.append("    FCostCenterID, \n");
        sql.append("    FCostObjectID, \n");
        sql.append("    FBizDate, \n");
        sql.append("    FCreatorID, \n");
        sql.append("    FCreateTime, \n");
        sql.append("    FLastUpdateUserID, \n");
        sql.append("    FLastUpdateTime, \n");
        sql.append("    FControlUnitID, \n");
        sql.append("    FSourceID \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    t.Fid, \n");
        sql.append("    '" + this.companyId + "', \n");
        sql.append("    t.FPeriodID, \n");
        sql.append("    t.FCostCenterID, \n");
        sql.append("    t.FCostObjectID, \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.userId + "', \n");
        sql.append("    getdate(), \n");
        sql.append("    '" + this.cuId + "', \n");
        sql.append("    t.FSourceID \n");
        sql.append("from ").append(this.tempTable).append(" t \n");
        sql.append("          group by t.fid,t.FPeriodID,t.FCostCenterID,t.FCostObjectID,t.FSourceID ;\n");
        sql.append(" update T_NCM_InitBalanceAdjust adjust set (FNumber,FBillStatus,FDescription,FBopWIPQty,FadjustQty,FFinishQty,FBopWIPHour,FAdjustHour,FFinishHour)=");
        sql.append(" (select top 1 t.FNumber,t.FBillStatus,t.FDescription,t.FCOQty,t.FCOadjustQty,t.FCOFinishQty,t.FCOHour,t.FCOAdjustHour,t.FCOFinishHour from ").append(this.tempTable);
        sql.append("  t where t.fid = adjust.fid); \n");
        sql.append("insert into T_NCM_InitBalanceEntryAdjust ( \n");
        sql.append("    FID, \n");
        sql.append("    FParentID, \n");
        sql.append("    FCostItemID, \n");
        sql.append("    FSourceID \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    t.FCIID, \n");
        sql.append("    t.FID, \n");
        sql.append("    t.FCostItemID, \n");
        sql.append("    t.FCISourceID \n");
        sql.append("   From ").append(this.tempTable).append(" t \n");
        sql.append("          group by t.fciid,t.Fid,t.FCostItemID,t.FCISourceID ; \n");
        sql.append(" update T_NCM_InitBalanceEntryAdjust entry set (FBopWIPQty,FadjustQty,FFinishQty,FBopWIPAmount,FAdjustAmount,FFinishAmount)=");
        sql.append(" (select top 1 t.FCIQty,t.FCIadjustQty,t.FCIFinishQty,t.FCIAmount,t.FCIAdjustAmount,t.FCIFinishAmount from ").append(this.tempTable);
        sql.append(" t  where entry.Fid = t.Fciid and entry.Fparentid = t.Fid and entry.FcostItemID = t.FcostItemID ) ;");
        sql.append("insert into T_NCM_MatDetailAdjust ( \n");
        sql.append("    FID, \n");
        sql.append("    FParentID, \n");
        sql.append("    FMaterialID, \n");
        sql.append("    FSourceID, \n");
        sql.append("    FBatchNo, \n");
        sql.append("    FQty, \n");
        sql.append("    FadjustQty, \n");
        sql.append("    FFinishQty, \n");
        sql.append("    FAmount, \n");
        sql.append("    FAdjustAmount, \n");
        sql.append("    FFinishAmount \n");
        sql.append(") \n");
        sql.append("select  \n");
        sql.append("    t.FMaID, \n");
        sql.append("    t.FCIID, \n");
        sql.append("    t.FMaterialID, \n");
        sql.append("    t.FMaSourceID, \n");
        sql.append("    t.FBatch, \n");
        sql.append("    t.FMaQty, \n");
        sql.append("    t.FMaadjustQty, \n");
        sql.append("    t.FMaFinishQty, \n");
        sql.append("    t.FMaAmount, \n");
        sql.append("    t.FMaAdjustAmount, \n");
        sql.append("    t.FMaFinishAmount \n");
        sql.append("   From ").append(this.tempTable).append(" t \n");
        sql.append("   where t.FMaId is not null ;\n");
        NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("select count(*) from " + this.tempTable + " \n");
        IRowSet rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            BigDecimal qty;
            result.put("FNumber", this.getNotBlankString(rs.getString("number")));
            result.put("FBillStatus", this.getNotBlankString(rs.getString("billStatus")));
            result.put("FCostCenterNumber", this.getNotBlankString(rs.getString("costCenter.number")));
            result.put("FCostObjectNumber", this.getNotBlankString(rs.getString("costObject.number")));
            if (rs.getString("adjustQty") != null) {
                if ("".equalsIgnoreCase(this.getNotBlankString(rs.getString("adjustQty"))) || this.getNotBlankString(rs.getString("adjustQty")).length() < 1) {
                    result.put("FCOAdjustQty", NCMConst.ZERO);
                } else {
                    qty = new BigDecimal(rs.getString("adjustQty"));
                    result.put("FCOAdjustQty", qty);
                }
            }
            if (rs.getString("adjustHour") != null) {
                if ("".equalsIgnoreCase(this.getNotBlankString(rs.getString("adjustHour"))) || this.getNotBlankString(rs.getString("adjustHour")).length() < 1) {
                    result.put("FCOAdjustHour", NCMConst.ZERO);
                } else {
                    qty = new BigDecimal(rs.getString("adjustHour"));
                    result.put("FCOAdjustHour", qty);
                }
            }
            result.put("FDescription", this.getNotBlankString(rs.getString("description")));
            result.put("FCostItemNumber", this.getNotBlankString(rs.getString("costItem.number")));
            if (rs.getString("entrys.adjustQty") != null) {
                if ("".equalsIgnoreCase(this.getNotBlankString(rs.getString("entrys.adjustQty"))) || this.getNotBlankString(rs.getString("entrys.adjustQty")).length() < 1) {
                    result.put("FCIAdjustQty", NCMConst.ZERO);
                } else {
                    qty = new BigDecimal(rs.getString("entrys.adjustQty"));
                    result.put("FCIAdjustQty", qty);
                }
            }
            if (rs.getString("entrys.adjustAmount") != null) {
                if ("".equalsIgnoreCase(this.getNotBlankString(rs.getString("entrys.adjustAmount"))) || this.getNotBlankString(rs.getString("entrys.adjustAmount")).length() < 1) {
                    result.put("FCIAdjustAmount", NCMConst.ZERO);
                } else {
                    qty = new BigDecimal(rs.getString("entrys.adjustAmount"));
                    result.put("FCIAdjustAmount", qty);
                }
            }
            result.put("FMaterialNumber", this.getNotBlankString(rs.getString("material.number")));
            result.put("FBatch", this.getNotBlankString(rs.getString("matDetail.batchNo")));
            if (rs.getString("matDetail.adjustQty") != null) {
                if ("".equalsIgnoreCase(this.getNotBlankString(rs.getString("matDetail.adjustQty"))) || this.getNotBlankString(rs.getString("matDetail.adjustQty")).length() < 1) {
                    result.put("FMaAdjustQty", NCMConst.ZERO);
                } else {
                    qty = new BigDecimal(rs.getString("matDetail.adjustQty"));
                    result.put("FMaAdjustQty", qty);
                }
            }
            if (rs.getString("matDetail.adjustAmount") != null) {
                if ("".equalsIgnoreCase(this.getNotBlankString(rs.getString("matDetail.adjustAmount"))) || this.getNotBlankString(rs.getString("matDetail.adjustAmount")).length() < 1) {
                    result.put("FMaAdjustAmount", NCMConst.ZERO);
                } else {
                    qty = new BigDecimal(rs.getString("matDetail.adjustAmount"));
                    result.put("FMaAdjustAmount", qty);
                }
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

