/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.CostItemEnum;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.bill.InitBalanceEntryCollection;
import com.kingdee.eas.ncm.bill.InitBalanceEntryInfo;
import com.kingdee.eas.ncm.bill.InitBalanceFactory;
import com.kingdee.eas.ncm.bill.InitBalanceInfo;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.CostObjectRelatedInfo;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.CostObjectUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;

public class InitBalanceDataImport
extends AbstractNCMDataImport {
    CtrlUnitInfo cu = null;
    CompanyOrgUnitInfo company = null;
    PeriodInfo period = null;

    public int getSubmitType() {
        return 1;
    }

    public String getMainField() {
        return "number";
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return InitBalanceFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsDataBlock, Context ctx) throws TaskExternalException {
        InitBalanceInfo head = null;
        try {
            this.initOrgUnit(ctx);
            for (int i = 0; i < hsDataBlock.size(); ++i) {
                Hashtable hsData = (Hashtable)hsDataBlock.get(i);
                if (i == 0) {
                    head = this.parseHead(hsData, ctx);
                    this.verifyHead(ctx, head);
                }
                InitBalanceEntryInfo entry = this.parseEntry(hsData, ctx);
                this.verifyEntry(ctx, entry);
                head.getEntrys().add(entry);
            }
            this.verifyBlocks(ctx, head);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e1) {
            throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
        }
        return head;
    }

    private void verifyBlocks(Context ctx, InitBalanceInfo head) throws BOSException {
        HashMap<String, String> infoMap = new HashMap<String, String>();
        InitBalanceEntryCollection coll = head.getEntrys();
        for (int i = 0; i < coll.size(); ++i) {
            if (infoMap.containsKey(coll.get(i).getCostItem().getId().toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"146_InitBalanceDataImport", (Locale)ctx.getLocale()));
            }
            infoMap.put(coll.get(i).getCostItem().getId().toString(), coll.get(i).getCostItem().getId().toString());
        }
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.cu == null || this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
        }
        if (this.period == null) {
            try {
                this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private InitBalanceInfo parseHead(Hashtable hsData, Context ctx) throws BOSException, TaskExternalException, EASBizException {
        CostObjectInfo costObjectInfo;
        CostObjectRelatedInfo costObjectRelatedInfo;
        MaterialInfo material = null;
        this.verify(ctx, hsData);
        InitBalanceInfo head = new InitBalanceInfo();
        head.setCompanyOrg(this.company);
        head.setCalculatePeriod(this.period);
        this.dealWithTheNumberByImpMode(ctx, hsData, head);
        Object data = this.getData(hsData, "costCenter");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"64_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        head.setCostCenter(NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"63_ActualHourDataImport", (Locale)ctx.getLocale()), (String)data.toString()));
        Object objectData = this.getData(hsData, "costObject");
        Object orderData = this.getData(hsData, "manufactureOrder");
        Object matData = this.getData(hsData, "material");
        Object storageData = this.getData(hsData, "storage.number");
        Object batchNumber = this.getData(hsData, "batchNumber");
        if (objectData != null && objectData.toString().trim().length() > 0 && (costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByCO((Context)ctx, (CostObjectInfo)(costObjectInfo = NCMDataImportUtil.getCostObjectbyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"247_GLFetchDataImport", (Locale)ctx.getLocale()), (String)objectData.toString(), (String)this.company.getId().toString())))) != null) {
            if (costObjectInfo.getStdProductID() != null) {
                material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(costObjectInfo.getStdProductID().getId().toString()));
            }
            head.setCostObject(costObjectRelatedInfo.getCostObjectInfo());
        }
        if (objectData != null && objectData.equals("") && !orderData.equals("") && orderData.toString().trim().length() > 0) {
            ManufactureOrderInfo orderInfo = NCMDataImportUtil.getManufactureOrderByNumber((Context)ctx, (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"160_InitBalanceEditUI_Order"), (String)orderData.toString(), (String)this.company.getId().toString(), (String)storageData.toString());
            if (!orderInfo.getBaseStatus().toString().equals(EASResource.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"158_InitBalanceEditUI_Released"))) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"161_InitBalanceEditUI"));
            }
            costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByOrder((Context)ctx, (ManufactureOrderInfo)orderInfo, (String)this.company.getId().toString());
            if (costObjectRelatedInfo != null) {
                head.setCostObject(costObjectRelatedInfo.getCostObjectInfo());
                if (material == null) {
                    material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(costObjectRelatedInfo.getCostObjectInfo().getStdProductID().getId().toString()));
                }
            }
        }
        if (objectData != null && orderData != null && matData != null && objectData.equals("") && orderData.equals("") && !matData.equals("") && matData.toString().trim().length() > 0) {
            MaterialInfo materialInfo = NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)EASResource.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"162_InitBalanceEditUI_Material"), (String)matData.toString());
            if (!materialInfo.getStatus().toString().equals(EASResource.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"163_InitBalanceEditUI_Audit"))) {
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"162_InitBalanceEditUI_Material") + materialInfo.getName() + EASResource.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"164_InitBalanceEditUI_Unlaw"));
            }
            costObjectRelatedInfo = CostObjectUtil.getCostObjectRelatedInfoByMat((Context)ctx, (MaterialInfo)materialInfo, (String)batchNumber.toString());
            if (costObjectRelatedInfo != null) {
                head.setCostObject(costObjectRelatedInfo.getCostObjectInfo());
                if (material == null) {
                    material = materialInfo;
                }
            } else {
                if (batchNumber.toString().equals("")) {
                    throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"165_InitBalanceEditUI_InputBatch"));
                }
                throw new TaskExternalException(EASResource.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"166_InitBalanceEditUI"));
            }
        }
        int qtyPrecision = 4;
        if (material != null && material.getBaseUnit() != null) {
            String unitID = material.getBaseUnit().getId().toString();
            String materialID = material.getId().toString();
            String oql = "select * where material.id = '" + materialID + "' and measureUnit.id = '" + unitID + "'";
            MultiMeasureUnitInfo mulUnitInfo = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitInfo(oql);
            qtyPrecision = mulUnitInfo.getQtyPrecision();
        }
        BigDecimal inputQty = null;
        data = this.getData(hsData, "BopWIPQty");
        if (data != null && data.toString().trim().length() > 0) {
            inputQty = this.getBigDecimalValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"147_InitBalanceDataImport", (Locale)ctx.getLocale()), data);
            inputQty = inputQty.setScale(qtyPrecision, 4);
            head.setBopWIPQty(inputQty);
        }
        if ((data = this.getData(hsData, "YTDFinishedQty")) != null && data.toString().trim().length() > 0) {
            inputQty = this.getBigDecimalValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"148_InitBalanceDataImport", (Locale)ctx.getLocale()), data);
            inputQty = inputQty.setScale(qtyPrecision, 4);
            head.setYTDFinishedQty(inputQty);
        } else {
            head.setYTDFinishedQty(new BigDecimal(0));
        }
        return head;
    }

    private void dealWithTheNumberByImpMode(Context ctx, Hashtable hsData, InitBalanceInfo info) throws BOSException, TaskExternalException {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus((IObjectValue)info, info.getCompanyOrg().getId().toString());
            if (ruleStatus.isExist()) {
                info.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                return;
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        String number = hsData.get("number").toString();
        if (number == null || number.length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"57_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        StringBuffer sb = new StringBuffer();
        sb.append("select FID, FBillStatus from T_NCM_InitBalance").append(" where FNumber=? and FCompanyOrg=? ;");
        Object[] param = new Object[]{number, this.company.getId().toString()};
        IRowSet _Data = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
        if (_Data != null && _Data.size() >= 1) {
            if (this.isSltImportUpdate()) {
                this.checkAndDealWithEdit(ctx, info, _Data, number);
            } else {
                throw new BOSException(number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"58_ActualHourDataImport", (Locale)ctx.getLocale()));
            }
        }
        info.setNumber(number);
        info.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
    }

    private void checkAndDealWithEdit(Context ctx, InitBalanceInfo info, IRowSet data, String number) throws BOSException {
        try {
            data.first();
            if (2 != data.getInt("FBillStatus")) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"61_ActualHourDataImport", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"62_ActualHourDataImport", (Locale)ctx.getLocale()));
            }
            info.setId(BOSUuid.read((String)data.getString("FID")));
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void verifyHead(Context ctx, InitBalanceInfo head) throws BOSException {
        this.checkCostCenter(ctx, head);
        this.checkCostObject(ctx, head);
    }

    private void checkCostCenter(Context ctx, InitBalanceInfo head) throws BOSException {
        CostCenterOrgUnitInfo costCenter = head.getCostCenter();
        NCMDataImportUtil.checkCostCenter((Context)ctx, (CostCenterOrgUnitInfo)costCenter, (String)head.getCompanyOrg().getId().toString());
        if (!CostCenterType.DirectProdDept.equals((Object)costCenter.getCostCenterType()) && !CostCenterType.AssistantProdDept.equals((Object)costCenter.getCostCenterType())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + costCenter.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"149_InitBalanceDataImport", (Locale)ctx.getLocale()));
        }
    }

    private void checkCostObject(Context ctx, InitBalanceInfo head) throws BOSException {
        CostObjectInfo costObject = head.getCostObject();
        if (costObject == null) {
            return;
        }
        if (costObject.isIsForbiden()) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + costObject.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"150_InitBalanceDataImport", (Locale)ctx.getLocale()));
        }
    }

    private void verify(Context ctx, Hashtable hsData) throws BOSException {
        Object costObject = this.getData(hsData, "costObject");
        Object material = this.getData(hsData, "material");
        Object order = this.getData(hsData, "manufactureOrder");
        Object bopWIPQty = this.getData(hsData, "BopWIPQty");
        if (costObject.equals("") && order.equals("") && material.equals("")) {
            throw new BOSException("\u6210\u672c\u5bf9\u8c61 \uff0c\u751f\u4ea7\u8ba2\u5355\uff0c\u7269\u6599+\u6279\u6b21\u81f3\u5c11\u8981\u5f55\u5165\u4e00\u4e2a");
        }
        if (bopWIPQty.equals("")) {
            throw new BOSException("\u671f\u521d\u5728\u5236\u54c1\u4ea7\u91cf\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        float f = Float.parseFloat(bopWIPQty.toString());
        if ((double)f <= 0.0) {
            throw new BOSException("\u671f\u521d\u5728\u5236\u54c1\u4ea7\u91cf\u4e0d\u53ef\u4ee5\u4e3a0\u6216\u8005\u5c0f\u4e8e0");
        }
    }

    private InitBalanceEntryInfo parseEntry(Hashtable hsData, Context ctx) throws BOSException {
        InitBalanceEntryInfo entry = new InitBalanceEntryInfo();
        Object data = this.getData(hsData, "costItem");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"84_CostItemDataImport", (Locale)ctx.getLocale()));
        }
        entry.setCostItem(NCMDataImportUtil.getCostItemByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"151_InitBalanceDataImport", (Locale)ctx.getLocale()), (String)data.toString()));
        entry.setBoPWIPAmount(this.getTheInputQty(ctx, hsData, entry, "BoPWIPAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"152_InitBalanceDataImport", (Locale)ctx.getLocale())));
        entry.setYTDInputAmount(this.getTheInputQty(ctx, hsData, entry, "YTDInputAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"153_InitBalanceDataImport", (Locale)ctx.getLocale())));
        entry.setYTDFinishAmount(this.getTheInputQty(ctx, hsData, entry, "YTDFinishAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"154_InitBalanceDataImport", (Locale)ctx.getLocale())));
        return entry;
    }

    private BigDecimal getTheInputQty(Context ctx, Hashtable hsData, InitBalanceEntryInfo entry, String feild, String feildName) throws BOSException {
        Object data = this.getData(hsData, feild);
        BigDecimal inputQty = null;
        if (data != null && data.toString().trim().length() > 0) {
            inputQty = this.getBigDecimalValueByFeildData(ctx, feildName, data);
        } else if (!CostItemEnum.STUFF.equals((Object)entry.getCostItem().getItemType()) && (feild.equals("YTDInputAmount") || feild.equals("YTDFinishAmount"))) {
            inputQty = new BigDecimal(0);
        }
        if (CostItemEnum.STUFF.equals((Object)entry.getCostItem().getItemType())) {
            if (inputQty != null) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + entry.getCostItem().getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"155_InitBalanceDataImport", (Locale)ctx.getLocale()) + feildName + "!");
            }
        } else if (feild.equals("BoPWIPAmount") && (inputQty == null || inputQty.compareTo(SysConstant.BIGZERO) <= 0)) {
            throw new BOSException(feildName + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"305_InitBalanceDataImport", (Locale)ctx.getLocale()));
        }
        if (inputQty != null) {
            inputQty = inputQty.setScale(NCMUtils.getCurrencyPrecision((Context)ctx, (String)this.company.getId().toString()), 4);
        }
        return inputQty;
    }

    private void verifyEntry(Context ctx, InitBalanceEntryInfo entry) throws BOSException {
        this.checkCostItem(ctx, entry);
    }

    private void checkCostItem(Context ctx, InitBalanceEntryInfo entry) throws BOSException {
        CostItemInfo costItem = entry.getCostItem();
        NCMDataImportUtil.checkDataBaseDPermission((Context)ctx, (String)this.cu.getId().toString(), (String)costItem.getCU().getId().toString(), (String)"548C5A91", (String)costItem.getId().toString(), (String)costItem.getNumber(), (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"137_ExpenseCompanyInfoDataImport", (Locale)ctx.getLocale()));
    }
}

