/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.CostItemEnum;
import com.kingdee.eas.basedata.assistant.CostItemInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.IInitBalanceEntry;
import com.kingdee.eas.ncm.bill.IInitBalanceMatDetail;
import com.kingdee.eas.ncm.bill.InitBalanceEntryCollection;
import com.kingdee.eas.ncm.bill.InitBalanceEntryFactory;
import com.kingdee.eas.ncm.bill.InitBalanceEntryInfo;
import com.kingdee.eas.ncm.bill.InitBalanceMatDetailCollection;
import com.kingdee.eas.ncm.bill.InitBalanceMatDetailFactory;
import com.kingdee.eas.ncm.bill.InitBalanceMatDetailInfo;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class InitBalanceMatDetailDataImport
extends AbstractNCMDataImport {
    CtrlUnitInfo cu = null;
    CompanyOrgUnitInfo company = null;
    PeriodInfo period = null;
    private InitBalanceMatDetailInfo originalInitBMDInfo = null;
    private Map numberMap = new HashMap();
    private Map costItemMap = new HashMap();
    private Map parentIdMap = new HashMap();
    private Map invalidNumberMap = new HashMap();
    private Map invalidCostItemMap = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return InitBalanceMatDetailFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        InitBalanceMatDetailInfo matDetail = null;
        try {
            BigDecimal baseConvsRate;
            this.initOrgUnit(ctx);
            matDetail = this.parseHead(hsData, ctx);
            String materialID = null;
            String unitID = null;
            if (matDetail.getMaterial() != null) {
                materialID = matDetail.getMaterial().getId().toString();
            }
            if (matDetail.getUnit() != null) {
                unitID = matDetail.getUnit().getId().toString();
            }
            if ((baseConvsRate = this.getBaseConvsRate(ctx, materialID, unitID)) != null) {
                matDetail.setQty(matDetail.getAddqty().multiply(baseConvsRate));
            } else if (matDetail.getMaterial().getAssistUnit() == null) {
                matDetail.setQty(matDetail.getAddqty());
            } else {
                String locale = ctx.getLocale().toString();
                if (locale.equals("l2")) {
                    throw new BOSException("\u7269\u6599" + matDetail.getMaterial().getName() + "\u7684\u8ba1\u91cf\u5355\u4f4d\u4e0e\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u4e4b\u95f4\u4e0d\u5b58\u5728\u6362\u7b97\u5173\u7cfb,\u8bf7\u5728\u7269\u6599\u7684\u57fa\u7840\u8d44\u6599\u91cc\u7ef4\u62a4");
                }
                if (locale.equals("l3")) {
                    throw new BOSException("\u7269\u6599" + matDetail.getMaterial().getName() + "\u7684\u8a08\u91cf\u55ae\u4f4d\u8207\u57fa\u672c\u8a08\u91cf\u55ae\u4f4d\u4e4b\u9593\u4e0d\u5b58\u5728\u63db\u7b97\u95dc\u4fc2 ,\u8acb\u5728\u7269\u6599\u7684\u57fa\u790e\u8cc7\u6599\u91cc\u7dad\u8b77");
                }
            }
            BigDecimal baseConvsAssitRate = NCMConst.ZERO;
            if (matDetail.getMaterial().getAssistUnit() != null) {
                baseConvsAssitRate = this.getBaseConvsRate(ctx, matDetail.getMaterial().getId().toString(), matDetail.getMaterial().getAssistUnit().getId().toString());
            }
            if (baseConvsAssitRate != null && baseConvsAssitRate.compareTo(NCMConst.ZERO) != 0) {
                matDetail.setAssistQty(matDetail.getAddqty().divide(baseConvsAssitRate, 8, 4));
            }
            this.checkImportData(ctx, matDetail);
            this.dealWithParentData(ctx, matDetail);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (SQLException e1) {
            throw new TaskExternalException(e1.getMessage(), (Throwable)e1);
        }
        catch (EASBizException e2) {
            throw new TaskExternalException(e2.getMessage(), (Throwable)e2);
        }
        return matDetail;
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.cu == null || this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
        }
        if (this.period == null) {
            try {
                this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private InitBalanceMatDetailInfo parseHead(Hashtable hsData, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        InitBalanceMatDetailInfo matDetail = new InitBalanceMatDetailInfo();
        matDetail.setParent(this.getTheParentOfMatDetail(ctx, hsData));
        matDetail.setMaterial(this.getTheInputMaterial(ctx, hsData));
        this.setBatchNo(ctx, hsData, matDetail);
        this.dealWithAddOrEditByImpMode(ctx, hsData, matDetail);
        int precision = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getQtyPrecision(matDetail.getMaterial().getId().toString(), matDetail.getMaterial().getBaseUnit().getId().toString());
        int pricePrecision = matDetail.getMaterial().getPricePrecision();
        int currencyPrecision = NCMUtils.getCurrencyPrecision((Context)ctx, (String)this.company.getId().toString());
        matDetail.setAddqty(this.getTheInputQty(ctx, hsData, "Qty", ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"157_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale())).setScale(precision, 4));
        matDetail.setUnit(this.getTheInputUnit(ctx, hsData));
        matDetail.setPrice(this.getBigDecimalValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"158_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()), this.getData(hsData, "Price")).setScale(pricePrecision, 4));
        BigDecimal amount = this.getTheInputQty(ctx, hsData, "amount", ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"159_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()));
        matDetail.setAmount(amount.setScale(NCMUtils.getCurrencyPrecision((Context)ctx, (String)this.company.getId().toString()), 4));
        this.dealWithTheQty(ctx, matDetail, pricePrecision);
        matDetail.setYTDInputMatQty(this.getBigDecimalValueByFeildData(ctx, "YTDInputMatQty", hsData.get("YTDInputMatQty")).setScale(precision, 4));
        matDetail.setYTDInputMatAmou(this.getBigDecimalValueByFeildData(ctx, "YTDInputMatAmou", hsData.get("YTDInputMatAmou")).setScale(currencyPrecision, 4));
        matDetail.setYTDFinishedMatQ(this.getBigDecimalValueByFeildData(ctx, "YTDFinishedMatQ", hsData.get("YTDFinishedMatQ")).setScale(precision, 4));
        matDetail.setYTDFinishedMatA(this.getBigDecimalValueByFeildData(ctx, "YTDFinishedMatA", hsData.get("YTDFinishedMatA")).setScale(currencyPrecision, 4));
        return matDetail;
    }

    private void dealWithTheQty(Context ctx, InitBalanceMatDetailInfo matDetail, int pricePrecision) throws BOSException {
        if (matDetail.getAddqty() == null || SysConstant.BIGZERO.compareTo(matDetail.getAddqty()) == 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"164_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()));
        }
        if (matDetail.getAmount() == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"165_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()));
        }
        matDetail.setPrice(new BigDecimal(matDetail.getAmount().doubleValue() / matDetail.getAddqty().doubleValue()).setScale(pricePrecision, 4));
    }

    private MaterialInfo getTheInputMaterial(Context ctx, Hashtable hsData) throws BOSException {
        String material = hsData.get("material").toString();
        if (material == null || material.length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"166_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()));
        }
        MaterialInfo materialInfo = NCMDataImportUtil.getMaterialByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"167_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()), (String)material);
        NCMDataImportUtil.checkDataBaseDPermission((Context)ctx, (String)this.cu.getId().toString(), (String)materialInfo.getCU().getId().toString(), (String)"4409E7F0", (String)materialInfo.getId().toString(), (String)materialInfo.getNumber(), (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"168_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()));
        return materialInfo;
    }

    private MeasureUnitInfo getTheInputUnit(Context ctx, Hashtable hsData) throws BOSException {
        if (hsData.get("unit") == null || hsData.get("unit").toString().length() <= 0) {
            return null;
        }
        String unit = hsData.get("unit").toString();
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
        MeasureUnitInfo measureUnit = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)unit));
        view.setFilter(filter);
        MeasureUnitCollection coll = iMeasureUnit.getMeasureUnitCollection(view);
        if (coll == null || coll.size() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"81_CostItemDataImport", (Locale)ctx.getLocale()) + unit + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"180_NCMDataImportUtil", (Locale)ctx.getLocale()));
        }
        measureUnit = coll.get(0);
        return measureUnit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dealWithAddOrEditByImpMode(Context ctx, Hashtable hsData, InitBalanceMatDetailInfo info) throws BOSException, TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)info.getParent().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)info.getMaterial().getId().toString()));
        String batchNumber = hsData.get("batchNo").toString();
        if (batchNumber != null && batchNumber.length() != 0) {
            filter.getFilterItems().add(new FilterItemInfo("batchNo", (Object)batchNumber));
        }
        view.setFilter(filter);
        InitBalanceMatDetailCollection coll = ((IInitBalanceMatDetail)this.getController(ctx)).getInitBalanceMatDetailCollection(view);
        if (coll != null && coll.size() >= 1) {
            if (!this.isSltImportUpdate()) throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"85_CostItemDataImport", (Locale)ctx.getLocale()) + info.getMaterial().getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"169_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()));
            info.setId(coll.get(0).getId());
            this.originalInitBMDInfo = coll.get(0);
            return;
        } else {
            this.originalInitBMDInfo = null;
        }
    }

    private void setBatchNo(Context ctx, Hashtable hsData, InitBalanceMatDetailInfo matDetail) throws BOSException {
        Object data = this.getData(hsData, "batchNo");
        if (data != null && data.toString().trim().length() > 0) {
            matDetail.setBatchNo(data.toString());
        }
    }

    private BigDecimal getTheInputQty(Context ctx, Hashtable hsData, String feild, String feildName) throws BOSException {
        Object data = this.getData(hsData, feild);
        BigDecimal inputQty = null;
        if (data != null && data.toString().trim().length() > 0) {
            inputQty = this.getBigDecimalValueByFeildData(ctx, feildName, data);
        }
        if ("Qty".equals(feild) && (inputQty == null || SysConstant.BIGZERO.compareTo(inputQty) >= 0)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"262_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()));
        }
        if (inputQty == null || SysConstant.BIGZERO.compareTo(inputQty) >= 0) {
            throw new BOSException(feildName + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"305_InitBalanceDataImport", (Locale)ctx.getLocale()));
        }
        return inputQty;
    }

    private InitBalanceEntryInfo getTheParentOfMatDetail(Context ctx, Hashtable hsData) throws BOSException, TaskExternalException {
        String headId = this.getHeadIdWithMap(ctx, hsData);
        String costItemId = this.getCostItemIdWithMap(ctx, hsData);
        BOSUuid parentIdOfMatDetail = BOSUuid.read((String)this.getParentIdOfMatDetailWithMap(ctx, hsData, headId, costItemId));
        InitBalanceEntryInfo initBalanceEntry = new InitBalanceEntryInfo();
        initBalanceEntry.setId(parentIdOfMatDetail);
        return initBalanceEntry;
    }

    private String getHeadIdWithMap(Context ctx, Hashtable hsData) throws BOSException {
        String number = hsData.get("number").toString();
        if (number == null || number.length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"57_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        String headId = null;
        if (this.numberMap.containsKey(number)) {
            headId = (String)this.numberMap.get(number);
        } else {
            headId = this.getHeadIdByNumber(ctx, number);
            this.numberMap.put(number, headId);
        }
        return headId;
    }

    private String getCostItemIdWithMap(Context ctx, Hashtable hsData) throws BOSException {
        String costItem = hsData.get("costItem").toString();
        if (costItem == null || costItem.length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"84_CostItemDataImport", (Locale)ctx.getLocale()));
        }
        String costItemId = null;
        if (this.costItemMap.containsKey(costItem)) {
            costItemId = (String)this.costItemMap.get(costItem);
        } else {
            costItemId = this.getCsotItemIdByNumber(ctx, costItem);
            this.costItemMap.put(costItem, costItemId);
        }
        return costItemId;
    }

    private String getParentIdOfMatDetailWithMap(Context ctx, Hashtable hsData, String headId, String costItemId) throws BOSException {
        String parentIdOfMatDetail = null;
        String key = headId + "_" + costItemId;
        if (this.parentIdMap.containsKey(key)) {
            parentIdOfMatDetail = (String)this.parentIdMap.get(key);
        } else {
            parentIdOfMatDetail = this.getParentIdOfMatDetail(ctx, hsData, headId, costItemId);
            this.parentIdMap.put(key, parentIdOfMatDetail);
        }
        return parentIdOfMatDetail;
    }

    private String getParentIdOfMatDetail(Context ctx, Hashtable hsData, String headId, String costItemId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Parent", (Object)headId));
        filter.getFilterItems().add(new FilterItemInfo("costItem", (Object)costItemId));
        view.setFilter(filter);
        InitBalanceEntryCollection coll = InitBalanceEntryFactory.getLocalInstance(ctx).getInitBalanceEntryCollection(view);
        if (coll != null && coll.size() >= 1) {
            return coll.get(0).getId().toString();
        }
        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"171_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()) + hsData.get("number").toString() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"172_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()) + hsData.get("costItem").toString() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"173_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()));
    }

    private String getCsotItemIdByNumber(Context ctx, String costItemNumber) throws BOSException {
        this.checkIsCanEditMatByCostItemNumebr(ctx, costItemNumber);
        return this.getNewCostItemIdByNumber(ctx, costItemNumber);
    }

    private void checkIsCanEditMatByCostItemNumebr(Context ctx, String costItemNumber) throws BOSException {
        if (this.invalidCostItemMap.containsKey(costItemNumber)) {
            this.invalidCostItemException(ctx, costItemNumber);
        }
    }

    private String getNewCostItemIdByNumber(Context ctx, String costItemNumber) throws BOSException {
        CostItemInfo costItem = NCMDataImportUtil.getCostItemByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"151_InitBalanceDataImport", (Locale)ctx.getLocale()), (String)costItemNumber);
        NCMDataImportUtil.checkDataBaseDPermission((Context)ctx, (String)this.cu.getId().toString(), (String)costItem.getCU().getId().toString(), (String)"548C5A91", (String)costItem.getId().toString(), (String)costItem.getNumber(), (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"137_ExpenseCompanyInfoDataImport", (Locale)ctx.getLocale()));
        if (!CostItemEnum.STUFF.equals((Object)costItem.getItemType())) {
            this.invalidCostItemMap.put(costItemNumber, costItemNumber);
            this.invalidCostItemException(ctx, costItemNumber);
        }
        return costItem.getId().toString();
    }

    private void invalidCostItemException(Context ctx, String costItemNumber) throws BOSException {
        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"61_ActualHourDataImport", (Locale)ctx.getLocale()) + costItemNumber + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"174_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()));
    }

    private String getHeadIdByNumber(Context ctx, String number) throws BOSException {
        this.checkIsSaveDataByNumber(ctx, number);
        return this.getNewHeadIdByNumber(ctx, number);
    }

    private void checkIsSaveDataByNumber(Context ctx, String number) throws BOSException {
        if (this.invalidNumberMap.containsKey(number)) {
            this.invalidNumberException(ctx, number);
        }
    }

    private String getNewHeadIdByNumber(Context ctx, String number) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select FID, FNumber, FBillStatus from T_NCM_InitBalance").append(" where FNumber=? and FCompanyOrg=? ;");
        Object[] param = new Object[]{number, this.company.getId().toString()};
        IRowSet _Data = NCMDbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])param);
        if (_Data != null && _Data.size() >= 1) {
            return this.checkReturnId(ctx, _Data, number);
        }
        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"175_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"176_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()));
    }

    private String checkReturnId(Context ctx, IRowSet data, String number) throws BOSException {
        String id = null;
        try {
            data.first();
            if (2 != data.getInt("FBillStatus")) {
                this.invalidNumberMap.put(number, number);
                this.invalidNumberException(ctx, number);
            }
            id = data.getString("FID");
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return id;
    }

    private void invalidNumberException(Context ctx, String number) throws BOSException {
        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"61_ActualHourDataImport", (Locale)ctx.getLocale()) + number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"62_ActualHourDataImport", (Locale)ctx.getLocale()));
    }

    private void checkImportData(Context ctx, InitBalanceMatDetailInfo matDetail) throws BOSException {
        if (matDetail.getQty().add(matDetail.getPrice()).add(matDetail.getAmount()).add(matDetail.getYTDInputMatQty()).add(matDetail.getYTDInputMatAmou()).add(matDetail.getYTDFinishedMatQ()).add(matDetail.getYTDFinishedMatA()).compareTo(SysConstant.BIGZERO) == 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"177_InitBalanceMatDetailDataImport", (Locale)ctx.getLocale()));
        }
    }

    private void dealWithParentData(Context ctx, InitBalanceMatDetailInfo matDetail) throws BOSException {
        try {
            IInitBalanceEntry iInitBalanceEntry = InitBalanceEntryFactory.getLocalInstance(ctx);
            ObjectUuidPK pk = new ObjectUuidPK(matDetail.getParent().getId());
            InitBalanceEntryInfo info = iInitBalanceEntry.getInitBalanceEntryInfo((IObjectPK)pk);
            boolean exsitData = matDetail.getId() != null;
            BigDecimal BoPWIPAmount = info.getBoPWIPAmount();
            if (BoPWIPAmount == null) {
                info.setBoPWIPAmount(matDetail.getAmount());
            } else if (exsitData) {
                info.setBoPWIPAmount(BoPWIPAmount.subtract(this.originalInitBMDInfo.getAmount()).add(matDetail.getAmount()));
            } else {
                info.setBoPWIPAmount(BoPWIPAmount.add(matDetail.getAmount()));
            }
            BigDecimal YTDInputAmount = info.getYTDInputAmount();
            if (YTDInputAmount == null) {
                info.setYTDInputAmount(matDetail.getYTDInputMatAmou());
            } else if (exsitData) {
                info.setYTDInputAmount(YTDInputAmount.subtract(this.originalInitBMDInfo.getYTDInputMatAmou()).add(matDetail.getYTDInputMatAmou()));
            } else {
                info.setYTDInputAmount(YTDInputAmount.add(matDetail.getYTDInputMatAmou()));
            }
            BigDecimal YTDFinishAmount = info.getYTDFinishAmount();
            if (YTDInputAmount == null) {
                info.setYTDFinishAmount(matDetail.getYTDFinishedMatA());
            } else if (exsitData) {
                info.setYTDFinishAmount(YTDFinishAmount.subtract(this.originalInitBMDInfo.getYTDFinishedMatA()).add(matDetail.getYTDFinishedMatA()));
            } else {
                info.setYTDFinishAmount(YTDFinishAmount.add(matDetail.getYTDFinishedMatA()));
            }
            iInitBalanceEntry.update((IObjectPK)pk, info);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getBaseConvsRate(Context ctx, String materialID, String unitID) throws BOSException, SQLException {
        BigDecimal baseConvsRate = null;
        String sql = "select FBaseConvsRate from T_BD_MultiMeasureUnit where FMaterialID='" + materialID + "' and FMeasureUnitID= '" + unitID + "'";
        IRowSet rs = null;
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                baseConvsRate = rs.getBigDecimal(1);
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return baseConvsRate;
    }
}

