/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CORelatedType;
import com.kingdee.eas.basedata.assistant.CalculateModeEnum;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.AUXOverheadInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.IContextHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.bill.AbstractInnerOverheadBillInfo;
import com.kingdee.eas.ncm.bill.IInnerOverheadBill;
import com.kingdee.eas.ncm.bill.InnerOverheadBillCollection;
import com.kingdee.eas.ncm.bill.InnerOverheadBillEntryInfo;
import com.kingdee.eas.ncm.bill.InnerOverheadBillFactory;
import com.kingdee.eas.ncm.bill.InnerOverheadBillInfo;
import com.kingdee.eas.ncm.bill.OverheadBizTypeEnum;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public class InnerOverheadBillDataImport
extends AbstractNCMDataImport {
    private CompanyOrgUnitInfo company = null;
    private CtrlUnitInfo cu = null;
    private PeriodInfo period = null;
    private UserInfo currUser = null;
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.bill.InputQtyBillResource";

    public int getSubmitType() {
        return 1;
    }

    public String getMainField() {
        return "costCenter.number";
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return InnerOverheadBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsDataBlock, Context ctx) throws TaskExternalException {
        AbstractInnerOverheadBillInfo innerOverheadBill = null;
        InnerOverheadBillEntryInfo innerOverheadBillEntry = null;
        try {
            this.initOrgUnit(ctx);
            for (int i = 0; i < hsDataBlock.size(); ++i) {
                Hashtable hsData = (Hashtable)hsDataBlock.get(i);
                innerOverheadBillEntry = this.parseEntryData(hsData, ctx);
                if (i == 0) {
                    innerOverheadBill = this.parseData(hsData, ctx);
                }
                innerOverheadBill.getEntrys().add(innerOverheadBillEntry);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return innerOverheadBill;
    }

    private InnerOverheadBillInfo parseData(Hashtable hsData, Context ctx) throws BOSException, TaskExternalException {
        InnerOverheadBillInfo innerOverheadBill = new InnerOverheadBillInfo();
        innerOverheadBill.setCompanyOrg(this.company);
        innerOverheadBill.setBizType(OverheadBizTypeEnum.aux);
        Object data = this.getData(hsData, "bizDate");
        Date bizDate = null;
        if (data != null) {
            bizDate = this.getDateByFeildData(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"59_ActualHourDataImport", (Locale)ctx.getLocale()), data.toString());
        }
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"60_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        innerOverheadBill.setBizDate(bizDate);
        this.dealWithNumberByImpMode(ctx, hsData, innerOverheadBill);
        innerOverheadBill.setCalculatePeriod(this.getPeriodByBizDate(ctx, bizDate, this.company));
        data = this.getData(hsData, "costCenter.number");
        CostCenterOrgUnitInfo costCenter = null;
        if (data != null && data.toString().trim().length() > 0) {
            costCenter = NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"63_ActualHourDataImport", (Locale)ctx.getLocale()), (String)data.toString());
            if (costCenter != null && CostCenterType.DirectProdDept.equals((Object)costCenter.getCostCenterType())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"183_InnerOverheadDataImport", (Locale)ctx.getLocale()));
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"64_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        innerOverheadBill.setCostCenter(costCenter);
        return innerOverheadBill;
    }

    private void checkCostCenterAndCostObject(Context ctx, InnerOverheadBillEntryInfo innerOverheadBillEntry) throws BOSException {
        CostCenterOrgUnitInfo costCenter = innerOverheadBillEntry.getConsumeCostCenter();
        CostObjectInfo costObject = innerOverheadBillEntry.getConsumeCostObject();
        if (costCenter != null && CostCenterType.DirectProdDept.equals((Object)costCenter.getCostCenterType()) && costObject != null && costObject.getRelatedType().equals((Object)CORelatedType.Overhead)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"178_InnerOverheadDataImport", (Locale)ctx.getLocale()) + costCenter.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"179_InnerOverheadDataImport", (Locale)ctx.getLocale()) + costObject.getName());
        }
        if (costCenter != null && CostCenterType.AssistantProdDept.equals((Object)costCenter.getCostCenterType()) && costObject != null && !costObject.getRelatedType().equals((Object)CORelatedType.Overhead)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"180_InnerOverheadDataImport", (Locale)ctx.getLocale()) + costCenter.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"181_InnerOverheadDataImport", (Locale)ctx.getLocale()) + costObject.getName());
        }
    }

    private void dealWithNumberByImpMode(Context ctx, Hashtable hsData, InnerOverheadBillInfo innerOverheadBill) throws BOSException, TaskExternalException {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            RuleStatus ruleStatus = iCodingRuleManager.getRuleStatus((IObjectValue)innerOverheadBill, innerOverheadBill.getCompanyOrg().getId().toString());
            if (ruleStatus.isExist()) {
                innerOverheadBill.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
                return;
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        String number = hsData.get("number").toString();
        if (number == null || number.length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"57_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)this.company.getId()));
        view.setFilter(filter);
        InnerOverheadBillCollection col = ((IInnerOverheadBill)this.getController(ctx)).getInnerOverheadBillCollection(view);
        if (col != null && col.size() >= 1) {
            if (this.isSltImportUpdate()) {
                this.checkCanEdit(ctx, col.get(0));
                innerOverheadBill.setId(col.get(0).getId());
            } else {
                throw new BOSException(number + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"58_ActualHourDataImport", (Locale)ctx.getLocale()));
            }
        }
        innerOverheadBill.setNumber(number);
        innerOverheadBill.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
    }

    private void checkCanEdit(Context ctx, InnerOverheadBillInfo innerOverheadBill) throws BOSException {
        if (BillBaseStatusEnum.AUDITED.equals((Object)innerOverheadBill.getBillStatus())) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"61_ActualHourDataImport", (Locale)ctx.getLocale()) + innerOverheadBill.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"62_ActualHourDataImport", (Locale)ctx.getLocale()));
        }
    }

    private InnerOverheadBillEntryInfo parseEntryData(Hashtable hsData, Context ctx) throws BOSException, EASBizException, SQLException {
        InnerOverheadBillEntryInfo innerOverheadEntry = new InnerOverheadBillEntryInfo();
        Object data = this.getData(hsData, "entrys.auxNumber");
        AUXOverheadInfo auxInfo = null;
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"172_InnerOverheadDataImport", (Locale)ctx.getLocale()));
        }
        auxInfo = NCMDataImportUtil.getAUXOverheadByNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"171_InnerOverheadDataImport", (Locale)ctx.getLocale()), (String)data.toString());
        innerOverheadEntry.setAuxOverhead(auxInfo);
        innerOverheadEntry.setStdPrice(this.getStdPrice(auxInfo, ctx));
        data = this.getData(hsData, "entrys.costCenterNumber");
        CostCenterOrgUnitInfo costCenterInfo = null;
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"174_InnerOverheadDataImport", (Locale)ctx.getLocale()));
        }
        costCenterInfo = NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"173_InnerOverheadDataImport", (Locale)ctx.getLocale()), (String)data.toString());
        innerOverheadEntry.setConsumeCostCenter(costCenterInfo);
        CostObjectInfo costObjectInfo = this.parseCostObject(hsData, ctx);
        innerOverheadEntry.setConsumeCostObject(costObjectInfo);
        String manufactureOrderID = null;
        String materialID = null;
        if (costObjectInfo != null) {
            if (costObjectInfo.getRelatedType().equals((Object)CORelatedType.Product) && costObjectInfo.getCalculateMode().equals((Object)CalculateModeEnum.BYORDER) && costObjectInfo.getOrderID() != null) {
                manufactureOrderID = costObjectInfo.getOrderID().toString();
                ManufactureOrderInfo order = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(manufactureOrderID));
                innerOverheadEntry.setManufactureOrder(order);
            }
            if (costObjectInfo.getStdProductID() != null) {
                materialID = costObjectInfo.getStdProductID().getId().toString();
                MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialID));
                innerOverheadEntry.setMaterial(material);
            }
        }
        if ((data = this.getData(hsData, "entrys.qty")) != null && data.toString().trim().length() > 0) {
            if (Float.compare(Float.valueOf(data.toString()).floatValue(), Float.valueOf("0").floatValue()) == -1) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"182_InnerOverheadDataImport", (Locale)ctx.getLocale()));
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"177_InnerOverheadDataImport", (Locale)ctx.getLocale()));
        }
        innerOverheadEntry.setQty(this.getBigDecimalValueByFeildData(ctx, ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"176_InnerOverheadDataImport", (Locale)ctx.getLocale()), data.toString()));
        innerOverheadEntry.setStdAmount(innerOverheadEntry.getQty().multiply(innerOverheadEntry.getStdPrice()));
        this.checkCostCenterAndCostObject(ctx, innerOverheadEntry);
        return innerOverheadEntry;
    }

    private CostObjectInfo parseCostObject(Hashtable hsData, Context ctx) throws BOSException, EASBizException {
        String companyId = this.company.getId().toString();
        Object storageData = this.getData(hsData, "storageOrgUnit.number");
        String storageOrgUnitNumber = null;
        if (storageData != null && storageData.toString().trim().length() > 0) {
            storageOrgUnitNumber = storageData.toString().trim();
        }
        Object costObjectData = this.getData(hsData, "entrys.costObjectNumber");
        String costObjectNumber = null;
        if (costObjectData != null && costObjectData.toString().trim().length() > 0) {
            costObjectNumber = costObjectData.toString().trim();
        }
        Object orderData = this.getData(hsData, "order.number");
        String orderNumber = null;
        if (orderData != null && orderData.toString().trim().length() > 0) {
            orderNumber = orderData.toString().trim();
        }
        Object productData = this.getData(hsData, "material.number");
        String productNumber = null;
        if (productData != null && productData.toString().trim().length() > 0) {
            productNumber = productData.toString().trim();
        }
        Object batchData = this.getData(hsData, "batch");
        String batch = null;
        if (batchData != null && batchData.toString().trim().length() > 0) {
            batch = batchData.toString().trim();
        }
        if (costObjectNumber != null) {
            return NCMDataImportUtil.getCostObjectbyNumber((Context)ctx, (String)this.getResource(ctx, "CostObjectNumber"), (String)costObjectNumber, (String)companyId);
        }
        if (orderNumber != null) {
            return NCMDataImportUtil.getCostObjectByOrder((Context)ctx, (String)companyId, (String)storageOrgUnitNumber, (String)orderNumber, (String)batch);
        }
        if (productNumber != null) {
            return NCMDataImportUtil.getCostObjectByProduct((Context)ctx, (String)companyId, (String)productNumber, (String)batch);
        }
        return null;
    }

    protected String getResource(Context ctx, String resName) {
        return this.getResource(ctx, resName, null);
    }

    protected String getResource(Context ctx, String resName, Object[] params) {
        if (params != null) {
            return MessageFormat.format(ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale()), params);
        }
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale());
    }

    private BigDecimal getStdPrice(AUXOverheadInfo auxInfo, Context ctx) throws BOSException, SQLException {
        BigDecimal stdPrice = new BigDecimal(0);
        int pricePrecision = 0;
        StringBuffer kSql = new StringBuffer();
        kSql.append(" SELECT auxCompany.FPricePrecision, \n");
        kSql.append("        auxCompany.FStdPrice \n");
        kSql.append(" FROM   T_NCM_AUXOverhead aux \n");
        kSql.append("        INNER JOIN T_NCM_AUXOverheadCompanyInfo auxCompany \n");
        kSql.append("          ON aux.FID = auxCompany.FAuxOverheadID ");
        kSql.append(" WHERE  aux.FID = '" + auxInfo.getId().toString() + "' \n");
        kSql.append(" and auxCompany.FCompanyID = '" + this.company.getId().toString() + "' \n");
        IRowSet rst = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)kSql.toString()).executeSQL();
        if (rst.next()) {
            pricePrecision = rst.getInt(1);
            stdPrice = rst.getBigDecimal(2);
            stdPrice = stdPrice.setScale(pricePrecision, 4);
        }
        return stdPrice;
    }

    private void initOrgUnit(Context ctx) throws BOSException, EASBizException {
        if (this.cu == null || this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
            if (this.period == null) {
                this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
            }
        }
        if (this.currUser == null) {
            this.currUser = (UserInfo)ctx.get((Object)"UserInfo");
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("number", this.getNotBlankString(rs.getString("number")));
            result.put("bizDate", this.getNotBlankString(rs.getString("bizDate")));
            result.put("period", this.getNotBlankString(rs.getString("calculatePeriod.number")));
            result.put("costCenter.number", this.getNotBlankString(rs.getString("costCenter.number")));
            result.put("costCenter.name", this.getNotBlankString(rs.getString("costCenter.name")));
            result.put("entrys.auxNumber", this.getNotBlankString(rs.getString("auxOverhead.number")));
            result.put("entrys.auxName", this.getNotBlankString(rs.getString("auxOverhead.name")));
            result.put("entrys.costCenterNumber", this.getNotBlankString(rs.getString("consumeCostCenter.number")));
            result.put("entrys.costCenterName", this.getNotBlankString(rs.getString("consumeCostCenter.name")));
            result.put("entrys.costObjectNumber", this.getNotBlankString(rs.getString("consumeCostObject.number")));
            result.put("entrys.costObjectName", this.getNotBlankString(rs.getString("consumeCostObject.name")));
            result.put("entrys.qty", this.getNotBlankString(rs.getString("entrys.qty")));
            result.put("storageOrgUnit.number", this.getNotBlankString(rs.getString("storageOrgUnit.number")));
            result.put("order.number", this.getNotBlankString(rs.getString("manufacturerOrder.number")));
            result.put("material.number", this.getNotBlankString(rs.getString("material.number")));
            result.put("batch", this.getNotBlankString(rs.getString("consumeCostObject.batchNumber")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

