/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.app.transmission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ncm.bill.WIPCountingBillFactory;
import com.kingdee.eas.ncm.bill.WIPCountingBillInfo;
import com.kingdee.eas.ncm.common.transmission.app.AbstractNCMDataImport;
import com.kingdee.eas.ncm.common.transmission.app.NCMDataImportUtil;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

public class WIPCountingBillDataImport
extends AbstractNCMDataImport {
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.bill.WIPCountingBillResource";
    CtrlUnitInfo cu = null;
    CompanyOrgUnitInfo company = null;
    PeriodInfo period = null;
    Set itemSet = new HashSet();
    CostCenterOrgUnitInfo costCenter = null;

    protected void prepareImport(Context ctx, IObjectValue info, Hashtable hsData) throws BOSException {
        super.prepareImport(ctx, info, hsData);
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        WIPCountingBillInfo countingBill = null;
        if (coreBaseInfo == null || !(coreBaseInfo instanceof WIPCountingBillInfo)) {
            return;
        }
        countingBill = (WIPCountingBillInfo)coreBaseInfo;
        try {
            String id = this.getId(countingBill.getCostCenter().getNumber(), countingBill.getCostObject().getNumber(), this.company.getId().toString(), countingBill.getCalculatePeriod().getNumber() + "", ctx);
            if (StringUtil.isEmptyString((String)id)) {
                this.insert(ctx, countingBill);
            } else {
                this.update(ctx, id, countingBill.getQty());
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(this.getResource(ctx, "01_WIPCountingImport", new Object[]{countingBill.getCostCenter().getNumber(), countingBill.getCostObject().getNumber()}), (Throwable)ex);
        }
    }

    private void insert(Context ctx, WIPCountingBillInfo countingBill) throws BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append(" insert into T_NCM_WIPCountingBill \n");
        ksql.append("\t\t(FID, \n");
        ksql.append(" \t\t FCompanyOrg, \n");
        ksql.append("\t\t FCostCenterID, \n");
        ksql.append("\t\t FCalculatePeriod, \n");
        ksql.append("\t\t FCostObjectID, \n");
        ksql.append("\t\t FInitBalacneQty, \n");
        ksql.append("\t\t FInputQty, \n");
        ksql.append("\t\t FManuOverQtry, \n");
        ksql.append("\t\t FBillStatus, \n");
        ksql.append("\t\t FQty) \n");
        ksql.append(" values ( \n");
        ksql.append("\t\t '" + BOSUuid.create((BOSObjectType)new BOSObjectType("53DE755F")) + "', \n");
        ksql.append("\t\t '" + this.company.getId().toString() + "', \n");
        ksql.append("\t\t '" + countingBill.getCostCenter().getId().toString() + "', \n");
        ksql.append("\t\t '" + countingBill.getCalculatePeriod().getId().toString() + "', \n");
        ksql.append("\t\t '" + countingBill.getCostObject().getId().toString() + "', \n");
        ksql.append("\t " + NCMConst.ZERO + ", \n");
        ksql.append("\t " + NCMConst.ZERO + ", \n");
        ksql.append("\t " + NCMConst.ZERO + ", \n");
        ksql.append("\t\t 4, \n");
        if (countingBill.getQty().equals(NCMConst.ZERO)) {
            ksql.append("\t " + NCMConst.ZERO + " ) \n");
        } else {
            ksql.append("\t " + countingBill.getQty() + " ) \n");
        }
        try {
            NCMDbUtil.execute((Context)ctx, (String)ksql.toString());
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    private void update(Context ctx, String id, BigDecimal qty) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_NCM_WIPCountingBill set FQty=" + qty + " where fid='" + id + "'");
        try {
            NCMDbUtil.execute((Context)ctx, (String)updateSql.toString());
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    private String getId(String costCenterNumber, String costObject, String companyID, String peroid, Context ctx) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        IRowSet rowSet = null;
        sql.append("select countingBill.fid from T_NCM_WIPCountingBill countingBill inner join T_ORG_CostCenter costCenter on countingBill.fcostcenterid=costCenter.FID inner join t_bd_costobject costobject  on countingBill.fcostobjectid=costobject.fid inner join T_BD_Period period on period.FID=countingBill.FCalculatePeriod where costCenter.FNumber=?  and  period.FNumber = ?  and countingBill.FCompanyorg=?  and costobject.FNumber=? ");
        try {
            rowSet = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{costCenterNumber, peroid, companyID, costObject});
            if (rowSet.next()) {
                return rowSet.getString(1);
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return WIPCountingBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        WIPCountingBillInfo countingBill = null;
        try {
            this.initOrgUnit(ctx);
            countingBill = this.parseHead(hsData, ctx);
            this.verifyHead(ctx, countingBill);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return countingBill;
    }

    private void initOrgUnit(Context ctx) throws BOSException {
        if (this.cu == null || this.company == null) {
            IContextHelper context = ContextHelperFactory.getLocalInstance((Context)ctx);
            if (this.cu == null) {
                this.cu = context.getCurrentCtrlUnit();
            }
            if (this.company == null) {
                this.company = context.getCurrentCompany();
            }
        }
        this.checkCompanyOrgUnit(ctx, this.company);
    }

    private WIPCountingBillInfo parseHead(Hashtable hsData, Context ctx) throws TaskExternalException, BOSException {
        WIPCountingBillInfo countingBill = new WIPCountingBillInfo();
        countingBill.setCompanyOrg(this.company);
        Object data = this.getData(hsData, "calculatePeriod");
        SimpleDateFormat sdf = null;
        Date bizDate = null;
        if (data != null && data.toString().trim().length() > 0) {
            String str = data.toString();
            sdf = new SimpleDateFormat("yyyyMM");
            try {
                bizDate = sdf.parse(str);
            }
            catch (ParseException e) {
                throw new BOSException(this.getResource(ctx, "02_WIPCountingImport"));
            }
        } else {
            throw new BOSException(this.getResource(ctx, "03_WIPCountingImport"));
        }
        PeriodInfo calculatePeriod = this.getPeriodByBizDate(ctx, bizDate, this.company);
        if (this.period == null) {
            try {
                this.period = NCMUtils.GetCurrentPeriod((Context)ctx, (String)this.company.getId().toString());
            }
            catch (EASBizException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        if (!calculatePeriod.equals((Object)this.period)) {
            throw new BOSException(this.getResource(ctx, "04_WIPCountingImport"));
        }
        countingBill.setCalculatePeriod(calculatePeriod);
        data = this.getData(hsData, "costCenter");
        if (data == null || data.toString().trim().length() <= 0) {
            throw new BOSException(this.getResource(ctx, "06_WIPCountingImport"));
        }
        countingBill.setCostCenter(NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)this.getResource(ctx, "05_WIPCountingImport"), (String)data.toString()));
        this.costCenter = NCMDataImportUtil.getCostCenterbyNumber((Context)ctx, (String)this.getResource(ctx, "05_WIPCountingImport"), (String)data.toString());
        CostObjectInfo costObject = this.parseCostObject(hsData, ctx);
        if (costObject != null) {
            if (costObject.isIsForbiden()) {
                throw new BOSException(this.getResource(ctx, "CostObjectHasForbidCanNotImport", new Object[]{costObject.getNumber()}));
            }
        } else {
            throw new BOSException(this.getResource(ctx, "07_WIPCountingImport"));
        }
        countingBill.setCostObject(costObject);
        data = this.getData(hsData, "qty");
        if (data.toString().trim().equals("") || data.toString().trim() == null) {
            throw new BOSException(this.getResource(ctx, "08_WIPCountingImport"));
        }
        BigDecimal qty = new BigDecimal(data.toString());
        if (data.toString().trim().length() > 0 && qty.compareTo(new BigDecimal(0)) >= 0) {
            countingBill.setQty(this.getBigDecimalValueByFeildData(ctx, this.getResource(ctx, "09_WIPCountingImport"), qty.toPlainString()));
        } else {
            countingBill.setQty(new BigDecimal("0"));
        }
        try {
            this.checkExists(ctx, countingBill);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return countingBill;
    }

    private CostObjectInfo parseCostObject(Hashtable hsData, Context ctx) throws BOSException {
        String companyId = this.company.getId().toString();
        Object storageData = this.getData(hsData, "storageOrgUnit.number");
        String storageOrgUnitNumber = null;
        if (storageData != null && storageData.toString().trim().length() > 0) {
            storageOrgUnitNumber = storageData.toString().trim();
        }
        Object costObjectData = this.getData(hsData, "costObject");
        String costObjectNumber = null;
        if (costObjectData != null && costObjectData.toString().trim().length() > 0) {
            costObjectNumber = costObjectData.toString().trim();
        }
        Object orderData = this.getData(hsData, "order.number");
        String orderNumber = null;
        if (orderData != null && orderData.toString().trim().length() > 0) {
            orderNumber = orderData.toString().trim();
        }
        Object productData = this.getData(hsData, "product.number");
        String productNumber = null;
        if (productData != null && productData.toString().trim().length() > 0) {
            productNumber = productData.toString().trim();
        }
        Object batchData = this.getData(hsData, "batch");
        String batch = null;
        if (batchData != null && batchData.toString().trim().length() > 0) {
            batch = batchData.toString().trim();
        }
        try {
            if (costObjectNumber != null) {
                return NCMDataImportUtil.getCostObjectbyNumber((Context)ctx, (String)this.getResource(ctx, "CostObjectNumber"), (String)costObjectNumber, (String)companyId);
            }
            if (orderNumber != null) {
                return NCMDataImportUtil.getCostObjectByOrder((Context)ctx, (String)companyId, (String)storageOrgUnitNumber, (String)orderNumber, (String)batch);
            }
            if (productNumber != null) {
                return NCMDataImportUtil.getCostObjectByProduct((Context)ctx, (String)companyId, (String)productNumber, (String)batch);
            }
            throw new BOSException(this.getResource(ctx, "CostObjectOrderMaterialCanNotAllEmpty"));
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void verifyHead(Context ctx, WIPCountingBillInfo countingBillInfo) throws BOSException {
        this.checkCostCenter(ctx, countingBillInfo);
    }

    private void checkCostCenter(Context ctx, WIPCountingBillInfo countingBillInfo) throws BOSException {
        if (!CostCenterType.DirectProdDept.equals((Object)countingBillInfo.getCostCenter().getCostCenterType())) {
            String msg = MessageFormat.format(this.getResource("COSTCENTER_NOT_DirectProdDept", ctx), countingBillInfo.getCostCenter().getNumber());
            throw new BOSException(msg);
        }
        NCMDataImportUtil.checkCostCenter((Context)ctx, (CostCenterOrgUnitInfo)countingBillInfo.getCostCenter(), (String)countingBillInfo.getCompanyOrg().getId().toString());
    }

    private void checkCompanyOrgUnit(Context ctx, CompanyOrgUnitInfo companyOrgUnit) throws BOSException {
        if (!companyOrgUnit.isIsCompanyOrgUnit()) {
            throw new BOSException(companyOrgUnit.getName() + this.getResource(ctx, "10_WIPCountingImport"));
        }
        if (!companyOrgUnit.isIsBizUnit()) {
            throw new BOSException(companyOrgUnit.getName() + this.getResource(ctx, "11_WIPCountingImport"));
        }
        if (companyOrgUnit.isIsOUSealUp()) {
            throw new BOSException(companyOrgUnit.getName() + this.getResource(ctx, "12_WIPCountingImport"));
        }
    }

    protected String getResource(Context ctx, String resName) {
        return this.getResource(ctx, resName, null);
    }

    protected String getResource(Context ctx, String resName, Object[] params) {
        if (params != null) {
            return MessageFormat.format(ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale()), params);
        }
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)ctx.getLocale());
    }

    private void checkExists(Context ctx, WIPCountingBillInfo info) throws BOSException, EASBizException, TaskExternalException {
        String costCenterNumber = info.getCostCenter().getNumber();
        String costObjectNumber = info.getCostObject().getNumber();
        if (this.itemSet.contains(costCenterNumber + "+" + costObjectNumber)) {
            String msg = this.getResource(ctx, "13_WIPCountingImport");
            String costCenter = "";
            costCenter = costCenter + "[" + costCenterNumber + "]";
            msg = msg + this.getResource(ctx, "14_WIPCountingImport") + costCenter;
            String costObject = "";
            costObject = costObject + "[" + costObjectNumber + "]";
            msg = msg + this.getResource(ctx, "15_WIPCountingImport") + costObject;
            msg = msg + "\u3002";
            this.itemSet.clear();
            throw new BOSException(msg);
        }
        this.itemSet.add(costCenterNumber + "+" + costObjectNumber);
    }
}

