/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.task.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.bill.AllocatorFacadeFactory;
import com.kingdee.eas.ncm.bill.MatAllocWizardSchemeEntryCollection;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocDispatch;
import com.kingdee.eas.ncm.bill.app.Alloc.MatAllocDispatch;
import com.kingdee.eas.ncm.common.task.CostTaskEntryInfo;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.task.CostTaskStatusEnum;
import com.kingdee.eas.ncm.common.task.CostTaskUtils;
import com.kingdee.eas.ncm.common.task.app.BaseCostTaskExecutor;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MatReqAllocTaskExecutor
extends BaseCostTaskExecutor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.task.app.MatReqAllocTaskExecutor");
    private static final String RES_CLASSNAME = "com.kingdee.eas.ncm.bill.task.MatReqAllocResource";
    private CostTaskEntryInfo totalEntry = null;
    private AllocDispatch allocDispatch = null;

    public LinkedList buildCostTaskEntries() throws BOSException, EASBizException {
        LinkedList<CostTaskEntryInfo> entries = new LinkedList<CostTaskEntryInfo>();
        this.totalEntry = new CostTaskEntryInfo();
        this.totalEntry.setName(this.getResource("MAT_REQ_ALLOC", NCMConst.l1), NCMConst.l1);
        this.totalEntry.setName(this.getResource("MAT_REQ_ALLOC", NCMConst.l2), NCMConst.l2);
        this.totalEntry.setName(this.getResource("MAT_REQ_ALLOC", NCMConst.l3), NCMConst.l3);
        this.totalEntry.setProgress(1);
        this.totalEntry.setStatus(CostTaskStatusEnum.NULL);
        this.totalEntry.setResult(CostTaskResultEnum.NULL);
        int level = 0;
        Object oLevel = this.param.get("CostTaskLevel");
        if (oLevel != null && oLevel instanceof Integer && (level = ((Integer)oLevel).intValue()) < 0) {
            level = 0;
        }
        this.totalEntry.setTypeSeq(1210);
        this.totalEntry.setSeq(0);
        this.totalEntry.setLevel(level);
        this.totalEntry.setLeaf(false);
        entries.add(this.totalEntry);
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)this.ctx);
        this.param.put("ctx", this.ctx);
        this.param.put("CU_ID", DefaultCU.getId().toString());
        this.param.put("CostTaskExecutor", this);
        this.param.put("typeSeq", this.totalEntry.getTypeSeq());
        AllocTypeEnum allocType = (AllocTypeEnum)((Object)this.param.get("allocType"));
        if (allocType != null) {
            if (allocType.equals((Object)AllocTypeEnum.AUTO)) {
                this.allocDispatch = new MatAllocDispatch(this.param);
                LinkedList subEntries = this.allocDispatch.buildCostTaskEntries();
                entries.addAll(subEntries);
            } else if (allocType.equals((Object)AllocTypeEnum.WIZ)) {
                this.totalEntry.setLeaf(true);
            }
        }
        return entries;
    }

    public CostTaskResultEnum doExecute() throws Throwable {
        this.totalEntry.setStatus(CostTaskStatusEnum.RUNNING);
        this.totalEntry.setBeginTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
        this.updateCostTaskEntry(this.totalEntry);
        CostTaskResultEnum isAllocSuccess = CostTaskResultEnum.SUCCESS;
        Throwable throwable = null;
        try {
            AllocTypeEnum allocType = (AllocTypeEnum)((Object)this.param.get("allocType"));
            if (allocType != null && allocType.equals((Object)AllocTypeEnum.WIZ)) {
                MatAllocWizardSchemeEntryCollection schemeEntries = (MatAllocWizardSchemeEntryCollection)((Object)this.param.get("schemeEntries"));
                Map reqResult = AllocatorFacadeFactory.getLocalInstance(this.ctx).wizardAllocate(this.param, schemeEntries);
                String status = (String)reqResult.get("HasError");
                if (status != null && status.equals("true")) {
                    isAllocSuccess = CostTaskResultEnum.FAILURE;
                }
            } else {
                Map reqResult = this.allocDispatch.DoAllocate();
                String status = (String)reqResult.get("HasError");
                if (status != null && status.equals("true")) {
                    isAllocSuccess = CostTaskResultEnum.FAILURE;
                }
            }
        }
        catch (Throwable t) {
            isAllocSuccess = CostTaskResultEnum.EXCEPTION;
            throwable = t;
        }
        this.totalEntry.setStatus(CostTaskStatusEnum.FINISHED);
        this.totalEntry.setResult(isAllocSuccess);
        this.totalEntry.setEndTime(new Timestamp(CostTaskUtils.getCurrentTime((Context)this.ctx)));
        if (isAllocSuccess.getValue() >= 7) {
            this.totalEntry.setReport(this.getResource("ERROR_REPORT", NCMConst.l1), NCMConst.l1);
            this.totalEntry.setReport(this.getResource("ERROR_REPORT", NCMConst.l2), NCMConst.l2);
            this.totalEntry.setReport(this.getResource("ERROR_REPORT", NCMConst.l3), NCMConst.l3);
            this.totalEntry.setFunction("com.kingdee.eas.ncm.bill.client.MaterialAllocLogReportUI");
            HashMap logUIParam = new HashMap();
            logUIParam.put("companyId", this.param.get("companyId"));
            logUIParam.put("periodId", this.param.get("periodId"));
            logUIParam.put("logTblName", "T_NCM_LOG_Mat");
            this.totalEntry.setParam(CostTaskUtils.encode(logUIParam));
        }
        this.updateCostTaskEntry(this.totalEntry);
        if (throwable != null) {
            throw throwable;
        }
        return this.totalEntry.getResult();
    }

    protected String getResource(String resName, Locale locale) {
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)locale);
    }
}

