/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.bill.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.task.CostTaskConstants;
import com.kingdee.eas.ncm.common.task.CostTaskInfo;
import com.kingdee.eas.ncm.common.task.CostTaskUtils;
import com.kingdee.eas.ncm.common.utils.NCMConst;
import com.kingdee.util.Assert;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class CostAllocUtils {
    public static Map buildCCOAllocParam(Map source) throws EASBizException, BOSException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Assert.that((boolean)source.containsKey("company"));
        Assert.that((boolean)source.containsKey("period"));
        Assert.that((boolean)source.containsKey("user"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)source.get("company");
        PeriodInfo period = (PeriodInfo)source.get("period");
        UserInfo user = (UserInfo)source.get("user");
        String companyId = company.getId().toString();
        String periodId = period.getId().toString();
        String userId = user.getId().toString();
        CostTaskUtils.setExecutorClazz(param, (String)"com.kingdee.eas.ncm.bill.task.app.CCOAllocTaskExecutor");
        CostTaskInfo costTask = new CostTaskInfo();
        costTask.setNumber("FactCCOAlloc");
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactCCOAlloc", (Locale)NCMConst.l1), NCMConst.l1);
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactCCOAlloc", (Locale)NCMConst.l2), NCMConst.l2);
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactCCOAlloc", (Locale)NCMConst.l3), NCMConst.l3);
        costTask.setCatagory("FactFeeAlloc");
        CompanyOrgUnitInfo aCompany = new CompanyOrgUnitInfo();
        PeriodInfo aPeriod = new PeriodInfo();
        UserInfo aUser = new UserInfo();
        aCompany.setId(BOSUuid.read((String)companyId));
        aCompany.setName(company.getName());
        aPeriod.setId(BOSUuid.read((String)periodId));
        aUser.setId(BOSUuid.read((String)userId));
        costTask.setCompany(aCompany);
        costTask.setPeriod(aPeriod);
        costTask.setCreator(aUser);
        costTask.setFunction("d3T+lgEaEADgAAobwKgRj53UGuM=" + companyId);
        CostTaskUtils.setTask(param, (CostTaskInfo)costTask);
        param.put("companyId", companyId);
        param.put("periodId", periodId);
        param.put("userId", userId);
        param.put("companyName", company.getName());
        param.put("periodNumber", String.valueOf(period.getNumber()));
        AllocTypeEnum allocType = (AllocTypeEnum)((Object)source.get("allocType"));
        if (allocType == null) {
            allocType = AllocTypeEnum.AUTO;
        }
        param.put("allocType", (Object)allocType);
        param.put("isMat", String.valueOf(false));
        param.put("allocSourceBill", AllocSourceBillEnum.CCOFeeBill);
        FilterInfo filterInfo = (FilterInfo)source.get("filterInfo");
        if (filterInfo == null) {
            filterInfo = CostAllocUtils.getFilterForCCOAlloc(source);
        }
        param.put("filterInfo", filterInfo);
        if (source.containsKey("bFilter_all")) {
            param.put("bFilter_all", source.get("bFilter_all"));
        }
        if (source.containsKey("isOnlyUnAlloced")) {
            param.put("isOnlyUnAlloced", source.get("isOnlyUnAlloced"));
        }
        param.put("isForAllocate", "true");
        return param;
    }

    private static FilterInfo getFilterForCCOAlloc(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo cuFilter = CostAllocUtils.getDefaultCUFilter();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)period.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)company.getId().toString()));
        if (param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
            FilterInfo filter1 = new FilterInfo();
            filter1.getFilterItems().add(new FilterItemInfo("entries.isAlloced", (Object)Boolean.FALSE));
            filter1.getFilterItems().add(new FilterItemInfo("entries.isAlloced", null));
            filter1.setMaskString("#0 or #1");
            filter.mergeFilter(filter1, "and");
        }
        cuFilter.mergeFilter(filter, "and");
        return cuFilter;
    }

    public static Map buildMatReqAllocParam(Map source) throws EASBizException, BOSException {
        FilterInfo filterInfo;
        HashMap<String, Object> param = new HashMap<String, Object>();
        Assert.that((boolean)source.containsKey("company"));
        Assert.that((boolean)source.containsKey("period"));
        Assert.that((boolean)source.containsKey("user"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)source.get("company");
        PeriodInfo period = (PeriodInfo)source.get("period");
        UserInfo user = (UserInfo)source.get("user");
        String companyId = company.getId().toString();
        String periodId = period.getId().toString();
        String userId = user.getId().toString();
        CostTaskUtils.setExecutorClazz(param, (String)"com.kingdee.eas.ncm.bill.task.app.MatReqAllocTaskExecutor");
        CostTaskInfo costTask = new CostTaskInfo();
        costTask.setNumber("FactMatReqAlloc");
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactMatReqAlloc", (Locale)NCMConst.l1), NCMConst.l1);
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactMatReqAlloc", (Locale)NCMConst.l2), NCMConst.l2);
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactMatReqAlloc", (Locale)NCMConst.l3), NCMConst.l3);
        costTask.setCatagory("FactFeeAlloc");
        CompanyOrgUnitInfo aCompany = new CompanyOrgUnitInfo();
        PeriodInfo aPeriod = new PeriodInfo();
        UserInfo aUser = new UserInfo();
        aCompany.setId(BOSUuid.read((String)companyId));
        aCompany.setName(company.getName());
        aPeriod.setId(BOSUuid.read((String)periodId));
        aUser.setId(BOSUuid.read((String)userId));
        costTask.setCompany(aCompany);
        costTask.setPeriod(aPeriod);
        costTask.setCreator(aUser);
        costTask.setFunction("d3T+lgEaEADgAAobwKgRj53UGuM=" + companyId);
        CostTaskUtils.setTask(param, (CostTaskInfo)costTask);
        param.put("companyId", companyId);
        param.put("periodId", periodId);
        param.put("userId", userId);
        param.put("companyName", company.getName() == null ? "" : company.getName());
        param.put("periodNumber", String.valueOf(period.getNumber()));
        AllocTypeEnum allocType = (AllocTypeEnum)((Object)source.get("allocType"));
        if (allocType == null) {
            allocType = AllocTypeEnum.AUTO;
        }
        param.put("allocType", (Object)allocType);
        param.put("isMat", String.valueOf(true));
        param.put("allocSourceBill", AllocSourceBillEnum.MaterialReqBill);
        if (source.containsKey("billType")) {
            param.put("billType", source.get("billType"));
        }
        if (source.containsKey("schemeEntries")) {
            param.put("schemeEntries", source.get("schemeEntries"));
        }
        if ((filterInfo = (FilterInfo)source.get("filterInfo")) == null) {
            filterInfo = CostAllocUtils.getFilterForMatAlloc(source);
        }
        param.put("filterInfo", filterInfo);
        if (source.containsKey("bFilter_all")) {
            param.put("bFilter_all", source.get("bFilter_all"));
        }
        if (source.containsKey("isOnlyUnAlloced")) {
            param.put("isOnlyUnAlloced", source.get("isOnlyUnAlloced"));
            if (param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
                param.put("isOnlyUnAlloced", String.valueOf(true));
            } else {
                param.put("bFilter_all", String.valueOf(true));
            }
        }
        return param;
    }

    private static FilterInfo getFilterForMatAlloc(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)String.valueOf(period.getPeriodYear())));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)String.valueOf(period.getPeriodNumber())));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
        HashSet<Integer> ccoTypeSet = new HashSet<Integer>();
        ccoTypeSet.add(0);
        ccoTypeSet.add(1);
        filter.getFilterItems().add(new FilterItemInfo("entry.costCenterOrgUnit.costCenterType", ccoTypeSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("transactionType.isManuCostCalculate", (Object)String.valueOf(true)));
        filter.getFilterItems().add(new FilterItemInfo("storeTypePre.isForwardAmt", (Object)String.valueOf(true)));
        return filter;
    }

    public static Map buildOtherInWarehsAllocParam(Map source) throws EASBizException, BOSException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Assert.that((boolean)source.containsKey("company"));
        Assert.that((boolean)source.containsKey("period"));
        Assert.that((boolean)source.containsKey("user"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)source.get("company");
        PeriodInfo period = (PeriodInfo)source.get("period");
        UserInfo user = (UserInfo)source.get("user");
        String companyId = company.getId().toString();
        String periodId = period.getId().toString();
        String userId = user.getId().toString();
        CostTaskUtils.setExecutorClazz(param, (String)"com.kingdee.eas.ncm.bill.task.app.OtherInWarehsAllocTaskExecutor");
        CostTaskInfo costTask = new CostTaskInfo();
        costTask.setNumber("FactOtherInWarehsAlloc");
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactOtherInWarehsAlloc", (Locale)NCMConst.l1), NCMConst.l1);
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactOtherInWarehsAlloc", (Locale)NCMConst.l2), NCMConst.l2);
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactOtherInWarehsAlloc", (Locale)NCMConst.l3), NCMConst.l3);
        costTask.setCatagory("FactFeeAlloc");
        CompanyOrgUnitInfo aCompany = new CompanyOrgUnitInfo();
        PeriodInfo aPeriod = new PeriodInfo();
        UserInfo aUser = new UserInfo();
        aCompany.setId(BOSUuid.read((String)companyId));
        aCompany.setName(company.getName());
        aPeriod.setId(BOSUuid.read((String)periodId));
        aUser.setId(BOSUuid.read((String)userId));
        costTask.setCompany(aCompany);
        costTask.setPeriod(aPeriod);
        costTask.setCreator(aUser);
        costTask.setFunction("d3T+lgEaEADgAAobwKgRj53UGuM=" + companyId);
        CostTaskUtils.setTask(param, (CostTaskInfo)costTask);
        param.put("companyId", companyId);
        param.put("periodId", periodId);
        param.put("userId", userId);
        param.put("companyName", company.getName() == null ? "" : company.getName());
        param.put("periodNumber", String.valueOf(period.getNumber()));
        AllocTypeEnum allocType = (AllocTypeEnum)((Object)source.get("allocType"));
        if (allocType == null) {
            allocType = AllocTypeEnum.AUTO;
        }
        param.put("allocType", (Object)allocType);
        param.put("isMat", String.valueOf(true));
        param.put("matType", "OtherInWarehs");
        FilterInfo filterInfo = (FilterInfo)source.get("filterInfo");
        if (filterInfo == null) {
            filterInfo = CostAllocUtils.getFilterForOIAlloc(source);
        }
        param.put("filterInfo", filterInfo);
        if (source.containsKey("bFilter_all")) {
            param.put("bFilter_all", source.get("bFilter_all"));
        }
        if (source.containsKey("isOnlyUnAlloced")) {
            param.put("isOnlyUnAlloced", source.get("isOnlyUnAlloced"));
            if (param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
                param.put("isOnlyUnAlloced", String.valueOf(true));
            } else {
                param.put("bFilter_all", String.valueOf(true));
            }
        }
        param.put("allocSourceBill", AllocSourceBillEnum.OtherInWarehsBill);
        return param;
    }

    private static FilterInfo getFilterForOIAlloc(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)String.valueOf(period.getPeriodYear())));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)String.valueOf(period.getPeriodNumber())));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("isReversed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costCenterOrgUnit.costCenterType", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("transactionType.isManuCostCalculate", (Object)String.valueOf(true)));
        return filter;
    }

    public static Map buildCostAdjustAllocParam(Map source) throws EASBizException, BOSException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Assert.that((boolean)source.containsKey("company"));
        Assert.that((boolean)source.containsKey("period"));
        Assert.that((boolean)source.containsKey("user"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)source.get("company");
        PeriodInfo period = (PeriodInfo)source.get("period");
        UserInfo user = (UserInfo)source.get("user");
        String companyId = company.getId().toString();
        String periodId = period.getId().toString();
        String userId = user.getId().toString();
        CostTaskUtils.setExecutorClazz(param, (String)"com.kingdee.eas.ncm.bill.task.app.CostAdjustAllocTaskExecutor");
        CostTaskInfo costTask = new CostTaskInfo();
        costTask.setNumber("FactCostAdjustAlloc");
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactCostAdjustAlloc", (Locale)NCMConst.l1), NCMConst.l1);
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactCostAdjustAlloc", (Locale)NCMConst.l2), NCMConst.l2);
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactCostAdjustAlloc", (Locale)NCMConst.l3), NCMConst.l3);
        costTask.setCatagory("FactFeeAlloc");
        CompanyOrgUnitInfo aCompany = new CompanyOrgUnitInfo();
        PeriodInfo aPeriod = new PeriodInfo();
        UserInfo aUser = new UserInfo();
        aCompany.setId(BOSUuid.read((String)companyId));
        aCompany.setName(company.getName());
        aPeriod.setId(BOSUuid.read((String)periodId));
        aUser.setId(BOSUuid.read((String)userId));
        costTask.setCompany(aCompany);
        costTask.setPeriod(aPeriod);
        costTask.setCreator(aUser);
        costTask.setFunction("d3T+lgEaEADgAAobwKgRj53UGuM=" + companyId);
        CostTaskUtils.setTask(param, (CostTaskInfo)costTask);
        param.put("companyId", companyId);
        param.put("periodId", periodId);
        param.put("userId", userId);
        param.put("companyName", company.getName() == null ? "" : company.getName());
        param.put("periodNumber", String.valueOf(period.getNumber()));
        AllocTypeEnum allocType = (AllocTypeEnum)((Object)source.get("allocType"));
        if (allocType == null) {
            allocType = AllocTypeEnum.AUTO;
        }
        param.put("allocType", (Object)allocType);
        param.put("isMat", String.valueOf(true));
        param.put("matType", "CostAdjust");
        FilterInfo filterInfo = (FilterInfo)source.get("filterInfo");
        if (filterInfo == null) {
            filterInfo = CostAllocUtils.getFilterForCAAlloc(source);
        }
        param.put("filterInfo", filterInfo);
        if (source.containsKey("bFilter_all")) {
            param.put("bFilter_all", source.get("bFilter_all"));
        }
        if (source.containsKey("isOnlyUnAlloced")) {
            param.put("isOnlyUnAlloced", source.get("isOnlyUnAlloced"));
            if (param.get("isOnlyUnAlloced").equals(String.valueOf(true))) {
                param.put("isOnlyUnAlloced", String.valueOf(true));
            } else {
                param.put("bFilter_all", String.valueOf(true));
            }
        }
        param.put("allocSourceBill", AllocSourceBillEnum.CostAjustBill);
        return param;
    }

    private static FilterInfo getFilterForCAAlloc(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)String.valueOf(period.getPeriodYear())));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)String.valueOf(period.getPeriodNumber())));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("isReversed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("calculateKind", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("issueType", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("costCenterOrgUnit.costCenterType", (Object)0));
        return filter;
    }

    public static Map buildOtherFeeAllocParam(Map source) throws EASBizException, BOSException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Assert.that((boolean)source.containsKey("company"));
        Assert.that((boolean)source.containsKey("period"));
        Assert.that((boolean)source.containsKey("user"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)source.get("company");
        PeriodInfo period = (PeriodInfo)source.get("period");
        UserInfo user = (UserInfo)source.get("user");
        String companyId = company.getId().toString();
        String periodId = period.getId().toString();
        String userId = user.getId().toString();
        CostTaskUtils.setExecutorClazz(param, (String)"com.kingdee.eas.ncm.bill.task.app.OtherFeeAllocTaskExecutor");
        CostTaskInfo costTask = new CostTaskInfo();
        costTask.setNumber("FactOtherFeeAlloc");
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactOtherFeeAlloc", (Locale)NCMConst.l1), NCMConst.l1);
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactOtherFeeAlloc", (Locale)NCMConst.l2), NCMConst.l2);
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactOtherFeeAlloc", (Locale)NCMConst.l3), NCMConst.l3);
        costTask.setCatagory("FactFeeAlloc");
        CompanyOrgUnitInfo aCompany = new CompanyOrgUnitInfo();
        PeriodInfo aPeriod = new PeriodInfo();
        UserInfo aUser = new UserInfo();
        aCompany.setId(BOSUuid.read((String)companyId));
        aCompany.setName(company.getName());
        aPeriod.setId(BOSUuid.read((String)periodId));
        aUser.setId(BOSUuid.read((String)userId));
        costTask.setCompany(aCompany);
        costTask.setPeriod(aPeriod);
        costTask.setCreator(aUser);
        costTask.setFunction("d3T+lgEaEADgAAobwKgRj53UGuM=" + companyId);
        CostTaskUtils.setTask(param, (CostTaskInfo)costTask);
        param.put("companyId", companyId);
        param.put("periodId", periodId);
        param.put("userId", userId);
        param.put("companyName", company.getName() == null ? "" : company.getName());
        param.put("periodNumber", String.valueOf(period.getNumber()));
        AllocTypeEnum allocType = (AllocTypeEnum)((Object)source.get("allocType"));
        if (allocType == null) {
            allocType = AllocTypeEnum.AUTO;
        }
        param.put("allocType", (Object)allocType);
        param.put("isMat", String.valueOf(false));
        FilterInfo filterInfo = (FilterInfo)source.get("filterInfo");
        if (filterInfo == null) {
            filterInfo = CostAllocUtils.getFilterForOtherAlloc(source);
        }
        param.put("filterInfo", filterInfo);
        if (source.containsKey("bFilter_all")) {
            param.put("bFilter_all", source.get("bFilter_all"));
        }
        if (source.containsKey("isOnlyUnAlloced")) {
            param.put("isOnlyUnAlloced", source.get("isOnlyUnAlloced"));
        }
        param.put("allocSourceBill", AllocSourceBillEnum.OtherFeeBill);
        return param;
    }

    private static FilterInfo getFilterForOtherAlloc(Map param) throws BOSException {
        Assert.that((boolean)param.containsKey("isOnlyUnAlloced"));
        Assert.that((boolean)param.containsKey("company"));
        Assert.that((boolean)param.containsKey("period"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo cuFilter = CostAllocUtils.getDefaultCUFilter();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)period.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)company.getId().toString()));
        HashSet<Integer> ccoTypeSet = new HashSet<Integer>();
        ccoTypeSet.add(0);
        ccoTypeSet.add(1);
        filter.getFilterItems().add(new FilterItemInfo("costCenter.costCenterType", ccoTypeSet, CompareType.INCLUDE));
        cuFilter.mergeFilter(filter, "and");
        return cuFilter;
    }

    public static Map buildAuxFeeAllocParam(Map source) throws EASBizException, BOSException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        Assert.that((boolean)source.containsKey("company"));
        Assert.that((boolean)source.containsKey("period"));
        Assert.that((boolean)source.containsKey("user"));
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)source.get("company");
        PeriodInfo period = (PeriodInfo)source.get("period");
        UserInfo user = (UserInfo)source.get("user");
        String companyId = company.getId().toString();
        String periodId = period.getId().toString();
        String userId = user.getId().toString();
        CostTaskUtils.setExecutorClazz(param, (String)"com.kingdee.eas.ncm.bill.task.app.AuxAllocTaskExecutor");
        CostTaskInfo costTask = new CostTaskInfo();
        costTask.setNumber("FactAuxFeeAlloc");
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactAuxFeeAlloc", (Locale)NCMConst.l1), NCMConst.l1);
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactAuxFeeAlloc", (Locale)NCMConst.l2), NCMConst.l2);
        costTask.setName(CostTaskConstants.getResource((String)"TASK_NUM_FactAuxFeeAlloc", (Locale)NCMConst.l3), NCMConst.l3);
        costTask.setCatagory("FactFeeAlloc");
        CompanyOrgUnitInfo aCompany = new CompanyOrgUnitInfo();
        PeriodInfo aPeriod = new PeriodInfo();
        UserInfo aUser = new UserInfo();
        aCompany.setId(BOSUuid.read((String)companyId));
        aCompany.setName(company.getName());
        aPeriod.setId(BOSUuid.read((String)periodId));
        aUser.setId(BOSUuid.read((String)userId));
        costTask.setCompany(aCompany);
        costTask.setPeriod(aPeriod);
        costTask.setCreator(aUser);
        costTask.setFunction("d3T+lgEaEADgAAobwKgRj53UGuM=" + companyId);
        CostTaskUtils.setTask(param, (CostTaskInfo)costTask);
        param.put("companyId", companyId);
        param.put("periodId", periodId);
        param.put("userId", userId);
        param.put("companyName", company.getName() == null ? "" : company.getName());
        param.put("periodNumber", String.valueOf(period.getNumber()));
        AllocTypeEnum allocType = (AllocTypeEnum)((Object)source.get("allocType"));
        if (allocType == null) {
            allocType = AllocTypeEnum.AUTO;
        }
        param.put("allocType", (Object)allocType);
        param.put("isMat", String.valueOf(false));
        FilterInfo filterInfo = (FilterInfo)source.get("filterInfo");
        if (filterInfo == null) {
            filterInfo = CostAllocUtils.getFilterForAuxFeeAlloc(source);
        }
        param.put("filterInfo", filterInfo);
        if (source.containsKey("bFilter_all")) {
            param.put("bFilter_all", source.get("bFilter_all"));
        }
        if (source.containsKey("isOnlyUnAlloced")) {
            param.put("isOnlyUnAlloced", source.get("isOnlyUnAlloced"));
        }
        param.put("allocSourceBill", AllocSourceBillEnum.InnerOverheadBill);
        return param;
    }

    private static FilterInfo getFilterForAuxFeeAlloc(Map param) throws BOSException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        PeriodInfo period = (PeriodInfo)param.get("period");
        FilterInfo cuFilter = CostAllocUtils.getDefaultCUFilter();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)period.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(4)));
        filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("AuxFIinfo.companyOrgUnit.id", (Object)company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("FeeCO.company.id", (Object)company.getId().toString()));
        HashSet<Integer> ccoTypeSet = new HashSet<Integer>();
        ccoTypeSet.add(0);
        ccoTypeSet.add(1);
        filter.getFilterItems().add(new FilterItemInfo("costCenter.costCenterType", ccoTypeSet, CompareType.INCLUDE));
        cuFilter.mergeFilter(filter, "and");
        return cuFilter;
    }

    private static FilterInfo getDefaultCUFilter() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        filter.setMaskString("#0 or #1 or #2");
        return filter;
    }
}

