/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dbclean.bill.app;

import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.eas.base.dbclean.JZContext;
import com.kingdee.eas.base.dbclean.JZTaskException;
import com.kingdee.eas.base.dbclean.app.CodeJZTask;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BillBaseJZTask
extends CodeJZTask {
    protected static String adminId = "00000000-0000-0000-0000-00000000000013B7DE7F";
    protected static String companyId = null;
    protected static int periodNumber = -1;
    protected static String periodTypeId = null;
    protected static String startPeriodId = null;
    protected static String currentPeriodId = null;
    protected static String jzPeriodId = null;
    protected static Set cleanPeriodIds = null;
    protected static String cuId = "";
    private static boolean isNeedJZ = false;

    public static synchronized boolean isNeedJZ(JZContext context) throws JZTaskException {
        if (companyId != null && periodNumber != -1 && companyId.equals(context.getOrgFId()) && periodNumber == context.getPeriodNumber()) {
            return isNeedJZ;
        }
        companyId = context.getOrgFId();
        periodNumber = context.getPeriodNumber();
        isNeedJZ = false;
        ResultSet rs = null;
        try {
            KDConnection dbConn = context.getDbConn();
            StringBuffer ksql = new StringBuffer();
            ksql.setLength(0);
            ksql.append("select FID, FAccountPeriodID, FControlUnitID from T_ORG_Company \n");
            ksql.append("where FID = ? \n");
            rs = BillBaseJZTask.executeQuery(context, ksql.toString(), new String[]{context.getOrgFId()});
            if (!rs.next()) {
                BillBaseJZTask.warn(context, "\u4e0d\u662f\u8d22\u52a1\u7ec4\u7ec7\uff0c\u4e0d\u9700\u8981\u7ed3\u8f6c\u3002");
                boolean bl = isNeedJZ;
                return bl;
            }
            periodTypeId = rs.getString("FAccountPeriodID");
            cuId = rs.getString("FControlUnitID");
            rs.close();
            rs = null;
            if (periodTypeId == null || periodTypeId.length() == 0) {
                BillBaseJZTask.warn(context, "\u6ca1\u6709\u5b9a\u4e49\u671f\u95f4\u7c7b\u578b\uff0c\u4e0d\u9700\u8981\u7ed3\u8f6c\u3002");
                boolean bl = isNeedJZ;
                return bl;
            }
            ksql.setLength(0);
            ksql.append("select \n");
            ksql.append("s.FHasPeriod, sc.FIsStart, sc.FStartPeriodID, sc.FCurrentPeriodID \n");
            ksql.append("from T_BD_SystemStatusCtrol sc \n");
            ksql.append("join T_BD_SystemStatus s on sc.FSystemStatusID = s.FID \n");
            ksql.append("where sc.FCompanyID = ? \n");
            ksql.append("and s.FName = 1001 \n");
            boolean hasPeriod = false;
            boolean isStart = false;
            rs = BillBaseJZTask.executeQuery(context, ksql.toString(), new String[]{companyId});
            if (rs.next()) {
                hasPeriod = rs.getInt("FHasPeriod") == 1;
                isStart = rs.getInt("FIsStart") == 1;
                startPeriodId = rs.getString("FStartPeriodID");
                currentPeriodId = rs.getString("FCurrentPeriodID");
            }
            rs.close();
            rs = null;
            if (!hasPeriod) {
                BillBaseJZTask.warn(context, "\u6ca1\u6709\u671f\u95f4\u63a7\u5236\uff0c\u4e0d\u9700\u8981\u7ed3\u8f6c\u3002");
                boolean bl = isNeedJZ;
                return bl;
            }
            if (!isStart) {
                BillBaseJZTask.warn(context, "\u6ca1\u6709\u542f\u7528\u6210\u672c\u7ba1\u7406\uff0c\u4e0d\u9700\u8981\u7ed3\u8f6c\u3002");
                boolean bl = isNeedJZ;
                return bl;
            }
            if (startPeriodId == null || startPeriodId.length() == 0 || currentPeriodId == null || currentPeriodId.length() == 0) {
                throw new JZTaskException(BillBaseJZTask.getMsg(context, "\u671f\u95f4\u5b9a\u4e49\u9519\u8bef\u3002"), 5);
            }
            if (startPeriodId.equals(currentPeriodId)) {
                BillBaseJZTask.warn(context, "\u6ca1\u6709\u5386\u53f2\u671f\u95f4\uff0c\u4e0d\u9700\u8981\u7ed3\u8f6c\u3002");
                boolean bl = isNeedJZ;
                return bl;
            }
            ksql.setLength(0);
            int count = 0;
            HashSet<String> ids = new HashSet<String>();
            ids.add(startPeriodId);
            ids.add(currentPeriodId);
            ksql.append("select count(*) from T_BD_Period \n");
            ksql.append("where FTypeID = ? \n");
            ksql.append("and FID in " + BillBaseJZTask.buildSqlFromIds(ids) + " \n");
            rs = BillBaseJZTask.executeQuery(context, ksql.toString(), new String[]{periodTypeId});
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
            rs = null;
            if (count != 2) {
                throw new JZTaskException(BillBaseJZTask.getMsg(context, "\u671f\u95f4\u8bbe\u7f6e\u5f02\u5e38\u3002"), 5);
            }
            ksql.setLength(0);
            ksql.append("select FID from T_BD_Period \n");
            ksql.append("where FTypeID = '" + periodTypeId + "' \n");
            ksql.append("and FNumber = " + context.getPeriodNumber() + " \n");
            rs = BillBaseJZTask.executeQuery(context, ksql.toString(), new Object[]{context.getPeriodNumber()});
            if (rs.next()) {
                jzPeriodId = rs.getString("FID");
            }
            rs.close();
            rs = null;
            if (jzPeriodId == null || jzPeriodId.length() == 0) {
                throw new JZTaskException(BillBaseJZTask.getMsg(context, "\u671f\u95f4\u53c2\u6570\u9519\u8bef[" + context.getPeriodNumber() + "]"), 5);
            }
            ksql.setLength(0);
            ksql.append("select FID from T_BD_Period p \n");
            ksql.append("where p.FTypeID = ? \n");
            ksql.append("and p.FBeginDate >= ( \n");
            ksql.append("    select p1.FBeginDate from T_BD_Period p1 where p1.FID = ? \n");
            ksql.append(") \n");
            ksql.append("and p.FEndDate < ( \n");
            ksql.append("    select p2.FBeginDate from T_BD_Period p2 where p2.FID = ? \n");
            ksql.append(") \n");
            ksql.append("and p.FEndDate < ( \n");
            ksql.append("    select p3.FBeginDate from T_BD_Period p3 where p3.FID = ? \n");
            ksql.append(") \n");
            ksql.append("order by p.FEndDate");
            rs = BillBaseJZTask.executeQuery(context, ksql.toString(), new String[]{periodTypeId, startPeriodId, jzPeriodId, currentPeriodId});
            cleanPeriodIds = new HashSet();
            while (rs.next()) {
                cleanPeriodIds.add(rs.getString("FID"));
            }
            rs.close();
            rs = null;
            if (cleanPeriodIds.size() <= 0) {
                BillBaseJZTask.warn(context, "\u6ca1\u6709\u5386\u53f2\u671f\u95f4\uff0c\u4e0d\u9700\u8981\u7ed3\u8f6c\u3002");
                boolean bl = isNeedJZ;
                return bl;
            }
        }
        catch (SQLException e) {
            companyId = null;
            periodNumber = -1;
            e.printStackTrace();
            throw new JZTaskException(e.getMessage(), 5);
        }
        catch (JZTaskException e) {
            companyId = null;
            periodNumber = -1;
            e.printStackTrace();
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        isNeedJZ = true;
        return isNeedJZ;
    }

    public boolean doTask(JZContext context) throws JZTaskException {
        if (BillBaseJZTask.isNeedJZ(context)) {
            return this.execute(context);
        }
        return true;
    }

    public abstract boolean execute(JZContext var1) throws JZTaskException;

    protected void cleanBillData(JZContext context, Statement stmt, String tableName, String companyFieldName, String periodFieldName) throws SQLException {
        if (companyId == null || cleanPeriodIds == null || cleanPeriodIds.size() <= 0 || tableName == null) {
            return;
        }
        StringBuffer ksql = new StringBuffer();
        ksql.append("delete from " + tableName + " \n");
        ksql.append("where 1=1 \n");
        if (companyFieldName != null) {
            ksql.append("and " + companyFieldName + " = '" + companyId + "' \n");
        }
        if (periodFieldName != null) {
            ksql.append("and " + periodFieldName + " in " + BillBaseJZTask.buildSqlFromIds(cleanPeriodIds) + " \n");
        }
        stmt.execute(ksql.toString());
    }

    protected void cleanEntryData(JZContext context, Statement stmt, String tableName, String entryTableName, String idFieldName, String parentFieldName) throws SQLException {
        if (companyId == null || cleanPeriodIds == null || cleanPeriodIds.size() <= 0 || tableName == null || entryTableName == null || idFieldName == null || parentFieldName == null) {
            return;
        }
        StringBuffer ksql = new StringBuffer();
        ksql.append("delete from " + entryTableName + " \n");
        ksql.append("where not exists ( \n");
        ksql.append("    select 1 from " + tableName + " \n");
        ksql.append("    where " + tableName + "." + idFieldName + " = " + entryTableName + "." + parentFieldName + " \n");
        ksql.append(") \n");
        stmt.execute(ksql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getPhysicalTblNames(JZContext context, Statement stmt, Set busiTblNames) throws SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (companyId == null || cleanPeriodIds == null || cleanPeriodIds.size() <= 0 || busiTblNames == null || busiTblNames.size() <= 0) {
            return result;
        }
        try (ResultSet rs = null;){
            StringBuffer ksql = new StringBuffer();
            ksql.append("select FPhysicalTblName, FBusinessTblName from T_NCM_DynamicTableMap \n");
            ksql.append("where FCompanyID = '" + companyId + "' \n");
            ksql.append("and FBusinessTblName in " + BillBaseJZTask.buildSqlFromIds(busiTblNames) + " \n");
            rs = stmt.executeQuery(ksql.toString());
            String physicalTblName = null;
            String businessTblName = null;
            while (rs.next()) {
                physicalTblName = rs.getString("FPhysicalTblName");
                businessTblName = rs.getString("FBusinessTblName");
                if (physicalTblName == null || businessTblName == null) continue;
                result.put(physicalTblName, businessTblName);
            }
        }
        return result;
    }

    public static String buildSqlFromIds(Set ids) {
        StringBuffer idsSql = new StringBuffer();
        if (ids != null && ids.size() > 0) {
            idsSql.append("(");
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                idsSql.append("'" + it.next() + "',");
            }
            idsSql.deleteCharAt(idsSql.length() - 1);
            idsSql.append(")");
        }
        return idsSql.toString();
    }

    protected static void debug(JZContext context, String msg) {
        if (context.getLogger() != null) {
            context.getLogger().println("DEBUG \u6210\u672c\u7ba1\u7406_\u5b9e\u9645\u6210\u672c\uff0c\u8d22\u52a1\u7ec4\u7ec7[" + context.getOrgFId() + "\uff0c" + context.getOrgNumber() + "]\uff1a" + msg);
        }
    }

    protected static void warn(JZContext context, String msg) {
        if (context.getLogger() != null) {
            context.getLogger().println("WARN  \u6210\u672c\u7ba1\u7406_\u5b9e\u9645\u6210\u672c\uff0c\u8d22\u52a1\u7ec4\u7ec7[" + context.getOrgFId() + "\uff0c" + context.getOrgNumber() + "]\uff1a" + msg);
        }
    }

    protected static void info(JZContext context, String msg) {
        if (context.getLogger() != null) {
            context.getLogger().println("INFO  \u6210\u672c\u7ba1\u7406_\u5b9e\u9645\u6210\u672c\uff0c\u8d22\u52a1\u7ec4\u7ec7[" + context.getOrgFId() + "\uff0c" + context.getOrgNumber() + "]\uff1a" + msg);
        }
    }

    protected static void error(JZContext context, String msg) {
        if (context.getLogger() != null) {
            context.getLogger().println("ERROR \u6210\u672c\u7ba1\u7406_\u5b9e\u9645\u6210\u672c\uff0c\u8d22\u52a1\u7ec4\u7ec7[" + context.getOrgFId() + "\uff0c" + context.getOrgNumber() + "]\uff1a" + msg);
        }
    }

    protected static String getMsg(JZContext context, String msg) {
        return "\u6210\u672c\u7ba1\u7406_\u5b9e\u9645\u6210\u672c\uff0c\u8d22\u52a1\u7ec4\u7ec7[" + context.getOrgFId() + "\uff0c" + context.getOrgNumber() + "]\uff1a" + msg;
    }

    public static void executeSql(JZContext context, String sql, Object[] params) throws JZTaskException, SQLException {
        KDConnection dbConn = null;
        PreparedStatement preparedStatement = null;
        try {
            dbConn = context.getDbConn();
            preparedStatement = dbConn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                preparedStatement.setObject(i + 1, params[i]);
            }
            preparedStatement.execute();
        }
        catch (SQLException e) {
            throw new JZTaskException(e.getMessage(), 5);
        }
        finally {
            if (dbConn != null) {
                dbConn.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    public static void executeBatchSql(JZContext context, String sql, List<Object[]> params) throws JZTaskException, SQLException {
        KDConnection dbConn = null;
        PreparedStatement preparedStatement = null;
        try {
            dbConn = context.getDbConn();
            preparedStatement = dbConn.prepareStatement(sql);
            for (int k = 0; k < params.size(); ++k) {
                Object[] param = params.get(k);
                for (int i = 0; i < param.length; ++i) {
                    preparedStatement.setObject(i + 1, param[i]);
                }
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (SQLException e) {
            throw new JZTaskException(e.getMessage(), 5);
        }
        finally {
            if (dbConn != null) {
                dbConn.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    public static IRowSet executeQuery(JZContext ctx, String sql, Object[] params) throws JZTaskException {
        JdbcRowSet jdbcRowSet;
        KDConnection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        conn = ctx.getDbConn();
        try {
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                throw new JZTaskException(exc.getMessage(), 5);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }
}

