/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllocFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.MatAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllocFactory.Fee.DynMatFeeData;
import com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllocFactory.Table.DynMatAllocTable;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class DynMatAllocator
extends MatAllocator {
    private static Logger logger = Logger.getLogger((String)DynMatAllocator.class.getName());
    protected PeriodInfo periodInfo = null;
    protected Date beginDate = null;
    protected Date endDate = null;

    public DynMatAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
        Context ctx = (Context)this._param.get("ctx");
        String periodId = this._param.get("periodId").toString();
        try {
            this.periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectStringPK(periodId));
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.bill.app.BILLAPPAutoGenerateResource", (String)"0_DynMatAllocator", (Locale)ctx.getLocale()));
        }
        this.beginDate = new Date(this.periodInfo.getBeginDate().getTime());
        this.endDate = new Date(this.periodInfo.getEndDate().getTime());
    }

    protected AllocTable setAllocTable(Map param) {
        return new DynMatAllocTable(param);
    }

    protected FeeData setFeeData(Map param) {
        return new DynMatFeeData(param);
    }

    public CostTaskResultEnum preCheck() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        boolean hasValidCostObject = false;
        try {
            hasValidCostObject = this.checkHasValidCostObject(ctx, companyId, periodId);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, (Throwable)e);
        }
        if (!hasValidCostObject) {
            AllocateException e = new AllocateException(AllocateException.ITEM_ALLOC_NO_INPUT_DYNWIP);
            this.processAllocateException(e, null, null);
            return CostTaskResultEnum.FAILURE;
        }
        return CostTaskResultEnum.SUCCESS;
    }

    protected void removeInvalidCostObject(Context ctx, String companyId, String periodId) throws AllocateException {
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        Boolean isAssistant = (Boolean)this._param.get("isAssistant");
        int compareObject = isAssistant != null && isAssistant != false ? 1 : 0;
        StringBuffer sb = new StringBuffer();
        sb.delete(0, sb.length());
        sb.append("SELECT DISTINCT MB.FNumber, ME.FSeq, CO.FName_L2 As FCostObjectName ").append('\n').append("FROM {0} D ").append('\n').append("INNER JOIN ").append(this.setPhsicalTblEntry()).append(" ME ON ME.FID=D.FSourceBillEntryID ").append('\n').append("INNER JOIN ").append(this.setPhsicalTblBill()).append(" MB ON MB.FID=D.FSourceBillID ").append('\n').append("INNER JOIN t_bd_CostObject CO ON CO.FID=D.FCostObjectID ").append('\n').append("INNER JOIN T_ORG_CostCenter CC ON ME.").append(this.setFCostCenterOrgUnitID()).append("=CC.FID ").append('\n').append("WHERE D.FCompanyID=''{1}'' AND D.FCalculatePeriodID=''{2}'' ").append('\n').append("  AND CC.FCostCenterType=").append(compareObject).append('\n').append("  AND NOT exists(").append('\n').append("\tSELECT FCostObjectID").append('\n').append("\tFROM {3} S ").append('\n').append("\tWhere S.Fcostcenterid=D.Fcostcenterid and S.FCostObjectID=D.Fcostobjectid ").append('\n').append(")");
        String sqlInvalidCostObject = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, tblObjRange);
        sb.delete(0, sb.length());
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlInvalidCostObject);
            rs.first();
            if (rs.getRow() > 0) {
                sb.append("DELETE {0} ").append("WHERE FCompanyID=''{1}'' AND FCalculatePeriodID=''{2}'' AND NOT exists (").append('\n').append("\tSELECT FCostObjectID").append('\n').append("\tFROM {3} S ").append('\n').append("\tWhere S.Fcostcenterid={4}.Fcostcenterid and S.FCostObjectID={5}.Fcostobjectid ").append('\n').append(") and {6}.AllocBillType=''{7}'' ");
                String sqlDeleteInvalid = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, tblObjRange, this.getTblResult(), this.getTblResult(), this.getTblResult(), this.getAllocBillType());
                DbUtil.execute((Context)ctx, (String)sqlDeleteInvalid);
                NumericExceptionSubItem except = null;
                except = isAssistant != null && isAssistant != false ? AllocateException.ITEM_ALLOC_INVALID_AUSCOSTOBJ : AllocateException.ITEM_ALLOC_INVALID_DYNCOSTOBJ;
                rs.first();
                while (rs.getRow() > 0 && !rs.isAfterLast()) {
                    String number = rs.getString("FNumber");
                    String seq = String.valueOf(rs.getInt("FSeq"));
                    String costObjName = rs.getString("FCostObjectName");
                    this.processAllocateException(new AllocateException(except, new Object[]{number, seq, costObjName}), null, null);
                    rs.next();
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e), null, null);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, (Throwable)e), null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillDirectObjectRange() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        Connection conn = null;
        try {
            String tblObjRange = this.getAllocTable().GetObjectRangeTable();
            StringBuffer kSql = new StringBuffer();
            kSql.append("insert into ").append(tblObjRange).append('\n');
            kSql.append("(FID,FCostCenterID,FCostObjectID,FCostItemID,FIsValid)").append('\n');
            kSql.append("select NEWBOSID('08F65F4A') as FID, FCostCenterID, FCostObjectID, NULL as FCostItemID, 1 AS FIsValid ").append('\n');
            kSql.append("  from (select distinct recBillEntry.FCostCenterOrgUnitID as FCostCenterID, CO.FID as FCostObjectID").append('\n');
            kSql.append("\t\t   from T_IM_ManufactureRecBill as recBill ").append('\n');
            kSql.append("\t      inner join T_SCM_TransactionType as transType  ").append('\n');
            kSql.append("            on recBill.FTransactionTypeID = transType.FID and transType.FIsManuCostCalculate = 1").append('\n');
            kSql.append("\t       left outer join T_IM_ManufactureRecBillEntry as recBillEntry ").append('\n');
            kSql.append("            on recBill.FID =  recBillEntry.FParentID").append('\n');
            kSql.append("\t\t   left outer join T_BD_CostObjectEntry as COEntry ").append('\n');
            kSql.append("\t\t\t on COEntry.FRelatedID = recBillEntry.FMaterialID ").append('\n');
            kSql.append("\t\t   left outer join T_BD_CostObject as CO ").append('\n');
            kSql.append("\t\t\t on CO.FID = COEntry.FParentID and CO.FCompanyID = recBillEntry.FCompanyOrgUnitID ").append('\n');
            kSql.append("  \t\t  inner join t_org_costcenter as cc ").append('\n');
            kSql.append("\t\t\t on cc.fid = recBillEntry.FCostCenterOrgUnitID and cc.FCostCenterType = 0 ").append('\n');
            kSql.append("\t      where CO.FRelatedType = 0  and CO.FIsForbiden=0 ").append('\n');
            kSql.append("\t\t    and ((CO.FCalculateMode=4 and Isnull(recBillEntry.FLot,'''') = Isnull(CO.FBatchNumber,''''))").append('\n');
            kSql.append("\t\t\t\t or CO.FCalculateMode <> 4)").append('\n');
            kSql.append("           and recBill.FBASESTATUS = 4  ").append('\n');
            kSql.append("           and recBillEntry.FCompanyOrgUnitID = ?  ").append('\n');
            kSql.append("           and recBill.FBizDate >= ? ").append('\n');
            kSql.append("           and recBill.FBizDate <= ? ").append('\n');
            kSql.append("          ) as A").append('\n');
            DbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{companyId, this.beginDate, this.endDate});
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblObjRange);
            SQLUtils.cleanup((Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e), null, null);
        }
        finally {
            SQLUtils.cleanup(conn);
        }
    }

    private boolean checkHasValidCostObject(Context ctx, String companyId, String periodId) throws BOSException, SQLException, EASBizException {
        IRowSet rst;
        block4: {
            boolean bl;
            StringBuffer kSql = new StringBuffer();
            kSql.append(" select sum(recBillEntry.FBaseQty) ").append('\n');
            kSql.append("\tfrom T_IM_ManufactureRecBill as recBill ").append('\n');
            kSql.append("\t\t inner join T_SCM_TransactionType as transType  ").append('\n');
            kSql.append(" \t   \t\ton recBill.FTransactionTypeID = transType.FID ").append('\n');
            kSql.append("      \t\t\tand transType.FIsManuCostCalculate = 1").append('\n');
            kSql.append("\t\t left outer join T_IM_ManufactureRecBillEntry as recBillEntry ").append('\n');
            kSql.append(" \t\t\ton recBill.FID =  recBillEntry.FParentID").append('\n');
            kSql.append("\t\t left outer join T_BD_CostObjectEntry as COEntry ").append('\n');
            kSql.append("\t\t\ton COEntry.FRelatedID = recBillEntry.FMaterialID ").append('\n');
            kSql.append("\t\t left outer join T_BD_CostObject as CO ").append('\n');
            kSql.append("\t\t\ton CO.FID = COEntry.FParentID ").append('\n');
            kSql.append("\t\t\t  and CO.FCompanyID = recBillEntry.FCompanyOrgUnitID ").append('\n');
            kSql.append("  \t\t inner join t_org_costcenter cc on cc.fid = recBillEntry.FCostCenterOrgUnitID").append('\n');
            kSql.append("  \t\t\t\t\t       and cc.FCostCenterType = 0 ").append('\n');
            kSql.append("  where CO.FRelatedType = 0 and CO.FIsForbiden=0 ").append('\n');
            kSql.append("\t and ((CO.FCalculateMode=4 and Isnull(recBillEntry.FLot,'''') = Isnull(CO.FBatchNumber,''''))").append('\n');
            kSql.append("\t\t\t\tor CO.FCalculateMode <> 4)").append('\n');
            kSql.append("    and recBill.FBASESTATUS = 4  ").append('\n');
            kSql.append("    and recBillEntry.FCompanyOrgUnitID = ?  ").append('\n');
            kSql.append("    and recBill.FBizDate >= ? ").append('\n');
            kSql.append("    and recBill.FBizDate <= ? ").append('\n');
            kSql.append("  group by recBillEntry.FCompanyOrgUnitID,CO.FID ").append('\n');
            kSql.append("       having sum(recBillEntry.FBaseQty) <> 0 ").append('\n');
            rst = null;
            try {
                rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{companyId, this.beginDate, this.endDate});
                if (!rst.next()) break block4;
                bl = true;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return false;
    }

    protected String getCostObjectIds() throws EASBizException, BOSException, SQLException {
        String companyId = this._param.get("companyId").toString();
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select distinct CO.FID as FCostObjectID ").append('\n');
        kSql.append("\tfrom T_IM_ManufactureRecBill as recBill ").append('\n');
        kSql.append("\t\t inner join T_SCM_TransactionType as transType  ").append('\n');
        kSql.append(" \t   \t\ton recBill.FTransactionTypeID = transType.FID ").append('\n');
        kSql.append("      \t\t\tand transType.FIsManuCostCalculate = 1").append('\n');
        kSql.append("\t\t left outer join T_IM_ManufactureRecBillEntry as recBillEntry ").append('\n');
        kSql.append(" \t\t\ton recBill.FID =  recBillEntry.FParentID").append('\n');
        kSql.append("\t\t left outer join T_BD_CostObjectEntry as COEntry ").append('\n');
        kSql.append("\t\t\ton COEntry.FRelatedID = recBillEntry.FMaterialID ").append('\n');
        kSql.append("\t\t left outer join T_BD_CostObject as CO ").append('\n');
        kSql.append("\t\t\ton CO.FID = COEntry.FParentID ").append('\n');
        kSql.append("\t\t\t  and CO.FCompanyID = recBillEntry.FCompanyOrgUnitID ").append('\n');
        kSql.append("  \t\t inner join t_org_costcenter cc on cc.fid = recBillEntry.FCostCenterOrgUnitID").append('\n');
        kSql.append("  \t\t\t\t\t       and cc.FCostCenterType = 0 ").append('\n');
        kSql.append("  where CO.FRelatedType = 0 and CO.FIsForbiden=0 ").append('\n');
        kSql.append("\t and ((CO.FCalculateMode=4 and Isnull(recBillEntry.FLot,'''') = Isnull(CO.FBatchNumber,''''))").append('\n');
        kSql.append("\t\t\t\tor CO.FCalculateMode <> 4)").append('\n');
        kSql.append("    and recBill.FBASESTATUS = 4  ").append('\n');
        kSql.append("    and recBillEntry.FCompanyOrgUnitID = '" + companyId + "'  ").append('\n');
        kSql.append("    and recBill.FBizDate >= TO_DATE('" + dateFormate.format(this.beginDate) + "') ").append('\n');
        kSql.append("    and recBill.FBizDate <= TO_DATE('" + dateFormate.format(this.endDate) + "') ").append('\n');
        return kSql.toString();
    }

    protected Map getMaterialList() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        FeeData iFee = this.GetFeeDataControl();
        String sqlIndirectFee = iFee.GetIndirectFeeDataSql();
        HashMap<String, String> ret = new HashMap<String, String>();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT distinct \"MATERIAL.ID\" As FMaterialId, \"BIZDATE\" As FBizDate ").append('\n').append("FROM ( ").append(sqlIndirectFee).append(" ) S ").append('\n').append("WHERE ").append('\n').append("  EXISTS(").append('\n').append("\t\tSELECT 1").append('\n').append("\t\tFROM T_NCM_AllocStdSetByPrd Prd").append('\n').append("\t\tINNER JOIN T_NCM_AllocStd STD ON STD.FID=Prd.FAllocStdID").append("\t\tWHERE Prd.FExpenseID='").append("ml7t5QEaEADgAAwawKgRe0olWCc=").append("' AND Prd.FCostCenterID=\"costCenterOrgUnit.id\" ").append('\n').append("\t\t\tAND Prd.FCompanyId='").append(companyId).append("' AND Prd.FCalculatePeriodId is null ").append('\n').append("\t\t\tAND Prd.FCostType = 2 ").append('\n').append("\t\t\tAND STD.FFormulaForParse like '%").append("d2T+lgEaEADgAAmCwKgRj53UGuM=").append("%'").append('\n').append("  )").append('\n');
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            rs.first();
            while (rs.getRow() > 0 && !rs.isAfterLast()) {
                ret.put(rs.getString("FMaterialId"), rs.getString("FBizDate"));
                rs.next();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e), null, null);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, (Throwable)e), null, null);
        }
        return ret;
    }
}

