/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllocFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.OtherAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Table.AllocTable;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllocFactory.Fee.DynOtherFeeData;
import com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllocFactory.Table.DynOtherAllocTable;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynOtherAllocator
extends OtherAllocator {
    private static Logger logger = Logger.getLogger((String)DynOtherAllocator.class.getName());
    protected PeriodInfo periodInfo = null;
    protected Date beginDate = null;
    protected Date endDate = null;

    public DynOtherAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
        Context ctx = (Context)this._param.get("ctx");
        String periodId = this._param.get("periodId").toString();
        try {
            this.periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectStringPK(periodId));
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw new IllegalArgumentException(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.bill.app.BILLAPPAutoGenerateResource", (String)"0_DynMatAllocator", (Locale)ctx.getLocale()));
        }
        this.beginDate = new Date(this.periodInfo.getBeginDate().getTime());
        this.endDate = new Date(this.periodInfo.getEndDate().getTime());
    }

    protected AllocTable setAllocTable(Map param) {
        return new DynOtherAllocTable(this._param);
    }

    public FeeData GetFeeDataControl() throws AllocateException {
        if (this.getFeeData() == null) {
            this.setFeeData((FeeData)new DynOtherFeeData(this._param));
        }
        return super.getFeeData();
    }

    protected void InsertDirectData(Context ctx, String companyId, String periodId, String userId) throws AllocateException {
        FeeData iFee = this.GetFeeDataControl();
        String sqlDirectFee = iFee.GetDirectFeeDataSql();
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO {0}(FID,FCompanyID,FCalculatePeriodID,FCostCenterID,").append("FSourceBillID,FSourceBillEntryID,FCostObjectID,FCostItemID,FAllocStdID,").append("FAllocStdData,FQty,FPrice,FAmount,FCreatorID,FCreateTime,FAdjustUserID,FAdjustTime,FIsDirect)").append('\n').append("SELECT newbosid(''BCAAC063'') AS FID, ''{1}'' As FCompanyID, ''{2}'' As FCalculatePeriodID,\"costCenter.id\" As FCostCenterID,").append('\n').append("\"ID\" As FSourceBillID,\"ENTRIES.ID\" As FSourceBillEntryID, \"COSTOBJECT.ID\" As FCostObjectID, \"COSTITEM.ID\" As FCostItemID, null As FAllocStdID,").append('\n').append("1 As FAllocStdData, ISNULL(\"ENTRIES.QTY\",0) As FQty,ISNULL(\"ENTRIES.PRICE\",0) As FPrice,\"ENTRIES.AMOUNT\" As FAmount, ").append('\n').append("''{3}'' As FCreatorID, GetDate() As FCreateTime, ''{4}'' as FAdjustUserID, GetDate() as FAdjustTime, 1 As FIsDirect ").append('\n').append("FROM ( {5} ) S ").append('\n');
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, userId, this.GetAdjustUserId(), sqlDirectFee);
        try {
            DbUtil.execute((Context)ctx, (String)sqlInsert);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e), null, null);
        }
    }

    protected String GetSql_InsertIndirectData(String companyId, String periodId, String userId, String allocStdId, IFeeInfo currFee) throws AllocateException {
        StringBuffer sb = new StringBuffer();
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(currFee.GetQtyPrecision());
        String strQty = fm.format(currFee.GetQty());
        fm.setMaximumFractionDigits(currFee.GetAmountPrecision());
        String strAmount = fm.format(currFee.GetAmount());
        fm.setMaximumFractionDigits(currFee.GetPricePrecision());
        String strPrice = fm.format(BigDecimal.valueOf(0L));
        if (currFee.GetQty().compareTo(BigDecimal.valueOf(0L)) != 0) {
            strPrice = fm.format(currFee.GetAmount().divide(currFee.GetQty(), currFee.GetPricePrecision(), 4));
        }
        sb.append("INSERT INTO {0}(FID,FCompanyID,FCalculatePeriodID,FCostCenterID,").append('\n').append("FSourceBillID,FSourceBillEntryID,FCostObjectID,FCostItemID,FAllocStdID,").append('\n').append("FAllocStdData,FQty,FPrice,FAmount,FCreatorID,FCreateTime,FAdjustUserID,FAdjustTime,FIsDirect)").append('\n').append("SELECT newbosid(''BCAAC063'') AS FID, ''{1}'' As FCompanyID, ''{2}'' As FCalculatePeriodID,R.FCostCenterID,").append('\n').append("''{3}'' As FSourceBillID,''{4}'' As FSourceBillEntryID, R.FCostObjectID, {5} As FCostItemID, ''{6}'' As FAllocStdID,").append('\n').append("D.FQty As FAllocStdData, ROUND({7} * D.FRatio,{8})As FQty,{9} As FPrice, ROUND({10} * D.FRatio,{11})As FAmount,").append('\n').append("''{12}'' As FCreatorID, GetDate() As FCreateTime, ''{13}'' as FAdjustUserID, GetDate() as FAdjustTime, 0 As FIsDirect ").append('\n').append("FROM {14} R ").append('\n').append("INNER JOIN {15} D ON D.FID=R.FID ").append('\n').append("WHERE R.FIsValid =1 ");
        if (this.IsOnlyNotZero_AllcoStdData()) {
            sb.append(" AND D.FRatio <>0 ");
        }
        sb.append(";");
        String costItemId = currFee.GetCostItemId();
        if (costItemId != null) {
            costItemId = "'" + costItemId + "'";
        }
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, currFee.GetId(), currFee.GetEntryId(), costItemId, this.getAllocStd().getId().toString(), strQty, String.valueOf(currFee.GetQtyPrecision()), strPrice, strAmount, String.valueOf(currFee.GetAmountPrecision()), userId, this.GetAdjustUserId(), this.getTblAllocObjectRange(), this.getTblAllocData());
        return sqlInsert;
    }

    protected String GetSql_AdjustDiff(IFeeInfo currFee) throws AllocateException {
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(currFee.GetQtyPrecision());
        String strQty = fm.format(currFee.GetQty());
        fm.setMaximumFractionDigits(currFee.GetAmountPrecision());
        String strAmount = fm.format(currFee.GetAmount());
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE {0} SET FQty=(FQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FQty),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FSourceBillID=''{3}'' AND S.FSourceBillEntryID=''{4}'')").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {5} ").append('\n').append("\tWHERE FSourceBillID=''{6}'' AND FSourceBillEntryID=''{7}'' ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustQty = MessageFormat.format(sb.toString(), this.getTblResult(), strQty, this.getTblResult(), currFee.GetId(), currFee.GetEntryId(), this.getTblResult(), currFee.GetId(), currFee.GetEntryId());
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET FAmount=(FAmount + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAmount),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FSourceBillID=''{3}'' AND S.FSourceBillEntryID=''{4}'')").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {5} ").append('\n').append("\tWHERE FSourceBillID=''{6}'' AND FSourceBillEntryID=''{7}'' ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustAmount = MessageFormat.format(sb.toString(), this.getTblResult(), strAmount, this.getTblResult(), currFee.GetId(), currFee.GetEntryId(), this.getTblResult(), currFee.GetId(), currFee.GetEntryId());
        sb.delete(0, sb.length());
        String sqlUpdatePrice = MessageFormat.format("UPDATE {0} SET FPrice=ROUND(to_decimal(FAmount,24,12)/to_decimal(FQty,24,12),{1}) WHERE FSourceBillID=''{2}'' AND FSourceBillEntryID=''{3}'' AND FQty<>0 ;", this.getTblResult(), String.valueOf(currFee.GetPricePrecision()), currFee.GetId(), currFee.GetEntryId());
        String sqlUpdatePrice_Zero = MessageFormat.format("UPDATE {0} SET FPrice=0 WHERE FSourceBillID=''{1}'' AND FSourceBillEntryID=''{2}'' AND FQty=0 ;", this.getTblResult(), currFee.GetId(), currFee.GetEntryId());
        return sqlAdjustQty + '\n' + sqlAdjustAmount + '\n' + sqlUpdatePrice + '\n' + sqlUpdatePrice_Zero;
    }

    protected void updateDefaultCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
        StringBuffer sb = new StringBuffer();
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET (FCostItemID)=(").append('\n').append("\tSELECT E.FCostItemID").append('\n').append("\tFROM T_NCM_ExpenseCompanyInfo E").append('\n').append("\tINNER JOIN T_NCM_OtherFeeBill OB ON OB.FExpenseID=E.FExpenseID").append('\n').append("\twhere OB.FID={1}.FSourceBillID AND E.FCompanyOrgUnitID=''{2}'')").append('\n').append("WHERE FCompanyID=''{3}'' AND FCalculatePeriodID=''{4}'' AND {5}.FCostItemID IS NULL");
        String sqlUpdateCostItem_Expense = MessageFormat.format(sb.toString(), this.getTblResult(), this.getTblResult(), companyId, companyId, periodId, this.getTblResult());
        try {
            DbUtil.execute((Context)ctx, (String)sqlUpdateCostItem_Expense);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e), null, null);
        }
    }

    protected void removeNoCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
        StringBuffer sb = new StringBuffer();
        sb.delete(0, sb.length());
        sb.append("SELECT DISTINCT MB.FNumber, ME.FSeq ").append("FROM {0} D ").append("INNER JOIN T_NCM_OtherFeeBillEntry ME ON ME.FID=D.FSourceBillEntryID ").append("INNER JOIN T_NCM_OtherFeeBill MB ON MB.FID=D.FSourceBillID ").append("WHERE D.FCompanyID=''{1}'' AND D.FCalculatePeriodID=''{2}'' AND D.FCostItemID IS NULL");
        String sqlNoCostItem = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId);
        sb.delete(0, sb.length());
        sb.append("DELETE {0} ").append("WHERE FCompanyID=''{1}'' AND FCalculatePeriodID=''{2}'' AND FCostItemID IS NULL");
        String sqlDeleteNoCostItem = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlNoCostItem);
            rs.first();
            if (rs.getRow() > 0) {
                DbUtil.execute((Context)ctx, (String)sqlDeleteNoCostItem);
            }
            rs.first();
            while (rs.getRow() > 0 && !rs.isAfterLast()) {
                String number = rs.getString("FNumber");
                String seq = String.valueOf(rs.getInt("FSeq"));
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NODEFAULT_COSTITEM_OTHER, new Object[]{number, seq}), null, null);
                rs.next();
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e), null, null);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, (Throwable)e), null, null);
        }
    }

    protected void removeInvalidCostObject(Context ctx, String companyId, String periodId) throws AllocateException {
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        Boolean isAssistant = (Boolean)this._param.get("isAssistant");
        int compareObject = isAssistant != null && isAssistant != false ? 1 : 0;
        StringBuffer sb = new StringBuffer();
        sb.delete(0, sb.length());
        sb.append("SELECT DISTINCT MB.FNumber, ME.FSeq, CO.FName_L2 As FCostObjectName ").append('\n').append("FROM {0} D ").append('\n').append("INNER JOIN T_NCM_OtherFeeBillEntry ME ON ME.FID=D.FSourceBillEntryID ").append('\n').append("INNER JOIN T_NCM_OtherFeeBill MB ON MB.FID=D.FSourceBillID ").append('\n').append("INNER JOIN t_bd_CostObject CO ON CO.FID=D.FCostObjectID ").append('\n').append("INNER JOIN T_ORG_CostCenter CC ON MB.FCostCenterID=CC.FID ").append('\n').append("WHERE D.FCompanyID=''{1}'' AND D.FCalculatePeriodID=''{2}'' ").append('\n').append("  AND CC.FCostCenterType=").append(compareObject).append('\n').append("  AND NOT exists(").append('\n').append("\tSELECT FCostObjectID").append('\n').append("\tFROM {3} S ").append('\n').append("\tWhere S.Fcostcenterid=D.Fcostcenterid and S.FCostObjectID=D.Fcostobjectid ").append('\n').append(")");
        String sqlInvalidCostObject = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, tblObjRange);
        sb.delete(0, sb.length());
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlInvalidCostObject);
            rs.first();
            if (rs.getRow() > 0) {
                sb.append("DELETE {0} ").append("WHERE FCompanyID=''{1}'' AND FCalculatePeriodID=''{2}'' AND NOT exists (").append('\n').append("\tSELECT FCostObjectID").append('\n').append("\tFROM {3} S ").append('\n').append("\tWhere S.Fcostcenterid={4}.Fcostcenterid and S.FCostObjectID={5}.Fcostobjectid ").append('\n').append(")");
                String sqlDeleteInvalid = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, tblObjRange, this.getTblResult(), this.getTblResult());
                DbUtil.execute((Context)ctx, (String)sqlDeleteInvalid);
                NumericExceptionSubItem except = null;
                except = isAssistant != null && isAssistant != false ? AllocateException.ITEM_ALLOC_INVALID_AUSCOSTOBJ : AllocateException.ITEM_ALLOC_INVALID_DYNCOSTOBJ;
                rs.first();
                while (rs.getRow() > 0 && !rs.isAfterLast()) {
                    String number = rs.getString("FNumber");
                    String seq = String.valueOf(rs.getInt("FSeq"));
                    String costObjName = rs.getString("FCostObjectName");
                    this.processAllocateException(new AllocateException(except, new Object[]{number, seq, costObjName}), null, null);
                    rs.next();
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e), null, null);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, (Throwable)e), null, null);
        }
    }

    public CostTaskResultEnum preCheck() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        boolean hasValidCostObject = false;
        try {
            hasValidCostObject = this.checkHasValidCostObject(ctx, companyId, periodId);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, (Throwable)e);
        }
        if (!hasValidCostObject) {
            AllocateException e = new AllocateException(AllocateException.ITEM_ALLOC_NO_INPUT_DYNWIP);
            this.processAllocateException(e, null, null);
            return CostTaskResultEnum.FAILURE;
        }
        return CostTaskResultEnum.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillDirectObjectRange() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        Connection conn = null;
        try {
            String tblObjRange = this.getAllocTable().GetObjectRangeTable();
            StringBuffer kSql = new StringBuffer();
            kSql.append("insert into ").append(tblObjRange).append('\n');
            kSql.append("(FID,FCostCenterID,FCostObjectID,FCostItemID,FIsValid)").append('\n');
            kSql.append("select NEWBOSID('08F65F4A') as FID, FCostCenterID, FCostObjectID, NULL as FCostItemID, 1 AS FIsValid ").append('\n');
            kSql.append("  from (select distinct recBillEntry.FCostCenterOrgUnitID as FCostCenterID, CO.FID as FCostObjectID").append('\n');
            kSql.append("\t\t   from T_IM_ManufactureRecBill as recBill ").append('\n');
            kSql.append("\t      inner join T_SCM_TransactionType as transType  ").append('\n');
            kSql.append("            on recBill.FTransactionTypeID = transType.FID and transType.FIsManuCostCalculate = 1").append('\n');
            kSql.append("\t       left outer join T_IM_ManufactureRecBillEntry as recBillEntry ").append('\n');
            kSql.append("            on recBill.FID =  recBillEntry.FParentID").append('\n');
            kSql.append("\t\t   left outer join T_BD_CostObjectEntry as COEntry ").append('\n');
            kSql.append("\t\t\t on COEntry.FRelatedID = recBillEntry.FMaterialID ").append('\n');
            kSql.append("\t\t   left outer join T_BD_CostObject as CO ").append('\n');
            kSql.append("\t\t\t on CO.FID = COEntry.FParentID and CO.FCompanyID = recBillEntry.FCompanyOrgUnitID ").append('\n');
            kSql.append("  \t\t  inner join t_org_costcenter as cc ").append('\n');
            kSql.append("\t\t\t on cc.fid = recBillEntry.FCostCenterOrgUnitID and cc.FCostCenterType = 0 ").append('\n');
            kSql.append("\t      where CO.FRelatedType = 0  and CO.FIsForbiden=0 ").append('\n');
            kSql.append("\t\t    and ((CO.FCalculateMode=4 and Isnull(recBillEntry.FLot,'''') = Isnull(CO.FBatchNumber,''''))").append('\n');
            kSql.append("\t\t\t\t or CO.FCalculateMode <> 4)").append('\n');
            kSql.append("           and recBill.FBASESTATUS = 4  ").append('\n');
            kSql.append("           and recBillEntry.FCompanyOrgUnitID = ?  ").append('\n');
            kSql.append("           and recBill.FBizDate >= ? ").append('\n');
            kSql.append("           and recBill.FBizDate <= ? ").append('\n');
            kSql.append("          ) as A").append('\n');
            DbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{companyId, this.beginDate, this.endDate});
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblObjRange);
            SQLUtils.cleanup((Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e), null, null);
        }
        finally {
            SQLUtils.cleanup(conn);
        }
    }

    private boolean checkHasValidCostObject(Context ctx, String companyId, String periodId) throws BOSException, SQLException, EASBizException {
        IRowSet rst;
        block4: {
            boolean bl;
            StringBuffer kSql = new StringBuffer();
            kSql.append(" select sum(recBillEntry.FBaseQty) ").append('\n');
            kSql.append("\tfrom T_IM_ManufactureRecBill as recBill ").append('\n');
            kSql.append("\t\t inner join T_SCM_TransactionType as transType  ").append('\n');
            kSql.append(" \t   \t\ton recBill.FTransactionTypeID = transType.FID ").append('\n');
            kSql.append("      \t\t\tand transType.FIsManuCostCalculate = 1").append('\n');
            kSql.append("\t\t left outer join T_IM_ManufactureRecBillEntry as recBillEntry ").append('\n');
            kSql.append(" \t\t\ton recBill.FID =  recBillEntry.FParentID").append('\n');
            kSql.append("\t\t left outer join T_BD_CostObjectEntry as COEntry ").append('\n');
            kSql.append("\t\t\ton COEntry.FRelatedID = recBillEntry.FMaterialID ").append('\n');
            kSql.append("\t\t left outer join T_BD_CostObject as CO ").append('\n');
            kSql.append("\t\t\ton CO.FID = COEntry.FParentID ").append('\n');
            kSql.append("\t\t\t  and CO.FCompanyID = recBillEntry.FCompanyOrgUnitID ").append('\n');
            kSql.append("  \t\t inner join t_org_costcenter cc on cc.fid = recBillEntry.FCostCenterOrgUnitID").append('\n');
            kSql.append("  \t\t\t\t\t       and cc.FCostCenterType = 0 ").append('\n');
            kSql.append("  where CO.FRelatedType = 0 and CO.FIsForbiden=0 ").append('\n');
            kSql.append("\t and ((CO.FCalculateMode=4 and Isnull(recBillEntry.FLot,'''') = Isnull(CO.FBatchNumber,''''))").append('\n');
            kSql.append("\t\t\t\tor CO.FCalculateMode <> 4)").append('\n');
            kSql.append("    and recBill.FBASESTATUS = 4  ").append('\n');
            kSql.append("    and recBillEntry.FCompanyOrgUnitID = ?  ").append('\n');
            kSql.append("    and recBill.FBizDate >= ? ").append('\n');
            kSql.append("    and recBill.FBizDate <= ? ").append('\n');
            kSql.append("  group by recBillEntry.FCompanyOrgUnitID,CO.FID ").append('\n');
            kSql.append("       having sum(recBillEntry.FBaseQty) <> 0 ").append('\n');
            rst = null;
            try {
                rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{companyId, this.beginDate, this.endDate});
                if (!rst.next()) break block4;
                bl = true;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return false;
    }

    protected boolean IsOnlyNotZero_AllcoStdData() {
        return true;
    }

    public AllocStdInfo GetAllocStdSetting(IFeeInfo currFee) throws AllocateException {
        return null;
    }
}

