/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllocFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.ncm.AllocStdFactory;
import com.kingdee.eas.basedata.ncm.AllocStdInfo;
import com.kingdee.eas.basedata.ncm.IAllocStd;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.bill.app.Alloc.AllcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.FeeData;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.IFeeInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.WizMatAllocator;
import com.kingdee.eas.ncm.bill.app.Alloc.helper.AllocateExceptionLog;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.dynamic.bill.app.Alloc.AllocFactory.DynMatAllocator;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynWizMatAllocator
extends DynMatAllocator {
    private static Logger logger = Logger.getLogger((String)WizMatAllocator.class.getName());
    private AllocateExceptionLog _logger;

    public DynWizMatAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
        Assert.that((boolean)param.containsKey("logger"));
        this._logger = (AllocateExceptionLog)param.get("logger");
    }

    public AllocStdInfo GetAllocStdSetting(IFeeInfo currFee) {
        Context ctx = (Context)this._param.get("ctx");
        String allocStdID = this._param.get("allocStdID").toString();
        try {
            IAllocStd iAllocStd = AllocStdFactory.getLocalInstance((Context)ctx);
            AllocStdInfo allocStd = iAllocStd.getAllocStdInfo((IObjectPK)new ObjectUuidPK(allocStdID));
            return allocStd;
        }
        catch (Exception e) {
            this._logger.AddLog(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e));
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public void processAllocateException(AllocateException e, String possibleReason, String adviceHandle) throws AllocateException {
        if (possibleReason == null || adviceHandle == null) {
            this._logger.AddLog(e);
        } else {
            this._logger.AddLog(e, possibleReason, adviceHandle);
        }
    }

    protected void updateDefaultCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
        if (this._param.containsKey("costItemID") && this._param.get("costItemID") != null) {
            String costItemID = this._param.get("costItemID").toString();
            FeeData iFee = this.GetFeeDataControl();
            String sqlDirectFee = iFee.GetDirectFeeDataSql();
            sqlDirectFee = sqlDirectFee.replaceAll("\"ENTRY\".FCostObjectID IS NOT NULL", " 1=1 ");
            sqlDirectFee = sqlDirectFee.replaceAll("\"COSTOBJECT\".FNumber <> 'SCOID'", " 1=1 ");
            StringBuffer kSql = new StringBuffer();
            kSql.append(" update {0} set FCostItemID = ''{1}''");
            kSql.append(" where FCompanyID=''{2}'' AND FCalculatePeriodID=''{3}'' AND FSourceBillEntryID in( ");
            kSql.append("              select \"ENTRY.ID\" from ( {4} ) S)");
            String _kSql = MessageFormat.format(kSql.toString(), this.getTblResult(), costItemID, companyId, periodId, sqlDirectFee);
            try {
                DbUtil.execute((Context)ctx, (String)_kSql);
            }
            catch (BOSException ex) {
                logger.error((Object)"", (Throwable)ex);
            }
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET (FCostItemID)=(").append("\tSELECT MC.FDefaultCostItemID").append("\tFROM T_BD_MaterialCost MC").append("\tINNER JOIN T_IM_MaterialReqBillEntry BE ON BE.FMaterialID=MC.FMaterialID").append("\tWHERE MC.FStatus=1 AND BE.FID={1}.FSourceBillEntryID AND MC.FOrgUnit={2}.FCompanyID").append(")").append("WHERE FCompanyID=''{3}'' AND FCalculatePeriodID=''{4}'' AND {5}.FCostItemID IS NULL ;");
        String sqlUpdateCostItem_Material = MessageFormat.format(sb.toString(), this.getTblResult(), this.getTblResult(), this.getTblResult(), companyId, periodId, this.getTblResult());
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET (FCostItemID)=(").append("\tSELECT E.FCostItemID").append("\tFROM T_NCM_ExpenseCompanyInfo E").append("\twhere E.FExpenseID=''{1}'' AND E.FCompanyOrgUnitID=''{2}'')").append("WHERE FCompanyID=''{3}'' AND FCalculatePeriodID=''{4}'' AND {5}.FCostItemID IS NULL ;");
        String sqlUpdateCostItem_Expense = MessageFormat.format(sb.toString(), this.getTblResult(), "ml7t5QEaEADgAAwawKgRe0olWCc=", companyId, companyId, periodId, this.getTblResult());
        try {
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)(sqlUpdateCostItem_Material + '\n' + sqlUpdateCostItem_Expense), (String)";");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, (Throwable)e), null, null);
        }
    }

    public void allocDirect() {
        try {
            super.allocDirect();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)e);
        }
    }

    public void allocIndirect(IFeeInfo currFee, int position) {
        try {
            super.allocIndirect(currFee, position);
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)e);
        }
    }

    public Map processResult() {
        HashMap<String, String> ret = null;
        try {
            ret = super.processResult();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)e);
        }
        if (ret == null) {
            ret = new HashMap<String, String>();
            if (this._logger.getLogCount() > 0) {
                IRowSet logData = this._logger.GetLogData();
                ret.put("HasError", String.valueOf(true));
                ret.put("logData", (String)logData);
            }
        }
        return ret;
    }

    public void endProcess() {
        try {
            super.endProcess();
        }
        catch (AllocateException e) {
            this._logger.AddLog(e);
            logger.error((Object)"", (Throwable)e);
        }
    }
}

