/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.app.Calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocateException;
import com.kingdee.eas.ncm.cal.app.Calc.CalcDispatch;
import com.kingdee.eas.ncm.cal.report.NCMReportHelper;
import com.kingdee.eas.ncm.cal.utils.CalculateUtil;
import com.kingdee.eas.ncm.cal.utils.app.CalSeverUtils;
import com.kingdee.eas.ncm.common.task.CostTaskResultEnum;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.dynamic.bill.app.SecondAlloc.DynSecAllocDispatch;
import com.kingdee.eas.ncm.dynamic.cal.DynCalcLogCollection;
import com.kingdee.eas.ncm.dynamic.cal.app.Calc.AllocWIP.DynAllocWIP;
import com.kingdee.eas.ncm.dynamic.cal.app.Calc.Helper.DynCalcExceptionLog;
import com.kingdee.eas.ncm.dynamic.common.app.DynCalcTable;
import com.kingdee.eas.ncm.dynamic.common.app.DynCostServerUtil;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.ICalculateFacade;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynCalcDispatch
extends CalcDispatch {
    private static Logger logger = Logger.getLogger((String)DynCalcDispatch.class.getName());
    protected PeriodInfo curBizPeriod = null;
    protected com.kingdee.eas.basedata.assistant.PeriodInfo curFiPeriod = null;
    protected DynCalcExceptionLog _log = null;

    public DynCalcDispatch(Map param) throws BOSException {
        super(param);
        this._calcTable = new DynCalcTable(this._param);
        this._param.put("calcTable", this._calcTable);
        this._log = new DynCalcExceptionLog(this._param);
        this._param.put("log", this._log);
        this.initPeriod();
    }

    private void initPeriod() throws BOSException {
        try {
            this.curBizPeriod = PeriodFactory.getLocalInstance((Context)this._ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(this._periodId));
            this.curFiPeriod = DynCostServerUtil.getFiPeriod(this._ctx, this.curBizPeriod);
        }
        catch (Exception exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap doCalc(Context ctx) throws BOSException, EASBizException {
        CostTaskResultEnum result = CostTaskResultEnum.SUCCESS;
        HashMap<String, Object> ret = new HashMap<String, Object>();
        int dispRank = 0;
        try {
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"10_DynCalcDispatch", (Locale)ctx.getLocale()));
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"11_DynCalcDispatch", (Locale)ctx.getLocale()));
            this.clearPreCalcResult();
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"12_DynCalcDispatch", (Locale)ctx.getLocale()));
            this.getProcessData();
            int companyBaseCurrencyPrec = super.getCompanyBaseCurrencyPerc(this._ctx, this._companyId);
            int lowest = CalSeverUtils.getDynLowestRank((Context)this._ctx, (String)this._companyId, (String)this._periodId);
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"13_DynCalcDispatch", (Locale)ctx.getLocale()) + lowest));
            DynAllocWIP alloc = new DynAllocWIP(this._param);
            for (int rank = lowest; rank >= 0; --rank) {
                this._log.AddCalcLog_PreSet(rank, ++dispRank);
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"14_DynCalcDispatch", (Locale)ctx.getLocale()));
                alloc.setCalcRank(rank);
                CostTaskResultEnum allocResult = alloc.DoAllocWIP(ctx);
                if (allocResult.getValue() > result.getValue()) {
                    result = allocResult;
                }
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"15_DynCalcDispatch", (Locale)ctx.getLocale()));
                this.calcIn(rank, dispRank, this.curFiPeriod.getPeriodYear(), this.curFiPeriod.getPeriodNumber(), companyBaseCurrencyPrec);
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"16_DynCalcDispatch", (Locale)ctx.getLocale()));
                this.calcOut(rank, dispRank);
                logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"17_DynCalcDispatch", (Locale)ctx.getLocale()));
                this.secAlloc(rank, dispRank);
            }
            this.calManufRecBillTotalActualCost();
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"18_DynCalcDispatch", (Locale)ctx.getLocale()));
            this._calcTable.releaseTempTable();
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"19_DynCalcDispatch", (Locale)ctx.getLocale()));
            this.backUpCalcResult();
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"20_DynCalcDispatch", (Locale)ctx.getLocale()));
            DynCostServerUtil.closePeriod(this._ctx, this.curBizPeriod.getId().toString(), this._companyId);
            DynCalcLogCollection logData = this._log.GetDynCalcLogData();
            ret.put("logData", (Object)logData);
            throw throwable;
        }
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"18_DynCalcDispatch", (Locale)ctx.getLocale()));
        this._calcTable.releaseTempTable();
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"19_DynCalcDispatch", (Locale)ctx.getLocale()));
        this.backUpCalcResult();
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"20_DynCalcDispatch", (Locale)ctx.getLocale()));
        DynCostServerUtil.closePeriod(this._ctx, this.curBizPeriod.getId().toString(), this._companyId);
        DynCalcLogCollection logData = this._log.GetDynCalcLogData();
        ret.put("logData", (Object)logData);
        ret.put("HasError", String.valueOf(result.getValue() >= 7));
        logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.app.CALAPPAutoGenerateResource", (String)"21_DynCalcDispatch", (Locale)ctx.getLocale()));
        return ret;
    }

    private void clearPreCalcResult() throws BOSException {
        try {
            NCMDynamicTableManager.DeleteTable((Context)this._ctx, (String)this._calcTable.GetCostCalResultTable(), null);
            NCMDynamicTableManager.DeleteTable((Context)this._ctx, (String)this._calcTable.GetCostCalMatDetailResultTable(), null);
            NCMDynamicTableManager.DeleteTable((Context)this._ctx, (String)this._calcTable.GetCostCalPrdDetailResultTable(), null);
            NCMDynamicTableManager.DeleteTable((Context)this._ctx, (String)this._calcTable.GetDataByCostObjTable(), null);
            NCMDynamicTableManager.DeleteTable((Context)this._ctx, (String)this._calcTable.GetDataByProductTable(), null);
            CalSeverUtils.DynClearInvalidAllocResult((Context)this._ctx, (String)this._companyId, (String)this._periodId);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void backUpCalcResult() throws BOSException {
        try {
            this.backUp(this._calcTable.GetCostCalResultTable(), NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_DynCostCalResult_History"), "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FFinishedAmount ,FEoPWIPAmount ,FRecvAmount ,FFinishedQty , FEoPWIPQty ,FCalcLevel,FFinishedAssistQty,FFinishedAddqty,FEoPWIPAssistQty,FEoPWIPAddqty ");
            this.backUp(this._calcTable.GetCostCalMatDetailResultTable(), NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_DynCostCalMatDetailResult_History"), "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FCostItemID ,FMaterialID ,FLot ,FAllocStdID ,FAllocStdData ,FFinishedQty ,FEoPWIPQty ,FFinishedAmount ,FEoPWIPAmount ,FCalcLevel,FFinishedAssistQty,FFinishedAddqty,FEoPWIPAssistQty,FEoPWIPAddqty,FIsReWork   ");
            this.backUp(this._calcTable.GetCostCalPrdDetailResultTable(), NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_DynCostCalPrdDetailResult_History"), "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FProductID ,FLot ,FCostItemID ,FAllocStdID ,FAllocStdData ,FFinishedQty ,FFinishedAmount ,FFinishedPrice ,FRecvAmount ,FTotalFinishedQty ,FVoucherid ,FCalcLevel, FTempAmount ");
            this.backUp(this._calcTable.GetDataByCostObjTable(), NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_DynDataByCostObj_History"), "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FFinishedQty , FFinishedAssistQty , FFinishedAddQty");
            this.backUp(this._calcTable.GetDataByProductTable(), NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_DynDataByProduct_History"), "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FCostObjectID ,FProductID ,FLot ,FFinishedQty , FFinishedAssistQty , FFinishedAddQty");
            if (!"true".equals(this._ctx.get((Object)"materialFeeBillCopyToHis"))) {
                this.backUp(NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_DynMatAllocResult"), NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_DynMatAllocResult_History"), "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FCommonQty ,FAssistQty ,FBaseUnitID ,FCommonUnitID ,FAssistUnitID ,FPrice ,FAmount ,FMaterialID ,FLot ,FBizDate ,FSeq ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect, AllocBillType , FIsRework, FAdminOrgUnitID , FWarehouseID");
            }
            if (!"true".equals(this._ctx.get((Object)"otherFeeBillCopyToHis"))) {
                this.backUp(NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_DynOtherAllocResult"), NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_DynOtherAllocResult_History"), "FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FDepartmentID , FSourceCostCenterID,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FPrice ,FAmount ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect ");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void backUp(String calTblName, String historyTblName, String colunms) throws BOSException {
        DbUtil.execute((Context)this._ctx, (String)("delete from " + historyTblName + " where FCalculatePeriodID = ? "), (Object[])new Object[]{this._periodId});
        DbUtil.execute((Context)this._ctx, (String)("insert into " + historyTblName + "(" + colunms + ") select " + colunms + " from " + calTblName + " where FCalculatePeriodID = ? "), (Object[])new Object[]{this._periodId});
    }

    protected void calcIn(int rank, int dispRank, int periodYear, int periodNumber, int companyBaseCurrencyPrec) throws BOSException {
        boolean isSuccess = false;
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE calcInTemp ");
        createTableSql.append("\t(");
        createTableSql.append("FID   \t\t\tVARCHAR(44),\t");
        createTableSql.append("FUnitActualCost \tNUMERIC(21,8),\t");
        createTableSql.append("FBaseQty\t\t\tNUMERIC(21,8),\t");
        createTableSql.append("FUnitId \t\t\tVARCHAR(44),\t");
        createTableSql.append("FBaseUnitId \t\tVARCHAR(44),\t");
        createTableSql.append("FMaterialID \t\tVARCHAR(44),\t");
        createTableSql.append("FIsAdjust\t\tINT DEFAULT 0\t");
        createTableSql.append(")");
        String tblName = null;
        try {
            tblName = TempTablePool.getInstance((Context)this._ctx).createTempTable(createTableSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tblName).append("(FId, FUnitActualCost) (").append('\n').append("\tSELECT entry.fid, ");
        NCMReportHelper.AppendCaseSQLClause((StringBuffer)sql, (String)"ISNULL(SUM(S.FFinishedAmount),0)", (String)"ISNULL(MAX(S.FTotalFinishedQty),1)", (String)"ISNULL(SUM(S.FFinishedAmount),0)", (String)"FUnitActualCost", (String)"MAX(mt.FPricePrecision)");
        sql.append("       FROM ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" S ").append('\n').append("           INNER JOIN T_IM_ManufactureRecBillEntry entry ON entry.FCostCenterOrgunitId = s.FCostCenterId ").append('\n').append("               AND s.FCompanyId = entry.FCompanyOrgunitId").append('\n').append("               AND s.FProductId = entry.FMaterialId").append('\n').append("\t\t\tINNER JOIN T_IM_ManufactureRecBill bill ON entry.FParentId = bill.FId ").append('\n').append("           INNER JOIN T_SCM_TransactionType trans ON bill.FTransactionTypeId = trans.FId AND trans.FIsManuCostCalculate = 1").append('\n').append("           LEFT JOIN T_BD_Material mt ON mt.FId = entry.FMaterialId").append('\n').append("\t\t\tLEFT JOIN T_BD_CostObject OBJ on s.FCostObjectID = OBJ.FId").append('\n').append("\t\tWHERE bill.FBaseStatus = 4").append('\n').append("           AND s.FCompanyId = '").append(this._companyId).append("'").append('\n').append("           AND s.FCalculatePeriodId = '").append(this._periodId).append("' ").append('\n').append("\t\t \tAND S.FCalcLevel=").append(rank).append('\n').append("\t\t \tAND entry.FId IS NOT NULL ").append('\n').append("\t\t\tAND ((OBJ.FCalculateMode=4 AND Isnull(ENTRY.FLot,' ') = Isnull(OBJ.FBatchNumber,' '))").append('\n').append("\t\t\t\tOR OBJ.FCalculateMode <> 4)").append('\n').append("              and bill.FBizDate >= TO_DATE('" + dateFormate.format(this.curBizPeriod.getBeginDate()) + "') ").append('\n').append("              and bill.FBizDate <= TO_DATE('" + dateFormate.format(this.curBizPeriod.getEndDate()) + "') ").append('\n').append("\t\tGROUP BY entry.FId);");
        NCMServerUtils.BatchSqlExecute((Context)this._ctx, (String)sql.toString(), (String)";");
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this._ctx);
            TempTablePool.getInstance((Context)this._ctx).analyzeTable(conn, tblName);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        sql.setLength(0);
        sql.append("UPDATE T_IM_ManufactureRecBillEntry ").append("\tSET FUnitActualCost =(").append(" \t\t\tSELECT temp.FUnitActualCost").append('\n').append("\t\t\t\tFROM ").append(tblName).append(" temp ").append('\n').append("\t\t\t\tWHERE T_IM_ManufactureRecBillEntry.FId = temp.FId)").append('\n').append("\tWHERE FID IN (SELECT FID FROM ").append(tblName).append(");");
        NCMServerUtils.BatchSqlExecute((Context)this._ctx, (String)sql.toString(), (String)";");
        sql.setLength(0);
        sql.append("UPDATE T_IM_ManufactureRecBillEntry ").append("\tSET FActualCost=(").append('\n').append(" \t\t\tSELECT ROUND(ISNULL(temp.FUnitActualCost * T_IM_ManufactureRecBillEntry.FBaseQty, 0),").append("\t\t\t\t\tISNULL(").append(companyBaseCurrencyPrec).append(", 8)) ").append('\n').append("\t\t\t\tFROM ").append(tblName).append(" temp ").append('\n').append("\t\t\t\tWHERE T_IM_ManufactureRecBillEntry.FId = temp.FId)").append('\n').append("\tWHERE FID IN (SELECT FID FROM ").append(tblName).append(" )");
        NCMServerUtils.BatchSqlExecute((Context)this._ctx, (String)sql.toString(), (String)";");
        this.adjustDiff_CalcIn(rank, dispRank, periodYear, periodNumber);
        sql.setLength(0);
        sql.append("INSERT INTO ").append(tblName).append(" (FId, FUnitActualCost, FIsAdjust ) ").append('\n').append("\t(SELECT entry.FID, ").append("\t\t\tRound(TO_DECIMAL(ISNULL(entry.FActualCost, 0), 24, 12) / TO_DECIMAL(ISNULL(entry.FQty, 1), 24, 12), MT.FPricePrecision) FUnitActualCost, ").append('\n').append(" \t\t\t1 FIsAdjust").append("\t\tFROM ").append(tblName).append(" temp ").append('\n').append("\t\t\tJOIN T_IM_ManufactureRecBillEntry entry ON entry.FId = temp.FId").append('\n').append("\t\t\tLEFT JOIN T_BD_Material mt ON mt.FId = entry.FMaterialId ").append('\n').append("\t\tWHERE entry.FUnitId <> entry.FBaseUnitId );").append('\n');
        NCMServerUtils.BatchSqlExecute((Context)this._ctx, (String)sql.toString(), (String)";");
        sql.setLength(0);
        sql.append("UPDATE T_IM_ManufactureRecBillEntry ").append("\tSET FUnitActualCost =(").append(" \t\t\tSELECT temp.FUnitActualCost").append('\n').append("\t\t\t\tFROM ").append(tblName).append(" temp ").append('\n').append("\t\t\t\tWHERE T_IM_ManufactureRecBillEntry.FId = temp.FId ").append("\t\t\t\t\tAND temp.FIsAdjust = 1)").append('\n').append("\tWHERE FID IN (SELECT FID FROM ").append(tblName).append(" WHERE FIsAdjust = 1);");
        NCMServerUtils.BatchSqlExecute((Context)this._ctx, (String)sql.toString(), (String)";");
        TempTablePool.getInstance((Context)this._ctx).releaseTable(tblName);
        isSuccess = true;
        String status = null;
        status = isSuccess ? CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_Sucess") : CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_Fail");
        this._log.AddCalcLog(dispRank, "", CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_CalcIn"), status, "", false, "CalcIn", 2);
    }

    private void adjustDiff_CalcIn(int rank, int dispRank, int periodYear, int periodNumber) throws BOSException {
        StringBuffer sb;
        SimpleDateFormat dateFormate;
        PreparedStatement pstmt;
        Connection conn;
        IRowSet rs;
        block6: {
            rs = null;
            conn = null;
            pstmt = null;
            dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sb = new StringBuffer();
            sb.append("Select D.FCostCenterID, D.FMaterialID, D.FLot, (S.FSrcSumAmount - D.FDestSumAmount )As FAmountDiff ").append('\n').append("FROM (").append('\n').append("\tSELECT entry.FCOSTCENTERORGUNITID as FCostCenterID, entry.FMaterialID,  ").append('\n').append("\tCASE WHEN  OBJ.FCalculateMode <> 4 then N' ' ELSE ISNULL(entry.FLot,N' ') END As FLot, SUM(entry.FActualCost) As FDestSumAmount ").append('\n').append("\tFROM T_IM_ManufactureRecBill bill ").append('\n').append("\tINNER JOIN T_SCM_TransactionType AS TRANS ON bill.FTransactionTypeID = TRANS.FID AND TRANS.FIsManuCostCalculate=1 ").append('\n').append("\tLEFT JOIN T_IM_ManufactureRecBillEntry entry ON entry.FParentid=bill.FID ").append('\n').append("\tLEFT OUTER JOIN T_BD_CostObject AS OBJ ON (OBJ.FStdProductIDID=entry.FMaterialID AND OBJ.FCompanyID=entry.FCompanyorgUnitID) ").append('\n').append("\tWHERE bill.FBaseStatus=4  ").append('\n').append("   and bill.FBizDate >= TO_DATE('" + dateFormate.format(this.curBizPeriod.getBeginDate()) + "') ").append('\n').append("       and bill.FBizDate <= TO_DATE('" + dateFormate.format(this.curBizPeriod.getEndDate()) + "') ").append('\n').append("\t\tAND entry.FCompanyorgUnitID='").append(this._companyId).append("' ").append('\n').append("\t\tAND ((OBJ.FCalculateMode=4 AND Isnull(ENTRY.FLot,' ') = Isnull(OBJ.FBatchNumber,' '))").append('\n').append("\t\t\t\tOR OBJ.FCalculateMode <> 4)").append('\n').append("\tGROUP BY entry.FCOSTCENTERORGUNITID, entry.FMaterialID, CASE WHEN  OBJ.FCalculateMode <> 4 then N' ' ELSE ISNULL(entry.FLot,N' ') END").append('\n').append(")D ").append('\n').append("LEFT JOIN (").append('\n').append("\tSELECT FCostCenterID,FProductID,ISNULL(FLot,' ')As FLot, SUM(FFinishedAmount)As FSrcSumAmount ").append('\n').append("\tFROM ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append('\n').append("\tWHERE FCompanyID='").append(this._companyId).append("' AND FCalculatePeriodID='").append(this._periodId).append("' AND FCalcLevel=").append(rank).append('\n').append("\tGROUP BY FCostCenterID,FProductID,FLot ").append('\n').append(")S ON D.FCostCenterID=S.FCostCenterid AND D.FMaterialID=S.FProductID AND S.FLot = D.FLot").append('\n').append("where  D.FDestSumAmount<>S.FSrcSumAmount").append('\n');
            rs = DbUtil.executeQuery((Context)this._ctx, (String)sb.toString());
            if (rs.size() != 0) break block6;
            SQLUtils.cleanup((ResultSet)rs, pstmt, conn);
            return;
        }
        try {
            sb.delete(0, sb.length());
            String sql = "UPDATE T_IM_ManufactureRecBillEntry SET FActualCost=(FActualCost+?) \n    WHERE FID =(\n\tSelect top 1 entry.FID \n\tFROM T_IM_ManufactureRecBill bill \n\tINNER JOIN T_SCM_TransactionType AS TRANS ON bill.FTransactionTypeID = TRANS.FID AND TRANS.FIsManuCostCalculate=1 \n\tLEFT JOIN T_IM_ManufactureRecBillEntry entry ON entry.FParentid=bill.FID \n\tLEFT JOIN T_BD_CostObject AS OBJ ON (OBJ.FStdProductIDID=entry.FMaterialID AND OBJ.FCompanyID=entry.FCompanyorgUnitID) \n\tWHERE entry.FCOSTCENTERORGUNITID=? AND entry.FMaterialID=? AND CASE WHEN  OBJ.FCalculateMode <> 4 then N' ' ELSE ISNULL(entry.FLot,N' ') END=? \n\t\tAND bill.FBaseStatus=4 \n    and bill.FBizDate >= TO_DATE(?) \n       and bill.FBizDate <= TO_DATE(?) \n\t\tAND entry.FCompanyorgUnitID= ? \n\tORDER BY entry.FActualCost DESC \n)";
            conn = EJBFactory.getConnection((Context)this._ctx);
            pstmt = conn.prepareStatement("UPDATE T_IM_ManufactureRecBillEntry SET FActualCost=(FActualCost+?) \n    WHERE FID =(\n\tSelect top 1 entry.FID \n\tFROM T_IM_ManufactureRecBill bill \n\tINNER JOIN T_SCM_TransactionType AS TRANS ON bill.FTransactionTypeID = TRANS.FID AND TRANS.FIsManuCostCalculate=1 \n\tLEFT JOIN T_IM_ManufactureRecBillEntry entry ON entry.FParentid=bill.FID \n\tLEFT JOIN T_BD_CostObject AS OBJ ON (OBJ.FStdProductIDID=entry.FMaterialID AND OBJ.FCompanyID=entry.FCompanyorgUnitID) \n\tWHERE entry.FCOSTCENTERORGUNITID=? AND entry.FMaterialID=? AND CASE WHEN  OBJ.FCalculateMode <> 4 then N' ' ELSE ISNULL(entry.FLot,N' ') END=? \n\t\tAND bill.FBaseStatus=4 \n    and bill.FBizDate >= TO_DATE(?) \n       and bill.FBizDate <= TO_DATE(?) \n\t\tAND entry.FCompanyorgUnitID= ? \n\tORDER BY entry.FActualCost DESC \n)");
            while (rs.next()) {
                pstmt.setDouble(1, rs.getDouble("FAmountDiff"));
                pstmt.setString(2, rs.getString("FCostCenterID"));
                pstmt.setString(3, rs.getString("FMaterialID"));
                pstmt.setString(4, rs.getString("FLot"));
                pstmt.setString(5, dateFormate.format(this.curBizPeriod.getBeginDate()));
                pstmt.setString(6, dateFormate.format(this.curBizPeriod.getEndDate()));
                pstmt.setString(7, this._companyId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void calcOut(int rank, int dispRank) throws BOSException {
        if (rank == 0) {
            return;
        }
        boolean isSuccess = false;
        String materialIdTempTableName = null;
        TempTablePool pool = TempTablePool.getInstance((Context)this._ctx);
        String createMaterialTempSql = "create table t_ncm_materialRange (fmaterialid varchar(44))";
        try {
            String Balance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this._ctx, (String)this._companyId, (String)"T_NCM_DynCostCalPrdDetailResult");
            materialIdTempTableName = pool.createTempTable(createMaterialTempSql);
            DbUtil.execute((Context)this._ctx, (String)("delete from  " + materialIdTempTableName));
            DbUtil.execute((Context)this._ctx, (String)("insert into " + materialIdTempTableName + " select distinct FProductID from " + Balance + " where  FCalculatePeriodID='" + this._periodId + "' AND FCalcLevel=" + rank));
            ICalculateFacade ida = CalculateFacadeFactory.getLocalInstance((Context)this._ctx);
            CalculateParams cps = ida.costCalculate(this.getFilterParam(this._ctx, this._companyId, materialIdTempTableName));
            if (cps != null) {
                isSuccess = cps.getBoolean("boolean");
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (materialIdTempTableName == null) throw throwable;
                    pool.releaseTable(materialIdTempTableName);
                    throw throwable;
                }
                catch (Exception e2) {
                    logger.error((Object)"", (Throwable)e2);
                    throw new BOSException((Throwable)e2);
                }
            }
        }
        try {
            if (materialIdTempTableName != null) {
                pool.releaseTable(materialIdTempTableName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String status = null;
        status = isSuccess ? CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_Sucess") : CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_Fail");
        String attachment = CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_SeeReport");
        this._log.AddCalcLog(dispRank, "", CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_CalcOut"), status, attachment, false, "CalcOut", 3);
    }

    protected void secAlloc(int rank, int dispRank) throws BOSException {
        if (rank == 0) {
            return;
        }
        boolean isSuccess = false;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("ctx", this._ctx);
        param.put("companyId", this._companyId);
        param.put("periodId", this._periodId);
        param.put("calcLevel", String.valueOf(rank));
        DynSecAllocDispatch secAlloc = new DynSecAllocDispatch(param);
        try {
            secAlloc.DoSecAllocate();
            isSuccess = true;
        }
        catch (AllocateException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String status = null;
        status = isSuccess ? CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_Sucess") : CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_Fail");
        this._log.AddCalcLog(dispRank, "", CalculateUtil.getSrvCalResource((Context)this._ctx, (String)"Calc_Report_SecAlloc"), status, "", false, "SecAlloc", 4);
    }

    protected com.kingdee.eas.basedata.assistant.PeriodInfo getPeriodInfo(Context ctx, String periodId) throws BOSException {
        int periodNumber;
        int periodYear;
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select * from T_BD_Period bd, T_NCM_Period ncm  ").append("where ncm.FBeginDate >= bd.FBeginDate and ncm.FEndDate <= bd.FEndDate and  ncm.FID = '").append(periodId).append("'");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        sql.delete(0, sql.length());
        try {
            rs.first();
            periodYear = rs.getInt("FPeriodYear");
            periodNumber = rs.getInt("FPeriodNumber");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        com.kingdee.eas.basedata.assistant.PeriodInfo info = new com.kingdee.eas.basedata.assistant.PeriodInfo();
        info.setPeriodYear(periodYear);
        info.setPeriodNumber(periodNumber);
        return info;
    }

    private void getProcessData() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(this._calcTable.GetDataByProductTable()).append("(").append('\n').append("\tFID,FCompanyID,FCalculatePeriodID,FCostCenterID,FCostObjectID,FProductID,FLot,FFinishedQty,FFinishedAssistQty,FFinishedAddQty )").append('\n').append("\tSELECT newbosid('C4774737') AS FID,'").append(this._companyId).append("' As FCompanyID,'").append(this._periodId).append("' As FCalculatePeriodID,").append('\n').append("\t\tENTRY.FCostCenterOrgUnitID,CO.FID As FCostObjectID,ENTRY.FMaterialID As FProductID,CO.FBatchNumber,").append('\n').append("\t\tISNULL(SUM(ENTRY.FBASEQTY),0) As FFinishedQty ").append('\n').append("\t\t,ISNULL(SUM(ENTRY.FAssistQty),0) As FFinishedAssistQty ").append('\n').append("\t\t,ISNULL(SUM(ENTRY.FQTY),0) As FFinishedAddQty ").append('\n').append("\tFROM T_IM_ManufactureRecBill AS  PARENT ").append('\n').append("\tINNER JOIN T_SCM_TransactionType AS TRANS ON PARENT.FTransactionTypeID = TRANS.FID AND FIsManuCostCalculate=1 ").append('\n').append("\tLEFT OUTER JOIN T_IM_ManufactureRecBillEntry AS  ENTRY ON  PARENT .FID =  ENTRY .FParentID ").append('\n').append("INNER JOIN T_BD_CostObject CO ON CO.FCompanyID = ENTRY.FCompanyOrgUnitID  ").append('\n').append("INNER JOIN T_BD_COstObjectEntry coe on coe.FparentId = co.Fid and  coe.FRelatedID = ENTRY.FMaterialID").append('\n').append("\tLEFT OUTER JOIN T_ORG_CostCenter CC ON CC.FID=ENTRY.FCostCenterOrgUnitID").append('\n').append("\tWHERE PARENT.FBaseStatus=4 AND ENTRY.FCompanyOrgUnitID='").append(this._companyId).append("'").append('\n').append("\t\tAND CC.FIsBizUnit=1 AND CC.FCostCenterType=0 AND CC.FisSealUp=0 ").append('\n').append("\t\tAND CO.FRelatedType=0 AND  CO.FIsForbiden =0 AND CO.FID is not null ").append('\n').append("\t\tAND ((CO.FCalculateMode=4 AND Isnull(ENTRY.FLot,' ') = Isnull(CO.FBatchNumber,' '))").append('\n').append("\t\t\t\tOR CO.FCalculateMode <> 4)").append('\n').append("              and PARENT.FBizDate >= ? ").append("              and PARENT.FBizDate <= ? ").append("\tGROUP BY ENTRY.FCostCenterOrgUnitID, CO.FID, ENTRY.FMaterialID, CO.FBatchNumber ").append('\n');
        DbUtil.execute((Context)this._ctx, (String)sql.toString(), (Object[])new Object[]{this.curBizPeriod.getBeginDate(), this.curBizPeriod.getEndDate()});
        sql.setLength(0);
        sql.append("INSERT INTO ").append(this._calcTable.GetDataByCostObjTable()).append("(").append('\n').append("\tFID,FCompanyID,FCalculatePeriodID,FCostCenterID,FCostObjectID,FFinishedQty,FFinishedAssistQty,FFinishedAddQty)").append('\n').append(" SELECT newbosid('C4774737') AS FID,'").append(this._companyId).append("' As FCompanyID,'").append(this._periodId).append("' As FCalculatePeriodID,").append('\n').append("\t\tS.FCostCenterID,S.FCostObjectID,").append('\n').append("\t\tto_decimal( SUM(S.FFinishedQty * ISNULL(coe.FQuotiety,1)) ,24,12) As FFinishedQty ").append('\n').append("\t\t,to_decimal( SUM(S.FFinishedAssistQty * ISNULL(coe.FQuotiety,1)) ,24,12) As FFinishedAssistQty ").append('\n').append("\t\t,to_decimal( SUM(S.FFinishedAddQty * ISNULL(coe.FQuotiety,1)) ,24,12) As FFinishedAddQty ").append('\n').append(" FROM ").append(this._calcTable.GetDataByProductTable()).append(" S ").append('\n').append(" INNER JOIN T_BD_CostObject CO ON CO.FID = S.FCostObjectID AND Isnull(CO.FBatchNumber,' ')=Isnull(S.FLOT,' ') ").append('\n').append(" INNER JOIN T_BD_COstObjectEntry coe on coe.FparentId = co.Fid and  coe.FRelatedID = S.FProductID ").append('\n').append(" WHERE S.FCompanyID='").append(this._companyId).append("' AND S.FCalculatePeriodID='").append(this._periodId).append("' ").append('\n').append("  AND CO.FRelatedType =0 AND  CO.FIsForbiden =0 ").append(" GROUP BY S.FCostCenterID,S.FCostObjectID ").append('\n').append(";");
        DbUtil.execute((Context)this._ctx, (String)sql.toString());
    }

    protected void calManufRecBillTotalActualCost() throws BOSException {
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE calcInTemp ");
        createTableSql.append("\t(");
        createTableSql.append("FID   \t\t\tVARCHAR(44),\t");
        createTableSql.append("FUnitActualCost \tNUMERIC(28,16),\t");
        createTableSql.append("FBaseQty\t\t\tNUMERIC(28,16),\t");
        createTableSql.append("FUnitId \t\t\tVARCHAR(44),\t");
        createTableSql.append("FBaseUnitId \t\tVARCHAR(44),\t");
        createTableSql.append("FMaterialID \t\tVARCHAR(44),\t");
        createTableSql.append("FIsAdjust\t\tINT DEFAULT 0\t");
        createTableSql.append(")");
        String tblName = null;
        try {
            tblName = TempTablePool.getInstance((Context)this._ctx).createTempTable(createTableSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tblName).append("(FId, FUnitActualCost) (").append('\n').append("\tSELECT entry.fid, ").append('\n');
        NCMReportHelper.AppendCaseSQLClause((StringBuffer)sql, (String)"ISNULL(SUM(S.FFinishedAmount),0)", (String)"ISNULL(MAX(S.FTotalFinishedQty),1)", (String)"ISNULL(SUM(S.FFinishedAmount),0)", (String)"FUnitActualCost", (String)"MAX(mt.FPricePrecision)");
        sql.append("       FROM ").append(this._calcTable.GetCostCalPrdDetailResultTable()).append(" S ").append('\n').append("           LEFT JOIN T_IM_ManufactureRecBillEntry entry ON entry.FCostCenterOrgunitId = s.FCostCenterId ").append('\n').append("               AND s.FCompanyId = entry.FCompanyOrgunitId").append('\n').append("               AND s.FProductId = entry.FMaterialId").append('\n').append("\t\t\tLEFT JOIN T_IM_ManufactureRecBill bill ON entry.FParentId = bill.FId ").append('\n').append("           INNER JOIN T_SCM_TransactionType trans ON bill.FTransactionTypeId = trans.FId AND trans.FIsManuCostCalculate = 1").append('\n').append("           LEFT JOIN T_BD_Material mt ON mt.FId = entry.FMaterialId").append('\n').append("\t\t\tLEFT JOIN T_BD_CostObject OBJ on s.FCostObjectID = OBJ.FId").append('\n').append("\t\tWHERE bill.FBaseStatus = 4").append('\n').append("           and bill.FBizDate >= ? ").append("           and bill.FBizDate <= ? ").append("           AND s.FCompanyId = '").append(this._companyId).append("'").append('\n').append("           AND s.FCalculatePeriodId = '").append(this._periodId).append("' ").append('\n').append("\t\t \tAND entry.FId IS NOT NULL ").append('\n').append("\t\tAND ((OBJ.FCalculateMode=4 AND Isnull(ENTRY.FLot,' ') = Isnull(OBJ.FBatchNumber,' '))").append('\n').append("\t\t\t\tOR OBJ.FCalculateMode <> 4)").append('\n').append("\t\tGROUP BY entry.FId);");
        DbUtil.execute((Context)this._ctx, (String)sql.toString(), (Object[])new Object[]{this.curBizPeriod.getBeginDate(), this.curBizPeriod.getEndDate()});
        sql.setLength(0);
        sql.setLength(0);
        sql.append("UPDATE T_IM_ManufactureRecBill ").append("\tSET FTotalActualCost=(").append('\n').append("\t\t\tSELECT ISNULL(SUM(entry.FActualCost), 0)").append('\n').append("\t\t\t\tFROM T_IM_ManufactureRecBillEntry entry").append('\n').append("\t\t\t\t\tJOIN ").append(tblName).append(" temp ON temp.FID = entry.FID").append('\n').append("\t\t\t\tWHERE T_IM_ManufactureRecBill.FID = entry.FParentID)").append('\n').append("\tWHERE EXISTS (").append('\n').append("\t\t\tSELECT 1 ").append('\n').append("\t\t\t\tFROM T_IM_ManufactureRecBillEntry entry").append('\n').append("\t\t\t\t\tJOIN ").append(tblName).append(" temp ON temp.FID = entry.FID").append('\n').append("\t\t\t\tWHERE T_IM_ManufactureRecBill.FID = entry.FParentId)").append('\n');
        NCMServerUtils.BatchSqlExecute((Context)this._ctx, (String)sql.toString(), (String)";");
        TempTablePool.getInstance((Context)this._ctx).releaseTable(tblName);
    }
}

