/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.cal.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DynCostCalTotalReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.dynamic.cal.report.app.DynCostCalTotalReport");
    private String tempTableNameSum = new String();
    private PeriodInfo periodFrom = null;
    private PeriodInfo periodTo = null;
    Date beginDate = null;
    Date endDate = null;
    SimpleDateFormat dateFormate = null;

    protected void initData(RptParams filter) {
        this.periodFrom = (PeriodInfo)filter.getObject("periodFrom");
        this.periodTo = (PeriodInfo)filter.getObject("periodTo");
        this.beginDate = new Date(this.periodFrom.getBeginDate().getTime());
        this.endDate = new Date(this.periodTo.getEndDate().getTime());
        this.dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        return null;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BOSException {
        this.initData(filter);
        StringBuffer sqlAll = new StringBuffer();
        Locale locale = this.getContext().getLocale();
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        String companyName = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getName(locale).toString();
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)this.getContext());
        String cuID = DefaultCU.getId().toString();
        StringBuffer filterContent = this.buildFilter(filter);
        String[] tableNames = this.getTableNames(companyID);
        IRowSet rsCostItems = this.getCostItems(companyID, cuID, locale, filterContent, tableNames);
        StringBuffer rowToColumn = this.getRowToColumn(rsCostItems, locale);
        StringBuffer[] rowToColumnForInsert = this.getRowToColumnForInsert(rsCostItems, locale);
        StringBuffer[] rowToColumnForCalc = this.getRowToColumnForCalc(rsCostItems, locale);
        String[] costItemForCalc = this.getCostItemForCalc(rsCostItems, locale);
        StringBuffer rowToColumnForDelete = this.getRowToColumnForDelete(rsCostItems, locale);
        StringBuffer[] rowToColumnForSum = this.getRowToColumnForSum(rsCostItems, locale);
        String tempTableNameMain = this.createTempTableMain();
        this.tempTableNameSum = this.createTempTableNameSum(rowToColumn);
        String TmpTbl_rowToCol = this.createTmpTbl_rowToCol(rowToColumn);
        sqlAll.append(this.insertDataToTableMain(tempTableNameMain, companyName, companyID, cuID, filterContent, tableNames));
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sqlAll.toString());
        sqlAll.delete(0, sqlAll.length());
        sqlAll.append(this.insertDataToTableSum(tempTableNameMain, this.tempTableNameSum, rowToColumnForInsert, rowToColumnForCalc, costItemForCalc, rowToColumnForDelete, TmpTbl_rowToCol));
        StringBuffer sqlResult = this.getDataToResult(this.tempTableNameSum, companyName, rowToColumnForInsert, rowToColumnForSum, filter, locale, companyID);
        sqlAll.append(sqlResult);
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sqlAll.toString());
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTableNameMain);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(TmpTbl_rowToCol);
        return this.tempTableNameSum;
    }

    private String createTempTableNameSum(StringBuffer rowToColumn) throws BOSException {
        StringBuffer createTableSum = this.getTempTableSum();
        createTableSum.append(rowToColumn);
        createTableSum.append(",FTotalRow decimal(21,8) not null default(0) ");
        createTableSum.append(",FTotalRow2 decimal(21,8) not null default(0) ");
        createTableSum.append(",FIsTotalRow int not null default(1) ");
        createTableSum.append(",FTotalPeriodRow int not null default(0) ");
        createTableSum.append(",FTotalCostCenterRow int not null default(0) ");
        createTableSum.append(",FTotalCostObjectRow int not null default(0) ");
        createTableSum.append(" ) ");
        String tempTable = null;
        try {
            tempTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableSum.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    private String createTempTableMain() throws BOSException {
        StringBuffer createTableMain = this.getTempTableMain();
        String tempTableNameMain = null;
        try {
            tempTableNameMain = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableMain.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableNameMain;
    }

    private String createTmpTbl_rowToCol(StringBuffer rowToColumn) throws BOSException {
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE rowToTotalTemp ");
        createTableSql.append("\t(");
        createTableSql.append("FPeriodName     VARCHAR(50) \n");
        createTableSql.append(",FCostCenterID   VARCHAR(44) \n");
        createTableSql.append(",FCostObjectID   VARCHAR(44) \n");
        createTableSql.append(rowToColumn);
        createTableSql.append(")");
        String tblName = null;
        try {
            tblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTableSql.toString());
            TempTablePool.getInstance((Context)this.getContext()).createIndex(tblName, "FPeriodName, FCostCenterID, FCostObjectID", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tblName;
    }

    private String[] getTableNames(String companyID) throws BOSException {
        String tableName;
        String[] tableNames = new String[2];
        try {
            tableName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyID, (String)"T_NCM_DynCostCalResult_History");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        tableNames[0] = tableName;
        try {
            tableName = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyID, (String)"T_NCM_DynDataByCostObj_History");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        tableNames[1] = tableName;
        return tableNames;
    }

    protected StringBuffer getTempTableMain() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getMain ( ");
        createTable.append("FOrgName varchar(255) ");
        createTable.append(",FCostCenterID varchar(44) ");
        createTable.append(",FCostCenterNumber varchar(255) not null default(' ')");
        createTable.append(",FCostObjectID varchar(44) ");
        createTable.append(",FCostObjectNumber varchar(255) not null default(' ') ");
        createTable.append(",FCostItemID varchar(44) ");
        createTable.append(",FBeginDate datetime ");
        createTable.append(",FEndDate datetime ");
        createTable.append(",FPeriodName varchar(255) ");
        createTable.append(",FPeriodNumber varchar(80) ");
        createTable.append(",FCurInQty  decimal(21,8) default(0) ");
        createTable.append(",FCurInAmount decimal(21,8) default(0) ");
        createTable.append(",FQtyOnline Decimal(21,8) Default(0) ");
        createTable.append(",FAmountOnline Decimal(21,8) Default(0) ");
        createTable.append(",FMakeSum   decimal(21,8) default(0) ");
        createTable.append(",FCurCompQty  decimal(21,8) default(0) ");
        createTable.append(",FCurAllAmount     decimal(21,8) default(0) ");
        createTable.append(",FCurUnitPrice   decimal(21,8) default(0) ");
        createTable.append(",FEndProQty  decimal(21,8) default(0) ");
        createTable.append(",FEndProAmount  decimal(21,8) default(0) ");
        createTable.append(",FYearInFee   decimal(21,8) default(0) ");
        createTable.append(",FYearCompQty  decimal(21,8) default(0) ");
        createTable.append(",FYearCompAmount  decimal(21,8) default(0) ");
        createTable.append(",FQtyDecimal int default(0) ");
        createTable.append(",FPriceDecimal int default(0) ");
        createTable.append(" ) ");
        return createTable;
    }

    protected StringBuffer getTempTableSum() {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table getSum ( ");
        createTable.append("FOrgName varchar(255) ");
        createTable.append(",FCostCenterID varchar(44) ");
        createTable.append(",FCostCenterNumber varchar(255) default(' ')");
        createTable.append(",FCostCenterName varchar(255) default(' ')");
        createTable.append(",FCostObjectID varchar(44) ");
        createTable.append(",FCostObjectNumber varchar(255) default(' ') ");
        createTable.append(",FCostObjectName varchar(255) default(' ') ");
        createTable.append(",FPeriodName varchar(50) ");
        createTable.append(",FPeriodNumber varchar(50) ");
        createTable.append(",FBatchNumber varchar(255)");
        createTable.append(",FUnitName varchar(255) ");
        createTable.append(",FModel nvarchar(255) ");
        createTable.append(",FShortName nvarchar(80) ");
        createTable.append(",FCurInQty  decimal(21,8) default(0) ");
        createTable.append(",FCurInAmount decimal(21,8) default(0) ");
        createTable.append(",FQtyOnline Decimal(21,8) Default(0) ");
        createTable.append(",FAmountOnline Decimal(21,8) Default(0) ");
        createTable.append(",FMakeSum   decimal(21,8) default(0) ");
        createTable.append(",FCurCompQty  decimal(21,8) default(0) ");
        createTable.append(",FCurAllAmount decimal(21,8)  default(0) ");
        createTable.append(",FCurUnitPrice   decimal(21,8) default(0) ");
        createTable.append(",FEndProQty  decimal(21,8) default(0) ");
        createTable.append(",FEndProAmount  decimal(21,8) default(0) ");
        createTable.append(",FYearInFee   decimal(21,8) default(0) ");
        createTable.append(",FYearCompQty  decimal(28,10) default(0) ");
        createTable.append(",FYearCompAmount  decimal(21,8) default(0) ");
        createTable.append(",FYearCompPrice  decimal(21,8) default(0) ");
        createTable.append(",FQtyDecimal int default(0) ");
        createTable.append(",FPriceDecimal int default(0) ");
        createTable.append(",FUnitPriceDecimal int default(0) ");
        return createTable;
    }

    protected StringBuffer insertDataToTableMain(String tempTableNameMain, String companyName, String companyID, String cuID, StringBuffer filter, String[] tableNames) {
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert Into " + tempTableNameMain + " (FOrgName,FBeginDate,FEndDate,FPeriodNumber,FPeriodName,FCostCenterID,FCostObjectID,FCurInQty ) \n");
        sql.append(" SELECT '" + companyName);
        sql.append("' ,t5.FBeginDate,t5.FEndDate,t5.FNumber,t5.FName_l2,T1.FCostCenterOrgUnitID,T2.FCostObjectID,T2.FQty ");
        sql.append(" FROM T_NCM_InputQtyBill T1 ");
        sql.append(" INNER JOIN T_NCM_InputQtyBillEntry T2 ON T1.FID=T2.FParentID ");
        sql.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterOrgUnitID = t3.FID  \n");
        sql.append(" inner join T_BD_CostObject t4 on t2.FCostObjectID = t4.FID  and t1.FCompanyOrg = t4.FCompanyID  \n");
        sql.append(" inner join t_ncm_period t5 on t1.FCalculatePeriod = t5.FID \n ");
        sql.append(" where t1.FCompanyOrg = '" + companyID + "' \n");
        sql.append(filter);
        sql.append("\n\n;");
        sql.append(" Insert Into " + tempTableNameMain + " (FOrgName,FBeginDate,FEndDate,FPeriodNumber,FPeriodName,FCostCenterID," + "FCostObjectID,FCostItemID,FCurAllAmount,FEndProAmount) \n");
        sql.append(" SELECT '" + companyName);
        sql.append("',t5.FBeginDate,t5.FEndDate,t5.FNumber,t5.FName_l2,T1.FCostCenterID,T1.FCostObjectID,T1.FCostItemID,T1.FFinishedAmount,T1.FEoPWIPAmount \n");
        sql.append(" FROM " + tableNames[0] + " T1 \n");
        sql.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sql.append(" inner join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID and t1.FCompanyID = t4.FCompanyID  \n");
        sql.append(" inner join t_ncm_period t5 on t1.FCalculatePeriodID = t5.FID \n ");
        sql.append(" INNER JOIN (SELECT COSTITEM.FID FROM T_NCM_CostItem AS COSTITEM \n");
        sql.append(" INNER JOIN T_ORG_CtrlUnit AS ADMINCU \n");
        sql.append(" ON COSTITEM.FAdminCUID = ADMINCU.FID \n");
        sql.append(" WHERE COSTITEM.FAdminCUID = '" + cuID + "' \n");
        sql.append(" UNION \n");
        sql.append(" SELECT COSTITEM.FID FROM T_NCM_CostItem AS COSTITEM \n");
        sql.append(" INNER JOIN T_BD_DataBaseDAssign AS DataBaseDAssign \n");
        sql.append(" ON DataBaseDAssign.FDataBaseDID=COSTITEM.FID AND DataBaseDAssign.FBOSObjectType='548C5A91' \n");
        sql.append(" WHERE DataBaseDAssign.FAssignCUID  = '" + cuID + "' \n");
        sql.append(" ) AS COSTITEM ON COSTITEM.FID = T1.FCostItemID \n");
        sql.append(" where T1.FCompanyID = '" + companyID + "' \n");
        sql.append(filter);
        sql.append("\n\n;");
        sql.append(" Insert Into " + tempTableNameMain + " (FOrgName,FBeginDate,FEndDate,FPeriodNumber,FPeriodName,FCostCenterID," + "FCostObjectID,FCurCompQty) \n");
        sql.append(" SELECT '" + companyName);
        sql.append("',t5.FBeginDate,t5.FEndDate,t5.FNumber,t5.FName_l2,T1.FCostCenterID, \nT1.FCostObjectID,T1.FFinishedQty \n");
        sql.append(" FROM " + tableNames[1] + " T1 \n");
        sql.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sql.append(" inner join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID and t1.FCompanyID = t4.FCompanyID  \n");
        sql.append(" inner join t_ncm_period t5 on t1.FCalculatePeriodID = t5.FID \n ");
        sql.append(" where T1.FCompanyID = '" + companyID + "' \n");
        sql.append(filter);
        sql.append("\n\n;");
        return sql;
    }

    private StringBuffer insertDataToTableSum(String tempTableNameMain, String tempTableNameSum, StringBuffer[] rowToColumnForInsert, StringBuffer[] rowToColumnForCalc, String[] costItemForCalc, StringBuffer rowToColumnForDelete, String TmpTbl_rowToCol) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO " + tempTableNameSum + "(");
        sql.append(" FOrgName,FPeriodName,FPeriodNumber,FCostCenterID,FCostObjectID,FCostCenterNumber,");
        sql.append(" FCostObjectNumber, \n");
        sql.append(" FCurAllAmount,FEndProAmount,FYearCompAmount, \n");
        sql.append(" FYearCompQty,FYearInFee,FCurInQty, \n");
        sql.append(" FCurCompQty,FEndProQty,FCurInAmount,FQtyOnline,FAmountOnline, FMakeSum,FCurUnitPrice,FIsTotalRow) \n");
        sql.append(" SELECT FOrgName, FPeriodName,FPeriodNumber, \n");
        sql.append(" FCostCenterID,FCostObjectID,FCostCenterNumber,FCostObjectNumber, \n");
        sql.append(" Sum(FCurAllAmount) as FCurAllAmount, \n");
        sql.append(" Sum(FEndProAmount) as FEndProAmount, \n");
        sql.append(" SUM(FYearCompAmount) as FYearCompAmount, \n");
        sql.append(" Sum(FYearCompQty) as FYearCompQty, \n");
        sql.append(" Sum(FYearInFee) as FYearInFee, \n");
        sql.append(" Sum(FCurInQty) as FCurInQty, \n");
        sql.append(" Sum(FCurCompQty) as FCurCompQty, \n");
        sql.append(" Sum(FEndProQty) as FEndProQty, \n");
        sql.append(" Sum(FCurAllAmount)+Sum(FEndProAmount) as FCurInAmount, \n");
        sql.append(" Sum(FQtyOnline) as FQtyOnline, \n");
        sql.append(" Sum(FAmountOnline) as FAmountOnline, \n");
        sql.append(" Sum(FCurAllAmount)+Sum(FEndProAmount) as FMakeSum, \n");
        sql.append(" (CASE WHEN Sum(FCurCompQty)<>0 THEN  to_decimal(Sum(FCurAllAmount),24,12)/ to_decimal(Sum(FCurCompQty),24,12) ELSE 0 END) as FCurUnitPrice,  \n");
        sql.append(" 0 AS FIsTotalRow \n");
        sql.append(" FROM " + tempTableNameMain);
        sql.append(" GROUP BY FOrgName,FPeriodName,FPeriodNumber,FCostCenterID,FCostObjectID,FCostCenterNumber,FCostObjectNumber \n");
        sql.append("\n\n;");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sql.toString());
        sql.delete(0, sql.length());
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            if (rowToColumnForInsert != null && rowToColumnForInsert.length > 0) {
                int count = rowToColumnForInsert.length;
                for (int i = 0; i < count; ++i) {
                    sql.append("truncate table " + TmpTbl_rowToCol + "\n;");
                    sql.append("insert into " + TmpTbl_rowToCol);
                    sql.append("(FPeriodName, FCostCenterID, FCostObjectID, " + rowToColumnForInsert[i] + ")");
                    sql.append("SELECT FPeriodName, \n");
                    sql.append(" FCostCenterID,FCostObjectID, \n");
                    sql.append(rowToColumnForCalc[i] + " \n");
                    sql.append(" FROM " + tempTableNameMain);
                    sql.append(" GROUP BY FPeriodName,FPeriodNumber,FCostCenterID, FCostObjectID \n;");
                    NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sql.toString());
                    sql.delete(0, sql.length());
                    TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, TmpTbl_rowToCol);
                    sql.append(" UPDATE " + tempTableNameSum + " AS T1 \n");
                    sql.append(" SET (" + rowToColumnForInsert[i] + ")= \n");
                    sql.append("( SELECT " + rowToColumnForInsert[i] + " \n");
                    sql.append(" FROM ").append(TmpTbl_rowToCol).append(" T2 \n");
                    sql.append(" WHERE T1.FPeriodName=T2.FPeriodName \nAND T1.FCostCenterID=T2.FCostCenterID \nAND T1.FCostObjectID=T2.FCostObjectID \n");
                    sql.append(" )");
                    sql.append("\n\n;");
                    NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sql.toString());
                    sql.delete(0, sql.length());
                }
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        sql.append(" DELETE " + tempTableNameSum);
        sql.append(" WHERE FCurInQty=0 AND FCurInAmount=0 \n");
        sql.append(" AND FCurCompQty=0 AND FCurAllAmount=0 AND FCurUnitPrice=0  \n");
        sql.append(" AND FEndProQty=0 AND FEndProAmount=0 \n");
        sql.append(" AND FMakeSum=0 \n");
        sql.append(rowToColumnForDelete);
        sql.append("\n\n;");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sql.toString());
        sql.delete(0, sql.length());
        return sql;
    }

    private StringBuffer getDataToResult(String tempTableNameSum, String orgCompanyName, StringBuffer[] rowToColumnForInsert, StringBuffer[] rowToColumnForSum, RptParams filter, Locale locale, String companyID) {
        Context ctx = this.getContext();
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        StringBuffer sql = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (list.size() == 3 && i == 0) continue;
            HashMap map = (HashMap)list.get(list.size() - i - 1);
            String fields = (String)map.get("groupby");
            String compares = (String)map.get("compare");
            fields = fields.replaceAll("FPeriodName", "FPeriodName,FPeriodNumber");
            sql.append(" INSERT INTO " + tempTableNameSum + "( \n");
            sql.append(" FTotalRow," + fields + ", \n");
            sql.append(" FCurAllAmount,FEndProAmount,FYearCompAmount, \n");
            sql.append(" FYearCompQty,FYearInFee,FCurInQty, \n");
            sql.append(" FCurCompQty,FEndProQty,FCurInAmount,FQtyOnline,FAmountOnline, \n");
            sql.append(" FMakeSum,FCurUnitPrice) \n");
            sql.append(" SELECT " + map.get("totalrow").toString() + "," + fields + ",");
            sql.append(" Sum(FCurAllAmount) as FCurAllAmount, \n");
            sql.append(" Sum(FEndProAmount) as FEndProAmount, \n");
            sql.append(" Sum(FYearCompAmount) as FYearCompAmount, \n");
            sql.append(" Sum(FYearCompQty) as FYearCompQty, \n");
            sql.append(" Sum(FYearInFee) as FYearInFee, \n");
            sql.append(" Sum(FCurInQty) as FCurInQty, \n");
            sql.append(" Sum(FCurCompQty) as FCurCompQty, \n");
            sql.append(" Sum(FEndProQty) as FEndProQty, \n");
            sql.append(" Sum(FCurAllAmount)+Sum(FEndProAmount) as FCurInAmount, \n");
            sql.append(" Sum(FQtyOnline) as FQtyOnline, \n");
            sql.append(" Sum(FAmountOnline) as FAmountOnline, \n");
            sql.append(" Sum(FCurAllAmount)+Sum(FEndProAmount) as FMakeSum, \n");
            sql.append(" (CASE WHEN Sum(FCurCompQty)<>0 THEN  to_decimal(Sum(FCurAllAmount),24,12)/ to_decimal(Sum(FCurCompQty),24,12) ELSE 0 END) as FCurUnitPrice  \n  \n");
            sql.append(" FROM " + tempTableNameSum + "\n");
            sql.append(" where FTotalRow = 0 \n");
            sql.append(" group by " + fields);
            sql.append("\n\n;");
            if (rowToColumnForInsert == null || rowToColumnForInsert.length <= 0) continue;
            int count = rowToColumnForInsert.length;
            for (int n = 0; n < count; ++n) {
                sql.append(" UPDATE " + tempTableNameSum + " AS T1 \n");
                sql.append(" SET (" + rowToColumnForInsert[n] + ")= \n");
                sql.append("( SELECT " + rowToColumnForInsert[n] + " \n");
                sql.append(" FROM (SELECT " + fields + "," + rowToColumnForSum[n] + " \n FROM " + tempTableNameSum + " \n");
                sql.append(" WHERE FTOTALROW = 0 ");
                sql.append(" GROUP BY " + fields + " ) T2 \n");
                sql.append(" WHERE " + compares + " \n");
                sql.append(" AND T1.FTotalRow= " + map.get("totalrow").toString() + ") \n");
                sql.append("\n\n;");
            }
        }
        sql.append(" INSERT INTO " + tempTableNameSum + "( \n");
        sql.append(" FOrgName,FTotalRow2,FTotalRow, \n");
        sql.append(" FCurAllAmount,FEndProAmount,FYearCompAmount, \n");
        sql.append(" FYearCompQty,FYearInFee,FCurInQty, \n");
        sql.append(" FCurCompQty,FEndProQty,FCurInAmount,FQtyOnline,FAmountOnline, \n");
        sql.append(" FMakeSum,FCurUnitPrice) \n");
        sql.append(" SELECT '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"0_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "',1,105,");
        sql.append(" Sum(FCurAllAmount) as FCurAllAmount, \n");
        sql.append(" Sum(FEndProAmount) as FEndProAmount, \n");
        sql.append(" Sum(FYearCompAmount) as FYearCompAmount, \n");
        sql.append(" Sum(FYearCompQty) as FYearCompQty, \n");
        sql.append(" Sum(FYearInFee) as FYearInFee, \n");
        sql.append(" Sum(FCurInQty) as FCurInQty, \n");
        sql.append(" Sum(FCurCompQty) as FCurCompQty, \n");
        sql.append(" Sum(FEndProQty) as FEndProQty, \n");
        sql.append(" Sum(FCurAllAmount)+Sum(FEndProAmount) as FCurInAmount, \n");
        sql.append(" Sum(FQtyOnline) as FQtyOnline, \n");
        sql.append(" Sum(FAmountOnline) as FAmountOnline, \n");
        sql.append(" Sum(FCurAllAmount)+Sum(FEndProAmount) as FMakeSum, \n");
        sql.append(" (CASE WHEN Sum(FCurCompQty)<>0 THEN  to_decimal(Sum(FCurAllAmount),24,12)/ to_decimal(Sum(FCurCompQty),24,12) ELSE 0 END) as FCurUnitPrice  \n");
        sql.append(" FROM " + tempTableNameSum + "\n");
        sql.append(" where FTotalRow = 0  \n");
        sql.append("\n\n;");
        if (rowToColumnForInsert != null && rowToColumnForInsert.length > 0) {
            int count = rowToColumnForInsert.length;
            for (int n = 0; n < count; ++n) {
                sql.append(" UPDATE " + tempTableNameSum + " AS T1 \n");
                sql.append(" SET (" + rowToColumnForInsert[n] + ")= \n");
                sql.append("( SELECT " + rowToColumnForInsert[n] + " \n");
                sql.append(" FROM (SELECT " + rowToColumnForSum[n] + " \n FROM " + tempTableNameSum + " \n");
                sql.append(" WHERE FTOTALROW = 0 ) T2 \n");
                sql.append(" WHERE T1.FTotalRow= 105 ) \n");
                sql.append("\n\n;");
            }
        }
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostCenterNumber,FCostCenterName)= (SELECT T2.FNumber, ");
        sql.append(" T2.FName_" + locale + " \n");
        sql.append(" FROM T_ORG_CostCenter T2 WHERE " + tempTableNameSum + ".FCostCenterID = T2.FID ) \n");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET (FCostObjectNumber,FCostObjectName) = \n");
        sql.append(" ( SELECT T2.FNumber,T2.FName_" + locale + "\n");
        sql.append(" FROM T_BD_CostObject T2 \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID =T2.FID ) \n ");
        sql.append("\n\n;");
        sql.append(" Update " + tempTableNameSum);
        sql.append(" SET FOrgName= '" + orgCompanyName + "' where FTotalRow2 <> 1 \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET (FBatchNumber,FUnitName,FModel,FShortName)= \n");
        sql.append(" (SELECT T2.FBatchNumber,T4.FName_" + locale + ",T3.FModel,T3.FShortName ");
        sql.append(" FROM T_BD_CostObject T2 ");
        sql.append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID \n");
        sql.append(" INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID ) \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET FQtyDecimal= \n");
        sql.append(" (SELECT MAX(T4.FqtyPrecision) \n");
        sql.append(" FROM T_BD_CostObject T2 ");
        sql.append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID ");
        sql.append(" INNER JOIN t_bd_MeasureUnit T4 ON T3.FBaseUnit = T4.FID \n");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID ) \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum);
        sql.append(" SET FUnitPriceDecimal= \n");
        sql.append(" (SELECT MAX(T3.FPricePrecision) \n");
        sql.append(" FROM T_BD_CostObject T2 ");
        sql.append(" INNER JOIN t_bd_Material T3 ON T2.FStdProductIDID = T3.FID ");
        sql.append(" WHERE " + tempTableNameSum + ".FCostObjectID=T2.FID ) \n");
        sql.append("\n\n;");
        sql.append("UPDATE ").append(tempTableNameSum).append(" SET (FPriceDecimal)=(").append(" \n").append("\tSELECT CY.FPrecision As FAmountPrecision ").append(" \n").append("\tFROM T_BD_Currency CY ").append(" \n").append("\tINNER JOIN T_ORG_Company CP ON CP.FBaseCurrencyID = CY.FID").append(" \n").append("\tWHERE CP.FID='").append(companyID).append("'").append(" \n").append(")").append(" \n");
        sql.append("\n\n;");
        sql.append("\n\n;");
        String field = "";
        String fieldName = "";
        String fieldNumber = "";
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            field = (String)map.get("id");
            fieldName = field.substring(0, field.length() - 2) + "Name";
            fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String whichTotal = "";
            if (field.equalsIgnoreCase("FCostCenterID")) {
                whichTotal = ", FTotalCostCenterRow = 1 ";
            }
            if (field.equalsIgnoreCase("FCostObjectID")) {
                whichTotal = ", FTotalCostObjectRow = 1 ";
            }
            if (!field.equals("FPeriodName")) {
                sql.append(" update " + tempTableNameSum + " set " + fieldName + "= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "', \n" + fieldNumber + " = " + fieldNumber + "\n");
                sql.append(whichTotal);
                sql.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
                sql.append("\n\n;");
                continue;
            }
            fieldNumber = field;
            sql.append(" update " + tempTableNameSum + " set " + field + " = " + field + " || ' " + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"1_DynByClassCostCalReport", (Locale)ctx.getLocale()) + "' \n");
            sql.append(", FTotalPeriodRow = 1");
            sql.append(" where FTotalRow = ").append(map.get("totalrow")).append("\n");
            sql.append("\n\n;");
        }
        sql.append(" UPDATE " + tempTableNameSum + " SET FQtyDecimal = (SELECT MAX(FQtyDecimal) FROM " + tempTableNameSum + ") \n,FUnitPriceDecimal= (SELECT MAX(FUnitPriceDecimal) FROM " + tempTableNameSum + ") \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " SET FYearInFee=FYearInFee+FEndProAmount+FCurAllAmount \n" + " ,FYearCompAmount=FYearCompAmount+FCurAllAmount," + "FYearCompQty=FYearCompQty+FCurCompQty \n");
        sql.append("\n\n;");
        sql.append(" UPDATE " + tempTableNameSum + " SET FYearCompPrice= (CASE WHEN FYearCompQty<>0 THEN " + " to_decimal(FYearCompAmount,24,12)/to_decimal(FYearCompQty,24,12) ELSE 0 END) \n");
        sql.append("\n\n;");
        return sql;
    }

    private StringBuffer buildFilter(RptParams filter) {
        this.initData(filter);
        StringBuffer sb = new StringBuffer();
        sb.append(" and t5.FBeginDate >= TO_DATE('");
        sb.append(this.dateFormate.format(this.beginDate));
        sb.append("') \n");
        sb.append(" and t5.FEndDate <= TO_DATE('");
        sb.append(this.dateFormate.format(this.endDate));
        sb.append("') \n");
        if (filter.getString("costcenterFrom") != null && !"".equals(filter.getString("costcenterFrom"))) {
            sb.append(" and t3.FNumber >='").append(filter.getString("costcenterFrom")).append("' \n");
        }
        if (filter.getString("costcenterTo") != null && !"".equals(filter.getString("costcenterTo"))) {
            sb.append(" and t3.FNumber <='").append(filter.getString("costcenterTo")).append("' \n");
        }
        if (filter.getString("costobjectFrom") != null && !"".equals(filter.getString("costobjectFrom"))) {
            sb.append(" and t4.FNumber >='").append(filter.getString("costobjectFrom")).append("' \n");
        }
        if (filter.getString("costobjectTo") != null && !"".equals(filter.getString("costobjectTo"))) {
            sb.append(" and t4.FNumber <='").append(filter.getString("costobjectTo")).append("' \n");
        }
        return sb;
    }

    private IRowSet getCostItems(String companyID, String cuID, Locale locale, StringBuffer filter, String[] tableNames) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct COSTITEM.FID,COSTITEM.FNumber,COSTITEM.FName_" + locale + " \n");
        sql.append(" FROM " + tableNames[0] + " T1 \n");
        sql.append(" inner join T_ORG_CostCenter t3 on t1.FCostCenterID = t3.FID  \n");
        sql.append(" inner join T_BD_CostObject t4 on t1.FCostObjectID = t4.FID  \n");
        sql.append(" inner join T_NCM_Period t5 on t1.FCalculatePeriodID = t5.FID \n ");
        sql.append(" INNER JOIN (SELECT COSTITEM.FID,COSTITEM.FNumber,COSTITEM.FName_" + locale + " FROM T_NCM_CostItem AS COSTITEM \n");
        sql.append(" INNER JOIN T_ORG_CtrlUnit AS ADMINCU \n");
        sql.append(" ON COSTITEM.FAdminCUID = ADMINCU.FID \n");
        sql.append(" WHERE COSTITEM.FAdminCUID = '" + cuID + "' \n");
        sql.append(" UNION \n");
        sql.append(" SELECT COSTITEM.FID,COSTITEM.FNumber,COSTITEM.FName_" + locale + " FROM T_NCM_CostItem AS COSTITEM \n");
        sql.append(" INNER JOIN T_BD_DataBaseDAssign AS DataBaseDAssign \n");
        sql.append(" ON DataBaseDAssign.FDataBaseDID=COSTITEM.FID AND DataBaseDAssign.FBOSObjectType='548C5A91' \n");
        sql.append(" WHERE DataBaseDAssign.FAssignCUID  = '" + cuID + "' \n");
        sql.append(" ) AS COSTITEM ON COSTITEM.FID = T1.FCostItemID \n");
        sql.append(" where T1.FCompanyID = '" + companyID + "' \n");
        sql.append(filter);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        return rs;
    }

    private int GetGreaterZeroRowCount(String columnName) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT COUNT(1) as thisCount FROM ").append(this.tempTableNameSum + " \n").append(" WHERE " + columnName + " != 0 \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        rs.first();
        int count = rs.getInt("thisCount");
        return count;
    }

    private StringBuffer getRowToColumn(IRowSet rsCostItem, Locale locale) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String name = "";
        try {
            rsCostItem.first();
            rsCostItem.previous();
            name = "FName_" + locale;
            int i = 0;
            String colName = "F" + Integer.toString(i);
            while (rsCostItem.next() && rsCostItem.getString(name) != null && rsCostItem.getString("FNumber") != null) {
                sql.append(",FAmount1" + colName + " Decimal(21,8) Default(0) \n");
                sql.append(",FAmount2" + colName + " Decimal(21,8) Default(0) \n");
                sql.append(",FAmount3" + colName + " Decimal(21,8) Default(0) \n");
                sql.append(",FAmount4" + colName + " Decimal(21,8) Default(0) \n");
                colName = "F" + Integer.toString(++i);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return sql;
    }

    private StringBuffer[] getRowToColumnForInsert(IRowSet rsCostItem, Locale locale) throws BOSException {
        try {
            StringBuffer[] sqls = new StringBuffer[rsCostItem.size()];
            if (rsCostItem.size() > 0) {
                StringBuffer sql = new StringBuffer();
                String name = "";
                rsCostItem.beforeFirst();
                name = "FName_" + locale;
                int i = 0;
                String colName = "F" + Integer.toString(i);
                while (rsCostItem.next() && rsCostItem.getString(name) != null && rsCostItem.getString("FNumber") != null) {
                    sql = new StringBuffer();
                    sql.append("FAmount1" + colName + ", \n");
                    sql.append("FAmount2" + colName + ", \n");
                    sql.append("FAmount3" + colName + ", \n");
                    sql.append("FAmount4" + colName + " \n");
                    sqls[i] = sql;
                    colName = "F" + Integer.toString(++i);
                }
            }
            return sqls;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private StringBuffer[] getRowToColumnForCalc(IRowSet rsCostItem, Locale locale) throws BOSException {
        try {
            StringBuffer[] sqls = new StringBuffer[rsCostItem.size()];
            if (rsCostItem.size() > 0) {
                String name = "";
                StringBuffer sql = new StringBuffer();
                rsCostItem.beforeFirst();
                name = "FName_" + locale;
                int i = 0;
                String colName = "F" + Integer.toString(i);
                while (rsCostItem.next() && rsCostItem.getString(name) != null && rsCostItem.getString("FNumber") != null) {
                    sql = new StringBuffer();
                    sql.append("SUM(CASE WHEN FCostItemID='" + rsCostItem.getString("FID") + "' THEN FCurAllAmount+FEndProAmount Else 0 END) AS FAmount2" + colName + ", \n");
                    sql.append("SUM(CASE WHEN FCostItemID='" + rsCostItem.getString("FID") + "' THEN FCurAllAmount Else 0 END) AS FAmount3" + colName + ", \n");
                    sql.append("SUM(CASE WHEN FCostItemID='" + rsCostItem.getString("FID") + "' THEN FYearInFee+FEndProAmount+FCurAllAmount Else 0 END) AS FAmount5" + colName + ", \n");
                    sql.append("SUM(CASE WHEN FCostItemID='" + rsCostItem.getString("FID") + "' THEN FYearCompAmount+FCurAllAmount Else 0 END) AS FAmount6" + colName + " \n");
                    sqls[i] = sql;
                    colName = "F" + Integer.toString(++i);
                }
            }
            return sqls;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String[] getCostItemForCalc(IRowSet rsCostItem, Locale locale) throws BOSException {
        try {
            String[] costItems = new String[rsCostItem.size()];
            if (rsCostItem.size() > 0) {
                int i = 0;
                rsCostItem.beforeFirst();
                while (rsCostItem.next() && rsCostItem.getString("FName_" + locale) != null && rsCostItem.getString("FNumber") != null) {
                    costItems[i] = rsCostItem.getString("FID");
                    ++i;
                }
            }
            return costItems;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private StringBuffer getRowToColumnForDelete(IRowSet rsCostItem, Locale locale) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String name = "";
        try {
            rsCostItem.beforeFirst();
            name = "FName_" + locale;
            int i = 0;
            String colName = "F" + Integer.toString(i);
            while (rsCostItem.next() && rsCostItem.getString(name) != null && rsCostItem.getString("FNumber") != null) {
                sql.append(" AND FAmount1" + colName + "=0 \n");
                sql.append(" AND FAmount2" + colName + "=0 \n");
                sql.append(" AND FAmount3" + colName + "=0 \n");
                sql.append(" AND FAmount4" + colName + "=0 \n");
                colName = "F" + Integer.toString(++i);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return sql;
    }

    private StringBuffer[] getRowToColumnForSum(IRowSet rsCostItem, Locale locale) throws BOSException {
        try {
            StringBuffer[] sqls = new StringBuffer[rsCostItem.size()];
            if (rsCostItem.size() > 0) {
                String name = "";
                StringBuffer sql = new StringBuffer();
                rsCostItem.beforeFirst();
                name = "FName_" + locale;
                int i = 0;
                String colName = "F" + Integer.toString(i);
                while (rsCostItem.next() && rsCostItem.getString(name) != null && rsCostItem.getString("FNumber") != null) {
                    sql = new StringBuffer();
                    sql.append("SUM(FAmount1" + colName + ") as FAmount1" + colName + ", \n");
                    sql.append("SUM(FAmount2" + colName + ") as FAmount2" + colName + ", \n");
                    sql.append("SUM(FAmount3" + colName + ") as FAmount3" + colName + ", \n");
                    sql.append("SUM(FAmount4" + colName + ") as FAmount4" + colName + " \n");
                    sqls[i] = sql;
                    colName = "F" + Integer.toString(++i);
                }
            }
            return sqls;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"2_DynByClassCostCalReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"3_DynByClassCostCalReport", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"25_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()) + this.periodFrom.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"5_DynByClassCostCalReport", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"45_DynCostCalTotalReport", (Locale)ctx.getLocale()) + this.periodTo.getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"6_DynByClassCostCalReport", (Locale)ctx.getLocale()));
        if (filter.getString("costcenterFrom") != null || filter.getString("costcenterTo") != null) {
            titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"7_DynByClassCostCalReport", (Locale)ctx.getLocale()) + StringUtils.cnulls((String)filter.getString("costcenterFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("costcenterTo")));
        } else {
            titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"46_DynCostCalTotalReport", (Locale)ctx.getLocale()));
        }
        if (filter.getString("costobjectFrom") != null || filter.getString("costobjectTo") != null) {
            titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"9_DynByClassCostCalReport", (Locale)ctx.getLocale()) + StringUtils.cnulls((String)filter.getString("costobjectFrom")) + "\u2014" + StringUtils.cnulls((String)filter.getString("costobjectTo")));
        } else {
            titles.AddTitle(4, ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"47_DynCostCalTotalReport", (Locale)ctx.getLocale()));
        }
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        Context ctx = this.getContext();
        ReportHeader reportHeader = new ReportHeader();
        reportHeader.addChild("FOrgName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"26_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(0);
        String orderBy = this.getShowString((ArrayList)filter.getObject("table")).toString();
        String[] orderStrings = orderBy.split(",");
        for (int i = 0; i < orderStrings.length; ++i) {
            if (orderStrings[i].equalsIgnoreCase("FPeriodName")) {
                reportHeader.addChild("FPeriodName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"48_DynCostCalTotalReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(i + 1);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostcenterNumber")) {
                reportHeader.addChild("FCostcenterNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"28_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(i + 1);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostcenterName")) {
                reportHeader.addChild("FCostcenterName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"29_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(i + 1);
            }
            if (orderStrings[i].equalsIgnoreCase("FCostobjectNumber")) {
                reportHeader.addChild("FCostobjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"30_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(i + 1);
            }
            if (!orderStrings[i].equalsIgnoreCase("FCostobjectName")) continue;
            reportHeader.addChild("FCostobjectName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"31_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(i + 1);
        }
        reportHeader.addChild("FModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"32_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(6);
        reportHeader.addChild("FShortName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"33_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(7);
        reportHeader.addChild("FBatchNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"34_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(8);
        reportHeader.addChild("FUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"35_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(1).setIndex(9);
        ReportHeader bandAmount2 = reportHeader.addChild("BQTR", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"49_DynCostCalTotalReport", (Locale)ctx.getLocale()));
        bandAmount2.addChild("FCurInQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"39_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
        reportHeader.addChild("FMakeSum", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"50_DynCostCalTotalReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
        ReportHeader bandAmount3 = reportHeader.addChild("BQWG", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"38_DynCostCalTotalDetailReport", (Locale)ctx.getLocale()));
        bandAmount3.addChild("FCurCompQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"39_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FQtyDecimal");
        Locale locale = this.getContext().getLocale();
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        CtrlUnitInfo DefaultCU = ContextUtil.getCurrentCtrlUnit((Context)this.getContext());
        String cuID = DefaultCU.getId().toString();
        StringBuffer filterContent = this.buildFilter(filter);
        String[] tableNames = this.getTableNames(companyID);
        IRowSet rsCostItems = this.getCostItems(companyID, cuID, locale, filterContent, tableNames);
        try {
            rsCostItems.beforeFirst();
            String name = "FName_" + locale;
            int i = 0;
            String colName = "F" + Integer.toString(i);
            int rowCount = 0;
            String realColName = "";
            ReportHeader bandTemp = bandAmount2;
            while (rsCostItems.next() && rsCostItems.getString(name) != null && rsCostItems.getString("FNumber") != null) {
                for (int j = 1; j <= 2; ++j) {
                    switch (j) {
                        case 1: {
                            bandTemp = bandAmount2;
                            break;
                        }
                        case 2: {
                            bandTemp = bandAmount3;
                            break;
                        }
                        default: {
                            bandTemp = bandAmount2;
                        }
                    }
                    realColName = "FAmount" + String.valueOf(j) + colName;
                    rowCount = this.GetGreaterZeroRowCount(realColName);
                    if (rowCount <= 0) continue;
                    bandTemp.addChild(realColName, rsCostItems.getString(name)).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
                }
                colName = "F" + Integer.toString(++i);
            }
            bandAmount2.addChild("FCurInAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"51_DynCostCalTotalReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
            bandAmount3.addChild("FCurAllAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"40_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FPriceDecimal");
            bandAmount3.addChild("FCurUnitPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.dynamic.cal.report.REPORTAutoGenerateResource", (String)"41_DynCostCalTotalDetailReport", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FUnitPriceDecimal");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return reportHeader;
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        StringBuffer compare = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            if (compare.length() > 0) {
                compare.append(" AND ");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            compare.append("T1." + fieldID + " = " + "T2." + fieldID);
            map.put("groupby", sb.toString());
            map.put("compare", compare.toString());
            map.put("totalrow", new Integer(104 - i));
            newList.add(map);
        }
        return newList;
    }

    private StringBuffer getSortString(ArrayList list, String sortModel) {
        StringBuffer sbChecked = new StringBuffer();
        StringBuffer sbNoChecked = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String orderByWhichTotal = "";
            if (field.equalsIgnoreCase("FPeriodName")) {
                orderByWhichTotal = ", FTotalPeriodRow " + sortModel;
                fieldNumber = "FPeriodNumber";
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                orderByWhichTotal = ", FTotalCostCenterRow " + sortModel;
            }
            if (fieldNumber.equalsIgnoreCase("FCostobjectNumber")) {
                orderByWhichTotal = ", FTotalCostObjectRow " + sortModel;
            }
            if (((Boolean)map.get("isTotal")).booleanValue()) {
                if (sbChecked.length() > 0) {
                    sbChecked.append(",");
                }
                sbChecked.append(fieldNumber);
                sbChecked.append(orderByWhichTotal);
                continue;
            }
            if (sbNoChecked.length() > 0) {
                sbNoChecked.append(",");
            }
            sbNoChecked.append(fieldNumber);
        }
        if (sbNoChecked.length() > 0 && sbChecked.length() > 0) {
            sbChecked.append(",").append(sbNoChecked);
        } else {
            sbChecked.append(sbNoChecked);
        }
        return sbChecked;
    }

    private StringBuffer getShowString(ArrayList list) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(this.getField(map));
        }
        return sb;
    }

    private StringBuffer getField(HashMap map) {
        StringBuffer sb = new StringBuffer();
        String field = (String)map.get("id");
        String fieldName = "";
        String fieldNumber = "";
        if (!field.equals("FPeriodName")) {
            fieldName = field.substring(0, field.length() - 2) + "Name";
            fieldNumber = field.substring(0, field.length() - 2) + "Number";
            sb.append(fieldNumber + "," + fieldName);
        } else {
            sb.append(field);
        }
        return sb;
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow", (Object)new BigDecimal(100), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow", 1, (Object)new BigDecimal(105), a);
        return conditions;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BOSException {
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        String orderBy = this.getSortString((ArrayList)filter.getObject("table"), orderByMode).toString();
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT * FROM " + tableName + where + " Order by  FTotalRow2 " + orderByMode + "," + orderBy + " ,FTotalRow"), (int)start, (int)rows);
        return rs;
    }
}

