/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.dynamic.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.ncm.IPeriod;
import com.kingdee.eas.basedata.ncm.PeriodFactory;
import com.kingdee.eas.basedata.ncm.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class DynCostServerUtil {
    private static Logger logger = Logger.getLogger((String)DynCostServerUtil.class.getName());

    public static com.kingdee.eas.basedata.assistant.PeriodInfo getFiPeriod(Context ctx, PeriodInfo bizPeriodInfo) throws BOSException {
        if (bizPeriodInfo == null || bizPeriodInfo.getId().toString().length() == 0) {
            return null;
        }
        StringBuffer kSql = new StringBuffer();
        kSql.append(" select FID,FPeriodYear,FPeriodNumber,FNumber ");
        kSql.append("   from T_BD_Period ");
        kSql.append("  where FBeginDate <= ? ");
        kSql.append("    and FEndDate >= ? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{bizPeriodInfo.getBeginDate(), bizPeriodInfo.getEndDate()});
        try {
            if (rs.next()) {
                com.kingdee.eas.basedata.assistant.PeriodInfo period = new com.kingdee.eas.basedata.assistant.PeriodInfo();
                period.setId(BOSUuid.read((String)rs.getString("FID")));
                period.setPeriodYear(rs.getInt("FPeriodYear"));
                period.setPeriodNumber(rs.getInt("FPeriodNumber"));
                com.kingdee.eas.basedata.assistant.PeriodInfo periodInfo = period;
                return periodInfo;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return null;
    }

    public static com.kingdee.eas.basedata.assistant.PeriodInfo getFiPeriod(Context ctx, String bizPeriodID) throws BOSException, EASBizException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(bizPeriodID));
        return DynCostServerUtil.getFiPeriod(ctx, periodInfo);
    }

    public static void closePeriod(Context ctx, String bizPeriodID, String companyID) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)" update T_NCM_PeriodStatus set FStatu = ? where FPeriodID = ? and FCompanyID = ? ", (Object[])new Object[]{"2", bizPeriodID, companyID});
    }
}

