/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.common.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.CMBillBaseInfo;
import com.kingdee.eas.ncm.common.CMBillException;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.order.common.app.AbstractOCBillBaseControllerBean;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import org.apache.log4j.Logger;

public abstract class OCBillBaseControllerBean
extends AbstractOCBillBaseControllerBean {
    private static final long serialVersionUID = 2902576187788263467L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.order.common.app.OCBillBaseControllerBean");

    public void checkStart(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ((CMBillBaseInfo)model).getCompanyOrg();
        String companyId = company.getId().toString();
        if (((CMBillBaseInfo)model).getCalculatePeriod() == null) {
            throw new CMBillException(CMBillException.NO_PERIOD);
        }
        OrderCMUtils.checkStart(ctx, companyId);
        if (this.isCheckStart()) {
            ObjectUuidPK periodPk = new ObjectUuidPK(((CMBillBaseInfo)model).getCalculatePeriod().getId().toString());
            PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)periodPk);
            PeriodInfo currentPeriod = OrderCMUtils.getCurrentPeriod(ctx, companyId);
            if (!NCMUtils.isBig((PeriodInfo)currentPeriod, (PeriodInfo)period)) {
                throw new CMBillException(CMBillException.NOT_EDIT);
            }
        }
    }

    public void checkStart(Context ctx, IObjectCollection coll) throws BOSException, EASBizException {
        PeriodInfo period;
        PeriodInfo currentPeriod;
        if (coll == null || coll.isEmpty()) {
            return;
        }
        CMBillBaseInfo info = null;
        if (this.isUsingPeriod()) {
            for (int i = 0; i < coll.size(); ++i) {
                info = (CMBillBaseInfo)coll.getObject(i);
                if (info.getCalculatePeriod() != null) continue;
                throw new CMBillException(CMBillException.NO_PERIOD);
            }
        }
        info = (CMBillBaseInfo)coll.getObject(0);
        CompanyOrgUnitInfo company = info.getCompanyOrg();
        String companyId = company.getId().toString();
        boolean isInit = OrderCMUtils.isStart(ctx, companyId);
        if (this.checkStartForCommon()) {
            if (!isInit) {
                throw new CMBillException(CMBillException.COST_NOTON);
            }
        } else if (isInit) {
            throw new CMBillException(CMBillException.COST_ISON);
        }
        if (this.isCheckStart() && !NCMUtils.isBig((PeriodInfo)(currentPeriod = OrderCMUtils.getCurrentPeriod(ctx, companyId)), (PeriodInfo)(period = this.getLeastPeriodInfo(ctx, coll)))) {
            throw new CMBillException(CMBillException.NOT_EDIT);
        }
    }
}

