/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.common.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.ncm.BDNCMException;
import com.kingdee.eas.basedata.ncm.OrderCostException;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeLevelEnum;
import com.kingdee.eas.ncm.order.std.basedata.ICostType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class OrderCMUtils {
    private static Logger logger = Logger.getLogger((String)OrderCMUtils.class.getName());

    public static boolean isStart(String companyId) throws EASBizException, BOSException {
        return OrderCMUtils.isStart(null, companyId);
    }

    public static boolean isStart(Context ctx, String companyId) throws BOSException, EASBizException {
        ISystemStatusCtrol control = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        return control.isStart(1010, companyId);
    }

    public static void checkStart(String companyId) throws EASBizException, BOSException {
        OrderCMUtils.checkStart(null, companyId);
    }

    public static void checkStart(Context ctx, String companyId) throws EASBizException, BOSException {
        if (!OrderCMUtils.isStart(ctx, companyId)) {
            throw new OrderCostException(OrderCostException.COST_NOTON);
        }
    }

    public static PeriodInfo getStartPeriod(String companyId) throws EASBizException, BOSException {
        return OrderCMUtils.getStartPeriod(null, companyId);
    }

    public static PeriodInfo getStartPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        ISystemStatusCtrol control = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        return control.getStartPeriod(1010, companyId);
    }

    public static PeriodInfo getCurrentPeriod(String companyId) throws EASBizException, BOSException {
        return OrderCMUtils.getCurrentPeriod(null, companyId);
    }

    public static PeriodInfo getCurrentPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        ISystemStatusCtrol control = ctx == null ? SystemStatusCtrolFactory.getRemoteInstance() : SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        return control.getCacheCurrentPeriod(1010, companyId);
    }

    public static PeriodInfo getMaxPeriod(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        return OrderCMUtils.getMaxPeriod(company, null);
    }

    public static PeriodInfo getMaxPeriod(CompanyOrgUnitInfo company, PeriodInfo currentPeriod) throws EASBizException, BOSException {
        return OrderCMUtils.getMaxPeriod(null, company, currentPeriod);
    }

    public static PeriodInfo getMaxPeriod(Context ctx, CompanyOrgUnitInfo company, PeriodInfo currentPeriod) throws EASBizException, BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("where periodType = '" + company.getAccountPeriodType().getId().toString() + "' \n");
        if (currentPeriod != null) {
            oql.append("and isadjustPeriod = 0 and periodYear >= " + currentPeriod.getPeriodYear() + " \n");
        }
        oql.append("order by periodYear desc, periodNumber desc \n");
        IPeriod period = ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection coll = period.getPeriodCollection(oql.toString());
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public static PeriodInfo getNextPeriod(Context ctx, PeriodInfo currentPeriod) throws BOSException, EASBizException {
        if (currentPeriod == null || currentPeriod.getPeriodType() == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)currentPeriod.getEndDate()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)currentPeriod.getPeriodType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.FALSE));
        evi.setFilter(filter);
        evi.getSorter().add(new SorterItemInfo("endDate"));
        IPeriod period = ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection coll = period.getPeriodCollection(evi.toString());
        if (coll.size() > 0) {
            return coll.get(0);
        }
        throw new BDNCMException(BDNCMException.NO_AVALIBLE_PERIOD);
    }

    public static PeriodInfo getPrePeriod(Context ctx, PeriodInfo currentPeriod) throws BOSException, EASBizException {
        if (currentPeriod == null || currentPeriod.getPeriodType() == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)currentPeriod.getBeginDate()), CompareType.LESS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)currentPeriod.getPeriodType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.FALSE));
        evi.setFilter(filter);
        evi.setFilter(filter);
        SorterItemInfo sorter = new SorterItemInfo("endDate");
        sorter.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorter);
        IPeriod period = ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection coll = period.getPeriodCollection(evi.toString());
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public static String getPeriodId(Context ctx, CompanyOrgUnitInfo company, Integer periodNumber) throws BOSException, EASBizException {
        PeriodInfo periodInfo = OrderCMUtils.getPeriodInfo(ctx, company, periodNumber);
        if (periodInfo != null) {
            return periodInfo.getId().toString();
        }
        return null;
    }

    public static PeriodInfo getPeriodInfo(Context ctx, CompanyOrgUnitInfo company, Integer periodNumber) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)company.getAccountPeriodType().getId().toString()));
        if (periodNumber != null) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)periodNumber));
        }
        view.setFilter(filter);
        IPeriod period = ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection coll = period.getPeriodCollection(view);
        if (coll != null && coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public static Set getPeriodIds(Context ctx, CompanyOrgUnitInfo company, Integer fromPeriodNumber, Integer toPeriodNumber) throws BOSException, EASBizException {
        HashSet<String> result = new HashSet<String>();
        PeriodCollection infos = OrderCMUtils.getPeriodInfos(ctx, company, fromPeriodNumber, toPeriodNumber);
        PeriodInfo info2 = null;
        for (PeriodInfo info2 : infos) {
            result.add(info2.getId().toString());
        }
        return result;
    }

    public static Map getPeriodIds(Context ctx, CompanyOrgUnitInfo company, Set periodNumbers) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        Map infos = OrderCMUtils.getPeriodInfos(ctx, company, periodNumbers);
        for (Map.Entry e : infos.entrySet()) {
            result.put(e.getKey(), ((PeriodInfo)e.getValue()).getId().toString());
        }
        return result;
    }

    public static PeriodCollection getPeriodInfos(Context ctx, CompanyOrgUnitInfo company, Integer fromPeriodNumber, Integer toPeriodNumber) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)company.getAccountPeriodType().getId().toString()));
        if (fromPeriodNumber != null) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)fromPeriodNumber, CompareType.GREATER_EQUALS));
        }
        if (toPeriodNumber != null) {
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)toPeriodNumber, CompareType.LESS_EQUALS));
        }
        view.setFilter(filter);
        IPeriod period = ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection coll = period.getPeriodCollection(view);
        return coll;
    }

    public static Map getPeriodInfos(Context ctx, CompanyOrgUnitInfo company, Set periodNumbers) throws BOSException, EASBizException {
        HashMap<Integer, PeriodInfo> result = new HashMap<Integer, PeriodInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)company.getAccountPeriodType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)periodNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        IPeriod period = ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance((Context)ctx);
        PeriodCollection coll = period.getPeriodCollection(view);
        if (coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                result.put(new Integer(coll.get(i).getNumber()), coll.get(i));
            }
        }
        return result;
    }

    public static Map getPeriodIds(Context ctx, CompanyOrgUnitInfo company, Set storageOrgUnitIds, String fromOrderNumber, String toOrderNumber, Set orderStatuses) throws BOSException, EASBizException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        if (storageOrgUnitIds == null || storageOrgUnitIds.size() == 0) {
            storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany((Context)ctx, (String)company.getId().toString());
        }
        if (orderStatuses == null || orderStatuses.size() == 0) {
            orderStatuses = new HashSet<Integer>();
            orderStatuses.add(new Integer(5));
            orderStatuses.add(new Integer(8));
            orderStatuses.add(new Integer(7));
            orderStatuses.add(new Integer(11));
        }
        StringBuffer ksql = new StringBuffer();
        ksql.append("select FID, FNumber from T_BD_Period p \n");
        ksql.append("where p.FTypeID = '" + company.getAccountPeriodType().getId().toString() + "' \n");
        ksql.append("and exists ( \n");
        ksql.append("    select top 1 1 from T_MM_ManufactureOrder o \n");
        ksql.append("    where o.FStorageOrgUnitID in " + BDCMUtils.buildSqlFromIds((Set)storageOrgUnitIds) + " \n");
        ksql.append("    and o.FBaseStatus in " + BDCMUtils.buildSqlFromInts(orderStatuses) + " \n");
        ksql.append("    and p.FEndDate >= o.FActureBeginDate \n");
        ksql.append("    and ( \n");
        ksql.append("        (o.FBaseStatus = 11 \n");
        ksql.append("            and p.FEndDate <= o.FCostSettlementTime) \n");
        ksql.append("        or \n");
        ksql.append("        (o.FBaseStatus <> 11) \n");
        ksql.append("    ) \n");
        if (fromOrderNumber != null) {
            ksql.append("    and o.FNumber >= '" + fromOrderNumber + "' \n");
        }
        if (toOrderNumber != null) {
            ksql.append("    and o.FNumber <= '" + toOrderNumber + "' \n");
        }
        ksql.append(") \n");
        IRowSet periodRowSet = DbUtil.executeQuery((Context)ctx, (String)ksql.toString());
        try {
            while (periodRowSet.next()) {
                result.put(new Integer(periodRowSet.getInt("FNumber")), periodRowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static void requestMutexForOC(CoreUI ui) {
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        try {
            ui.setOprtState("CLOSING");
            ui.pubFireVOChangeListener("kUDur9AVMZPgQAB/AQAFDsR4mOE=_" + companyId);
        }
        catch (Throwable t) {
            ui.handUIException(t);
            SysUtil.abort();
        }
    }

    public static void releaseMutexForOC(CoreUI ui) {
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        try {
            ui.setOprtState("RELEASEALL");
            ui.pubFireVOChangeListener("kUDur9AVMZPgQAB/AQAFDsR4mOE=_" + companyId);
        }
        catch (Throwable t) {
            ui.handUIException(t);
        }
    }

    public static void requestMutexForOS(CoreUI ui) {
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        try {
            ui.setOprtState("CLOSING");
            ui.pubFireVOChangeListener("kUkliKs5ap7gQAB/AQATQ8R4mOE=_" + companyId);
        }
        catch (Throwable t) {
            ui.handUIException(t);
            SysUtil.abort();
        }
    }

    public static void releaseMutexForOS(CoreUI ui) {
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        try {
            ui.setOprtState("RELEASEALL");
            ui.pubFireVOChangeListener("kUkliKs5ap7gQAB/AQATQ8R4mOE=_" + companyId);
        }
        catch (Throwable t) {
            ui.handUIException(t);
        }
    }

    public static void setDefaultPeriod(CompanyOrgUnitInfo companyOrg, KDBizPromptBox prmtCalculatePeriod) throws BOSException, EASBizException {
        ISystemStatusCtrol control = SystemStatusCtrolFactory.getRemoteInstance();
        if (control.isStart(1010, companyOrg.getId().toString())) {
            PeriodInfo curPeriodInfo = control.getCacheCurrentPeriod(1010, companyOrg.getId().toString());
            prmtCalculatePeriod.setValue((Object)curPeriodInfo);
        }
        OrderCMUtils.filterCompanyOrgForPeriod(prmtCalculatePeriod, companyOrg);
    }

    public static boolean isPositiveNumber(String number) {
        Pattern pattern = Pattern.compile("^(([0-9]+\\.[0-9]*[1-9][0-9]*)|([0-9]*[1-9][0-9]*\\.[0-9]+)|([0-9]*[1-9][0-9]*))$");
        Matcher matcher = pattern.matcher(number);
        return matcher.find();
    }

    public static String getSTD_001Pk(Context ctx, String companyId, boolean create) throws BOSException, EASBizException {
        CostTypeInfo std001 = null;
        ICostType iCostType = null;
        iCostType = ctx != null ? CostTypeFactory.getLocalInstance(ctx) : CostTypeFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"STD_001", CompareType.EQUALS));
        if (iCostType.exists(filter)) {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            std001 = iCostType.getCostTypeCollection(view).get(0);
            return std001.getId().toString();
        }
        if (!create) {
            return "##########";
        }
        std001 = new CostTypeInfo();
        std001.setNumber("STD_001");
        std001.setName("\u57fa\u51c6\u6807\u51c6\u6210\u672c");
        std001.setDescription("\u8be5\u6210\u672c\u7c7b\u578b\u7528\u4e8e\u8bb0\u8d26\uff0c\u8bf7\u8c28\u614e\u5904\u7406\u3002");
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        std001.setCompany(company);
        std001.setIsIncludeScrapRatio(false);
        std001.setIsIncludeYieldRatio(false);
        std001.setLevel(CostTypeLevelEnum.product);
        std001.setPricePrecision(2);
        std001.setStatus(BillBaseStatusEnum.AUDITED);
        IObjectPK std001Pk = iCostType.addnew(std001);
        return std001Pk.toString();
    }

    public static void filterCompanyOrgForPeriod(KDBizPromptBox prmt, CompanyOrgUnitInfo orgInfo) throws EASBizException, BOSException {
        if (orgInfo == null) {
            throw new IllegalArgumentException("CompanyOrgUnit is NULL !");
        }
        PeriodInfo currPeriod = SystemStatusCtrolFactory.getRemoteInstance().getCacheCurrentPeriod(1010, orgInfo.getId().toString());
        EntityViewInfo evi = null;
        evi = prmt.getEntityViewInfo() != null ? prmt.getEntityViewInfo() : new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)orgInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)currPeriod.getBeginDate()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isAdjustPeriod", (Object)Boolean.FALSE, CompareType.EQUALS));
        try {
            filter.mergeFilter(evi.getFilter(), "AND");
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        evi.setFilter(filter);
        prmt.setEntityViewInfo(evi);
    }
}

