/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.order.fact.alloc.app.AbstractOCAllocFacadeControllerBean;
import com.kingdee.eas.ncm.order.fact.alloc.app.helper.CCOFeeAllocExceptionLog;
import com.kingdee.eas.ncm.order.fact.alloc.app.helper.OCAllocExceptionLog;
import com.kingdee.eas.ncm.order.fact.alloc.app.helper.OCCC2ActivityAllocExceptionLog;
import com.kingdee.eas.ncm.order.fact.alloc.app.helper.OCMaterialAllocExceptionLog;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class OCAllocFacadeControllerBean
extends AbstractOCAllocFacadeControllerBean {
    private static final long serialVersionUID = -3673145341061581735L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.order.fact.alloc.app.OCAllocFacadeControllerBean");
    private static final char CLF = '\n';

    @Override
    protected IRowSet _getLogData(Context ctx, String companyId, String periodId, String feeType) throws BOSException {
        Assert.that((feeType != null ? 1 : 0) != 0);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("companyId", companyId);
        param.put("periodId", periodId);
        param.put("ctx", (String)ctx);
        OCAllocExceptionLog log = null;
        if ("ccoFee".equals(feeType)) {
            log = new CCOFeeAllocExceptionLog(param);
        } else if ("matFee".equals(feeType)) {
            log = new OCMaterialAllocExceptionLog(param);
        } else if ("activityFee".equals(feeType)) {
            log = new OCCC2ActivityAllocExceptionLog(param);
        } else {
            Assert.that((boolean)false, (String)("not support fee type " + feeType));
        }
        return log == null ? null : log.getLogData();
    }

    @Override
    protected IRowSet _getMatAdjustData(Context ctx, String companyId, String periodId, String sourceBillId, String sourceBillEntryId, boolean forAdjust) throws BOSException {
        String physicalTbl = "T_IM_MaterialReqBillEntry";
        String resultTbl = "T_NCM_OCMatAllocResult";
        StringBuffer sb = this.makeCommonMatAdjustData(ctx, companyId, periodId, sourceBillId, sourceBillEntryId, forAdjust, resultTbl, null, physicalTbl);
        return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
    }

    private StringBuffer makeCommonMatAdjustData(Context ctx, String companyId, String periodId, String sourceBillId, String sourceBillEntryID, boolean forAdjust, String resultTbl, String adjustTbl, String physicalTbl) throws BOSException {
        Assert.that((companyId != null ? 1 : 0) != 0);
        Assert.that((periodId != null ? 1 : 0) != 0);
        Assert.that((sourceBillId != null ? 1 : 0) != 0);
        Assert.that((sourceBillEntryID != null ? 1 : 0) != 0);
        String logPhysicalTblName = null;
        String logPhysicalTblName_Adjust = null;
        StringBuffer sb = new StringBuffer();
        try {
            logPhysicalTblName = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)periodId, (String)resultTbl);
            if (forAdjust) {
                logPhysicalTblName_Adjust = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)periodId, (String)adjustTbl);
            }
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        if (forAdjust) {
            sb.append("Delete from ").append(logPhysicalTblName_Adjust).append('\n').append("WHERE FSourceBillID='").append(sourceBillId).append("' AND FSourceBillEntryID='").append(sourceBillEntryID).append("';").append(";").append("Insert Into ").append(logPhysicalTblName_Adjust).append(" (").append("FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FCommonQty ,FAssistQty ,FBaseUnitID ,FCommonUnitID ,FAssistUnitID ,FPrice ,FAmount ,FMaterialID ,FLot ,FBizDate ,FSeq ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect, AllocBillType , FIsRework, FAdminOrgUnitID , FWarehouseID").append(") ").append('\n').append("Select ").append("FID ,FCompanyID ,FCalculatePeriodID ,FCostCenterID ,FSourceBillID ,FSourceBillEntryID ,FCostObjectID ,FCostItemID ,FAllocStdID ,FAllocStdData ,FQty ,FCommonQty ,FAssistQty ,FBaseUnitID ,FCommonUnitID ,FAssistUnitID ,FPrice ,FAmount ,FMaterialID ,FLot ,FBizDate ,FSeq ,FCreatorID ,FCreateTime ,FAdjustUserID ,FAdjustTime ,FIsDirect, AllocBillType , FIsRework, FAdminOrgUnitID , FWarehouseID").append(" from ").append(logPhysicalTblName).append('\n').append("WHERE FCompanyID='").append(companyId).append("' AND FCalculatePeriodID='").append(periodId).append("' ").append('\n').append("  AND FSourceBillID='").append(sourceBillId).append("' AND FSourceBillEntryID='").append(sourceBillEntryID).append("'");
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            sb.delete(0, sb.length());
        }
        StringBuffer ksql = new StringBuffer();
        ksql.append("select \n");
        ksql.append("    D.FID, o.FID FOrderID, o.FNumber FOrderNumber, s.FName_l2 FOrderStorageName, \n");
        ksql.append("    op.FName_l2 FOperationName, \n");
        ksql.append("    om.FName_l2 FOrderMaterailName, om.FModel FOrderMaterialModel, o.FLot FOrderMaterialLot, \n");
        ksql.append("    D.FAllocStdData, D.FQty, D.FBaseQty, D.FAssistQty, D.FPrice, D.FAmount,");
        ksql.append("    D.FCostItemID, ci.FNumber As FCostItemNumber, ci.FName_L2 As FCostItemName,");
        ksql.append("    D.FAllocStdID, cd.FNumber As FAllocStdNumber, cd.FName_L2 As FAllocStdName, ");
        ksql.append("    D.FCreatorID, CR.FNumber As FCreatorNumber, CR.FName_L2 As FCreatorName, D.FCreateTime,");
        ksql.append("    D.FAdjustUserID, AD.FNumber As AdjustUserNumber, AD.FName_L2 As FAdjustUserName,D.FAdjustTime, ");
        ksql.append("    BU.FQtyPrecision, CY.FPrecision As FAmountPrecision, MT.FPricePrecision ");
        if (forAdjust) {
            ksql.append("FROM ").append(logPhysicalTblName_Adjust).append(" D ").append('\n');
        } else {
            ksql.append("FROM ").append(logPhysicalTblName).append(" D ").append('\n');
        }
        ksql.append("left join T_MM_ManufactureOrder o on o.FID = D.FOrderID \n");
        ksql.append("left join T_ORG_Storage s on s.FID = o.FStorageOrgUnitID \n");
        ksql.append("left join T_MM_Operation op on op.FID = D.FOperationID \n");
        ksql.append("left join T_BD_Material om on om.FID = o.FMaterialID \n");
        ksql.append("left join T_IM_MaterialReqBillEntry ME ON ME.FID = D.FSourceBillEntryID ");
        ksql.append("left join T_BD_Material MT ON ME.FMaterialID = MT.FID ");
        ksql.append("left join T_NCM_CostDriver cd ON cd.FID = D.FAllocStdID ");
        ksql.append("left join T_BD_MeasureUnit BU ON ME.FUnitID = BU.FID ");
        ksql.append("left join T_ORG_Company COM ON ME.FCompanyOrgUnitID = COM.FID ");
        ksql.append("left join T_BD_Currency CY ON COM.FBaseCurrencyID = CY.FID ");
        ksql.append("left join T_NCM_CostItem ci ON ci.FID = D.FCostItemID ");
        ksql.append("left join T_PM_User CR ON D.FCreatorID = CR.FID ");
        ksql.append("left join T_PM_User AD ON D.FAdjustUserID = AD.FID ");
        ksql.append("where D.FCompanyID = '" + companyId + "' \n");
        ksql.append("and D.FCalculatePeriodID= '" + periodId + "'");
        ksql.append("and D.FSourceBillID = '" + sourceBillId + "' \n");
        ksql.append("and D.FSourceBillEntryID = '" + sourceBillEntryID + "' \n");
        ksql.append("order by o.FNumber ");
        return ksql;
    }

    @Override
    protected IRowSet _getCCOFeeAdjustData(Context ctx, String companyId, String periodId, String sourceBillId, String sourceBillEntryId, boolean forAdjust) throws BOSException {
        Assert.that((companyId != null ? 1 : 0) != 0);
        Assert.that((periodId != null ? 1 : 0) != 0);
        Assert.that((sourceBillId != null ? 1 : 0) != 0);
        Assert.that((sourceBillEntryId != null ? 1 : 0) != 0);
        StringBuffer sb = new StringBuffer();
        String physicalTblData = null;
        try {
            sb.append("(select a.FID, a.FCompanyOrg as FCompanyID, a.FCalculatePeriod as FCalculatePeriodID,").append('\n').append("        a.FExpenseID as FExpenseID, a.FCostCenterID, a.FDepartmentID, a.FSourceBillID as FSourceBillEntryID,").append('\n').append("        a.FCreatorID, a.FCreateTime, a.FLastUpdateUserID as FAdjustUserID, a.FLastUpdateTime as FAdjustTime,").append('\n').append("        b.FAmount, b.FQty, b.FPrice, b.FCostDriverData, a.FCostDriverID as FCostDriverID,").append('\n').append("        c.FCostCenterGroupID,d.FCostItemID, c.FID as FSourceBillID, d.FManufacturerID").append('\n').append("   from T_NCM_OrderCCFeeBill a, T_NCM_OrderCCFeeBillEntry b, T_NCM_OrderCCOFeeBill c, T_NCM_OrderCCOFeeEntryBill d").append('\n').append("  where a.FID = b.FParentID and a.FSourceBillID = d.FID and d.FParentID = c.FID").append('\n').append("    and a.FSourceBillID = ''{0}'')");
            physicalTblData = MessageFormat.format(sb.toString(), sourceBillEntryId);
            sb.delete(0, sb.length());
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        sb.append("SELECT D.FID,D.FCostCenterID,O.FNumber As FCostCenterNumber, O.FName_L2 As FCostCenterName,").append('\n').append("       D.FDepartmentID,dp.Fnumber as Fdepartmentnumber,dp.Fname_l2 as Fdepartmentname,").append('\n').append("       D.FCostDriverData,D.FQty, D.FPrice, D.FAmount,").append('\n').append("       m.FNumber as FManufantureNumber,stor.FName_l2 as FStorageName,").append('\n').append("       I.FID,I.FNumber as FCostItemNumber, I.FName_L2 as FCostItemName, ").append('\n').append("       D.FCostDriverID, S.FNumber As FCostDriverNumber, S.FName_L2 As FCostDriverName, ").append('\n').append("       D.FCreatorID, CR.FNumber As FCreatorNumber, CR.FName_L2 As FCreatorName,D.FCreateTime,").append('\n').append("       D.FAdjustUserID, AD.FNumber As AdjustUserNumber, AD.FName_L2 As FAdjustUserName,D.FAdjustTime,").append('\n').append("       CY.FPrecision As FAmountPrecision,Isnull(UNT.FQtyPrecision,8)As FQtyPrecision, Isnull(EXP.FPricePrecision,8)As FPricePrecision ").append('\n').append("FROM ").append(physicalTblData).append(" D ").append('\n').append("LEFT OUTER JOIN T_NCM_CostDriver S ON D.FCostDriverID = S.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_CostCenter O ON D.FCostCenterID = O.FID ").append('\n').append("LEFT OUTER JOIN T_NCM_CostItem I ON D.FCostItemID = I.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_BaseUnit dp ON D.FDepartmentID = dp.FID ").append('\n').append("LEFT OUTER JOIN T_PM_User CR ON D.FCreatorID = CR.FID ").append('\n').append("LEFT OUTER JOIN T_PM_User AD ON D.FAdjustUserID = AD.FID ").append('\n').append("LEFT OUTER JOIN T_ORG_Company COM ON D.FCompanyID = COM.FID ").append('\n').append("LEFT OUTER JOIN T_BD_Currency CY ON COM.FBaseCurrencyID = CY.FID ").append('\n').append("LEFT OUTER JOIN T_NCM_Expense EXP ON D.FExpenseID = EXP.FID ").append('\n').append("LEFT OUTER JOIN T_BD_MeasureUnit UNT ON EXP.FUnitID = UNT.FID ").append('\n').append("LEFT OUTER JOIN T_MM_ManufactureOrder m ON d.FManufacturerID = m.FID ").append('\n').append("LEFT OUTER JOIN T_Org_Storage stor ON stor.FID = m.FStorageOrgUnitID ").append('\n').append("").append('\n').append("WHERE D.FCompanyID ='").append(companyId).append("' AND D.FCalculatePeriodID='").append(periodId).append("'").append('\n').append("  AND D.FSourceBillID='").append(sourceBillId).append("' AND D.FSourceBillEntryID='").append(sourceBillEntryId).append("'").append('\n').append("Order by O.FNumber ");
        try {
            return DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _checkCCOFeeIsAlloced(Context ctx, String companyID, String periodID, FilterInfo filter) throws BOSException, EASBizException {
        HashSet<String> billEntryIDSet = new HashSet<String>();
        String entryID = null;
        MetaDataPK mdPk = new MetaDataPK("com.kingdee.eas.ncm.order.fact.bill.app", "OrderCCOFeeBillQuery");
        try {
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mdPk);
            IRowSet rs = null;
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter(filter);
            exec.setObjectView(ev);
            rs = exec.executeQuery();
            while (rs.next()) {
                entryID = rs.getString("entries.id");
                if (entryID == null) continue;
                billEntryIDSet.add(entryID);
            }
            StringBuffer checkSql = new StringBuffer();
            checkSql.append("select count(1) from T_NCM_OrderCCFeeBill \n").append("  where FCompanyOrg = '" + companyID + "' \n").append("  AND FCalculatePeriod = '" + periodID + "' \n").append("  AND FSourceBillID in (?) \n");
            List rsList = NCMServerUtils.executeSQLByBatch((Context)ctx, (String)checkSql.toString(), null, billEntryIDSet);
            int rsSize = rsList.size();
            for (int rsNum = 0; rsNum < rsSize; ++rsNum) {
                ResultSet sumResult = (ResultSet)rsList.get(rsNum);
                while (sumResult.next()) {
                    if (sumResult.getInt(1) == 0) continue;
                    return true;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected IRowSet _getCC2ActivityAdjustData(Context ctx, String companyId, String periodId, String sourceBillId, String sourceBillEntryId, boolean forAdjust) throws BOSException {
        Assert.that((companyId != null ? 1 : 0) != 0);
        Assert.that((periodId != null ? 1 : 0) != 0);
        Assert.that((sourceBillId != null ? 1 : 0) != 0);
        Assert.that((sourceBillEntryId != null ? 1 : 0) != 0);
        StringBuffer sb = new StringBuffer();
        String cc2ActivityTable = null;
        String activity2OrderTable = null;
        try {
            cc2ActivityTable = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)periodId, (String)"T_NCM_OCCC2ActivityAlloc");
            activity2OrderTable = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)periodId, (String)"T_NCM_OCActivity2OrderAlloc");
            sb.append(" select a.fid as FSourceBillID, b.fid as FSourceBillEntryID,").append('\n').append(" c.fid as FActivityID, c.fnumber as FActivityNumber, c.fname_l2 as FActivityName,").append('\n').append(" f.fnumber as FOrderNumber, f.flot as Flot,").append('\n').append(" g.fname_l2 as FStorageName, h.fname_l2 as FMaterialName,").append('\n').append(" isnull(e.forderqty, d.factivitqty) as forderqty, ").append('\n').append(" isnull(e.fprice, d.fprice) as fprice, ").append('\n').append(" isnull(e.famount, d.famount) as famount,").append('\n').append(" d.fcostdriveramount as FCostCenterDriverAmount, ").append('\n').append(" e.fcostdriveramount as FActivityDriverAmount,").append('\n').append(" i.fname_l2 as FCostCenterDriverName, j.fname_l2 as FActivityDriverName ").append('\n').append(" from T_NCM_OrderCCFeeBill a ").append('\n').append(" inner join t_Ncm_Orderccfeebillentry b on a.fid = b.fparentid").append('\n').append(" inner join ").append(cc2ActivityTable).append('\n').append(" d on b.fid = d.fsourcebillentryid").append('\n').append(" LEFT OUTER JOIN ").append(activity2OrderTable).append('\n').append(" e on d.fid = e.fcc2activityid").append('\n').append(" LEFT OUTER JOIN T_NCM_Activity c on d.factivityid = c.fid ").append('\n').append(" LEFT OUTER JOIN T_MM_ManufactureOrder f on e.forderid = f.fid").append('\n').append(" LEFT OUTER JOIN T_ORG_Storage g on f.Fstorageorgunitid = g.fid").append('\n').append(" LEFT OUTER JOIN T_BD_Material h on f.fmaterialid = h.fid").append('\n').append(" LEFT OUTER JOIN T_NCM_CostDriver i on d.fcostdriverid = i.fid").append('\n').append(" LEFT OUTER JOIN T_NCM_CostDriver j on e.fcostdriverid = j.fid").append('\n').append(" where b.fid = ? order by c.fnumber").append('\n');
            return DbUtil.executeQuery((Context)ctx, (String)sb.toString(), (Object[])new String[]{sourceBillEntryId});
        }
        catch (Exception e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
    }

    @Override
    protected boolean _checkActivityFeeIsAlloced(Context ctx, String companyID, String periodID, FilterInfo filter) throws BOSException {
        HashSet<String> billEntryIDSet = new HashSet<String>();
        String entryID = null;
        MetaDataPK mdPk = new MetaDataPK("com.kingdee.eas.ncm.order.fact.bill.app", "OrderCCFeeBillQuery");
        try {
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mdPk);
            IRowSet rs = null;
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter(filter);
            exec.setObjectView(ev);
            rs = exec.executeQuery();
            while (rs.next()) {
                entryID = rs.getString("entries.id");
                if (entryID == null) continue;
                billEntryIDSet.add(entryID);
            }
            String cc2ActivityTable = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)periodID, (String)"T_NCM_OCCC2ActivityAlloc");
            StringBuffer checkSql = new StringBuffer(200);
            checkSql.append("select count(1) from \n").append(cc2ActivityTable).append("  where FCompanyID = '" + companyID + "' \n").append("  AND FCalculatePeriodID = '" + periodID + "' \n").append("  AND FSourceBillEntryID in (?) \n");
            List rsList = NCMServerUtils.executeSQLByBatch((Context)ctx, (String)checkSql.toString(), null, billEntryIDSet);
            int rsSize = rsList.size();
            for (int rsNum = 0; rsNum < rsSize; ++rsNum) {
                ResultSet sumResult = (ResultSet)rsList.get(rsNum);
                while (sumResult.next()) {
                    if (sumResult.getInt(1) == 0) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"_checkActivityFeeIsAlloced", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }
}

