/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.app.fee;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.FeeData;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class CCOFeeData
extends FeeData {
    private static Logger logger = Logger.getLogger((String)CCOFeeData.class.getName());
    private IMetaDataPK mdPk = new MetaDataPK("com.kingdee.eas.ncm.order.fact.bill.app", "OrderCCOFeeBillQuery");

    public CCOFeeData(Map param) {
        super(param);
    }

    @Override
    public IRowSet getIndirectFeeData() throws AllocateException {
        FilterInfo filter = this.getAllocFilter();
        Context ctx = (Context)this.param.get("ctx");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        IRowSet rs = null;
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        try {
            exec.setObjectView(ev);
            rs = exec.executeQuery();
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e1);
        }
        return rs;
    }

    @Override
    public String getDirectFeeDataSql() throws AllocateException {
        return null;
    }

    @Override
    public String getIndirectFeeDataSql() throws AllocateException {
        FilterInfo filter = this.getAllocFilter();
        String sql = null;
        Context ctx = (Context)this.param.get("ctx");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        try {
            exec.setObjectView(ev);
            sql = exec.getSQL();
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e1);
        }
        return sql;
    }

    public String getCountIndirectFeeDataSql() throws AllocateException {
        String sql = this.getIndirectFeeDataSql();
        int index = sql.indexOf("FROM");
        sql = "select count(*) from " + sql.substring(index + 4);
        return sql.toString();
    }

    @Override
    public void clearPreAllocResult(String tblResult, String tblToAlloc) throws AllocateException {
        FilterInfo filter = this.getAllocFilter();
        Context ctx = (Context)this.param.get("ctx");
        boolean bFilter_all = false;
        if (this.param.containsKey("bFilter_all")) {
            bFilter_all = this.param.get("bFilter_all").equals(String.valueOf(true));
        }
        if (bFilter_all) {
            try {
                NCMDynamicTableManager.DeleteTable((Context)ctx, (String)tblResult, null);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
            }
            return;
        }
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        try {
            exec.setObjectView(ev);
            String sql = exec.getSQL();
            if (this.param.containsKey("isCCOOnlyUnAlloc") && this.param.get("isCCOOnlyUnAlloc") != null) {
                String join = " LEFT OUTER JOIN " + tblResult + " AS \"TBLRESULT\" \n";
                join = join + " ON \"TBLRESULT\".FSourceBillEntryID = \"ENTRIES\".FID \n";
                join = join + " WHERE \n";
                sql = sql.replaceAll("WHERE", join);
            }
            StringBuffer finalSql = new StringBuffer();
            finalSql.append("truncate table ").append(tblToAlloc).append("; \n").append("Insert into ").append(tblToAlloc).append(" select b.FID from T_NCM_OrderCCOFeeBill b, (SELECT \"ENTRIES.ID\" id FROM (").append(sql).append(")A) c where b.FSourceBillID=c.id; \n").append("truncate table " + tblResult + ";");
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)finalSql.toString(), (String)";");
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e1);
        }
    }

    protected FilterInfo getAllocFilter() throws AllocateException {
        FilterInfo filter = (FilterInfo)this.param.get("ccoAllocFilterInfo");
        if (filter != null) {
            return (FilterInfo)filter.clone();
        }
        try {
            filter = new FilterInfo();
            Context ctx = (Context)this.param.get("task.context");
            String companyId = (String)this.param.get("companyId");
            String periodId = (String)this.param.get("periodId");
            filter.getFilterItems().add(new FilterItemInfo("calculatePeriod.id", (Object)periodId));
            filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)String.valueOf(4)));
            filter.getFilterItems().add(new FilterItemInfo("companyOrg.id", (Object)companyId));
            return filter;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }
}

