/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.app.fee;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.FeeData;
import com.kingdee.eas.ncm.order.fact.alloc.app.task.OCMaterialAllocTask;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MatFeeData
extends FeeData {
    private static Logger logger = Logger.getLogger((String)MatFeeData.class.getName());
    private OCMaterialAllocTask task = null;
    protected IMetaDataPK mdPk = null;
    private String tblAllocResult = null;
    private String tblToAlloc = null;
    private FilterInfo allFilter = null;
    private String allFeeDataSql = null;
    private String allocFeeDataSql = null;
    private String directFeeDataSql = null;
    private String indirectFeeDataSql = null;

    public MatFeeData(OCMaterialAllocTask task) {
        super(task.getParam());
        this.task = task;
        this.mdPk = new MetaDataPK("com.kingdee.eas.ncm.order.fact.alloc.app.OCMaterialAllocQuery");
    }

    private String getAllFeeDataSql() throws AllocateException {
        if (this.allFeeDataSql != null) {
            return this.allFeeDataSql;
        }
        Context ctx = this.task.getContext();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        FilterInfo filter = this.getAllFilter();
        try {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            exec.setObjectView(evi);
            this.allFeeDataSql = exec.getSQL();
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e1);
        }
        return this.allFeeDataSql;
    }

    private String getAllocFeeDataSql() throws AllocateException {
        if (this.allocFeeDataSql != null) {
            return this.allocFeeDataSql;
        }
        Context ctx = this.task.getContext();
        String tblResult = this.getTblAllocResult();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        FilterInfo filter = this.getAllocFilter();
        try {
            if (this.isOnlyAllocUnAlloc()) {
                StringBuffer notexistsSql = new StringBuffer();
                notexistsSql.append("select top 1 1 \n");
                notexistsSql.append("from " + tblResult + "  \n");
                notexistsSql.append("where FSourceBillEntryID = \"ENTRY\".FID \n");
                FilterInfo notexistsFilter = new FilterInfo();
                notexistsFilter.getFilterItems().add(new FilterItemInfo(null, (Object)notexistsSql.toString(), CompareType.NOTEXISTS));
                filter.mergeFilter(notexistsFilter, "and");
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            exec.setObjectView(evi);
            this.allocFeeDataSql = exec.getSQL();
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e1);
        }
        return this.allocFeeDataSql;
    }

    @Override
    public String getDirectFeeDataSql() throws AllocateException {
        if (this.directFeeDataSql != null) {
            return this.directFeeDataSql;
        }
        Context ctx = this.task.getContext();
        String tblResult = this.getTblAllocResult();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        FilterInfo filter = this.getAllocFilter();
        try {
            FilterInfo directFilter = new FilterInfo();
            directFilter.getFilterItems().add(new FilterItemInfo("sourceBillType.billTypeGroup", (Object)new Integer(67), CompareType.EQUALS));
            filter.mergeFilter(directFilter, "and");
            if (this.isOnlyAllocUnAlloc()) {
                StringBuffer notexistsSql = new StringBuffer();
                notexistsSql.append("select top 1 1 \n");
                notexistsSql.append("from " + tblResult + "  \n");
                notexistsSql.append("where FSourceBillEntryID = \"ENTRY\".FID \n");
                FilterInfo notexistsFilter = new FilterInfo();
                notexistsFilter.getFilterItems().add(new FilterItemInfo(null, (Object)notexistsSql.toString(), CompareType.NOTEXISTS));
                filter.mergeFilter(notexistsFilter, "and");
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            exec.setObjectView(evi);
            this.directFeeDataSql = exec.getSQL();
            int index = this.directFeeDataSql.indexOf("ORDER BY");
            this.directFeeDataSql = this.directFeeDataSql.substring(0, index);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e1);
        }
        return this.directFeeDataSql;
    }

    public String getCountDirectFeeDataSql() throws AllocateException {
        String sql = this.getDirectFeeDataSql();
        int index = sql.indexOf("FROM");
        sql = "select count(*) from " + sql.substring(index + 4);
        index = sql.indexOf("ORDER BY");
        if (index >= 0) {
            sql = sql.substring(0, index);
        }
        return sql.toString();
    }

    public String getCheckCostItemDataSql() throws AllocateException {
        String temp = this.getAllocFeeDataSql();
        int index = temp.indexOf("FROM");
        temp = temp.substring(index + 4);
        index = temp.indexOf("ORDER BY");
        temp = temp.substring(0, index);
        temp = temp.replaceFirst("WHERE", " LEFT JOIN T_BD_MaterialCost mc ON mc.FMaterialID = \"ENTRY\".FMaterialID WHERE ");
        StringBuffer ksql = new StringBuffer();
        ksql.append("select top 50 \n");
        ksql.append("\"MATERIALREQBILL\".FNumber, \"ENTRY\".FSeq \n");
        ksql.append("from \n");
        ksql.append(temp).append(" \n");
        ksql.append("and (\"ENTRY\".FCostItemID is null and mc.FDefaultCostItemID is null)");
        ksql.append("order by \n");
        ksql.append("\"MATERIALREQBILL\".FNumber ASC, \"ENTRY\".FSeq ASC \n");
        return ksql.toString();
    }

    @Override
    public IRowSet getIndirectFeeData() throws AllocateException {
        return null;
    }

    @Override
    public String getIndirectFeeDataSql() throws AllocateException {
        if (this.indirectFeeDataSql != null) {
            return this.indirectFeeDataSql;
        }
        Context ctx = this.task.getContext();
        String tblResult = this.getTblAllocResult();
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)this.mdPk);
        FilterInfo filter = this.getAllocFilter();
        try {
            FilterInfo directFilter = new FilterInfo();
            directFilter.getFilterItems().add(new FilterItemInfo("sourceBillType.billTypeGroup", (Object)new Integer(67), CompareType.NOTEQUALS));
            filter.mergeFilter(directFilter, "and");
            if (this.isOnlyAllocUnAlloc()) {
                StringBuffer notexistsSql = new StringBuffer();
                notexistsSql.append("select top 1 1 \n");
                notexistsSql.append("from " + tblResult + "  \n");
                notexistsSql.append("where FSourceBillEntryID = \"ENTRY\".FID \n");
                FilterInfo notexistsFilter = new FilterInfo();
                notexistsFilter.getFilterItems().add(new FilterItemInfo(null, (Object)notexistsSql.toString(), CompareType.NOTEXISTS));
                filter.mergeFilter(notexistsFilter, "and");
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            exec.setObjectView(evi);
            this.indirectFeeDataSql = exec.getSQL();
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e1);
        }
        return this.indirectFeeDataSql;
    }

    @Override
    public void clearPreAllocResult(String tblResult, String tblToAlloc) throws AllocateException {
        Context ctx = this.task.getContext();
        tblResult = this.getTblAllocResult();
        if (this.param.containsKey("bMaterialAllocFilter_all") && this.param.get("bMaterialAllocFilter_all").equals(String.valueOf(true))) {
            try {
                DbUtil.execute((Context)ctx, (String)("truncate table " + tblResult));
            }
            catch (BOSException e1) {
                logger.error((Object)"", (Throwable)e1);
                throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e1);
            }
            return;
        }
        StringBuffer ksql = new StringBuffer();
        tblToAlloc = this.getTblToAlloc();
        ksql.append("truncate table " + tblToAlloc + ";");
        String sql = this.getAllFeeDataSql();
        int index = sql.indexOf("FROM");
        sql = "select distinct \"ENTRY\".FID from " + sql.substring(index + 4);
        index = sql.indexOf("ORDER BY");
        sql = sql.substring(0, index);
        ksql.append("insert into " + tblToAlloc + " " + sql + "; \n");
        ksql.append("delete from " + tblResult + "  \n");
        ksql.append("where not exists ( \n");
        ksql.append("    select top 1 1 from " + tblToAlloc + "  \n");
        ksql.append("    where FSourceBillEntryID = " + tblResult + ".FSourceBillEntryID \n");
        ksql.append("); \n");
        ksql.append("truncate table " + tblToAlloc + ";");
        sql = this.getAllocFeeDataSql();
        index = sql.indexOf("FROM");
        sql = "select distinct \"ENTRY\".FID from " + sql.substring(index + 4);
        index = sql.indexOf("ORDER BY");
        sql = sql.substring(0, index);
        ksql.append("insert into " + tblToAlloc + " " + sql + "; \n");
        ksql.append("delete from " + tblResult + "  \n");
        ksql.append("where exists ( \n");
        ksql.append("    select top 1 1 from " + tblToAlloc + "  \n");
        ksql.append("    where FSourceBillEntryID = " + tblResult + ".FSourceBillEntryID \n");
        ksql.append("); \n");
        try {
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)ksql.toString(), (String)";");
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e1);
        }
    }

    protected boolean isOnlyAllocUnAlloc() {
        if (this.param.containsKey("isMatOnlyUnAlloc")) {
            Object value = this.param.get("isMatOnlyUnAlloc");
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                return "true".equals((String)value);
            }
        }
        return false;
    }

    protected FilterInfo getAllFilter() throws AllocateException {
        if (this.allFilter != null) {
            return (FilterInfo)this.allFilter.clone();
        }
        try {
            this.allFilter = new FilterInfo();
            Context ctx = this.task.getContext();
            String companyId = this.task.getCompanyId();
            String periodId = this.task.getPeriodId();
            PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)periodId)));
            this.allFilter.getFilterItems().add(new FilterItemInfo("year", (Object)String.valueOf(period.getPeriodYear())));
            this.allFilter.getFilterItems().add(new FilterItemInfo("period", (Object)String.valueOf(period.getPeriodNumber())));
            this.allFilter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)String.valueOf(4)));
            this.allFilter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId));
            HashSet<Integer> ccoTypeSet = new HashSet<Integer>();
            ccoTypeSet.add(new Integer(0));
            this.allFilter.getFilterItems().add(new FilterItemInfo("costCenterOrgUnit.costCenterType", ccoTypeSet, CompareType.INCLUDE));
            this.allFilter.getFilterItems().add(new FilterItemInfo("transactionType.isManuCostCalculate", (Object)String.valueOf(true)));
            this.allFilter.getFilterItems().add(new FilterItemInfo("sourceBillType.billTypeGroup", (Object)new Integer(67), CompareType.EQUALS));
            return this.getAllFilter();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
    }

    protected FilterInfo getAllocFilter() throws AllocateException {
        FilterInfo filter = (FilterInfo)this.param.get("materialAllocFilterInfo");
        if (filter != null) {
            return (FilterInfo)filter.clone();
        }
        return this.getAllFilter();
    }

    public String getTblAllocResult() throws AllocateException {
        if (this.tblAllocResult != null) {
            return this.tblAllocResult;
        }
        this.task.info("\u53d6\u6750\u6599\u8d39\u7528\u5206\u914d\u7ed3\u679c\u8868...");
        try {
            this.tblAllocResult = DynamicTableManager.getPhysicalTblNameWithCreate((Context)this.task.getContext(), (String)this.task.getCompanyId(), (String)this.task.getPeriodId(), (String)"T_NCM_OCMatAllocResult");
            if (this.task.isDebugEnabled()) {
                this.task.debug("\u6750\u6599\u8d39\u7528\u5206\u914d\u7ed3\u679c\u8868\uff1a" + this.tblAllocResult);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
        }
        this.task.info("\u53d6\u6750\u6599\u8d39\u7528\u5206\u914d\u7ed3\u679c\u8868\u5b8c\u6210\u3002");
        return this.tblAllocResult;
    }

    public String getTblToAlloc() throws AllocateException {
        if (this.tblToAlloc != null) {
            return this.tblToAlloc;
        }
        this.task.info("\u521b\u5efa\u5f85\u5206\u914d\u8d39\u7528\u5206\u5f55ID\u6570\u636e\u8868...");
        String createSqlTempBillEntryID = "create table t_ncm_BillEntryIDDataList (FSourceBillEntryID VARCHAR(44))";
        if (this.task.isDebugEnabled()) {
            this.task.debug(createSqlTempBillEntryID);
        }
        try {
            this.tblToAlloc = TempTablePool.getInstance((Context)this.task.getContext()).createTempTable(createSqlTempBillEntryID);
            if (this.task.isDebugEnabled()) {
                this.task.debug("\u5f85\u5206\u914d\u8d39\u7528\u5206\u5f55ID\u6570\u636e\u8868\uff1a" + this.tblToAlloc);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
        }
        return this.tblToAlloc;
    }

    public void release() throws Throwable {
        if (this.tblToAlloc != null) {
            try {
                TempTablePool.getInstance((Context)this.task.getContext()).releaseTable(this.tblToAlloc);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e);
            }
        }
    }
}

