/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.ncm.CostDriverInfo;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.allcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.FeeData;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory.CCOAllocator;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.info.IFeeInfo;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.table.AllocTable;
import com.kingdee.eas.ncm.order.fact.alloc.app.helper.OCAllocExceptionLog;
import com.kingdee.eas.ncm.order.fact.bill.CostDriverSetByCCOCollection;
import com.kingdee.eas.ncm.order.fact.bill.CostDriverSetByCCOFactory;
import com.kingdee.eas.ncm.order.fact.bill.ICostDriverSetByCCO;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoCCOAllocator
extends CCOAllocator {
    private static Logger logger = Logger.getLogger((String)AutoCCOAllocator.class.getName());
    private CostDriverSetByCCOCollection costDriverSettingCache = null;
    private OCAllocExceptionLog _logger;

    public AutoCCOAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
        Assert.that((boolean)param.containsKey("logger"));
        this._logger = (OCAllocExceptionLog)param.get("logger");
    }

    @Override
    public void preCheck() throws AllocateException {
        super.preCheck();
    }

    @Override
    public AllocTable getAllocTable() {
        try {
            return super.getAllocTable();
        }
        catch (AllocateException e) {
            this._logger.addLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
            return null;
        }
    }

    @Override
    public void preProcess() {
        try {
            super.preProcess();
        }
        catch (AllocateException e) {
            this._logger.addLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
    }

    @Override
    public CostDriverInfo getAllocStdSetting(IFeeInfo currFee) {
        CostDriverInfo setting;
        Context ctx = (Context)this._param.get("ctx");
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        if (this.costDriverSettingCache == null) {
            StringBuffer sb = new StringBuffer();
            try {
                ICostDriverSetByCCO fact = CostDriverSetByCCOFactory.getLocalInstance(ctx);
                sb.append("Select costDriver.*,expense.*,costCenterGroup.* where company = '").append(companyId).append("' AND calculatePeriod = '").append(periodId).append("' AND costDriver.id is not null ");
                this.costDriverSettingCache = fact.getCostDriverSetByCCOCollection(sb.toString());
            }
            catch (BOSException e) {
                this._logger.addLog(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e));
                logger.error((Object)"", (Throwable)e);
            }
        }
        if ((setting = this.getAllocStdFromCache(currFee)) == null) {
            this._logger.addLog(new AllocateException(AllocateException.ITEM_ALLOC_NOTSET, new Object[]{currFee.GetExpenseNumber().concat(" ").concat(currFee.GetExpenseName()), currFee.GetCostCenterGroupNumber().concat(" ").concat(currFee.GetCostCenterGroupName())}));
        }
        return setting;
    }

    @Override
    public FeeData getFeeDataControl() {
        try {
            return super.getFeeDataControl();
        }
        catch (AllocateException e) {
            this._logger.addLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
            return null;
        }
    }

    @Override
    public void allocDirect() {
        try {
            super.allocDirect();
        }
        catch (AllocateException e) {
            this._logger.addLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
    }

    @Override
    public void allocIndirect(IFeeInfo currFee, int position) {
        try {
            super.allocIndirect(currFee, position);
        }
        catch (AllocateException e) {
            this._logger.addLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
    }

    @Override
    public Map processResult() {
        HashMap<String, String> ret = null;
        try {
            ret = super.processResult();
        }
        catch (AllocateException e) {
            this._logger.addLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
        if (ret == null) {
            ret = new HashMap<String, String>();
        } else {
            ret.put("HalfAlloc", String.valueOf(true));
        }
        if (this._logger.getLogCount() > 0) {
            IRowSet logData = this._logger.getLogData();
            ret.put("HasError", String.valueOf(true));
            ret.put("logData", (String)logData);
        }
        return ret;
    }

    @Override
    public void endProcess() {
        try {
            super.endProcess();
        }
        catch (AllocateException e) {
            this._logger.addLog(e);
            logger.error((Object)"", (Throwable)((Object)e));
        }
    }

    private CostDriverInfo getAllocStdFromCache(IFeeInfo currFee) {
        String expenseId = null;
        String costCenterGroupId = null;
        for (int i = 0; i < this.costDriverSettingCache.size(); ++i) {
            expenseId = this.costDriverSettingCache.get(i).getExpense().getId().toString();
            costCenterGroupId = this.costDriverSettingCache.get(i).getCostCenterGroup().getId().toString();
            if (!currFee.GetExpenseId().equals(expenseId) || !currFee.GetCostCenterGroupId().equals(costCenterGroupId)) continue;
            return this.costDriverSettingCache.get(i).getCostDriver();
        }
        return null;
    }

    @Override
    public void processAllocateException(AllocateException e, String possibleReason, String adviceHandle) throws AllocateException {
        if (possibleReason == null || adviceHandle == null) {
            this._logger.addLog(e);
        } else {
            this._logger.addLog(e, possibleReason, adviceHandle);
        }
    }

    @Override
    protected boolean isOnlyNotZero_AllcoStdData() {
        return false;
    }

    @Override
    protected boolean crossCostObjectSuiteRange(IFeeInfo currFee) throws AllocateException {
        return false;
    }
}

