/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.ncm.CostDriverInfo;
import com.kingdee.eas.ncm.bill.app.Alloc.AllocatorFactory.Fee.Info.MatFeeInfoAdapter;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.allcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.FeeData;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory.Allocator;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.info.IFeeInfo;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.table.AllocTable;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BaseAllocator
extends Allocator {
    protected AllocTable _allocTable;
    private FeeData _feeData;
    private String _tblResult = null;
    protected String _tblAllocData = null;
    protected String _tblAllocObjectRange = null;
    protected CostDriverInfo _costDriver = null;
    protected static final char CLF = '\n';
    protected static final Logger log = Logger.getLogger((String)BaseAllocator.class.getName());
    protected String lastCostCenterId = null;
    protected boolean bRangeChanged = false;
    protected boolean bMaterialChanged = false;

    public BaseAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
    }

    @Override
    public void preCheck() throws AllocateException {
    }

    @Override
    public void preProcess() throws AllocateException {
        this.getFeeData().clearPreAllocResult(this.getAllocTable().GetResultTable(), this.getAllocTable().GetToAllocBillEntryIDTable());
        this.preAllocProcess();
        this.fillObjectRange();
        this.fillAllocTempData();
        this.getAllocTable().CreateTempTableIndexs();
    }

    @Override
    public void allocDirect() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String userId = this._param.get("userId").toString();
        Context ctx = (Context)this._param.get("ctx");
        this.insertDirectData(ctx, companyId, periodId, userId);
        this.updateDefaultCostItem(ctx, companyId, periodId);
        this.removeNoCostItem(ctx, companyId, periodId);
        this.removeInvalidCostObject(ctx, companyId, periodId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void allocIndirect(IFeeInfo currFee, int position) throws AllocateException {
        Context ctx;
        block17: {
            boolean cancelAlloc;
            block16: {
                boolean allocStdChanged;
                boolean isDirectMatQtyStrategy;
                block15: {
                    String materialId;
                    CostDriverInfo std;
                    block14: {
                        block13: {
                            block12: {
                                block11: {
                                    cancelAlloc = false;
                                    ctx = (Context)this._param.get("ctx");
                                    try {
                                        log.debug((Object)"--E.00,begin allocIndirect");
                                        cancelAlloc = this.dataIsVouchered(currFee);
                                        if (!cancelAlloc) break block11;
                                    }
                                    catch (Throwable throwable) {
                                        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                                        log.debug((Object)"--E.00,end allocIndirect");
                                        this.commitAllocResult((position & 2) > 0);
                                        throw throwable;
                                    }
                                    log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                                    log.debug((Object)"--E.00,end allocIndirect");
                                    this.commitAllocResult((position & 2) > 0);
                                    return;
                                }
                                log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"14_BaseAllocator", (Locale)ctx.getLocale()));
                                cancelAlloc = this.crossCostObjectSuiteRange(currFee);
                                if (!cancelAlloc) break block12;
                                log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                                log.debug((Object)"--E.00,end allocIndirect");
                                this.commitAllocResult((position & 2) > 0);
                                return;
                            }
                            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"15_BaseAllocator", (Locale)ctx.getLocale()));
                            cancelAlloc = this.filterAllocTempDataRange(currFee);
                            if (!cancelAlloc) break block13;
                            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                            log.debug((Object)"--E.00,end allocIndirect");
                            this.commitAllocResult((position & 2) > 0);
                            return;
                        }
                        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"16_BaseAllocator", (Locale)ctx.getLocale()));
                        std = this.getAllocStdSetting(currFee);
                        if (std != null) break block14;
                        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                        log.debug((Object)"--E.00,end allocIndirect");
                        this.commitAllocResult((position & 2) > 0);
                        return;
                    }
                    if (currFee instanceof MatFeeInfoAdapter && !StringUtils.isEmpty((String)(materialId = ((MatFeeInfoAdapter)currFee).GetMaterialId()))) {
                        this._param.put("currFeeMaterialId", materialId);
                    }
                    isDirectMatQtyStrategy = !StringUtils.isEmpty((String)std.getFormulaForParse()) && std.getFormulaForParse().indexOf("wSCGfwEgEADgABg2wKgSMp3UGuM=") != -1 && this._param.containsKey("currFeeMaterialId");
                    boolean bl = allocStdChanged = this._costDriver == null || std == null || !this._costDriver.getId().toString().equals(std.getId().toString());
                    if (allocStdChanged) {
                        this.setCostDriver(std);
                    }
                    if (!allocStdChanged && !this.bRangeChanged) break block15;
                    log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"17_BaseAllocator", (Locale)ctx.getLocale()));
                    cancelAlloc = this.initAllocDataTable();
                    if (!cancelAlloc) break block15;
                    log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                    log.debug((Object)"--E.00,end allocIndirect");
                    this.commitAllocResult((position & 2) > 0);
                    return;
                }
                if (!allocStdChanged && !this.bRangeChanged && !this.bMaterialChanged && !isDirectMatQtyStrategy) break block16;
                log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"18_BaseAllocator", (Locale)ctx.getLocale()));
                cancelAlloc = this.updateAllocDataTable();
                if (!cancelAlloc) break block16;
                log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                log.debug((Object)"--E.00,end allocIndirect");
                this.commitAllocResult((position & 2) > 0);
                return;
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"19_BaseAllocator", (Locale)ctx.getLocale()));
            if (this.isOnlyNotZero_AllcoStdData()) {
                this.checkNoAllocStdData(currFee);
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"20_BaseAllocator", (Locale)ctx.getLocale()));
            cancelAlloc = this.saveAllocResult(currFee);
            if (!cancelAlloc) break block17;
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
            log.debug((Object)"--E.00,end allocIndirect");
            this.commitAllocResult((position & 2) > 0);
            return;
        }
        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
        log.debug((Object)"--E.00,end allocIndirect");
        this.commitAllocResult((position & 2) > 0);
    }

    protected boolean dataIsVouchered(IFeeInfo currFee) throws AllocateException {
        return false;
    }

    @Override
    public Map processResult() throws AllocateException {
        return null;
    }

    @Override
    public void endProcess() throws AllocateException {
        this.endAllocProcess();
        this.getAllocTable().releaseTempTable();
    }

    protected void fillObjectRange() throws AllocateException {
        this.removeDataInObjectRange();
        boolean isAux = AllocSourceBillEnum.InnerOverheadBill.equals(this._param.get("allocSourceBill"));
        if (isAux) {
            this.fillDirectObjectRange();
            this.fillAssistantObjectRange();
            return;
        }
        Boolean isAssistant = (Boolean)this._param.get("isAssistant");
        if (isAssistant != null && isAssistant.booleanValue()) {
            this.fillAssistantObjectRange();
        } else {
            this.fillDirectObjectRange();
        }
    }

    private void removeDataInObjectRange() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String sqlTruncateTbl = null;
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        sqlTruncateTbl = "truncate table " + tblObjRange;
        try {
            DbUtil.execute((Context)ctx, (String)sqlTruncateTbl);
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillAssistantObjectRange() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        Object[] params = new Object[]{companyId, periodId};
        StringBuffer sb = new StringBuffer();
        this.appendSQLForInsertAuxAllocObjRangeTbl(tblObjRange, sb);
        try {
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblObjRange);
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected void appendSQLForInsertAuxAllocObjRangeTbl(String tblObjRange, StringBuffer sb) throws AllocateException {
        sb.append("INSERT INTO ").append(tblObjRange).append(" (FID,FCostCenterID,FCostObjectID,FCostItemID,FIsValid)").append('\n').append("SELECT newbosid('08F65F4A') AS FId, FCostCenterID,FCostObjectID, null As FCostItemID, FIsValid ").append('\n').append("FROM (").append('\n').append("\tSELECT DISTINCT B.FCostCenterID as FCostCenterID,CO.FID as FCostObjectID, 1 As FIsValid ").append('\n').append("\tFROM T_NCM_InnerOverheadBill B ").append('\n').append("\tRIGHT OUTER JOIN T_NCM_InnerOverheadBillEntry E ON B.FID = E.FParentID ").append('\n').append("\tINNER JOIN T_BD_CostObjectEntry COE ON COE.FRelatedID = E.FAuxOverheadID ").append('\n').append("\tINNER JOIN T_BD_CostObject CO ON CO.FID = COE.FParentID AND CO.FCompanyID = B.FCompanyOrg ").append('\n').append("\tWHERE B.FBillStatus=4 AND B.FCompanyOrg = ? AND B.FCalculatePeriod = ? ").append('\n').append(") As A ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillDirectObjectRange() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        Object[] params = new Object[]{companyId, periodId, companyId, periodId};
        String tblBalance = null;
        try {
            tblBalance = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_Balance");
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(tblObjRange).append(" (FID,FCostCenterID,FCostObjectID,FCostItemID,FIsValid)").append('\n').append("SELECT newbosid('08F65F4A') AS FId, FCostCenterOrgUnitID,FCostObjectID, null As FCostItemID, FIsValid ").append('\n').append("FROM (").append('\n').append("\tSELECT DISTINCT B.FCostCenterOrgUnitID,E.FCostObjectID, 1 As FIsValid ").append('\n').append("\tFROM T_NCM_InputQtyBill B ").append('\n').append("\tRIGHT OUTER JOIN T_NCM_InputQtyBillEntry E ON B.FID = E.FParentID ").append('\n').append("\tWHERE B.FBillStatus=4 AND B.FCompanyOrg = ? AND B.FCalculatePeriod = ? ").append('\n').append("\tUNION ").append('\n').append("\tSELECT DISTINCT BB.FCostCenterID As FCostCenterOrgUnitID,BB.FCostObjectID, 1 As FIsValid ").append('\n').append("\tFROM ").append(tblBalance).append(" BB ").append('\n').append("\tWHERE BB.FCompanyOrg = ? AND BB.FCalculatePeriodID = ? ").append('\n').append(") As A ");
        this.appendWhereSQLClause(sb, companyId, periodId);
        try {
            DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblObjRange);
        }
        catch (SQLException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    protected void appendWhereSQLClause(StringBuffer sb, String companyId, String periodId) {
    }

    protected void fillAllocTempData() throws AllocateException {
    }

    protected abstract boolean crossCostObjectSuiteRange(IFeeInfo var1) throws AllocateException;

    protected boolean filterAllocTempDataRange(IFeeInfo currFee) throws AllocateException {
        return false;
    }

    protected boolean initAllocDataTable() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String fieldList = this._ausCtx.GetFieldListForQuery();
        String fldAstList = this._ausCtx.GetMergeFormatStr("0 As {0}", ",");
        boolean cancelAlloc = true;
        StringBuffer sb = new StringBuffer();
        sb.append("truncate table ").append(this.getTblAllocData()).append(";").append('\n');
        sb.append("INSERT INTO ").append(this.getTblAllocData()).append("(FID,").append(fieldList).append("FQty,FRatio)").append('\n').append("Select FID,").append(fldAstList).append("0 As FQty, 0 As FRatio ").append('\n').append("from ").append(this.getTblAllocObjectRange()).append('\n').append("where FIsValid =1 ;");
        try {
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            cancelAlloc = false;
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return cancelAlloc;
    }

    protected boolean updateAllocDataTable() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        boolean cancelAlloc = true;
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("update " + this.getTblAllocData() + " set " + this._ausCtx.GetMergeFormatStr("{0} = 0", ",") + " FRatio=0, FQty = 0;");
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            sb.delete(0, sb.length());
            sb.append(this._ausCtx.GetAllocStdUnitDataSql()).append('\n');
            sb.append(this._ausCtx.GetAllocStdFormulaUpdateSql()).append('\n');
            sb.append(" UPDATE ").append(this.getTblAllocData()).append(" SET FQty = 0 WHERE FQty < 0 ;").append('\n');
            sb.append(" UPDATE ").append(this.getTblAllocData()).append(" SET FRatio = FQty/").append("\t(").append("\tSelect ISNULL(SUM(S.FQty),1)As FQty").append("\tFROM ").append(this.getTblAllocData()).append(" S ").append("\tWHERE S.FQty > 0 ").append("\tGROUP BY S.FRatio ").append("\tHAVING SUM(S.FQty) <> 0 ").append("\t);");
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            cancelAlloc = false;
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return cancelAlloc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void checkNoAllocStdData(IFeeInfo currFee) throws AllocateException {
        IRowSet rs;
        block7: {
            Context ctx = (Context)this._param.get("ctx");
            StringBuffer sb = new StringBuffer();
            sb.append("Select top 1 FQty ").append("FROM ").append(this.getTblAllocData()).append(" ").append("WHERE FQty <> 0 ");
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (rs.next()) break block7;
                String[] hint = this._ausCtx.GetNoAllocStdDataHint();
                if (!this._param.containsKey("allocStdID")) {
                    this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NO_COSTDRIVERDATA, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), this.getCostDriver().getName()}), hint[0], hint[1]);
                    break block7;
                }
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_NO_COSTDRIVERDATA, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), this.getCostDriver().getName()}), this.getCostDriver().getName() + ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"22_BaseAllocator", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"23_BaseAllocator", (Locale)ctx.getLocale()));
            }
            catch (BOSException e) {
                log.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
                SQLUtils.cleanup((ResultSet)rs);
            }
            catch (SQLException e2) {
                log.error((Object)"", (Throwable)e2);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e2), null, null);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    protected boolean saveAllocResult(IFeeInfo currFee) throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String userId = this._param.get("userId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String allocStdStr = this.getCostDriver().getId().toString();
        boolean cancelAlloc = true;
        String sqlInsert = this.getSql_InsertIndirectData(companyId, periodId, userId, allocStdStr, currFee);
        String sqlAdjustDiff = this.getSql_AdjustDiff(currFee);
        try {
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)(sqlInsert + '\n' + sqlAdjustDiff), (String)";");
        }
        catch (BOSException e) {
            log.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        cancelAlloc = false;
        return cancelAlloc;
    }

    protected void commitAllocResult(boolean isLastBatch) throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        if (isLastBatch) {
            this.updateDefaultCostItem(ctx, companyId, periodId);
            this.removeNoCostItem(ctx, companyId, periodId);
        }
    }

    protected String getAdjustUserId() {
        return null;
    }

    @Override
    public void processAllocateException(AllocateException e, String possibleReason, String adviceHandle) throws AllocateException {
        throw e;
    }

    protected abstract void insertDirectData(Context var1, String var2, String var3, String var4) throws AllocateException;

    protected abstract String getSql_InsertIndirectData(String var1, String var2, String var3, String var4, IFeeInfo var5) throws AllocateException;

    protected abstract boolean isOnlyNotZero_AllcoStdData();

    protected abstract String getSql_AdjustDiff(IFeeInfo var1) throws AllocateException;

    protected abstract void updateDefaultCostItem(Context var1, String var2, String var3) throws AllocateException;

    protected abstract void removeNoCostItem(Context var1, String var2, String var3) throws AllocateException;

    protected abstract void removeInvalidCostObject(Context var1, String var2, String var3) throws AllocateException;

    @Override
    public AllocTable getAllocTable() throws AllocateException {
        return this._allocTable;
    }

    public void setAllocTable(AllocTable table) {
        this._allocTable = table;
    }

    public FeeData getFeeData() {
        return this._feeData;
    }

    public void setFeeData(FeeData data) {
        this._feeData = data;
    }

    public CostDriverInfo getCostDriver() {
        return this._costDriver;
    }

    public void setCostDriver(CostDriverInfo allocStd) throws AllocateException {
        Assert.that((allocStd != null ? 1 : 0) != 0);
        Assert.that((this._ausCtx != null ? 1 : 0) != 0);
        String formulaForParse = allocStd.getFormulaForParse();
        this._ausCtx.setStrategyContext(formulaForParse, this.getAllocTable());
        this._costDriver = allocStd;
        this.setTblAllocData(null);
    }

    public String getTblAllocData() throws AllocateException {
        Assert.that((this.getCostDriver() != null ? 1 : 0) != 0);
        Assert.that((this._ausCtx != null ? 1 : 0) != 0);
        Assert.that((this.getAllocTable() != null ? 1 : 0) != 0);
        if (this._tblAllocData == null) {
            this.setTblAllocData(this.getAllocTable().GetAllocDataTable(this._ausCtx.GetFieldListForCreateTbl()));
        }
        return this._tblAllocData;
    }

    public void setTblAllocData(String tblAllocData) {
        this._tblAllocData = tblAllocData;
    }

    public String getTblAllocObjectRange() throws AllocateException {
        if (this._tblAllocObjectRange == null) {
            this._tblAllocObjectRange = this.getAllocTable().GetObjectRangeTable();
        }
        return this._tblAllocObjectRange;
    }

    public void setTblAllocObjectRange(String tblAllocObjectRange) {
        this._tblAllocObjectRange = tblAllocObjectRange;
    }

    public String getTblResult() throws AllocateException {
        if (this._tblResult == null) {
            this._tblResult = this.getAllocTable().GetResultTable();
        }
        return this._tblResult;
    }

    public void setTblResult(String tblResult) {
        this._tblResult = tblResult;
    }

    @Override
    public void preAllocProcess() throws AllocateException {
        if (this.getFeeDataControl() != null) {
            this.getFeeDataControl().updateFeeDataFlagToUnallocated(this.getAllocTable().GetResultTable());
        }
    }

    @Override
    public void endAllocProcess() throws AllocateException {
        if (this.getFeeDataControl() != null) {
            this.getFeeDataControl().updateFeeDataFlagToAllocated(this.getAllocTable().GetResultTable());
        }
    }
}

