/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.ncm.CostDriverInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.allcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.CCOFeeData;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.FeeData;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory.BaseAllocator;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.info.CCOFeeInfoAdapter;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.info.IFeeInfo;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.table.AllocTable;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.table.CCOAllocTable;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillCollection;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillFactory;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class CCOAllocator
extends BaseAllocator {
    private static Logger logger = Logger.getLogger((String)CCOAllocator.class.getName());

    public CCOAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
    }

    @Override
    public AllocTable getAllocTable() throws AllocateException {
        if (super.getAllocTable() == null) {
            Context ctx = (Context)this._param.get("ctx");
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            this._param.put("pool", pool);
            this.setAllocTable(new CCOAllocTable(this._param));
        }
        return super.getAllocTable();
    }

    @Override
    public FeeData getFeeDataControl() throws AllocateException {
        if (this.getFeeData() == null) {
            this.setFeeData(new CCOFeeData(this._param));
        }
        return super.getFeeData();
    }

    @Override
    protected void insertDirectData(Context ctx, String companyId, String periodId, String userId) throws AllocateException {
    }

    @Override
    protected String getSql_InsertIndirectData(String companyId, String periodId, String userId, String allocStdId, IFeeInfo currFee) throws AllocateException {
        StringBuffer sb = new StringBuffer();
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(currFee.GetQtyPrecision());
        String strQty = fm.format(currFee.GetQty());
        fm.setMaximumFractionDigits(currFee.GetAmountPrecision());
        String strAmount = fm.format(currFee.GetAmount());
        fm.setMaximumFractionDigits(currFee.GetPricePrecision());
        String strPrice = fm.format(BigDecimal.valueOf(0L));
        if (!fm.format(currFee.GetQty()).equals(BigDecimal.valueOf(0L).toString())) {
            strPrice = fm.format(currFee.GetAmount().divide(currFee.GetQty(), currFee.GetPricePrecision(), 4));
        }
        sb.append("INSERT INTO {0}(FID,FCompanyID,FCalculatePeriodID,FCostCenterGroupID,FCostCenterID,").append('\n').append("FSourceBillID,FSourceBillEntryID,FExpenseID,FCostItemID,FAllocStdID,FManufactureID,").append('\n').append("FAllocStdData,FQty,FPrice,FAmount,FCreatorID,FCreateTime,FAdjustUserID,FAdjustTime,FIsDirect)").append('\n').append("SELECT newbosid(''474CFD96'') AS FID, ''{1}'' As FCompanyID, ''{2}'' As FCalculatePeriodID, ''{3}'' As FCostCenterGroupID,R.FCostCenterID,").append('\n').append("''{4}'' As FSourceBillID,''{5}'' As FSourceBillEntryID, ''{6}'' As FExpenseID, ''{7}'' As FCostItemID, ''{8}'' As FAllocStdID, ''{18}'' As FManufactureID,").append('\n').append("D.FQty As FAllocStdData, ROUND({9} * D.FRatio,{10})As FQty,{11} As FPrice, ROUND({12} * D.FRatio,{13})As FAmount,").append('\n').append("''{14}'' As FCreatorID, GetDate() As FCreateTime, ''{15}'' as FAdjustUserID, GetDate() as FAdjustTime, 0 As FIsDirect ").append('\n').append("FROM {16} R ").append('\n').append("INNER JOIN {17} D ON D.FID=R.FID ").append('\n').append("WHERE R.FIsValid =1 ");
        if (this.IsOnlyNotZero_AllcoStdData()) {
            sb.append(" AND D.FRatio <>0 ");
        }
        sb.append(";");
        String costCenterGroupId = currFee.GetCostCenterGroupId();
        String costItemId = currFee.GetCostItemId();
        String expenseId = currFee.GetExpenseId();
        String manufactureID = ((CCOFeeInfoAdapter)currFee).GetManufactureID();
        if (manufactureID == null) {
            manufactureID = "";
        }
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, costCenterGroupId, currFee.GetId(), currFee.GetEntryId(), expenseId, costItemId, this.getCostDriver().getId().toString(), strQty, String.valueOf(currFee.GetQtyPrecision()), strPrice, strAmount, String.valueOf(currFee.GetAmountPrecision()), userId, this.getAdjustUserId(), this.getTblAllocObjectRange(), this.getTblAllocData(), manufactureID);
        return sqlInsert;
    }

    @Override
    protected String getSql_AdjustDiff(IFeeInfo currFee) throws AllocateException {
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(currFee.GetQtyPrecision());
        String strQty = fm.format(currFee.GetQty());
        fm.setMaximumFractionDigits(currFee.GetAmountPrecision());
        String strAmount = fm.format(currFee.GetAmount());
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE {0} SET FQty=(FQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FQty),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FSourceBillID=''{3}'' AND S.FSourceBillEntryID=''{4}'')").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {5} ").append('\n').append("\tWHERE FSourceBillID=''{6}'' AND FSourceBillEntryID=''{7}'' ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustQty = MessageFormat.format(sb.toString(), this.getTblResult(), strQty, this.getTblResult(), currFee.GetId(), currFee.GetEntryId(), this.getTblResult(), currFee.GetId(), currFee.GetEntryId());
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET FAmount=(FAmount + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAmount),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FSourceBillID=''{3}'' AND S.FSourceBillEntryID=''{4}'')").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {5} ").append('\n').append("\tWHERE FSourceBillID=''{6}'' AND FSourceBillEntryID=''{7}'' ").append('\n').append("\tORDER BY FAllocStdData DESC ").append('\n').append(");");
        String sqlAdjustAmount = MessageFormat.format(sb.toString(), this.getTblResult(), strAmount, this.getTblResult(), currFee.GetId(), currFee.GetEntryId(), this.getTblResult(), currFee.GetId(), currFee.GetEntryId());
        sb.delete(0, sb.length());
        String sqlUpdatePrice = MessageFormat.format("UPDATE {0} SET FPrice=ROUND(to_decimal(FAmount,24,12)/to_decimal(FQty,24,12),{1}) WHERE FSourceBillID=''{2}'' AND FSourceBillEntryID=''{3}'' AND FQty<>0 ;", this.getTblResult(), String.valueOf(currFee.GetPricePrecision()), currFee.GetId(), currFee.GetEntryId());
        String sqlUpdatePrice_Zero = MessageFormat.format("UPDATE {0} SET FPrice=0 WHERE FSourceBillID=''{1}'' AND FSourceBillEntryID=''{2}'' AND FQty=0 ;", this.getTblResult(), currFee.GetId(), currFee.GetEntryId());
        return sqlAdjustQty + '\n' + sqlAdjustAmount + '\n' + sqlUpdatePrice + '\n' + sqlUpdatePrice_Zero;
    }

    @Override
    protected void updateDefaultCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
    }

    @Override
    protected void removeNoCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
    }

    @Override
    protected void removeInvalidCostObject(Context ctx, String companyId, String periodId) throws AllocateException {
    }

    protected boolean IsOnlyNotZero_AllcoStdData() {
        return false;
    }

    @Override
    public Map processResult() throws AllocateException {
        if (this._param.get("isForAllocate") != null && "true".equals(this._param.get("isForAllocate").toString())) {
            try {
                if (this.saveDataInOrderCCFeeBill()) {
                    return new HashMap();
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return null;
    }

    private boolean saveDataInOrderCCFeeBill() throws AllocateException, BOSException {
        String tempResTable = this.getTblResult();
        String tblToAlloc = this.getAllocTable().GetToAllocBillEntryIDTable();
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String tblName = this.createTempTable(ctx, "CCOAllocTemp");
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tblToAlloc).append(" (FSourceBillEntryID)").append('\n').append("   SELECT FSourceBillEntryID FROM ").append(tempResTable + ";").append('\n');
        sql.append("INSERT INTO ").append(tblName).append(" (FID) ").append('\n').append("\tselect b.FID from T_NCM_OrderCCFeeBill a, T_NCM_OrderCCOFeeEntryBill b ").append('\n').append("\t\twhere a.FSourceBillID=b.fid and a.Fivouchered=1;").append('\n').append('\n');
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblName);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String tblName2 = this.createTempTable(ctx, "CCOAllocTemp2");
        sql.append("INSERT INTO ").append(tblName2).append(" (FID) SELECT FID FROM T_NCM_OrderCCFeeBillEntry ").append('\n').append("\twhere exists(select 1 from {0} s, T_NCM_OrderCCFeeBill m ").append('\n').append("\t\twhere s.FSourceBillEntryID=m.FSourceBillID ").append('\n').append("\t\t\tAND m.fid= M.FSourcebillid ").append('\n').append("\t\t\t  and m.FSourceBillID not in ").append('\n').append("\t\t\t\t(select FID from ").append(tblName).append("));").append('\n').append('\n');
        try {
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblName2);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        sql.append("INSERT INTO ").append(tblName2).append(" (FID) SELECT FID FROM T_NCM_OrderCCFeeBill ").append('\n').append("\twhere exists(select 1 from {1} s ").append('\n').append("\t\twhere s.FSourceBillEntryID=T_NCM_OrderCCFeeBill.FSourcebillid ").append('\n').append("\t\t\t  and FSourceBillID not in ").append('\n').append("\t\t\t\t(select FID from ").append(tblName).append("));").append('\n');
        try {
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblName2);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        try {
            String oCCC2ActivityAllocTable = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)periodId, (String)"T_NCM_OCCC2ActivityAlloc");
            String oCCC2ActivitOrderyAllocTable = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)periodId, (String)"T_NCM_OCActivity2OrderAlloc");
            sql.append(" DELETE FROM " + oCCC2ActivitOrderyAllocTable + "\n").append(" WHERE FCC2ActivityID IN ( ").append("                           SELECT FID FROM " + oCCC2ActivityAllocTable + "\n").append("                                  WHERE FSourceBillID IN ( SELECT T1.FID FROM ").append(tblName2).append(" AS T1 \n").append("                                                                     INNER JOIN T_NCM_OrderCCFeeBill AS T2 ON T1.FID = T2.FID AND T2.FIsAllocted = 1)); \n");
            sql.append(" DELETE FROM " + oCCC2ActivityAllocTable + "\n").append(" WHERE FSourceBillID IN ( SELECT T1.FID FROM ").append(tblName2).append(" AS T1 \n").append("                                    INNER JOIN T_NCM_OrderCCFeeBill AS T2 ON T1.FID = T2.FID AND T2.FIsAllocted = 1); \n");
        }
        catch (EASBizException ee) {
            logger.error((Object)"", (Throwable)ee);
            throw new BOSException((Throwable)ee);
        }
        catch (SQLException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        sql.append("DELETE FROM T_NCM_OrderCCFeeBill WHERE FID IN (SELECT FID FROM ").append(tblName2).append(");").append('\n');
        sql.append("DELETE FROM ").append(tblName2).append(";").append('\n');
        String sqlDelOldDataInOtherFeeBill = MessageFormat.format(sql.toString(), tblToAlloc, tblToAlloc);
        sql.delete(0, sql.length());
        sql.append("Insert into T_NCM_OrderCCFeeBill(FID, FNumber, FCompanyOrg, FCalculatePeriod, FExpenseID,").append('\n').append(" FCostCenterID, FDepartmentID, FSourceBillID, FCreatorID, FCreateTime,").append('\n').append(" FLastUpdateUserID, FLastUpdateTime, FControlUnitID,").append('\n').append(" FBizDate,FHasEffected, FAuditorID,FAuditTime,FCostDriverID,").append('\n').append(" FBillStatus, FIsAuto, Fivouchered,FSourceFunction)").append('\n').append(" select tt.FID, ''testAlloc'' as FNumber, tt.FCompanyID as FCompanyOrg, tt.FCalculatePeriodID as FCalculatePeriod, tt.FExpenseID as FExpenseID,").append('\n').append(" tt.FCostCenterID, cc.FDepartmentID, tt.FSourceBillEntryID as FSourceBillID, tt.FCreatorID, tt.FCreateTime,").append('\n').append(" tt.FCreatorID as FLastUpdateUserID, tt.FCreateTime as FLastUpdateTime, FControlUnitID as FControlUnitID,").append('\n').append(" cc.FBizDate as FBizDate, 1 as FHasEffected, tt.FCreatorID as FAuditorID, tt.FCreateTime as FAuditTime,tt.FAllocStdID as FCostDriverID, ").append('\n').append(" 4 as FBillStatus, 1 as FIsAuto, 0 as Fivouchered,''").append("\u7531\u8de8\u6210\u672c\u4e2d\u5fc3\u8d39\u7528\u5f52\u96c6\u5355\u636e").append("''''''||cc.FNumber||''''''").append(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"239_CCOAllocator", (Locale)ctx.getLocale())).append("''||TO_CHAR(ce.FSeq)||''").append(ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"240_CCOAllocator", (Locale)ctx.getLocale())).append("''").append('\n').append(" from T_NCM_OrderCCOFeeBill cc, T_NCM_OrderCCOFeeEntryBill ce, {0} tt").append('\n').append(" where tt.FAllocStddata <> 0 and  cc.FID = ce.FParentID and cc.FID = tt.FSourceBillID and ce.FID = tt.FSourceBillEntryID and ce.FID not in (select b.FID from T_NCM_OrderCCFeeBill a, T_NCM_OrderCCOFeeEntryBill b where a.FSourceBillID=b.fid and a.Fivouchered=1);");
        String sqlInsertOtherFeeBillHeader = MessageFormat.format(sql.toString(), tempResTable);
        sql.delete(0, sql.length());
        String coField = "";
        String coFieldValue = "";
        sql.append("Insert into T_NCM_OrderCCFeeBillEntry(FID, FSeq, FParentID, FCostItemID, FAmount, FQty, FPrice, FCostDriverData " + coField + ")").append('\n').append("select newbosid(''2640287C'') as FID, 1 as FSeq, FID as FParentID, FCostItemID, FAmount, FQty, FPrice,FAllocStdData" + coFieldValue).append('\n').append("  from {0} where FAllocStdData <> 0 and FSourceBillID not in (select b.FID from T_NCM_OrderCCFeeBill a, T_NCM_OrderCCOFeeEntryBill b where a.FSourceBillID=b.fid and a.Fivouchered=1);");
        String sqlInsertOtherFeeBillEntry = MessageFormat.format(sql.toString(), tempResTable);
        sql.delete(0, sql.length());
        sql.append("update T_NCM_OrderCCOFeeEntryBill set FIsAlloced=1 ").append('\n').append("where exists(select 1 from T_NCM_OrderCCOFeeBill cc, {0} tt").append('\n').append("              where cc.FID = T_NCM_OrderCCOFeeEntryBill.FParentID and cc.FID = tt.FSourceBillID and T_NCM_OrderCCOFeeEntryBill.FID = tt.FSourceBillEntryID);").append('\n');
        String sqlSetAlloced = MessageFormat.format(sql.toString(), tempResTable);
        sql.delete(0, sql.length());
        boolean allocSuccess = false;
        try {
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)(sqlDelOldDataInOtherFeeBill + '\n' + sqlInsertOtherFeeBillHeader + '\n' + sqlInsertOtherFeeBillEntry + '\n' + sqlSetAlloced), (String)";");
            allocSuccess = this.updateOtherFeeBillNumberAndSeq(ctx, tempResTable, this._param.get("companyId").toString());
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTableName(tblName);
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTableName(tblName2);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return allocSuccess;
    }

    private String createTempTable(Context ctx, String businessTblName) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE ");
        createTableSql.append(businessTblName);
        createTableSql.append("\t(");
        createTableSql.append("FID   \tVARCHAR(44)");
        createTableSql.append(")");
        String tblName = null;
        try {
            tblName = pool.createTempTable(createTableSql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tblName;
    }

    @Override
    public void preProcess() throws AllocateException {
        this.getFeeData().clearPreAllocResult(this.getAllocTable().GetResultTable(), this.getAllocTable().GetToAllocBillEntryIDTable());
        this.fillObjectRange();
        this.getAllocTable().CreateTempTableIndexs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fillObjectRange() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        Connection conn = null;
        try {
            DbUtil.execute((Context)ctx, (String)("truncate table " + tblObjRange));
            StringBuffer kSql = new StringBuffer();
            kSql.append("INSERT INTO ").append(tblObjRange).append(" (FID,FCostCenterID,FIsValid)").append('\n').append("SELECT newbosid('08F65F4A') AS FId, FCostCenterOrgUnitID, FIsValid ").append('\n').append("FROM (").append('\n').append("\tSELECT DISTINCT E.FCostCenterOrgUnitID,1 As FIsValid ").append('\n').append("\tFROM T_NCM_OrderCCOFeeBill B ").append('\n').append("\tLEFT OUTER JOIN T_NCM_CostCenterGroupEntry E ON B.FCostCenterGroupID = E.FParentID ").append('\n').append("\tWHERE B.FBillStatus=4 AND B.FCompanyOrg = ? AND B.FCalculatePeriod = ? ").append('\n').append(") As A ");
            DbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{companyId, periodId});
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblObjRange);
            SQLUtils.cleanup((Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        finally {
            SQLUtils.cleanup(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void allocIndirect(IFeeInfo currFee, int position) throws AllocateException {
        Context ctx;
        block15: {
            boolean cancelAlloc;
            block13: {
                block14: {
                    boolean allocStdChanged;
                    CostDriverInfo std;
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    cancelAlloc = false;
                                    ctx = (Context)this._param.get("ctx");
                                    try {
                                        log.info((Object)"--E.00,begin allocIndirect");
                                        cancelAlloc = this.dataIsVouchered(currFee);
                                        if (!cancelAlloc) break block9;
                                    }
                                    catch (Throwable throwable) {
                                        log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                                        log.info((Object)"--E.00,end allocIndirect");
                                        this.commitAllocResult((position & 2) > 0);
                                        throw throwable;
                                    }
                                    log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                                    log.info((Object)"--E.00,end allocIndirect");
                                    this.commitAllocResult((position & 2) > 0);
                                    return;
                                }
                                log.info((Object)"---E.01 \u8bbe\u7f6e\u6210\u672c\u4e2d\u5fc3\u7684\u8303\u56f4");
                                cancelAlloc = this.setCostCenterRange(currFee);
                                if (!cancelAlloc) break block10;
                                log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                                log.info((Object)"--E.00,end allocIndirect");
                                this.commitAllocResult((position & 2) > 0);
                                return;
                            }
                            log.info((Object)"---E.02,\u8fc7\u6ee4\u8303\u56f4\uff0d\uff0d\u5206\u914d\u8fc7\u7a0b\u4e34\u65f6\u6570\u636e");
                            cancelAlloc = this.filterAllocTempDataRange(currFee);
                            if (!cancelAlloc) break block11;
                            log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                            log.info((Object)"--E.00,end allocIndirect");
                            this.commitAllocResult((position & 2) > 0);
                            return;
                        }
                        log.info((Object)"---E.03,\u83b7\u53d6\u3001\u8bbe\u7f6e\u5206\u914d\u52a8\u56e0");
                        std = this.getAllocStdSetting(currFee);
                        if (std != null) break block12;
                        log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                        log.info((Object)"--E.00,end allocIndirect");
                        this.commitAllocResult((position & 2) > 0);
                        return;
                    }
                    boolean isDirectMatQtyStrategy = !StringUtils.isEmpty((String)std.getFormulaForParse()) && std.getFormulaForParse().indexOf("wSCGfwEgEADgABg2wKgSMp3UGuM=") != -1 && this._param.containsKey("currFeeMaterialId");
                    boolean bl = allocStdChanged = this._costDriver == null || std == null || !this._costDriver.getId().toString().equals(std.getId().toString());
                    if (allocStdChanged) {
                        this.setCostDriver(std);
                    }
                    if (!allocStdChanged && !this.bRangeChanged) break block13;
                    log.info((Object)"---E.04,\u521d\u59cb\u586b\u5145\u3000\u5206\u914d\u6570\u636e\u660e\u7ec6\u8868");
                    cancelAlloc = this.initAllocDataTable();
                    if (!cancelAlloc) break block14;
                    log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                    log.info((Object)"--E.00,end allocIndirect");
                    this.commitAllocResult((position & 2) > 0);
                    return;
                }
                log.info((Object)"---E.05,\u66f4\u65b0\u5404\u5206\u914d\u52a8\u56e0\u56e0\u5b50\u6807\u51c6\u503c");
                cancelAlloc = this.updateAllocDataTable();
                if (!cancelAlloc) break block13;
                log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                log.info((Object)"--E.00,end allocIndirect");
                this.commitAllocResult((position & 2) > 0);
                return;
            }
            log.info((Object)"---E.06,\u68c0\u67e5 \u65e0\u5206\u914d\u6807\u51c6\u503c");
            this.checkNoAllocStdData(currFee);
            log.info((Object)"---E.07,\u4fdd\u5b58\u5206\u914d\u7ed3\u679c");
            cancelAlloc = this.saveAllocResult(currFee);
            if (!cancelAlloc) break block15;
            log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
            log.info((Object)"--E.00,end allocIndirect");
            this.commitAllocResult((position & 2) > 0);
            return;
        }
        log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
        log.info((Object)"--E.00,end allocIndirect");
        this.commitAllocResult((position & 2) > 0);
    }

    protected boolean setCostCenterRange(IFeeInfo currFee) throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String costCenterGroupId = currFee.GetCostCenterGroupId();
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        String sqlInit = "UPDATE " + tblObjRange + " SET FIsValid = 0 ";
        StringBuffer sb = new StringBuffer();
        boolean cancelAlloc = true;
        this.bRangeChanged = false;
        if (costCenterGroupId != null && !costCenterGroupId.equals(this.lastCostCenterId)) {
            sb.append("UPDATE ").append(tblObjRange).append(" SET (FIsValid)=(").append('\n').append("\tSELECT 1").append('\n').append("\tFROM T_NCM_CostCenterOrgUnitGroup S").append('\n').append("\tRIGHT OUTER JOIN T_NCM_CostCenterGroupEntry E ON S.FID = E.FParentID").append('\n').append("\tWHERE S.FID = '").append(costCenterGroupId).append("' AND S.FCompanyOrgUnitID = '").append(companyId).append("' AND E.FCostCenterOrgUnitID = ").append(tblObjRange).append(".FCostCenterID").append('\n').append(") WHERE exists (select 1 from T_NCM_CostCenterGroupEntry a where FCostCenterID = a.FCostCenterOrgUnitID AND a.FParentID=?)");
            Object[] params = new Object[]{costCenterGroupId};
            this.lastCostCenterId = costCenterGroupId;
            try {
                DbUtil.execute((Context)ctx, (String)sqlInit);
                DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
                cancelAlloc = false;
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            }
            this.bRangeChanged = true;
        }
        cancelAlloc = false;
        if (costCenterGroupId != null && !costCenterGroupId.equals("")) {
            sb.delete(0, sb.length());
            sb.append("Select top 1 FID ").append("FROM ").append(tblObjRange).append(" ").append("WHERE FIsValid = 1 ");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (!rs.next()) {
                    cancelAlloc = true;
                    this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_INVALID_COSTCENTER, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), currFee.GetCostCenterGroupNumber()}), null, null);
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
            }
        }
        return cancelAlloc;
    }

    @Override
    protected boolean dataIsVouchered(IFeeInfo currFee) throws AllocateException {
        boolean isVouchered = true;
        Context ctx = (Context)this._param.get("ctx");
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Select TOP 1 fid From T_NCM_OrderCCFeeBill ").append(" Where FSourceBillID = ?  And Fivouchered = 1");
        Object[] params = new Object[]{currFee.GetEntryId()};
        try {
            IRowSet voucheredRS = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])params);
            if (voucheredRS.size() > 0) {
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq()}), EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.alloc.OrderAllocResource", (String)"CCOAllocator_Voucher_IsExist"), EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.alloc.OrderAllocResource", (String)"CCOAllocator_DeleteVoucher"));
            } else {
                isVouchered = false;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return isVouchered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateOtherFeeBillNumberAndSeq(Context ctx, String tempResTable, String companyID) throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException e1) {
            logger.error((Object)"", (Throwable)e1);
            throw new BOSException((Throwable)e1);
        }
        if (conn == null) {
            return false;
        }
        StringBuffer sb = new StringBuffer();
        boolean allocSuccess = true;
        try {
            sb.append("select distinct FID from " + tempResTable + " where FAllocStdData <> 0 order by FID;");
            IRowSet _Data = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            if (_Data != null && _Data.size() > 0) {
                ArrayList<String> idList = new ArrayList<String>();
                _Data.first();
                while (_Data.getRow() > 0 && !_Data.isAfterLast()) {
                    idList.add(_Data.getString("FID"));
                    _Data.next();
                }
                Map codingRuleNumber = this.getDispNumber(ctx, companyID, idList);
                String ids = "";
                String id = null;
                sb.append("update T_NCM_OrderCCFeeBill set FNumber = ? where FID = ?");
                PreparedStatement pstmt = conn.prepareStatement(sb.toString());
                sb.delete(0, sb.length());
                for (int i = 0; i < idList.size(); ++i) {
                    id = (String)idList.get(i);
                    ids = ids + "'" + (i < idList.size() - 1 ? id + "', " : id + "'");
                    pstmt.setString(1, codingRuleNumber.get(id).toString());
                    pstmt.setString(2, id);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
                pstmt.close();
                sb.append("select FParentID,FID from T_NCM_OrderCCFeeBillEntry where FParentID in (" + ids + ") order by FParentID,FID;");
                _Data = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                sb.delete(0, sb.length());
                if (_Data != null && _Data.size() > 0) {
                    String FParentID = null;
                    String FID = null;
                    HashMap billMap = new HashMap();
                    _Data.first();
                    while (_Data.getRow() > 0 && !_Data.isAfterLast()) {
                        FParentID = _Data.getString("FParentID");
                        FID = _Data.getString("FID");
                        if (billMap.containsKey(FParentID)) {
                            ((List)billMap.get(FParentID)).add(FID);
                        } else {
                            ArrayList<String> entryList = new ArrayList<String>();
                            entryList.add(FID);
                            billMap.put(FParentID, entryList);
                        }
                        _Data.next();
                    }
                    String sb1 = "update T_NCM_OrderCCFeeBillEntry set FSeq = ? where FID = ?";
                    pstmt = conn.prepareStatement("update T_NCM_OrderCCFeeBillEntry set FSeq = ? where FID = ?");
                    List tempList = new ArrayList();
                    for (int i = 0; i < billMap.size(); ++i) {
                        tempList = (List)billMap.get(FParentID);
                        for (int j = 0; j < tempList.size(); ++j) {
                            pstmt.setBigDecimal(1, new BigDecimal(j + 1));
                            pstmt.setString(2, (String)tempList.get(j));
                            pstmt.addBatch();
                        }
                    }
                    pstmt.executeBatch();
                    pstmt.close();
                }
            } else {
                allocSuccess = false;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        catch (AllocateException e) {
            logger.error((Object)"", (Throwable)((Object)e));
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return allocSuccess;
    }

    private Map getDispNumber(Context ctx, String companyId, List idList) throws AllocateException {
        block8: {
            if (idList != null && idList.size() > 0) {
                try {
                    ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    if (codingRuleManager.isExist((IObjectValue)new OrderCCFeeBillInfo(), companyId)) {
                        StringBuffer ids = new StringBuffer();
                        for (int i = 0; i < idList.size(); ++i) {
                            ids.append("'");
                            ids.append(idList.get(i).toString());
                            ids.append("'");
                            if (i >= idList.size() - 1) continue;
                            ids.append(",");
                        }
                        OrderCCFeeBillCollection coll = OrderCCFeeBillFactory.getLocalInstance(ctx).getOrderCCFeeBillCollection("select * where id in(" + ids + ")");
                        if (coll != null && coll.size() > 0) {
                            HashMap<String, String> numbers = new HashMap<String, String>();
                            OrderCCFeeBillInfo info = null;
                            for (int i = 0; i < coll.size(); ++i) {
                                info = coll.get(i);
                                numbers.put(info.getId().toString(), codingRuleManager.getNumber((IObjectValue)info, companyId));
                            }
                            return numbers;
                        }
                        break block8;
                    }
                    throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
                }
                catch (EASBizException e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e);
                }
            }
        }
        return null;
    }

    @Override
    protected boolean updateAllocDataTable() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        boolean cancelAlloc = true;
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this._ausCtx.GetAllocStdUnitDataSql()).append('\n');
            if (sb.length() <= 1) {
                return false;
            }
            DbUtil.execute((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            String[] columns = this._ausCtx.getColumns();
            String updateList = "";
            String dataList = "";
            String zeroList = "";
            String whereList = "";
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i];
                updateList = updateList + column;
                dataList = dataList + "tt." + column + "+dd." + column;
                zeroList = zeroList + column + "=0";
                whereList = whereList + "tt." + column + "<>0";
                if (i == columns.length - 1) continue;
                updateList = updateList + ",";
                dataList = dataList + ",";
                zeroList = zeroList + ",";
                whereList = whereList + " or ";
            }
            sb.append(" UPDATE ").append(this.getTblAllocData()).append(" as tt ").append('\n').append(" SET (").append(updateList).append(") = (").append('\n').append("select ").append(dataList).append('\n').append("  from ").append(this.getTblAllocData()).append(" dd ").append('\n').append(" where tt.FCostCenterID = dd.FCostCenterID and dd.FCostObjectID is null").append('\n').append(") WHERE tt.FCostObjectID is not null ").append('\n').append("   and (").append(whereList).append(");").append('\n');
            DbUtil.execute((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            sb.append(" UPDATE ").append(this.getTblAllocData()).append('\n').append(" SET ").append(zeroList).append('\n').append(" WHERE FCostCenterID in ").append('\n').append("(select tt.FCostCenterID from ").append(this.getTblAllocData()).append(" tt ").append('\n').append(" where tt.FCostObjectID is not null and (").append(whereList).append(")) ").append('\n').append("   and FCostObjectID is null ;").append('\n');
            DbUtil.execute((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            sb.append(this._ausCtx.GetAllocStdFormulaUpdateSql()).append('\n');
            DbUtil.execute((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            sb.append(" UPDATE ").append(this.getTblAllocData()).append(" SET FQty = 0 WHERE FQty < 0 ;").append('\n');
            DbUtil.execute((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            sb.append(" UPDATE ").append(this.getTblAllocData()).append(" SET FQty = FQty+ISNULL((").append("Select sum(tt.FQty) As FQty from ").append(this.getTblAllocData()).append(" tt ").append('\n').append(" where tt.FCostCenterID= ").append(this.getTblAllocData()).append(".FCostCenterID ").append('\n').append("   and tt.FCostObjectID is not null and tt.FQty > 0 ").append('\n').append(" group by tt.FCostCenterID ),0) ").append('\n').append("where FCostObjectID is null;");
            DbUtil.execute((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            sb.append(" delete from ").append(this.getTblAllocData()).append(" where FCostObjectID is not null;");
            DbUtil.execute((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            sb.append(" UPDATE ").append(this.getTblAllocData()).append(" SET FRatio = FQty/").append("\t(").append("\tSelect ISNULL(SUM(S.FQty),1)As FQty").append("\tFROM ").append(this.getTblAllocData()).append(" S ").append("\tWHERE S.FQty > 0 ").append("\tGROUP BY S.FRatio ").append("\tHAVING SUM(S.FQty) <> 0 ").append("\t);");
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            cancelAlloc = false;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return cancelAlloc;
    }

    @Override
    protected boolean initAllocDataTable() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String fieldList = this._ausCtx.GetFieldListForQuery();
        String fldAstList = this._ausCtx.GetMergeFormatStr("0 As {0}", ",");
        boolean cancelAlloc = true;
        StringBuffer sb = new StringBuffer();
        sb.append("truncate table ").append(this.getTblAllocData()).append(";").append('\n');
        fieldList = fieldList + "FCostCenterID, FCostObjectID,";
        fldAstList = fldAstList + "FCostCenterID, FCostObjectID,";
        sb.append("INSERT INTO ").append(this.getTblAllocData()).append("(FID,").append(fieldList).append("FQty,FRatio)").append('\n').append("Select FID,").append(fldAstList).append("0 As FQty, 0 As FRatio ").append('\n').append("from ").append(this.getTblAllocObjectRange()).append('\n').append("where FIsValid =1 ;");
        try {
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            cancelAlloc = false;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return cancelAlloc;
    }
}

