/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.ncm.CostDriverInfo;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.allcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.FeeData;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.OCCC2ActivityData;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory.BaseAllocator;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory.CCOAllocator;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.info.IFeeInfo;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.info.OCC2ActivityFeeInfoAdapter;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.table.AllocTable;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.table.OCCC2ActivityAllocTable;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class OCCC2ActicityAllocator
extends BaseAllocator {
    private static Logger logger = Logger.getLogger((String)CCOAllocator.class.getName());

    public OCCC2ActicityAllocator(Map param, AUSContext ausCtx) {
        super(param, ausCtx);
    }

    @Override
    public AllocTable getAllocTable() throws AllocateException {
        if (super.getAllocTable() == null) {
            Context ctx = (Context)this._param.get("ctx");
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            this._param.put("pool", pool);
            this.setAllocTable(new OCCC2ActivityAllocTable(this._param));
        }
        return super.getAllocTable();
    }

    @Override
    public FeeData getFeeDataControl() throws AllocateException {
        if (this.getFeeData() == null) {
            this.setFeeData(new OCCC2ActivityData(this._param));
        }
        return super.getFeeData();
    }

    @Override
    protected void insertDirectData(Context ctx, String companyId, String periodId, String userId) throws AllocateException {
        StringBuffer sb = new StringBuffer(500);
        String sqlInsert = null;
        sb.append("INSERT INTO {0}(FID, FCompanyID, FCalculatePeriodID, ").append('\n').append("FCostCenterID, ").append('\n').append("FSourceBillID, ").append('\n').append("FSourceBillEntryID, ").append('\n').append("FOrderID, ").append('\n').append("FExpenseID, ").append('\n').append("FDepartmentID, ").append('\n').append("FCostItemID, ").append('\n').append("FActivityID, ").append('\n').append("FPrice, FActivitQty, FAmount, ").append('\n').append("FCreatorID, FCreateTime, FAdjustUserID, FAdjustTime, FIsDirect)").append('\n').append(" SELECT newbosid(''474CFD96'') AS FID, ").append('\n').append("a.fcompanyorg as FCompanyID, ").append('\n').append("a.fcalculateperiod as FCalculatePeriodID, ").append('\n').append("a.fcostcenterid as FCostCenterID, ").append('\n').append("a.fid as FSourceBillID, ").append('\n').append("b.fid as FSourceBillEntryID, ").append('\n').append("b.fmanufactureorderid as FOrderID, ").append('\n').append("a.fexpenseid as FExpenseID, ").append('\n').append("a.fdepartmentid as FDepartmentID, ").append('\n').append("b.fcostitemid as FCostItemID, ").append('\n').append("b.factivityid as FActivityID, ").append('\n').append("ISNULL(b.fprice, 0) as FPrice, ").append('\n').append("ISNULL(b.fqty, 0) as FActivitQty, ").append('\n').append("ISNULL(b.famount, 0) as FAmount, ").append('\n').append("''{1}'' As FCreatorID,").append('\n').append("GetDate() as FCreateTime, ").append('\n').append("''{2}'' As FAdjustUserID,").append('\n').append("GetDate() as FAdjustTime, ").append('\n').append("''1'' as FIsDirect").append('\n').append(" FROM T_NCM_OrderCCFeeBill a inner join t_Ncm_Orderccfeebillentry b on a.fid = b.fparentid").append('\n').append(" inner join {3} c on b.fid = c.FSourceBillEntryID ").append('\n').append(" where a.fcompanyorg = ''{4}'' and a.fcalculateperiod = ''{5}'' and b.factivityid is not null ").append('\n');
        sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), userId, userId, this.getAllocTable().GetToAllocBillEntryIDTable(), companyId, periodId);
        try {
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sqlInsert);
        }
        catch (BOSException e) {
            log.error((Object)"insertDirectData", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
    }

    @Override
    protected String getSql_InsertIndirectData(String companyId, String periodId, String userId, String allocStdId, IFeeInfo currFee) throws AllocateException {
        StringBuffer sb = new StringBuffer(500);
        OCC2ActivityFeeInfoAdapter _currFee = (OCC2ActivityFeeInfoAdapter)currFee;
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(_currFee.GetQtyPrecision());
        String strQty = fm.format(_currFee.GetQty());
        fm.setMaximumFractionDigits(_currFee.GetAmountPrecision());
        String strAmount = fm.format(_currFee.GetAmount());
        fm.setMaximumFractionDigits(_currFee.GetPricePrecision());
        String strPrice = fm.format(BigDecimal.valueOf(0L));
        if (_currFee.GetQty().compareTo(BigDecimal.valueOf(0L)) != 0) {
            strPrice = fm.format(_currFee.GetAmount().divide(_currFee.GetQty(), _currFee.GetPricePrecision(), 4));
        }
        sb.append("INSERT INTO {0}(FID, FCompanyID, FCalculatePeriodID, FCostCenterID, ").append('\n').append("FSourceBillID, FSourceBillEntryID, FExpenseID, ").append('\n').append("FDepartmentID, FCostDriverID, FCostItemID,").append("FActivitQty, FPrice, FAmount, FCostDriverAmount, ").append('\n').append("FCreatorID, FCreateTime, FAdjustUserID, FAdjustTime, FIsDirect, ").append('\n').append("FActivityID) ").append('\n').append("SELECT newbosid(''474CFD96'') AS FID, ").append('\n').append("''{1}'' As FCompanyID, ").append('\n').append("''{2}'' As FCalculatePeriodID, ").append("''{3}'' As FCostCenterID,").append('\n').append("''{4}'' As FSourceBillID,").append('\n').append("''{5}'' As FSourceBillEntryID, ").append('\n').append("''{6}'' As FExpenseID, ").append('\n').append("''{7}'' As FDepartmentID, ").append('\n').append("''{8}'' As FCostDriverID, ").append('\n').append("''{9}'' As FCostItemID,").append('\n').append("ROUND({10} * D.FRatio,{11}) As FActivitQty,").append('\n').append("{12} As FPrice, ").append("ROUND({13} * D.FRatio,{14}) As FAmount,").append('\n').append(" D.FQty as FCostDriverAmount,").append('\n').append("''{15}'' As FCreatorID, GetDate() As FCreateTime, ").append('\n').append("''{16}'' as FAdjustUserID, ").append("GetDate() as FAdjustTime,").append('\n').append(" ''0'' As FIsDirect, ").append('\n').append("D.FActivityID As FActivityID ").append('\n').append("FROM {17} R ").append('\n').append("INNER JOIN {18} D ON D.FID=R.FID ").append('\n').append("WHERE R.FIsValid =1 ");
        if (this.IsOnlyNotZero_AllcoStdData()) {
            sb.append(" AND D.FRatio <>0 ");
        }
        sb.append(";");
        String costCenterId = _currFee.GetCostCenterId();
        String costItemId = _currFee.GetCostItemId();
        String expenseId = _currFee.GetExpenseId();
        String departmentId = _currFee.GetDepartmentId();
        if (departmentId == null) {
            departmentId = "";
        }
        String sqlInsert = MessageFormat.format(sb.toString(), this.getTblResult(), companyId, periodId, costCenterId, _currFee.GetId(), _currFee.GetEntryId(), expenseId, departmentId, this.getCostDriver().getId().toString(), costItemId, strQty, String.valueOf(_currFee.GetQtyPrecision()), strPrice, strAmount, String.valueOf(_currFee.GetAmountPrecision()), userId, userId, this.getTblAllocObjectRange(), this.getTblAllocData());
        return sqlInsert;
    }

    @Override
    protected String getSql_AdjustDiff(IFeeInfo currFee) throws AllocateException {
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(false);
        fm.setMaximumFractionDigits(currFee.GetQtyPrecision());
        String strQty = fm.format(currFee.GetQty());
        fm.setMaximumFractionDigits(currFee.GetAmountPrecision());
        String strAmount = fm.format(currFee.GetAmount());
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE {0} SET FActivitQty =(FActivitQty + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FActivitQty),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FSourceBillID=''{3}'' AND S.FSourceBillEntryID=''{4}'')").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {5} ").append('\n').append("\tWHERE FSourceBillID=''{6}'' AND FSourceBillEntryID=''{7}'' ").append('\n').append(");");
        String sqlAdjustQty = MessageFormat.format(sb.toString(), this.getTblResult(), strQty, this.getTblResult(), currFee.GetId(), currFee.GetEntryId(), this.getTblResult(), currFee.GetId(), currFee.GetEntryId());
        sb.delete(0, sb.length());
        sb.append("UPDATE {0} SET FAmount=(FAmount + {1} - ").append('\n').append("\t(SELECT ISNULL(SUM(S.FAmount),0.00) ").append('\n').append("\tFROM {2} S").append('\n').append("\tWHERE S.FSourceBillID=''{3}'' AND S.FSourceBillEntryID=''{4}'')").append('\n').append(")").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 FID ").append('\n').append("\tFrom {5} ").append('\n').append("\tWHERE FSourceBillID=''{6}'' AND FSourceBillEntryID=''{7}'' ").append('\n').append(");");
        String sqlAdjustAmount = MessageFormat.format(sb.toString(), this.getTblResult(), strAmount, this.getTblResult(), currFee.GetId(), currFee.GetEntryId(), this.getTblResult(), currFee.GetId(), currFee.GetEntryId());
        sb.delete(0, sb.length());
        return sqlAdjustQty + '\n' + sqlAdjustAmount + '\n';
    }

    @Override
    protected void updateDefaultCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
    }

    @Override
    protected void removeNoCostItem(Context ctx, String companyId, String periodId) throws AllocateException {
    }

    @Override
    protected void removeInvalidCostObject(Context ctx, String companyId, String periodId) throws AllocateException {
    }

    protected boolean IsOnlyNotZero_AllcoStdData() {
        return false;
    }

    @Override
    public Map processResult() throws AllocateException {
        return null;
    }

    @Override
    public void preProcess() throws AllocateException {
        AllocTable tables = this.getAllocTable();
        FeeData feeData = this.getFeeData();
        String allocResultTable = tables.GetResultTable();
        String toAllocBillEntryTable = tables.GetToAllocBillEntryIDTable();
        feeData.clearPreAllocResult(allocResultTable, toAllocBillEntryTable);
        this._param.put("toAllocBillEntryTable", toAllocBillEntryTable);
        this.fillObjectRange();
        tables.CreateTempTableIndexs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fillObjectRange() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        if (StringUtils.isEmpty((String)tblObjRange)) {
            return;
        }
        Connection conn = null;
        try {
            DbUtil.execute((Context)ctx, (String)("truncate table " + tblObjRange));
            StringBuffer kSql = new StringBuffer(200);
            kSql.append("INSERT INTO ").append(tblObjRange).append(" (FID,FCostCenterID,FActivityID,FIsValid)").append('\n').append("SELECT newbosid('08F65F4A') AS FId, fcostcenterid, fid, 1 ").append('\n').append("FROM (").append('\n').append(" select distinct b.fcostcenterid,b.fid from T_Ncm_Activity B ").append('\n').append(" WHERE b.fdeletedstatus = 1 and b.fcompanyid= ? ").append('\n').append(") As A ");
            DbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{companyId});
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, tblObjRange);
            SQLUtils.cleanup((Connection)conn);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        finally {
            SQLUtils.cleanup(conn);
        }
    }

    @Override
    public void allocDirect() throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        String userId = this._param.get("userId").toString();
        Context ctx = (Context)this._param.get("ctx");
        this.insertDirectData(ctx, companyId, periodId, userId);
        this.updateDefaultCostItem(ctx, companyId, periodId);
        this.removeNoCostItem(ctx, companyId, periodId);
        this.removeInvalidCostObject(ctx, companyId, periodId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void allocIndirect(IFeeInfo currFee, int position) throws AllocateException {
        Context ctx;
        block13: {
            boolean cancelAlloc;
            block12: {
                boolean allocStdChanged;
                boolean isDirectMatQtyStrategy;
                block11: {
                    CostDriverInfo std;
                    block10: {
                        block9: {
                            block8: {
                                cancelAlloc = false;
                                ctx = (Context)this._param.get("ctx");
                                try {
                                    log.info((Object)"--OCCC2ActicityAllocator, begin allocIndirect");
                                    cancelAlloc = this.crossCostObjectSuiteRange(currFee);
                                    if (!cancelAlloc) break block8;
                                }
                                catch (Throwable throwable) {
                                    log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                                    log.info((Object)"--OCCC2ActicityAllocator, end allocIndirect");
                                    this.commitAllocResult((position & 2) > 0);
                                    throw throwable;
                                }
                                log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                                log.info((Object)"--OCCC2ActicityAllocator, end allocIndirect");
                                this.commitAllocResult((position & 2) > 0);
                                return;
                            }
                            log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"15_BaseAllocator", (Locale)ctx.getLocale()));
                            cancelAlloc = this.filterAllocTempDataRange(currFee);
                            if (!cancelAlloc) break block9;
                            log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                            log.info((Object)"--OCCC2ActicityAllocator, end allocIndirect");
                            this.commitAllocResult((position & 2) > 0);
                            return;
                        }
                        log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"16_BaseAllocator", (Locale)ctx.getLocale()));
                        std = this.getAllocStdSetting(currFee);
                        if (std != null) break block10;
                        log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                        log.info((Object)"--OCCC2ActicityAllocator, end allocIndirect");
                        this.commitAllocResult((position & 2) > 0);
                        return;
                    }
                    isDirectMatQtyStrategy = !StringUtils.isEmpty((String)std.getFormulaForParse()) && std.getFormulaForParse().indexOf("wSCGfwEgEADgABg2wKgSMp3UGuM=") != -1 && this._param.containsKey("currFeeMaterialId");
                    boolean bl = allocStdChanged = this._costDriver == null || std == null || !this._costDriver.getId().toString().equals(std.getId().toString());
                    if (allocStdChanged) {
                        this.setCostDriver(std);
                    }
                    if (!allocStdChanged && !this.bRangeChanged) break block11;
                    log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"17_BaseAllocator", (Locale)ctx.getLocale()));
                    cancelAlloc = this.initAllocDataTable();
                    if (!cancelAlloc) break block11;
                    log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                    log.info((Object)"--OCCC2ActicityAllocator, end allocIndirect");
                    this.commitAllocResult((position & 2) > 0);
                    return;
                }
                if (!allocStdChanged && !this.bRangeChanged && !this.bMaterialChanged && !isDirectMatQtyStrategy) break block12;
                log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"18_BaseAllocator", (Locale)ctx.getLocale()));
                cancelAlloc = this.updateAllocDataTable();
                if (!cancelAlloc) break block12;
                log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
                log.info((Object)"--OCCC2ActicityAllocator, end allocIndirect");
                this.commitAllocResult((position & 2) > 0);
                return;
            }
            log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"19_BaseAllocator", (Locale)ctx.getLocale()));
            this.checkNoAllocStdData(currFee);
            log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"20_BaseAllocator", (Locale)ctx.getLocale()));
            cancelAlloc = this.saveAllocResult(currFee);
            if (!cancelAlloc) break block13;
            log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
            log.info((Object)"--OCCC2ActicityAllocator, end allocIndirect");
            this.commitAllocResult((position & 2) > 0);
            return;
        }
        log.info((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"21_BaseAllocator", (Locale)ctx.getLocale()));
        log.info((Object)"--OCCC2ActicityAllocator, end allocIndirect");
        this.commitAllocResult((position & 2) > 0);
    }

    @Override
    protected boolean crossCostObjectSuiteRange(IFeeInfo currFee) throws AllocateException {
        String companyId = this._param.get("companyId").toString();
        String periodId = this._param.get("periodId").toString();
        Context ctx = (Context)this._param.get("ctx");
        String costCenterId = currFee.GetCostCenterId();
        String tblObjRange = this.getAllocTable().GetObjectRangeTable();
        String sqlInit = "UPDATE " + tblObjRange + " SET FIsValid = 0 ";
        StringBuffer sb = new StringBuffer();
        StringBuffer sbQty = new StringBuffer();
        boolean cancelAlloc = true;
        this.bRangeChanged = false;
        if (costCenterId != null) {
            sb.append("UPDATE ").append(tblObjRange).append(" SET (FIsValid)= ").append(" (SELECT top 1 1 FROM T_NCM_OrderReportBill a inner JOIN T_NCM_OrderReportBillHourEntry b ON a.FID = b.FParentID ").append(" WHERE a.fcompanyorg = '").append(companyId).append("' and a.fcalculateperiod = '").append(periodId).append("' and b.fcostcenterid = '").append(costCenterId).append("' and b.fcostcenterid = ").append(tblObjRange).append(".Fcostcenterid  ").append(" AND b.factivityid = ").append(tblObjRange).append(".FACTIVITYID and (b.FPrepareTime > 0 or FProcessTime >0) )").append(" where  exists (SELECT 1 ").append(" FROM T_NCM_OrderReportBill a inner JOIN T_NCM_OrderReportBillHourEntry b ON a.FID = b.FParentID ").append(" WHERE a.fcompanyorg = '").append(companyId).append("' and a.fcalculateperiod = '").append(periodId).append("' and b.fcostcenterid = '").append(costCenterId).append("' and b.fcostcenterid = ").append(tblObjRange).append(".Fcostcenterid  ").append(" AND b.factivityid = ").append(tblObjRange).append(".FACTIVITYID and (b.FPrepareTime > 0 or FProcessTime >0) )");
            sbQty.append("UPDATE ").append(tblObjRange).append(" SET (FIsValid)= ").append(" (SELECT top 1 1 FROM T_NCM_OrderReportBill a inner JOIN T_NCM_OrderReportBillQtyEntry b ON a.FID = b.FParentID ").append(" WHERE a.fcompanyorg = '").append(companyId).append("' and a.fcalculateperiod = '").append(periodId).append("' and b.fcostcenterid = '").append(costCenterId).append("' and b.fcostcenterid = ").append(tblObjRange).append(".Fcostcenterid  ").append(" AND b.factivityid = ").append(tblObjRange).append(".FACTIVITYID and  \n").append("  (b.FReportQty > 0 or b.FDetectQty > 0 or b.FQualifiedQty > 0 or b.FYieldQty > 0 or b.FScrapQty > 0 \n").append("   or b.FWorkerScrapQty > 0 or b.FSteelScrapQty > 0 or b.FRepairQty > 0))").append(" where  exists (SELECT 1 ").append(" FROM T_NCM_OrderReportBill a inner JOIN T_NCM_OrderReportBillQtyEntry b ON a.FID = b.FParentID ").append(" WHERE a.fcompanyorg = '").append(companyId).append("' and a.fcalculateperiod = '").append(periodId).append("' and b.fcostcenterid = '").append(costCenterId).append("' and b.fcostcenterid = ").append(tblObjRange).append(".Fcostcenterid  \n").append(" AND b.factivityid = ").append(tblObjRange).append(".FACTIVITYID and \n").append("  (b.FReportQty > 0 or b.FDetectQty > 0 or b.FQualifiedQty > 0 or b.FYieldQty > 0 or b.FScrapQty > 0 \n").append("   or b.FWorkerScrapQty > 0 or b.FSteelScrapQty > 0 or b.FRepairQty > 0))");
            try {
                DbUtil.execute((Context)ctx, (String)sqlInit);
                DbUtil.execute((Context)ctx, (String)sb.toString());
                DbUtil.execute((Context)ctx, (String)sbQty.toString());
                cancelAlloc = false;
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            }
            this.bRangeChanged = true;
        }
        cancelAlloc = false;
        if (costCenterId != null && !costCenterId.equals("")) {
            sb.delete(0, sb.length());
            sb.append("Select top 1 FID ").append("FROM ").append(tblObjRange).append(" ").append("WHERE FIsValid = 1 ");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                if (!rs.next()) {
                    cancelAlloc = true;
                    this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_INVALID_ACTIVITY, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq(), currFee.GetCostCenterNumber()}), null, null);
                }
            }
            catch (BOSException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_SQLEXCEPTION, e), null, null);
            }
        }
        return cancelAlloc;
    }

    @Override
    protected boolean dataIsVouchered(IFeeInfo currFee) throws AllocateException {
        boolean isVouchered = true;
        Context ctx = (Context)this._param.get("ctx");
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Select TOP 1 fid From T_NCM_OrderCCFeeBill ").append(" Where FSourceBillID = ?  And Fivouchered = 1");
        Object[] params = new Object[]{currFee.GetEntryId()};
        try {
            IRowSet voucheredRS = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])params);
            if (voucheredRS.size() > 0) {
                this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, new Object[]{currFee.GetNumber(), currFee.GetEntrySeq()}), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"25_CCOAllocator", (Locale)ctx.getLocale()), ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"26_CCOAllocator", (Locale)ctx.getLocale()));
            } else {
                isVouchered = false;
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return isVouchered;
    }

    @Override
    protected boolean updateAllocDataTable() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        boolean cancelAlloc = true;
        StringBuffer sb = new StringBuffer(150);
        String tblAllocData = this.getTblAllocData();
        try {
            sb.append(this._ausCtx.GetAllocStdUnitDataSql()).append('\n');
            if (sb.length() <= 1) {
                return false;
            }
            DbUtil.execute((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            sb.append(this._ausCtx.GetAllocStdFormulaUpdateSql()).append('\n');
            sb.append(" UPDATE ").append(tblAllocData).append(" SET FQty = 0 WHERE FQty < 0 ;").append('\n');
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString());
            sb.delete(0, sb.length());
            sb.append(" UPDATE ").append(tblAllocData).append(" SET FRatio = FQty/").append("\t(").append("\tSelect ISNULL(SUM(S.FQty),1)As FQty").append("\tFROM ").append(tblAllocData).append(" S ").append("\tWHERE S.FQty > 0 ").append("\tGROUP BY S.FRatio ").append("\tHAVING SUM(S.FQty) <> 0 ").append("\t);");
            sb.append(" delete from ").append(tblAllocData).append(" WHERE FRatio is null or FRatio = 0 ;");
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            cancelAlloc = false;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return cancelAlloc;
    }

    @Override
    protected boolean initAllocDataTable() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        String fieldList = this._ausCtx.GetFieldListForQuery();
        String fldAstList = this._ausCtx.GetMergeFormatStr("0 As {0}", ",");
        boolean cancelAlloc = true;
        String tblAllocData = this.getTblAllocData();
        if (StringUtils.isEmpty((String)tblAllocData)) {
            return cancelAlloc;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("truncate table ").append(tblAllocData).append(";").append('\n');
        fieldList = fieldList + "FCostCenterID, FActivityID,";
        fldAstList = fldAstList + "FCostCenterID, FActivityID,";
        sb.append("INSERT INTO ").append(tblAllocData).append("(FID,").append(fieldList).append("FQty,FRatio)").append('\n').append("Select FID,").append(fldAstList).append("0 As FQty, 0 As FRatio ").append('\n').append("from ").append(this.getTblAllocObjectRange()).append('\n').append("where FIsValid =1 ;");
        try {
            NCMServerUtils.BatchSqlExecute((Context)ctx, (String)sb.toString(), (String)";");
            cancelAlloc = false;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.processAllocateException(new AllocateException(AllocateException.ITEM_ALLOC_BOSEXCEPTION, e), null, null);
        }
        return cancelAlloc;
    }
}

