/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.app.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class OCAllocExceptionLog {
    private Context ctx = null;
    private String companyId = null;
    private String periodId = null;
    private String logTblName = null;
    private String logPhysicalTblName = null;
    private int logCount = 0;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.order.fact.alloc.app.helper.OCAllocateExceptionLog");

    public OCAllocExceptionLog(Map param) {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("ctx"));
        this.companyId = (String)param.get("companyId");
        this.periodId = (String)param.get("periodId");
        this.ctx = (Context)param.get("ctx");
        this.logTblName = this.getLogTblName();
        Assert.that((this.logTblName != null ? 1 : 0) != 0);
        try {
            this.logPhysicalTblName = DynamicTableManager.getPhysicalTblNameWithCreate((Context)this.ctx, (String)this.companyId, (String)this.logTblName);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    public abstract String getLogTblName();

    public void clearPreLogData() {
        if (this.logPhysicalTblName != null) {
            try {
                DynamicTableManager.deleteTable((Context)this.ctx, (String)this.logPhysicalTblName, null);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
    }

    public abstract void addLog(AllocateException var1);

    public void addLog(AllocateException e, String possibleReason, String adviceHandle) {
        this.addLog(e.getMessage(this.ctx.getLocale()), possibleReason, adviceHandle);
    }

    public void addLog(String error, String possibleReason, String adviceHandle) {
        try {
            ++this.logCount;
            this.writeLog(error, possibleReason, adviceHandle);
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
        }
    }

    private void writeLog(String allocErrorInfo, String possibleReason, String adviceHandle) throws BOSException {
        if (possibleReason.length() > 500) {
            possibleReason = possibleReason.substring(0, 499);
        }
        StringBuffer ksql = new StringBuffer();
        ksql.append("INSERT INTO ").append(this.logPhysicalTblName);
        ksql.append("(FID, FCompanyID, FCalculatePeriodID, FErrorInfo, FPossibleReason, FAdviceHandle, FLogTime)");
        ksql.append("VALUES(newbosid('08F65F4A'),'").append(this.companyId).append("','").append(this.periodId).append("','");
        ksql.append(allocErrorInfo).append("','").append(possibleReason.replaceAll("\\'", "\\`")).append("','").append(adviceHandle).append("',GetDate()");
        ksql.append(")");
        DbUtil.execute((Context)this.ctx, (String)ksql.toString());
    }

    public IRowSet getLogData() {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT D.FCompanyId, D.FCalculatePeriodID, D.FErrorInfo,D.FPossibleReason,D.FAdviceHandle,D.FLogTime,").append("  C.FNumber As FCompanyNumber, C.FName_L2 As FCompanyName,P.FNumber As FPeriodNumber ").append("FROM ").append(this.logPhysicalTblName).append(" D ").append("LEFT OUTER JOIN T_ORG_Company C ON D.FCompanyID = C.FID ").append("LEFT OUTER JOIN T_BD_Period P ON D.FCalculatePeriodID = P.FID ").append("WHERE D.FCompanyID ='").append(this.companyId).append("' AND D.FCalculatePeriodID='").append(this.periodId).append("'");
        try {
            return DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            return null;
        }
    }

    public int getLogCount() {
        return this.logCount;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public String getPeriodId() {
        return this.periodId;
    }

    public Context getCtx() {
        return this.ctx;
    }
}

