/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.app.task;

import com.kingdee.eas.ncm.common.progress.ProgressBaseTask;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.FeeData;
import com.kingdee.eas.ncm.order.fact.alloc.app.helper.OCAllocExceptionLog;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class OCBaseAllocTask
extends ProgressBaseTask {
    private String companyId = null;
    private String periodId = null;
    private static Logger logger = Logger.getLogger((String)OCBaseAllocTask.class.getName());

    public void init(Map param) {
        super.init(param);
        if (!param.containsKey("ctx")) {
            param.put("ctx", this.getContext());
        }
        this.companyId = (String)param.get("companyId");
        this.periodId = (String)param.get("periodId");
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public String getPeriodId() {
        return this.periodId;
    }

    public void doTask() throws Throwable {
        this.preProcess();
        this.preCheck();
        this.allocDirect();
        this.allocIndirect();
        this.endProcess();
    }

    public abstract FeeData getFeeData() throws Throwable;

    public abstract OCAllocExceptionLog getExceptionLog() throws Throwable;

    public abstract void preProcess() throws Throwable;

    public abstract void preCheck() throws Throwable;

    public abstract void allocDirect() throws Throwable;

    public abstract void allocIndirect() throws Throwable;

    public abstract void endProcess() throws Throwable;

    public abstract void release() throws Throwable;

    public void doTaskAfter() throws Throwable {
        super.doTaskAfter();
        this.release();
    }

    public int calculateStepAmount() throws Throwable {
        return 0;
    }

    public String getConcurrentID() {
        return "d3T+lgEaEADgAAobwKgRj53UGuM=" + this.getCompanyId();
    }

    public int getConcurrentSeq() {
        return super.getConcurrentSeq();
    }

    public void processAllocateError(String error, String possibleReason, String adviceHandle) throws Throwable {
        OCAllocExceptionLog exclog = this.getExceptionLog();
        if (exclog != null) {
            exclog.addLog(error, possibleReason, adviceHandle);
        }
    }

    public void processAllocateException(AllocateException e, String possibleReason, String adviceHandle) throws Throwable {
        OCAllocExceptionLog exclog = this.getExceptionLog();
        if (exclog != null) {
            if (possibleReason == null || adviceHandle == null) {
                exclog.addLog(e);
            } else {
                exclog.addLog(e, possibleReason, adviceHandle);
            }
        } else {
            throw e;
        }
    }
}

