/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.app.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.ncm.CostDriverTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.allcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.CCOFeeData;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.FeeData;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory.Allocator;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory.AutoCCOAllocator;
import com.kingdee.eas.ncm.order.fact.alloc.app.helper.CCOFeeAllocExceptionLog;
import com.kingdee.eas.ncm.order.fact.alloc.app.helper.OCAllocExceptionLog;
import com.kingdee.eas.ncm.order.fact.alloc.app.task.OCBaseAllocTask;
import com.kingdee.eas.ncm.order.fact.alloc.batchAllocIterator.AutoCCOBatchAllocIterator;
import com.kingdee.eas.ncm.order.fact.alloc.batchAllocIterator.IBatchAllocIterator;
import com.kingdee.eas.ncm.order.fact.bill.OrderCCFeeBillInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class OCCCOFeeAllocTask
extends OCBaseAllocTask {
    private static Logger logger = Logger.getLogger((String)OCCCOFeeAllocTask.class.getName());
    private int directDataCount = 0;
    private int indirectDataCount = 0;
    protected CCOFeeData feeData = null;
    private Map _param;
    private Allocator allocator;
    private CCOFeeAllocExceptionLog _logger;
    private String companyId;
    private String periodId;
    private String userId;
    private AllocTypeEnum allocType;
    private FilterInfo filterInfo;
    private AllocSourceBillEnum allocSourceBill;
    private static Logger log = Logger.getLogger((String)"com.kingdee.eas.ncm.bill.app.Alloc.AllocDispatchLog");

    @Override
    public void init(Map param) {
        super.init(param);
        this._param = param;
        if (!param.containsKey("ctx")) {
            param.put("ctx", this.getContext());
        }
        this.companyId = param.get("companyId").toString();
        this.periodId = param.get("periodId").toString();
        this.userId = ContextUtil.getCurrentUserInfo((Context)this.getContext()).getId().toString();
        param.put("userId", this.userId);
        this.allocType = (AllocTypeEnum)param.get("allocType");
        if (this.allocType == null) {
            this.allocType = AllocTypeEnum.AUTO;
        }
        this.filterInfo = (FilterInfo)param.get("ccoAllocFilterInfo");
        param.put("isForAllocate", "true");
    }

    protected CCOFeeData getCCOFeeData() throws Throwable {
        if (this.feeData == null) {
            this.feeData = new CCOFeeData(this.getParam());
        }
        return this.feeData;
    }

    @Override
    public int calculateStepAmount() throws Throwable {
        this.setStepName(EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.alloc.OrderAllocResource", (String)"OCCOFeeAllocTask_ProgressTitle_Start"));
        this.writeInfo("\u6b63\u5728\u8fdb\u884c\u8de8\u6210\u672c\u4e2d\u5fc3\u8d39\u7528\u5206\u914d\u4efb\u52a1\u91cf\u8ba1\u7b97...");
        int stepAmount = 0;
        ++stepAmount;
        ++stepAmount;
        stepAmount += 5;
        stepAmount += 13;
        String sql = ((CCOFeeData)this.getFeeData()).getCountIndirectFeeDataSql();
        IRowSet rowset = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        if (rowset.next()) {
            this.indirectDataCount = rowset.getInt(1);
        }
        if (this.isDebugEnabled()) {
            this.writeInfo("\u5171\u6709" + this.indirectDataCount + "\u7b14\u8de8\u6210\u672c\u4e2d\u5fc3\u8d39\u7528\u3002");
        }
        stepAmount = this.indirectDataCount > 80 ? (stepAmount += 80) : (stepAmount += this.indirectDataCount);
        this.writeInfo("\u8de8\u6210\u672c\u4e2d\u5fc3\u8d39\u7528\u5206\u914d\u4efb\u52a1\u91cf\u8ba1\u7b97\u5b8c\u6210\u3002");
        return stepAmount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map DoAllocate() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        Map ret = null;
        log.info((Object)"-\u5f00\u59cb\u8d39\u7528\u5206\u914d");
        log.info((Object)"--\u6784\u5efa\u5206\u914d\u7b56\u7565\u4e0a\u4e0b\u6587");
        AUSContext ausCtx = new AUSContext(this._param);
        log.info((Object)"--\u6784\u5efa\u5206\u914d\u8005");
        this.allocator = this.CreateAllocator(ausCtx);
        log.info((Object)"--\u6784\u5efa\u5206\u914d\u8fed\u4ee3\u5668");
        IBatchAllocIterator iterator = this.CreateBatchAllocIterator(this.allocator);
        log.info((Object)"--\u5206\u914d\u524d\u68c0\u67e5\uff08preCheck\uff09");
        this.allocator.preCheck();
        try {
            log.info((Object)"--\u5206\u914d\u524d\u9884\u5904\u7406\uff08preProcess\uff09");
            this.writeInfo("\u6e05\u9664\u5386\u53f2\u6570\u636e\u5f00\u59cb...");
            this.allocator.preProcess();
            this.writeInfo("\u6e05\u9664\u5386\u53f2\u6570\u636e\u7ed3\u675f\u3002");
            int i = 1;
            log.info((Object)"--\u5faa\u73af\u5206\u914d\u95f4\u63a5\u8d39\u7528");
            iterator.FirstBatch();
            while (!iterator.IsDone()) {
                this.writeInfo("\u5f00\u59cb\u5206\u914d\u7b2c" + i + "\u7b14\u8d39\u7528...");
                iterator.AllocateCurrBatch();
                this.writeInfo("\u7b2c" + i + "\u7b14\u8d39\u7528\u5206\u914d\u5b8c\u6210\u3002");
                ++i;
                if (this.indirectDataCount + this.directDataCount < 80) {
                    this.progress(1);
                } else if (i % this.getNumberProgress() == 0) {
                    this.progress(1);
                }
                iterator.NextBatch();
            }
            log.info((Object)"--\u5904\u7406\u5206\u914d\u7ed3\u679c");
            this.writeInfo("\u5f00\u59cb\u5904\u7406\u5206\u914d\u7ed3\u679c...");
            ret = this.allocator.processResult();
            this.progress(13);
            this.writeInfo("\u5206\u914d\u7ed3\u679c\u5904\u7406\u5b8c\u6210\u3002");
        }
        finally {
            log.info((Object)"--\u5206\u914d\u672b\u5904\u7406");
            this.allocator.endProcess();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
            boolean isSuccessed = false;
            if (this._logger == null || this._logger.getLogCount() == 0) {
                isSuccessed = true;
            }
            NCMUtils.addEASLogForAlloc((Context)ctx, (String)"DoAllocate", (String)(company.getNumber() + ' ' + company.getName()), (String)"OrderCCOFeeAllocAuto", (String)this.companyId, (boolean)isSuccessed);
        }
        log.info((Object)"-\u7ed3\u675f\u8d39\u7528\u5206\u914d");
        return ret;
    }

    private Allocator CreateAllocator(AUSContext ausCtx) {
        AutoCCOAllocator alloc = null;
        switch (this.allocType.getValue()) {
            case 2: {
                this._logger = new CCOFeeAllocExceptionLog(this._param);
                this._param.put("logger", this._logger);
                alloc = new AutoCCOAllocator(this._param, ausCtx);
                break;
            }
            case 1: {
                break;
            }
        }
        return alloc;
    }

    private IBatchAllocIterator CreateBatchAllocIterator(Allocator allocatorAdapter) throws AllocateException {
        AutoCCOBatchAllocIterator alloc = null;
        switch (this.allocType.getValue()) {
            case 2: {
                alloc = new AutoCCOBatchAllocIterator(this._param, allocatorAdapter);
                break;
            }
            case 1: {
                break;
            }
        }
        return alloc;
    }

    public AllocTypeEnum getAllocType() {
        return this.allocType;
    }

    @Override
    public String getCompanyId() {
        return this.companyId;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    @Override
    public String getPeriodId() {
        return this.periodId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Allocator getAllocator() {
        return this.allocator;
    }

    @Override
    public void allocDirect() throws Throwable {
    }

    @Override
    public void allocIndirect() throws Throwable {
        this.DoAllocate();
    }

    @Override
    public void endProcess() throws Throwable {
        if (this._logger == null || this._logger.getLogCount() == 0) {
            this.setStepName(EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.alloc.OrderAllocResource", (String)"OCCOFeeAllocTask_ProgressTitle_EndSccuess"));
            this.addUserObject("ccoAlloc_success");
        } else {
            this.setStepName(EASResource.getString((String)"com.kingdee.eas.ncm.order.fact.alloc.OrderAllocResource", (String)"OCCOFeeAllocTask_ProgressTitle_EndFailure"));
            this.addUserObject("ccoAlloc_error");
        }
    }

    @Override
    public OCAllocExceptionLog getExceptionLog() throws Throwable {
        if (this._logger == null) {
            this._logger = new CCOFeeAllocExceptionLog(this.getParam());
        }
        this._logger.clearPreLogData();
        this.progress(1);
        return this._logger;
    }

    @Override
    public FeeData getFeeData() throws Throwable {
        if (this.feeData == null) {
            this.feeData = new CCOFeeData(this.getParam());
        }
        this.progress(1);
        return this.feeData;
    }

    @Override
    public void preCheck() throws Throwable {
        this.checkCCFeeBillCodingRule();
        this.getExceptionLog();
    }

    @Override
    public void preProcess() throws Throwable {
        this._param.put("allocStdType", CostDriverTypeEnum.BETWEENCC_DRIVER);
        this.allocSourceBill = (AllocSourceBillEnum)this._param.get("allocSourceBill");
        if (this.allocSourceBill == null) {
            this.allocSourceBill = AllocSourceBillEnum.CCOFeeBill;
        }
    }

    @Override
    public void release() throws Throwable {
    }

    private void checkCCFeeBillCodingRule() throws AllocateException, BOSException, EASBizException {
        Context ctx = (Context)this._param.get("ctx");
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (!codingRuleManager.isExist((IObjectValue)new OrderCCFeeBillInfo(), this.companyId)) {
                throw new AllocateException(AllocateException.ITEM_CCOFEEBILL_NO_CODINGRULE);
            }
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException es) {
            throw es;
        }
    }

    private int getNumberProgress() {
        return (this.indirectDataCount + this.directDataCount) / 80;
    }

    private void writeInfo(String info) {
        this.info(info);
        log.info((Object)info);
    }
}

