/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.alloc.dispatch;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.ncm.CostDriverTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.ncm.bill.AllocTypeEnum;
import com.kingdee.eas.ncm.common.AllocSourceBillEnum;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.order.fact.alloc.AllocateException;
import com.kingdee.eas.ncm.order.fact.alloc.allcoUnitStrategy.AUSContext;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory.Allocator;
import com.kingdee.eas.ncm.order.fact.alloc.app.fee.allocatorFactory.AutoCCOAllocator;
import com.kingdee.eas.ncm.order.fact.alloc.app.helper.CCOFeeAllocExceptionLog;
import com.kingdee.eas.ncm.order.fact.alloc.batchAllocIterator.AutoCCOBatchAllocIterator;
import com.kingdee.eas.ncm.order.fact.alloc.batchAllocIterator.IBatchAllocIterator;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.Assert;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class CCOAllocDispatch {
    private Map _param;
    private Allocator allocator;
    private CCOFeeAllocExceptionLog _logger;
    private String companyId;
    private String periodId;
    private String userId;
    private AllocTypeEnum allocType;
    private FilterInfo filterInfo;
    private AllocSourceBillEnum allocSourceBill;
    private static Logger log = Logger.getLogger((String)"com.kingdee.eas.ncm.bill.app.Alloc.AllocDispatchLog");

    public CCOAllocDispatch(Map param) {
        Assert.that((boolean)param.containsKey("companyId"));
        Assert.that((boolean)param.containsKey("periodId"));
        Assert.that((boolean)param.containsKey("userId"));
        Assert.that((boolean)param.containsKey("allocType"));
        Assert.that((boolean)param.containsKey("filterInfo"));
        this._param = param;
        this.companyId = param.get("companyId").toString();
        this.periodId = param.get("periodId").toString();
        this.userId = param.get("userId").toString();
        this.allocType = (AllocTypeEnum)param.get("allocType");
        this.filterInfo = (FilterInfo)param.get("filterInfo");
        this._param.put("allocStdType", CostDriverTypeEnum.BETWEENCC_DRIVER);
        this.allocSourceBill = (AllocSourceBillEnum)param.get("allocSourceBill");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map DoAllocate() throws AllocateException {
        Context ctx = (Context)this._param.get("ctx");
        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"27_AllocDispatch", (Locale)ctx.getLocale()));
        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"28_AllocDispatch", (Locale)ctx.getLocale()));
        AUSContext ausCtx = new AUSContext(this._param);
        this.allocator = this.CreateAllocator(ausCtx);
        IBatchAllocIterator iterator = this.CreateBatchAllocIterator(this.allocator);
        Map ret = null;
        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"29_AllocDispatch", (Locale)ctx.getLocale()));
        this.allocator.preCheck();
        try {
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"30_AllocDispatch", (Locale)ctx.getLocale()));
            this.allocator.preProcess();
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"32_AllocDispatch", (Locale)ctx.getLocale()));
            iterator.FirstBatch();
            while (!iterator.IsDone()) {
                iterator.AllocateCurrBatch();
                iterator.NextBatch();
            }
            log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"33_AllocDispatch", (Locale)ctx.getLocale()));
            ret = this.allocator.processResult();
        }
        finally {
            this.allocator.endProcess();
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
            boolean isSuccessed = false;
            if (this._logger == null || this._logger.getLogCount() == 0) {
                isSuccessed = true;
            }
            NCMUtils.addEASLogForAlloc((Context)ctx, (String)"DoAllocate", (String)(company.getNumber() + ' ' + company.getName()), (AllocSourceBillEnum)this.allocSourceBill, (AllocTypeEnum)this.allocType, (String)this.companyId, (boolean)isSuccessed);
        }
        log.debug((Object)ResourceBase.getString((String)"com.kingdee.eas.ncm.bill.app.BILLAPPAutoGenerateResource", (String)"34_AllocDispatch", (Locale)ctx.getLocale()));
        return ret;
    }

    private Allocator CreateAllocator(AUSContext ausCtx) {
        AutoCCOAllocator alloc = null;
        switch (this.allocType.getValue()) {
            case 2: {
                this._logger = new CCOFeeAllocExceptionLog(this._param);
                this._param.put("logger", this._logger);
                alloc = new AutoCCOAllocator(this._param, ausCtx);
                break;
            }
            case 1: {
                break;
            }
        }
        return alloc;
    }

    private IBatchAllocIterator CreateBatchAllocIterator(Allocator allocatorAdapter) throws AllocateException {
        AutoCCOBatchAllocIterator alloc = null;
        switch (this.allocType.getValue()) {
            case 2: {
                alloc = new AutoCCOBatchAllocIterator(this._param, allocatorAdapter);
                break;
            }
            case 1: {
                break;
            }
        }
        return alloc;
    }

    public AllocTypeEnum getAllocType() {
        return this.allocType;
    }

    public String getCompanyId() {
        return this.companyId;
    }

    public FilterInfo getFilterInfo() {
        return this.filterInfo;
    }

    public String getPeriodId() {
        return this.periodId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Allocator getAllocator() {
        return this.allocator;
    }
}

