/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.bill.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.utils.BDCMUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.fact.bill.app.AbstractOCWIPCountingBillControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OCWIPCountingBillControllerBean
extends AbstractOCWIPCountingBillControllerBean {
    private static final long serialVersionUID = -7809965734956084562L;
    protected static final char CLF = '\n';
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.order.fact.bill.app.OCWIPCountingBillControllerBean");

    public String getMainTableName(Context ctx, IObjectPK[] model) throws EASBizException, BOSException {
        return "T_NCM_OCWIPCountingBill";
    }

    @Override
    protected void _updateData(Context ctx, List list) throws BOSException, EASBizException {
        if (list == null || list.size() == 0) {
            return;
        }
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        PeriodInfo period = OrderCMUtils.getCurrentPeriod(ctx, companyId);
        String periodId = period.getId().toString();
        Connection conn = null;
        PreparedStatement pstmt = null;
        Statement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer ksql = new StringBuffer();
            ksql.append("update T_NCM_OCWIPCountingBill \n");
            ksql.append("set \n");
            ksql.append("FCTiQty = ?, FCToQty = ?, \n");
            ksql.append("FEUntoCntQty = ?, \n");
            ksql.append("FFlag = 2, \n");
            ksql.append("FLastUpdateUserID = ?, \n");
            ksql.append("FLastUpdateTime = GetDate() \n");
            ksql.append("where FID = ? \n");
            pstmt = conn.prepareStatement(ksql.toString());
            for (int i = 0; i < list.size(); ++i) {
                Map info = (Map)list.get(i);
                String id = (String)info.get("id");
                if (id == null) continue;
                int index = 0;
                Object temp = info.get("cTiQty");
                if (temp != null && temp instanceof BigDecimal) {
                    pstmt.setBigDecimal(++index, (BigDecimal)temp);
                } else {
                    pstmt.setBigDecimal(++index, SysConstant.BIGZERO);
                }
                temp = info.get("cToQty");
                if (temp != null && temp instanceof BigDecimal) {
                    pstmt.setBigDecimal(++index, (BigDecimal)temp);
                } else {
                    pstmt.setBigDecimal(++index, SysConstant.BIGZERO);
                }
                temp = info.get("eUntoCntQty");
                if (temp != null && temp instanceof BigDecimal) {
                    pstmt.setBigDecimal(++index, (BigDecimal)temp);
                } else {
                    pstmt.setBigDecimal(++index, SysConstant.BIGZERO);
                }
                pstmt.setString(++index, userId);
                pstmt.setString(++index, id);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            stmt = conn.createStatement();
            ksql.setLength(0);
            ksql.append("update T_NCM_OCWIPCountingBill set ");
            ksql.append("FEcToUnewhQty = FBcToUnewhQty + FCToQty - FCurFinishedQty, ");
            ksql.append("FEUntoQty = FBUntoQty + FCTiQty - FCToQty, ");
            ksql.append("FFlag = 1 ");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("and FFlag = 2 \n");
            ksql.append("and FWipType = 2 \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("update T_NCM_OCWIPCountingBill set \n");
            ksql.append("FEUntoQty = FBUntoQty + FCTiQty - FCToQty, \n");
            ksql.append("FFlag = 1 ");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("and FFlag = 2 \n");
            ksql.append("and FWipType = 1 \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString());
        }
        catch (SQLException e) {
            try {
                logger.debug((Object)e);
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Connection)conn);
    }

    @Override
    public void resetData(Context ctx, Map param) throws BOSException, EASBizException {
        IObjectPK logPk = null;
        Set deleteIds = (Set)param.get("deleteIds");
        logPk = deleteIds != null && deleteIds.size() > 0 ? LogUtil.beginLog((Context)ctx, (String)"reset", (BOSObjectType)this.getBOSType(), null, (String)"", (String)"OC_WIPCountingBill_Reset") : LogUtil.beginLog((Context)ctx, (String)"generate", (BOSObjectType)this.getBOSType(), null, (String)"", (String)"OC_WIPCountingBill_View");
        super.resetData(ctx, param);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    @Override
    protected void _resetData(Context ctx, Map param) throws BOSException, EASBizException {
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        PeriodInfo period = OrderCMUtils.getCurrentPeriod(ctx, companyId);
        String periodId = period.getId().toString();
        Set costCenterIds = BDCMUtils.getCostCenterIdsOfCompany((Context)ctx, (String)companyId);
        if (costCenterIds.size() <= 0) {
            return;
        }
        Set storageOrgUnitIds = BDCMUtils.getStorageOrgUnitIdsOfCompany((Context)ctx, (String)companyId);
        if (storageOrgUnitIds.size() <= 0) {
            return;
        }
        String T_NCM_OrderBalance = null;
        String T_NCM_OrderBalanceActivity = null;
        try {
            T_NCM_OrderBalance = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)periodId, (String)"T_NCM_OrderBalance");
            T_NCM_OrderBalanceActivity = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)periodId, (String)"T_NCM_OrderBalanceActivity");
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String tempTable = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            String orderId2;
            StringBuffer ksql = new StringBuffer();
            ksql.append("create table T ( \n");
            ksql.append("     FOrderID varchar(44), \n");
            ksql.append("     FBaseQty NUMERIC(28,10) DEFAULT 0, \n");
            ksql.append("     FSeq int DEFAULT 0, \n");
            ksql.append("     FOperationID varchar(44), \n");
            ksql.append("     FActivityID varchar(44), \n");
            ksql.append("     FQualifiedQty NUMERIC(28,10) DEFAULT 0, \n");
            ksql.append("     FReportCount INT DEFAULT 0 \n");
            ksql.append(") \n");
            try {
                tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(ksql.toString());
            }
            catch (Exception e) {
                logger.debug((Object)e);
                throw new BOSException((Throwable)e);
            }
            conn = EJBFactory.getConnection((Context)ctx);
            Set deleteIds = (Set)param.get("deleteIds");
            if (deleteIds != null && deleteIds.size() > 0) {
                ksql.setLength(0);
                ksql.append("delete from T_NCM_OCWIPCountingBill where FID in \n");
                ksql.append(BDCMUtils.buildSqlFromIds((Set)deleteIds));
                DbUtil.execute((Context)ctx, (String)ksql.toString());
            }
            ksql.setLength(0);
            ksql.append("delete from T_NCM_OCWIPCountingBill \n");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("and FWipType = 1 \n");
            ksql.append("and not exists ( \n");
            ksql.append("    select top 1 1 from T_MM_ManufactureOrder o \n");
            ksql.append("    where o.FID = T_NCM_OCWIPCountingBill.FOrderID \n");
            ksql.append("    and o.FBaseStatus in ( \n");
            ksql.append("    5, \n");
            ksql.append("    7, \n");
            ksql.append("    8 \n");
            ksql.append("    ) \n");
            ksql.append("    and o.FActureBeginDate >= ? and o.FActureBeginDate <= ? \n");
            ksql.append("    and o.FStorageOrgUnitID in " + BDCMUtils.buildSqlFromIds((Set)storageOrgUnitIds) + " \n");
            ksql.append(") \n");
            ksql.append("and not exists ( \n");
            ksql.append("    select top 1 1 \n");
            ksql.append("    from " + T_NCM_OrderBalance + " b \n");
            ksql.append("    where b.FOrderID = T_NCM_OCWIPCountingBill.FOrderID \n");
            ksql.append(") \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString(), (Object[])new Object[]{period.getBeginDate(), period.getEndDate()});
            ksql.setLength(0);
            ksql.append("insert into T_NCM_OCWIPCountingBill ( \n");
            ksql.append("    FID, \n");
            ksql.append("    FCompanyOrg, \n");
            ksql.append("    FCalculatePeriod, \n");
            ksql.append("    FOrderID, \n");
            ksql.append("    FWipType, \n");
            ksql.append("    FActivityID, \n");
            ksql.append("    FBcToUnewhQty, \n");
            ksql.append("    FBUntoQty, \n");
            ksql.append("    FCTiQty, \n");
            ksql.append("    FCToQty, \n");
            ksql.append("    FEcToUnewhQty, \n");
            ksql.append("    FEUntoQty, \n");
            ksql.append("    FEUntoCntQty, \n");
            ksql.append("    FSeq, \n");
            ksql.append("    FFlag, \n");
            ksql.append("    FCreatorID, \n");
            ksql.append("    FCreateTime, \n");
            ksql.append("    FLastUpdateUserID, \n");
            ksql.append("    FLastUpdateTime, \n");
            ksql.append("    FControlUnitID \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    newbosid('25F438D7') FID, \n");
            ksql.append("    '" + companyId + "' FCompanyOrg, \n");
            ksql.append("    '" + periodId + "' FCalculatePeriod, \n");
            ksql.append("    o.FID FOrderID, \n");
            ksql.append("    1 FWipType, \n");
            ksql.append("    null FActivityID, \n");
            ksql.append("    0 FBcToUnewhQty, \n");
            ksql.append("    0 FBUntoQty, \n");
            ksql.append("    0 FCTiQty, \n");
            ksql.append("    0 FCToQty, \n");
            ksql.append("    0 FEcToUnewhQty, \n");
            ksql.append("    0 FEUntoQty, \n");
            ksql.append("    0 FEUntoCntQty, \n");
            ksql.append("    0 FSeq, \n");
            ksql.append("    0 FFlag, \n");
            ksql.append("    '").append(userId).append("' FCreatorID, \n");
            ksql.append("    GetDate() FCreateTime, \n");
            ksql.append("    '").append(userId).append("' FLastUpdateUserID, \n");
            ksql.append("    GetDate() FLastUpdateTime, \n");
            ksql.append("    '").append(cuId).append("' FControlUnitID \n");
            ksql.append("from T_MM_ManufactureOrder o \n");
            ksql.append("where o.FBaseStatus in ( \n");
            ksql.append("    5, \n");
            ksql.append("    7, \n");
            ksql.append("    8 \n");
            ksql.append(") \n");
            ksql.append("and FActureBeginDate >= ? and FActureBeginDate <= ? \n");
            ksql.append("and o.FStorageOrgUnitID in " + BDCMUtils.buildSqlFromIds((Set)storageOrgUnitIds) + " \n");
            ksql.append("and not exists ( \n");
            ksql.append("    select top 1 1 from T_NCM_OCWIPCountingBill wip \n");
            ksql.append("    where \n");
            ksql.append("    wip.FCompanyOrg = '" + companyId + "' \n");
            ksql.append("    and wip.FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("    and wip.FWipType = 1 \n");
            ksql.append("    and wip.FOrderID = o.FID \n");
            ksql.append(") \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString(), (Object[])new Object[]{period.getBeginDate(), period.getEndDate()});
            ksql.setLength(0);
            ksql.append("insert into T_NCM_OCWIPCountingBill ( \n");
            ksql.append("    FID, \n");
            ksql.append("    FCompanyOrg, \n");
            ksql.append("    FCalculatePeriod, \n");
            ksql.append("    FOrderID, \n");
            ksql.append("    FWipType, \n");
            ksql.append("    FActivityID, \n");
            ksql.append("    FBcToUnewhQty, \n");
            ksql.append("    FBUntoQty, \n");
            ksql.append("    FCTiQty, \n");
            ksql.append("    FCToQty, \n");
            ksql.append("    FEcToUnewhQty, \n");
            ksql.append("    FEUntoQty, \n");
            ksql.append("    FEUntoCntQty, \n");
            ksql.append("    FSeq, \n");
            ksql.append("    FFlag, \n");
            ksql.append("    FCreatorID, \n");
            ksql.append("    FCreateTime, \n");
            ksql.append("    FLastUpdateUserID, \n");
            ksql.append("    FLastUpdateTime, \n");
            ksql.append("    FControlUnitID \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    newbosid('25F438D7') FID, \n");
            ksql.append("    '" + companyId + "' FCompanyOrg, \n");
            ksql.append("    '" + periodId + "' FCalculatePeriod, \n");
            ksql.append("    b.FOrderID FOrderID, \n");
            ksql.append("    1 FWipType, \n");
            ksql.append("    null FActivityID, \n");
            ksql.append("    0 FBcToUnewhQty, \n");
            ksql.append("    0 FBUntoQty, \n");
            ksql.append("    0 FCTiQty, \n");
            ksql.append("    0 FCToQty, \n");
            ksql.append("    0 FEcToUnewhQty, \n");
            ksql.append("    0 FEUntoQty, \n");
            ksql.append("    0 FEUntoCntQty, \n");
            ksql.append("    0 FSeq, \n");
            ksql.append("    0 FFlag, \n");
            ksql.append("    '").append(userId).append("' FCreatorID, \n");
            ksql.append("    GetDate() FCreateTime, \n");
            ksql.append("    '").append(userId).append("' FLastUpdateUserID, \n");
            ksql.append("    GetDate() FLastUpdateTime, \n");
            ksql.append("    '").append(cuId).append("' FControlUnitID \n");
            ksql.append("from " + T_NCM_OrderBalance + " b \n");
            ksql.append("where not exists ( \n");
            ksql.append("    select top 1 1 from T_NCM_OCWIPCountingBill wip \n");
            ksql.append("    where \n");
            ksql.append("    wip.FCompanyOrg = '" + companyId + "' \n");
            ksql.append("    and wip.FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("    and wip.FWipType = 1 \n");
            ksql.append("    and wip.FOrderID = b.FOrderID \n");
            ksql.append(") \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("update T_NCM_OCWIPCountingBill set \n");
            ksql.append("    FBUntoQty \n");
            ksql.append(" = ( \n");
            ksql.append("    select \n");
            ksql.append("    isnull(sum(b.FBopWIPQty), 0) FBUntoQty \n");
            ksql.append("    from " + T_NCM_OrderBalance + " b \n");
            ksql.append("    where b.FOrderID = T_NCM_OCWIPCountingBill.FOrderID \n");
            ksql.append(") \n");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("and FWipType = 1 \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("update T_NCM_OCWIPCountingBill wip set \n");
            ksql.append("FCTiQty = case \n");
            ksql.append("when FBUntoQty > 0 then 0 \n");
            ksql.append("else ( \n");
            ksql.append("    select o.FBaseQty from T_MM_ManufactureOrder o \n");
            ksql.append("    where o.FID = wip.FOrderID \n");
            ksql.append(") \n");
            ksql.append("end, \n");
            ksql.append("FCToQty = isnull(( \n");
            ksql.append("    select sum(e.FBaseQty) from T_IM_ManufactureRecBill b \n");
            ksql.append("    join T_IM_ManufactureRecBillEntry e on e.FParentID = b.FID \n");
            ksql.append("    and b.FBaseStatus = 4 \n");
            ksql.append("    and b.FStorageOrgUnitID in " + BDCMUtils.buildSqlFromIds((Set)storageOrgUnitIds) + " \n");
            ksql.append("    join T_SCM_TransactionType tt on tt.FID = b.FTransactionTypeID \n");
            ksql.append("    and tt.FIsManuCostCalculate = 1 \n");
            ksql.append("\t inner join T_IM_InvUpdateType ut on e.FINVUPDATETYPEID = ut.fid \n");
            ksql.append("\t inner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 \n");
            ksql.append("    where e.FManuBillID = wip.FOrderID \n");
            ksql.append("    and b.FYear = " + period.getPeriodYear() + " \n");
            ksql.append("    and b.FPeriod = " + period.getPeriodNumber() + " \n");
            ksql.append("), 0) \n");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("and FWipType = 1 \n");
            ksql.append("and FFlag = 0 \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("update T_NCM_OCWIPCountingBill wip set \n");
            ksql.append("FEUntoQty = FBUntoQty + FCTiQty - FCToQty \n");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("and FWipType = 1 \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("update T_NCM_OCWIPCountingBill wip set \n");
            ksql.append("FEUntoCntQty = FEUntoQty \n");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("and FWipType = 1 \n");
            ksql.append("and FFlag = 0 \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into " + tempTable + " ( \n");
            ksql.append("    FOrderID, \n");
            ksql.append("    FBaseQty, \n");
            ksql.append("    FSeq, \n");
            ksql.append("    FOperationID, \n");
            ksql.append("    FActivityID \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("     o.FID FOrderID, \n");
            ksql.append("     case when o.FActureBeginDate >= ? and o.FActureBeginDate <= ? then o.FBaseQty \n");
            ksql.append("     else 0 end FBaseQty, \n");
            ksql.append("     ot.FSeq FSeq, \n");
            ksql.append("     op.FID FOperationID, \n");
            ksql.append("     a.FID FActivityID \n");
            ksql.append("from T_MM_ManufactureOrder o \n");
            ksql.append("join T_MM_MFTOrderTechnics ot on ot.FParentID = o.FID \n");
            ksql.append("join T_MM_Operation op on op.FID = ot.FOperationID \n");
            ksql.append("left join T_NCM_ActivityOperation ao on ao.FOperationID = op.FID  \n");
            ksql.append("left join T_NCM_Activity a on a.FID = ao.FParentID  \n");
            ksql.append("where o.FBaseStatus in ( \n");
            ksql.append("    5, \n");
            ksql.append("    7, \n");
            ksql.append("    8 \n");
            ksql.append(") \n");
            ksql.append("and o.FActureBeginDate <= ? \n");
            ksql.append("and o.FStorageOrgUnitID in " + BDCMUtils.buildSqlFromIds((Set)storageOrgUnitIds) + " \n");
            ksql.append("and a.FCompanyID = '" + companyId + "' \n");
            ksql.append("and a.FDeletedStatus = 1 \n");
            ksql.append("and exists ( \n");
            ksql.append("    select top 1 1 from T_NCM_OCWIPCountingBill wip \n");
            ksql.append("    where \n");
            ksql.append("    wip.FCompanyOrg = '" + companyId + "' \n");
            ksql.append("    and wip.FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("    and wip.FWipType = 1 \n");
            ksql.append("    and wip.FOrderID = o.FID \n");
            ksql.append(") \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString(), (Object[])new Object[]{period.getBeginDate(), period.getEndDate(), period.getEndDate()});
            ksql.setLength(0);
            ksql.append("update " + tempTable + " t set FQualifiedQty = ( \n");
            ksql.append("    select isnull(sum(be.FQualifiedQty), 0) \n");
            ksql.append("    from T_NCM_OrderReportBill b \n");
            ksql.append("    join T_NCM_OrderReportBillQtyEntry be \n");
            ksql.append("    on be.FParentID = b.FID \n");
            ksql.append("    where b.FManuFacturerOrderID = t.FOrderID \n");
            ksql.append("    and be.FActivityID = t.FActivityID \n");
            ksql.append("    and b.FBillStatus = 4 \n");
            ksql.append("    and b.FCompanyOrg = '" + companyId + "' \n");
            ksql.append("    and b.FCalculatePeriod = '" + periodId + "' \n");
            ksql.append(") \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("select * from " + tempTable + " \n");
            ksql.append("order by \n");
            ksql.append("FOrderID, FSeq, FOperationID \n");
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)ksql.toString());
            HashMap<String, OrderItem> orderItems = new HashMap<String, OrderItem>();
            while (rowset.next()) {
                orderId2 = rowset.getString("FOrderID");
                BigDecimal baseQty = rowset.getBigDecimal("FBaseQty");
                String activityId = rowset.getString("FActivityID");
                String operationId = rowset.getString("FOperationID");
                int seq = rowset.getInt("FSeq");
                BigDecimal qualifiedQty = rowset.getBigDecimal("FQualifiedQty");
                int reportCount = rowset.getInt("FReportCount");
                OrderItem orderItem = (OrderItem)orderItems.get(orderId2);
                if (orderItem == null) {
                    orderItem = new OrderItem();
                    orderItem.baseQty = baseQty;
                    orderItems.put(orderId2, orderItem);
                }
                orderItem.add(activityId, operationId, seq, qualifiedQty, reportCount);
            }
            ksql.setLength(0);
            ksql.append("delete from T_NCM_OCWIPCountingBill \n");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("and FWipType = 2 \n");
            ksql.append("and not exists ( \n");
            ksql.append("    select top 1 1 from " + tempTable + " t \n");
            ksql.append("    where t.FOrderID = T_NCM_OCWIPCountingBill.FOrderID \n");
            ksql.append("    and t.FActivityID = T_NCM_OCWIPCountingBill.FActivityID \n");
            ksql.append(") \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("insert into T_NCM_OCWIPCountingBill ( \n");
            ksql.append("    FID, \n");
            ksql.append("    FCompanyOrg, \n");
            ksql.append("    FCalculatePeriod, \n");
            ksql.append("    FOrderID, \n");
            ksql.append("    FWipType, \n");
            ksql.append("    FActivityID, \n");
            ksql.append("    FBcToUnewhQty, \n");
            ksql.append("    FBUntoQty, \n");
            ksql.append("    FCTiQty, \n");
            ksql.append("    FCToQty, \n");
            ksql.append("    FEcToUnewhQty, \n");
            ksql.append("    FEUntoQty, \n");
            ksql.append("    FEUntoCntQty, \n");
            ksql.append("    FSeq, \n");
            ksql.append("    FFlag, \n");
            ksql.append("    FCreatorID, \n");
            ksql.append("    FCreateTime, \n");
            ksql.append("    FLastUpdateUserID, \n");
            ksql.append("    FLastUpdateTime, \n");
            ksql.append("    FControlUnitID \n");
            ksql.append("    ) \n");
            ksql.append("select \n");
            ksql.append("    newbosid('25F438D7') FID, \n");
            ksql.append("    '" + companyId + "' FCompanyOrg, \n");
            ksql.append("    '" + periodId + "' FCalculatePeriod, \n");
            ksql.append("    t.FOrderID FOrderID, \n");
            ksql.append("    2 FWipType, \n");
            ksql.append("    t.FActivityID FActivityID, \n");
            ksql.append("    0 FBcToUnewhQty, \n");
            ksql.append("    0 FBUntoQty, \n");
            ksql.append("    0 FCTiQty, \n");
            ksql.append("    0 FCToQty, \n");
            ksql.append("    0 FEcToUnewhQty, \n");
            ksql.append("    0 FEUntoQty, \n");
            ksql.append("    0 FEUntoCntQty, \n");
            ksql.append("    0 FSeq, \n");
            ksql.append("    0 FFlag, \n");
            ksql.append("    '").append(userId).append("' FCreatorID, \n");
            ksql.append("    GetDate() FCreateTime, \n");
            ksql.append("    '").append(userId).append("' FLastUpdateUserID, \n");
            ksql.append("    GetDate() FLastUpdateTime, \n");
            ksql.append("    '").append(cuId).append("' FControlUnitID \n");
            ksql.append("from ( \n");
            ksql.append("    select distinct FOrderID, FActivityID \n");
            ksql.append("    from " + tempTable + " \n");
            ksql.append("    where FActivityID is not null \n");
            ksql.append(") t \n");
            ksql.append("where not exists ( \n");
            ksql.append("    select top 1 1 from T_NCM_OCWIPCountingBill wip \n");
            ksql.append("    where \n");
            ksql.append("    wip.FCompanyOrg = '" + companyId + "' \n");
            ksql.append("    and wip.FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("    and wip.FOrderID = t.FOrderID \n");
            ksql.append("    and wip.FActivityID = t.FActivityID \n");
            ksql.append("    and wip.FWipType = 2 \n");
            ksql.append(") \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("update T_NCM_OCWIPCountingBill set \n");
            ksql.append("FBcToUnewhQty = ( \n");
            ksql.append("    select \n");
            ksql.append("    isnull(sum(ia.FBcToUnewhQty), 0) FBcToUnewhQty \n");
            ksql.append("    from " + T_NCM_OrderBalance + " i \n");
            ksql.append("    join " + T_NCM_OrderBalanceActivity + " ia on ia.FParentID = i.FID \n");
            ksql.append("    where i.FOrderID = T_NCM_OCWIPCountingBill.FOrderID \n");
            ksql.append("    and ia.FActivityID = T_NCM_OCWIPCountingBill.FActivityID \n");
            ksql.append("), \n");
            ksql.append("FBUntoQty = ( \n");
            ksql.append("    select \n");
            ksql.append("    isnull(sum(ia.FBUntoQty), 0) FBUntoQty \n");
            ksql.append("    from " + T_NCM_OrderBalance + " i \n");
            ksql.append("    join " + T_NCM_OrderBalanceActivity + " ia on ia.FParentID = i.FID \n");
            ksql.append("    where i.FOrderID = T_NCM_OCWIPCountingBill.FOrderID \n");
            ksql.append("    and ia.FActivityID = T_NCM_OCWIPCountingBill.FActivityID \n");
            ksql.append(") \n");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("and FWipType = 2 \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("update T_NCM_OCWIPCountingBill set \n");
            ksql.append("FCTiQty = ?, FCToQty = ? \n");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("and FOrderID = ? \n");
            ksql.append("and FActivityID = ? \n");
            ksql.append("and FWipType = 2 \n");
            ksql.append("and FFlag = 0 \n");
            pstmt = conn.prepareStatement(ksql.toString());
            orderId2 = null;
            OrderItem orderItem = null;
            int index = 0;
            ActivityItem activityItem = null;
            for (String orderId2 : orderItems.keySet()) {
                orderItem = (OrderItem)orderItems.get(orderId2);
                for (int i = 0; i < orderItem.activityItems.size(); ++i) {
                    activityItem = (ActivityItem)orderItem.activityItems.get(i);
                    if (activityItem.activityId == null) continue;
                    index = 0;
                    pstmt.setBigDecimal(++index, activityItem.getCurrentTiQty(orderItem));
                    pstmt.setBigDecimal(++index, activityItem.getCurrentToQty());
                    pstmt.setString(++index, orderId2);
                    pstmt.setString(++index, activityItem.activityId);
                    pstmt.addBatch();
                }
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt, null);
            ksql.setLength(0);
            ksql.append("update T_NCM_OCWIPCountingBill set \n");
            ksql.append("FFirstOperationID = ?, FLastOperationID = ?, FSeq = ? \n");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("and FOrderID = ? \n");
            ksql.append("and FActivityID = ? \n");
            ksql.append("and FWipType = 2 \n");
            pstmt = conn.prepareStatement(ksql.toString());
            for (String orderId2 : orderItems.keySet()) {
                orderItem = (OrderItem)orderItems.get(orderId2);
                for (int i = 0; i < orderItem.activityItems.size(); ++i) {
                    activityItem = (ActivityItem)orderItem.activityItems.get(i);
                    if (activityItem.activityId == null) continue;
                    index = 0;
                    pstmt.setString(++index, activityItem.getFirstOperaction());
                    pstmt.setString(++index, activityItem.getLastOperaction());
                    pstmt.setInt(++index, activityItem.getSeq());
                    pstmt.setString(++index, orderId2);
                    pstmt.setString(++index, activityItem.activityId);
                    pstmt.addBatch();
                }
            }
            pstmt.executeBatch();
            SQLUtils.cleanup((Statement)pstmt, null);
            ksql.setLength(0);
            ksql.append("update T_NCM_OCWIPCountingBill t set \n");
            ksql.append("FcurFinishedQty = isnull(( \n");
            ksql.append("    select sum(e.FBaseQty) from T_IM_ManufactureRecBill b \n");
            ksql.append("    join T_IM_ManufactureRecBillEntry e on e.FParentID = b.FID \n");
            ksql.append("    and b.FBaseStatus = 4 \n");
            ksql.append("    and b.FStorageOrgUnitID in " + BDCMUtils.buildSqlFromIds((Set)storageOrgUnitIds) + " \n");
            ksql.append("    join T_SCM_TransactionType tt on tt.FID = b.FTransactionTypeID \n");
            ksql.append("    and tt.FIsManuCostCalculate = 1 \n");
            ksql.append("\t inner join T_IM_InvUpdateType ut on e.FINVUPDATETYPEID = ut.fid \n");
            ksql.append("\t inner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 \n");
            ksql.append("    where e.FManuBillID = t.FOrderID \n");
            ksql.append("    and b.FYear = " + period.getPeriodYear() + " \n");
            ksql.append("    and b.FPeriod = " + period.getPeriodNumber() + " \n");
            ksql.append("), 0) \n");
            ksql.append(",FCumFinishedQty = isnull(( \n");
            ksql.append("    select sum(e.FBaseQty) from T_IM_ManufactureRecBill b \n");
            ksql.append("    join T_IM_ManufactureRecBillEntry e on e.FParentID = b.FID \n");
            ksql.append("    and b.FBaseStatus = 4 \n");
            ksql.append("    and b.FStorageOrgUnitID in " + BDCMUtils.buildSqlFromIds((Set)storageOrgUnitIds) + " \n");
            ksql.append("    join T_SCM_TransactionType tt on tt.FID = b.FTransactionTypeID \n");
            ksql.append("    and tt.FIsManuCostCalculate = 1 \n");
            ksql.append("\t inner join T_IM_InvUpdateType ut on e.FINVUPDATETYPEID = ut.fid ").append('\n');
            ksql.append("\t inner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 ").append('\n');
            ksql.append("    where e.FManuBillID = t.FOrderID \n");
            ksql.append("), 0) \n");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("update T_NCM_OCWIPCountingBill set \n");
            ksql.append("FEcToUnewhQty = FBcToUnewhQty + FCToQty - FCurFinishedQty, \n");
            ksql.append("FEUntoQty = FBUntoQty + FCTiQty - FCToQty \n");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("and FWipType = 2 \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("update T_NCM_OCWIPCountingBill set \n");
            ksql.append("FEUntoCntQty = FEUntoQty \n");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            ksql.append("and FWipType = 2 \n");
            ksql.append("and FFlag = 0 \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString());
            ksql.setLength(0);
            ksql.append("update T_NCM_OCWIPCountingBill wip set \n");
            ksql.append("(FOrderNumber, FOrderProductID, FOrderProductLot) = ( \n");
            ksql.append("    select \n");
            ksql.append("    o.FNumber FOrderNumber, \n");
            ksql.append("    o.FMaterialID FOrderProdID, \n");
            ksql.append("    case when mc.FAccountType = 5 \n");
            ksql.append("    then (case when o.FLot is null then N' ' else (o.FLot||N'') end) \n");
            ksql.append("    else N' ' end FOrderProdBatchNo \n");
            ksql.append("    from T_MM_ManufactureOrder o \n");
            ksql.append("    left join T_BD_MaterialCompanyInfo mc on \n");
            ksql.append("    mc.FCompanyID = '" + companyId + "' and mc.FMaterialID = o.FMaterialID \n");
            ksql.append("    where o.FID = wip.FOrderID \n");
            ksql.append(") \n");
            ksql.append("where FCompanyOrg = '" + companyId + "' \n");
            ksql.append("and FCalculatePeriod = '" + periodId + "' \n");
            DbUtil.execute((Context)ctx, (String)ksql.toString());
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
                SQLUtils.cleanup(pstmt, null);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        SQLUtils.cleanup((Statement)pstmt, null);
    }

    private static class OperationItem {
        String operationId;
        int seq;
        BigDecimal qualifiedQty;

        private OperationItem() {
        }

        public boolean isReport() {
            return this.qualifiedQty != null && this.qualifiedQty.compareTo(SysConstant.BIGZERO) > 0;
        }
    }

    private static class ActivityItem {
        String activityId;
        List operationItems = new ArrayList();

        private ActivityItem() {
        }

        public void add(String operationId, int seq, BigDecimal qualifiedQty, int reportCount) {
            OperationItem operationItem = new OperationItem();
            operationItem.operationId = operationId;
            operationItem.seq = seq;
            operationItem.qualifiedQty = qualifiedQty;
            this.operationItems.add(operationItem);
        }

        public int getSeq() {
            if (this.operationItems.size() > 0) {
                return ((OperationItem)this.operationItems.get((int)0)).seq;
            }
            return 0;
        }

        public String getFirstOperaction() {
            if (this.operationItems.size() > 0) {
                return ((OperationItem)this.operationItems.get((int)0)).operationId;
            }
            return null;
        }

        public String getLastOperaction() {
            if (this.operationItems.size() > 0) {
                return ((OperationItem)this.operationItems.get((int)(this.operationItems.size() - 1))).operationId;
            }
            return null;
        }

        public BigDecimal getCurrentTiQty(OrderItem orderItem) {
            BigDecimal qty = null;
            int index = orderItem.activityItems.indexOf(this);
            if (index > 0) {
                ActivityItem activityItem = (ActivityItem)orderItem.activityItems.get(index - 1);
                qty = activityItem.getCurrentToQty();
            } else {
                qty = orderItem.baseQty;
            }
            if (qty == null) {
                qty = SysConstant.BIGZERO;
            }
            return qty;
        }

        public BigDecimal getCurrentToQty() {
            BigDecimal qty = null;
            if (this.operationItems.size() > 0) {
                OperationItem operationItem = null;
                for (int i = this.operationItems.size() - 1; i >= 0; --i) {
                    operationItem = (OperationItem)this.operationItems.get(i);
                    if (!operationItem.isReport()) continue;
                    qty = operationItem.qualifiedQty;
                    break;
                }
            }
            if (qty == null) {
                qty = SysConstant.BIGZERO;
            }
            return qty;
        }
    }

    private static class OrderItem {
        BigDecimal baseQty;
        List activityItems = new ArrayList();

        private OrderItem() {
        }

        public void add(String activityId, String operationId, int seq, BigDecimal qualifiedQty, int reportCount) {
            ActivityItem activityItem = null;
            if (activityId == null) {
                activityItem = new ActivityItem();
                this.activityItems.add(activityItem);
            } else {
                for (int i = 0; i < this.activityItems.size(); ++i) {
                    ActivityItem temp = (ActivityItem)this.activityItems.get(i);
                    if (temp.activityId == null || !temp.activityId.equals(activityId)) continue;
                    activityItem = temp;
                    break;
                }
                if (activityItem == null) {
                    activityItem = new ActivityItem();
                    activityItem.activityId = activityId;
                    this.activityItems.add(activityItem);
                }
            }
            activityItem.add(operationId, seq, qualifiedQty, reportCount);
        }
    }
}

