/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.app.calc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.order.fact.cal.OrderCalcLogCollection;
import com.kingdee.eas.ncm.order.fact.cal.app.calc.allocwip.AllocWIP;
import com.kingdee.eas.ncm.order.fact.cal.app.calc.helper.CalcParamAdapter;
import com.kingdee.eas.ncm.order.fact.cal.app.calc.helper.CalcUtils;
import com.kingdee.eas.ncm.order.fact.cal.utils.app.CalcAppUntil;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.ICalculateFacade;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class OrderCalcDispatch {
    private static Logger logger = Logger.getLogger((String)OrderCalcDispatch.class.getName());
    public static final char CLF = '\n';
    private CalcParamAdapter _calcParam;

    public OrderCalcDispatch(CalcParamAdapter calcParam) throws BOSException {
        Assert.that((calcParam != null ? 1 : 0) != 0);
        this._calcParam = calcParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap DoCalc() throws BOSException, EASBizException {
        boolean isCalcSuccess = false;
        HashMap<String, Object> ret = new HashMap<String, Object>();
        AllocWIP alloc = null;
        String logSign = "";
        try {
            this.setLogger("LoggerInof_BeginCalc", new Object[]{"-"});
            this.setLogger("LoggerInof_ClearLast", new Object[]{"--A"});
            Integer mainProcess = new Integer(1);
            this.setCostCalProcess(mainProcess, "Calc_ClearLast");
            this.ClearPreCalcResult();
            this.setLogger("LoggerInof_GetProcessData", new Object[]{"--B"});
            mainProcess = new Integer(2);
            this.setCostCalProcess(mainProcess, "Calc_GetProcessData");
            this.GetProcessData();
            this._calcParam.getCalcProcess().CommitCacheSetProcessSql();
            this.setLogger("LoggerInof_CalcByRank", new Object[]{"--C"});
            int lowest = CalcUtils.getLowestRank(this._calcParam.getCtx(), this._calcParam.getCompanyId(), this._calcParam.getPeriodId());
            alloc = new AllocWIP(this._calcParam);
            int dispRank = 0;
            Integer detailProcess = null;
            Integer lowRankLevel = null;
            mainProcess = new Integer(4);
            for (int rank = lowest; rank >= 0; --rank) {
                lowRankLevel = new Integer(++dispRank);
                logSign = "---C.Rank" + String.valueOf(dispRank);
                try {
                    this.setLogger("LoggerInof_CurrentRank", new Object[]{logSign, String.valueOf(dispRank)});
                    this.setLogger("LoggerInof_CurrentRank_AddCalcLog_Head", new Object[]{logSign + ".01"});
                    this._calcParam.getCalcLog().AddCalcLog_Head(dispRank);
                    this.setLogger("LoggerInof_CurrentRank_AddCalcLog_PreSet", new Object[]{logSign + ".02"});
                    this._calcParam.getCalcLog().AddCalcLog_PreSet(rank, dispRank);
                    this.setLogger("LoggerInof_CurrentRank_DoAllocWIP", new Object[]{logSign + ".03"});
                    detailProcess = new Integer(1);
                    this.setCostCalProcess(mainProcess, lowRankLevel, detailProcess, "Calc_AllocWIP");
                    this._calcParam.getCalcProcess().CommitCacheSetProcessSql();
                    alloc.setCalcRank(rank);
                    isCalcSuccess = alloc.DoAllocWIP();
                    this.setLogger("LoggerInof_CurrentRank_UpdatePreSetCalcLog", new Object[]{logSign + ".04"});
                    this._calcParam.getCalcLog().UpdatePreSetCalcLog(dispRank);
                    this.setLogger("LoggerInof_CurrentRank_calcIn", new Object[]{logSign + ".05"});
                    detailProcess = new Integer(3);
                    this.setCostCalProcess(mainProcess, lowRankLevel, detailProcess, "Calc_CalcIn");
                    this.calcIn(rank, dispRank, this._calcParam.getPeriodYear(), this._calcParam.getPeriodNumber(), this._calcParam.getCurrencyPrecision());
                    this.setLogger("LoggerInof_CurrentRank_calcOut", new Object[]{logSign + ".06"});
                    detailProcess = new Integer(4);
                    this.setCostCalProcess(mainProcess, lowRankLevel, detailProcess, "Calc_CalcOut");
                    this._calcParam.getCalcProcess().CommitCacheSetProcessSql();
                    this.CalcOut(rank, dispRank);
                    this.setLogger("LoggerInof_CurrentRank_SecAlloc", new Object[]{logSign + ".07"});
                    detailProcess = new Integer(5);
                    this.setCostCalProcess(mainProcess, lowRankLevel, detailProcess, "Calc_SecAlloc");
                    this.SecAlloc(rank, dispRank);
                    continue;
                }
                finally {
                    this._calcParam.getCalcLog().CommitCacheLogSql();
                    this._calcParam.getCalcProcess().CommitCacheSetProcessSql();
                }
            }
            this.setLogger("LoggerInof_CalcManufRecBillTotalActualCost", new Object[]{"--D"});
            mainProcess = new Integer(6);
            this.setCostCalProcess(mainProcess, "Calc_UpdateManufRecBillTotalActualCost");
            this.calManufRecBillTotalActualCost(this._calcParam.getPeriodYear(), this._calcParam.getPeriodNumber());
        }
        catch (Throwable throwable) {
            this.setLogger("LoggerInof_BeginCalc", new Object[]{"--F"});
            OrderCalcLogCollection logData = this._calcParam.getCalcLog().GetCalcLogData();
            ret.put("logData", (Object)logData);
            this.setLogger("LoggerInof_BeginCalc", new Object[]{"-"});
            Integer mainProcess = new Integer(7);
            this.setCostCalProcess(mainProcess, "Calc_End");
            this._calcParam.getCalcProcess().CommitCacheSetProcessSql();
            throw throwable;
        }
        this.setLogger("LoggerInof_BeginCalc", new Object[]{"--F"});
        OrderCalcLogCollection logData = this._calcParam.getCalcLog().GetCalcLogData();
        ret.put("logData", (Object)logData);
        this.setLogger("LoggerInof_BeginCalc", new Object[]{"-"});
        Integer mainProcess = new Integer(7);
        this.setCostCalProcess(mainProcess, "Calc_End");
        this._calcParam.getCalcProcess().CommitCacheSetProcessSql();
        ret.put("HasError", String.valueOf(!isCalcSuccess));
        return ret;
    }

    private void setLogger(String resKey, Object[] arguments) {
        String infoMsg = MessageFormat.format(CalcUtils.getCalcAppResource(this._calcParam.getCtx(), resKey), arguments);
        logger.info((Object)infoMsg);
    }

    private void ClearPreCalcResult() throws BOSException {
        DynamicTableManager.TruncateTables((Context)this._calcParam.getCtx(), (String[])new String[]{this._calcParam.get_tbl_OrderCostCalResult(), this._calcParam.get_tbl_OrderCostCalMatDetailResult(), this._calcParam.get_tbl_OrderCostCalActivityResult(), this._calcParam.get_tbl_OrderCostCalActivityDetailResult()});
    }

    private void GetProcessData() throws BOSException {
    }

    protected void calManufRecBillTotalActualCost(String periodYear, String periodNumber) throws BOSException {
        String tblName = this._calcParam.get_tempTbl_Partial_ManufactureRecBill();
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_IM_ManufactureRecBill ").append("\tSET FTotalActualCost=(").append('\n').append("\t\t\tSELECT ISNULL(SUM(entry.FActualCost), 0)").append('\n').append("\t\t\t\tFROM T_IM_ManufactureRecBillEntry entry").append('\n').append("\t\t\t\t\tJOIN ").append(tblName).append(" temp ON temp.FID = entry.FID").append('\n').append("\t\t\t\tWHERE T_IM_ManufactureRecBill.FID = entry.FParentID)").append('\n').append("\tWHERE EXISTS (").append('\n').append("\t\t\tSELECT 1 ").append('\n').append("\t\t\t\tFROM T_IM_ManufactureRecBillEntry entry").append('\n').append("\t\t\t\t\tJOIN ").append(tblName).append(" temp ON temp.FID = entry.FID").append('\n').append("\t\t\t\tWHERE T_IM_ManufactureRecBill.FID = entry.FParentId)").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sql.toString(), (String)";");
    }

    protected void calcIn(int rank, int dispRank, String periodYear, String periodNumber, int companyBaseCurrencyPrec) throws BOSException {
        boolean isSuccess = false;
        String tblName = this._calcParam.get_tempTbl_Partial_ManufactureRecBill();
        StringBuffer sql = new StringBuffer();
        sql.append("Delete from ").append(tblName).append(";").append('\n').append("INSERT INTO ").append(tblName).append("(FId, FUnitActualCost) (").append('\n').append("\tSELECT entry.fid, ");
        CalcUtils.AppendCaseSQLClause(sql, "ISNULL(SUM(S.FFinishedAmount),0)", "ISNULL(MAX(S.FTotalFinishedQty),1)", "ISNULL(SUM(S.FFinishedAmount),0)", "FUnitActualCost", "MAX(mt.FPricePrecision)");
        sql.append("       FROM ").append(this._calcParam.get_tbl_OrderCostCalResult()).append(" S ").append('\n').append("           LEFT JOIN T_IM_ManufactureRecBillEntry entry ON entry.FCostCenterOrgunitId = s.FCostCenterId ").append('\n').append("               AND s.FCompanyId = entry.FCompanyOrgunitId").append('\n').append("               AND s.FProductId = entry.FMaterialId AND S.FOrderID= entry.FManuBillID ").append('\n').append("\t\t\tLEFT JOIN T_IM_ManufactureRecBill bill ON entry.FParentId = bill.FId ").append('\n').append("           INNER JOIN T_SCM_TransactionType trans ON bill.FTransactionTypeId = trans.FId AND trans.FIsManuCostCalculate = 1").append('\n').append("\t \t\tinner join T_IM_InvUpdateType ut on entry.FINVUPDATETYPEID = ut.fid ").append('\n').append("\t \t\tnner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 ").append('\n').append("           LEFT JOIN T_BD_Material mt ON mt.FId = entry.FMaterialId").append('\n').append("           LEFT JOIN T_BD_MaterialCompanyInfo mc ON mc.FCompanyID=S.FCompanyID AND mc.FMaterialID = entry.FMaterialId").append('\n').append("\t\tWHERE bill.FBaseStatus = 4").append('\n').append("         \tAND bill.FYear = ").append(periodYear).append(" \t\t\tAND bill.FPeriod=").append(periodNumber).append('\n').append("           AND s.FCompanyId = '").append(this._calcParam.getCompanyId()).append("'").append('\n').append("           AND s.FCalculatePeriodId = '").append(this._calcParam.getPeriodId()).append("' ").append('\n').append("\t\t \tAND S.FCalcLevel=").append(rank).append('\n').append("\t\t \tAND entry.FId IS NOT NULL ").append('\n').append("\t\t\tAND ((mc.FAccountType = 5 AND Isnull(ENTRY.FLot,N' ') = Isnull(S.FProdBatchNo,N' '))").append('\n').append("\t\t\t\tOR mc.FAccountType <> 5)").append('\n').append("\t\tGROUP BY entry.FId);");
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sql.toString(), (String)";");
        NCMDbUtil.analyzeTempTable((Context)this._calcParam.getCtx(), (String)tblName);
        sql.setLength(0);
        sql.append("UPDATE T_IM_ManufactureRecBillEntry ").append("\tSET FUnitActualCost =(").append(" \t\t\tSELECT temp.FUnitActualCost").append('\n').append("\t\t\t\tFROM ").append(tblName).append(" temp ").append('\n').append("\t\t\t\tWHERE T_IM_ManufactureRecBillEntry.FId = temp.FId)").append('\n').append("\tWHERE FID IN (SELECT FID FROM ").append(tblName).append(");");
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sql.toString(), (String)";");
        sql.setLength(0);
        sql.append("UPDATE T_IM_ManufactureRecBillEntry ").append("\tSET FActualCost=(").append('\n').append(" \t\t\tSELECT ROUND(ISNULL(temp.FUnitActualCost * T_IM_ManufactureRecBillEntry.FBaseQty, 0),").append("\t\t\t\t\tISNULL(").append(companyBaseCurrencyPrec).append(", 8)) ").append('\n').append("\t\t\t\tFROM ").append(tblName).append(" temp ").append('\n').append("\t\t\t\tWHERE T_IM_ManufactureRecBillEntry.FId = temp.FId)").append('\n').append("\tWHERE FID IN (SELECT FID FROM ").append(tblName).append(" )");
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sql.toString(), (String)";");
        this.AdjustDiff_CalcIn(rank, dispRank, periodYear, periodNumber);
        sql.setLength(0);
        sql.append("INSERT INTO ").append(tblName).append(" (FId, FUnitActualCost, FIsAdjust ) ").append('\n').append("\t(SELECT entry.FID, ").append("\t\t\tRound(TO_DECIMAL(ISNULL(entry.FActualCost, 0), 24, 12) / TO_DECIMAL(ISNULL(entry.FQty, 1), 24, 12), MT.FPricePrecision) FUnitActualCost, ").append('\n').append(" \t\t\t1 FIsAdjust").append("\t\tFROM ").append(tblName).append(" temp ").append('\n').append("\t\t\tJOIN T_IM_ManufactureRecBillEntry entry ON entry.FId = temp.FId").append('\n').append("\t\t\tLEFT JOIN T_BD_Material mt ON mt.FId = entry.FMaterialId ").append('\n').append("\t\tWHERE entry.FUnitId <> entry.FBaseUnitId );").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sql.toString(), (String)";");
        sql.setLength(0);
        sql.append("UPDATE T_IM_ManufactureRecBillEntry ").append("\tSET FUnitActualCost =(").append(" \t\t\tSELECT temp.FUnitActualCost").append('\n').append("\t\t\t\tFROM ").append(tblName).append(" temp ").append('\n').append("\t\t\t\tWHERE T_IM_ManufactureRecBillEntry.FId = temp.FId ").append("\t\t\t\t\tAND temp.FIsAdjust = 1)").append('\n').append("\tWHERE FID IN (SELECT FID FROM ").append(tblName).append(" WHERE FIsAdjust = 1);");
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sql.toString(), (String)";");
        isSuccess = true;
        String status = null;
        status = isSuccess ? CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_Sucess") : CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_Fail");
        this._calcParam.getCalcLog().AddCalcLog(dispRank, CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_CalcIn"), status, "", false, " ", " ", " ", "CalcIn", "CalcIn", 2);
    }

    private void AdjustDiff_CalcIn(int rank, int dispRank, String periodYear, String periodNumber) throws BOSException {
        IRowSet rs = null;
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("Select D.FCostCenterID, D.FMaterialID, D.FLot, (S.FSrcSumAmount - D.FDestSumAmount )As FAmountDiff ").append('\n').append("FROM (").append('\n').append("\tSELECT entry.FCOSTCENTERORGUNITID as FCostCenterID, entry.FManuBillID, entry.FMaterialID,  ").append('\n').append("\tCASE WHEN  mc.FAccountType <> 5 then N' ' ELSE ISNULL(entry.FLot,N' ') END As FLot, SUM(entry.FActualCost) As FDestSumAmount ").append('\n').append("\tFROM T_IM_ManufactureRecBill bill ").append('\n').append("\tINNER JOIN T_SCM_TransactionType AS TRANS ON bill.FTransactionTypeID = TRANS.FID AND TRANS.FIsManuCostCalculate=1 ").append('\n').append("\tLEFT JOIN T_IM_ManufactureRecBillEntry entry ON entry.FParentid=bill.FID ").append('\n').append("\tinner join T_IM_InvUpdateType ut on entry.FINVUPDATETYPEID = ut.fid ").append('\n').append("\tinner join T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 ").append('\n').append("   LEFT JOIN T_BD_MaterialCompanyInfo mc ON mc.FCompanyID=entry.FCompanyorgUnitID AND mc.FMaterialID = entry.FMaterialId").append('\n').append("\tWHERE bill.FBaseStatus=4 AND bill.FYear=").append(periodYear).append(" AND bill.FPeriod=").append(periodNumber).append('\n').append("\t\tAND entry.FCompanyorgUnitID='").append(this._calcParam.getCompanyId()).append("' ").append('\n').append("\tGROUP BY entry.FCOSTCENTERORGUNITID, entry.FManuBillID, entry.FMaterialID,  mc.FAccountType, entry.FLot ").append('\n').append(")D ").append('\n').append("LEFT JOIN (").append('\n').append("\tSELECT FCostCenterID,FOrderID,FProductID,ISNULL(FProdBatchNo,' ')As FLot, SUM(FFinishedAmount)As FSrcSumAmount ").append('\n').append("\tFROM ").append(this._calcParam.get_tbl_OrderCostCalResult()).append('\n').append("\tWHERE FCompanyID='").append(this._calcParam.getCompanyId()).append("' AND FCalculatePeriodID='").append(this._calcParam.getPeriodId()).append("' AND FCalcLevel=").append(rank).append('\n').append("\tGROUP BY FCostCenterID,FOrderID,FProductID,FProdBatchNo ").append('\n').append(")S ON D.FCostCenterID=S.FCostCenterid AND D.FManuBillID=S.FOrderID AND D.FMaterialID=S.FProductID AND S.FLot = D.FLot").append('\n').append("where  D.FDestSumAmount<>S.FSrcSumAmount").append('\n');
            rs = NCMDbUtil.executeQuery((Context)this._calcParam.getCtx(), (String)sb.toString());
            if (rs.size() == 0) {
                return;
            }
            sb.delete(0, sb.length());
            sb.append("UPDATE T_IM_ManufactureRecBillEntry SET FActualCost=(FActualCost+?) ").append('\n').append("WHERE FID =(").append('\n').append("\tSelect top 1 entry.FID ").append('\n').append("\tFROM T_IM_ManufactureRecBill bill ").append('\n').append("\tINNER JOIN T_SCM_TransactionType AS TRANS ON bill.FTransactionTypeID = TRANS.FID AND TRANS.FIsManuCostCalculate=1 ").append('\n').append("\tLEFT JOIN T_IM_ManufactureRecBillEntry entry ON entry.FParentid=bill.FID ").append('\n').append("\tINNER JOIN T_IM_InvUpdateType ut on entry.FINVUPDATETYPEID = ut.fid ").append('\n').append("\tINNER JOIN T_IM_STORETYPE st on ut.FSTORETYPEID = st.fid and st.FISFORWARDAMT = 1 ").append('\n').append("\tLEFT JOIN T_BD_CostObject AS OBJ ON (OBJ.FStdProductIDID=entry.FMaterialID AND OBJ.FCompanyID=entry.FCompanyorgUnitID) ").append('\n').append("\tWHERE entry.FCOSTCENTERORGUNITID=? AND entry.FMaterialID=? AND CASE WHEN  OBJ.FCalculateMode <> 4 then N' ' ELSE ISNULL(entry.FLot,N' ') END=? ").append('\n').append("\t\tAND bill.FBaseStatus=4 AND bill.FYear=").append(periodYear).append(" AND bill.FPeriod=").append(periodNumber).append('\n').append("\t\tAND entry.FCompanyorgUnitID='").append(this._calcParam.getCompanyId()).append("' ").append('\n').append("\tORDER BY entry.FActualCost DESC ").append('\n').append(")");
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            rs.first();
            while (rs.getRow() > 0 && !rs.isAfterLast()) {
                paramList.add(new Object[]{rs.getBigDecimal("FAmountDiff"), rs.getString("FCostCenterID"), rs.getString("FMaterialID"), rs.getString("FLot")});
                rs.next();
            }
            NCMDbUtil.executeBatch((Context)this._calcParam.getCtx(), (String)sb.toString(), paramList);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    protected void CalcOut(int rank, int dispRank) throws BOSException {
        if (rank == 0) {
            return;
        }
        boolean isSuccess = false;
        String materialIdTempTableName = this._calcParam.get_tempTbl_calcOut();
        StringBuffer sb = new StringBuffer();
        sb.append("delete from  ").append(materialIdTempTableName).append('\n').append(";").append("insert into ").append(materialIdTempTableName).append('\n').append("select distinct FProductID  ").append('\n').append("From ").append(this._calcParam.get_tbl_OrderCostCalResult()).append('\n').append("where FCalcLevel = ").append(rank).append('\n').append(";");
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sb.toString(), (String)";");
        ICalculateFacade ida = CalculateFacadeFactory.getLocalInstance((Context)this._calcParam.getCtx());
        try {
            CalculateParams cps = ida.costCalculate(this.getFilterParam(this._calcParam.getCtx(), this._calcParam.getCompanyId(), materialIdTempTableName));
            if (cps != null) {
                isSuccess = cps.getBoolean("boolean");
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String status = null;
        status = isSuccess ? CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_Sucess") : CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_Fail");
        String calcItem = CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_CalcOut");
        String attachment = CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_SeeReport");
        this._calcParam.getCalcLog().AddCalcLog(dispRank, calcItem, status, attachment, false, " ", " ", " ", "CalcOut", "CalcOut", 3);
    }

    protected void SecAlloc(int rank, int dispRank) throws BOSException {
        if (rank == 0) {
            return;
        }
        boolean isSuccess = false;
        String tblName = this._calcParam.get_tempTbl_SecAlloc();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tblName).append("(FID, FQty,FAmount,FPrice) (").append('\n').append(" select distinct E.FID, E.FBaseQty As FQty, E.FActualCost As FAmount, E.FUnitActualCost As FPrice").append(" from T_IM_MaterialReqBillEntry E ").append(" INNER JOIN ").append(this._calcParam.get_tbl_OCMatAllocResult()).append(" AS D on E.FID=D.FSourceBillEntryID ").append('\n').append(" INNER JOIN ").append(this._calcParam.get_tbl_OrderCostCalResult()).append(" P ON P.FProductID=E.FMaterialID and P.FCOMPANYID = e.FCOMPANYORGUNITID ").append('\n').append(" LEFT JOIN T_BD_MaterialCompanyInfo mc ON mc.FCompanyID=e.FCOMPANYORGUNITID AND mc.FMaterialID = E.FMaterialId").append('\n').append(" where P.FCalcLevel = ").append(rank).append("\tAND ((mc.FAccountType = 5 AND Isnull(E.FLot,' ') = Isnull(P.FProdBatchNo,' '))").append('\n').append("\t\t\t\tOR mc.FAccountType <> 5)").append('\n').append(" \t\tAND D.FIsDirect=1 and (E.FBaseQty<>D.FQty or E.FActualCost<>D.FAmount or E.FUnitActualCost<>D.FPrice)").append(" ); ");
        sql.append("update ").append(this._calcParam.get_tbl_OCMatAllocResult()).append(" AS D set (FQty,FAmount,FPrice)=(").append('\n').append("\tSelect entry.FQty, entry.FAmount, entry.FPrice ").append("\tfrom " + tblName + " entry ").append("\twhere entry.FID= D.FSourceBillEntryID) ").append("where D.FIsDirect=1 and D.FSourceBillEntryID in (select fid from " + tblName + "); ");
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sql.toString(), (String)";");
        isSuccess = true;
        String status = null;
        status = isSuccess ? CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_Sucess") : CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_Fail");
        String calcItem = CalcAppUntil.getSrvCalcResource(this._calcParam.getCtx(), "Calc_Report_SecAlloc");
        this._calcParam.getCalcLog().AddCalcLog(dispRank, calcItem, status, "", false, " ", " ", " ", "SecAlloc", "SecAlloc", 4);
    }

    protected CalculateParams getFilterParam(Context ctx, String companyOrgInfoID, String materialTempTableName) throws EASBizException, BOSException {
        CalculateParams params = new CalculateParams();
        params.setBoolean("ISWRITECOSTCOMPUTEREPORT", true);
        params.setString("COMPANY_ID", companyOrgInfoID);
        params.setBoolean("IsOtherInvkCostCalculate", true);
        params.setBoolean("IsCreateTmpTable", true);
        params.setBoolean("IsCostAllAccountType", true);
        params.setString("ThirdPartyMaterialTableName", materialTempTableName);
        return params;
    }

    private void setCostCalProcess(Integer mainProcess, Integer FLowRankStep, Integer detailProcess, String description) throws BOSException, EASBizException {
        String descDisp = CalcUtils.getCalcAppResource(this._calcParam.getCtx(), description);
        this._calcParam.getCalcProcess().setProcess("OrderCostCal", mainProcess, FLowRankStep, detailProcess, descDisp);
    }

    private void setCostCalProcess(Integer mainProcess, String description) throws BOSException, EASBizException {
        String descDisp = CalcUtils.getCalcAppResource(this._calcParam.getCtx(), description);
        this._calcParam.getCalcProcess().setProcess("OrderCostCal", mainProcess, new Integer(0), new Integer(0), descDisp);
    }
}

