/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.app.calc.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.order.fact.cal.OrderCalcLogCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCalcLogFactory;
import com.kingdee.eas.ncm.order.fact.cal.app.calc.helper.CalcParamAdapter;
import com.kingdee.eas.ncm.order.fact.cal.app.calc.helper.CalcUtils;
import com.kingdee.util.Assert;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class CalcExceptionLog {
    private static Logger logger = Logger.getLogger((String)CalcExceptionLog.class.getName());
    private CalcParamAdapter _calcParam = null;
    private StringBuffer _logSqlCacheByRank = null;

    public CalcExceptionLog(CalcParamAdapter calcParam) throws BOSException {
        Assert.that((calcParam != null ? 1 : 0) != 0);
        this._calcParam = calcParam;
        this.ClearPreCalcLog();
    }

    private void ClearPreCalcLog() throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM T_NCM_OrderCalcLogEntry WHERE EXISTS( ").append('\n').append("\tSelect 1 ").append('\n').append("\tFROM T_NCM_OrderCalcLog L ").append('\n').append("\tWHERE L.FID=T_NCM_OrderCalcLogEntry.FParentID AND L.FCompanyID='").append(this._calcParam.getCompanyId()).append("' AND L.FPeriodId='").append(this._calcParam.getPeriodId()).append("' ").append('\n').append(");").append('\n').append("DELETE FROM T_NCM_OrderCalcLog WHERE FCompanyID='").append(this._calcParam.getCompanyId()).append("' AND FPeriodId='").append(this._calcParam.getPeriodId()).append("';").append('\n');
        NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)sb.toString(), (String)";");
    }

    private StringBuffer get_logSqlCacheByRank() {
        if (this._logSqlCacheByRank == null) {
            this._logSqlCacheByRank = new StringBuffer();
        }
        return this._logSqlCacheByRank;
    }

    public void CommitCacheLogSql() throws BOSException {
        if (this.get_logSqlCacheByRank().length() > 0) {
            NCMDbUtil.BatchSqlExecute((Context)this._calcParam.getCtx(), (String)this.get_logSqlCacheByRank().toString(), (String)";");
            this.get_logSqlCacheByRank().delete(0, this.get_logSqlCacheByRank().length());
        }
    }

    public void AddCalcLog(int dispRank, String calcItem, String status, String attachment, boolean hasDetailLog, String prodDispName, String orderNumber, String storageOrgUnitDisp, String materialId, String orderId, int sort) throws BOSException {
        String rankStr = MessageFormat.format(CalcUtils.getCalcAppResource(this._calcParam.getCtx(), "Calc_Report_Rank"), String.valueOf(dispRank));
        int hasDetail = 0;
        if (hasDetailLog) {
            hasDetail = 1;
        }
        this._writeLog(rankStr, calcItem, status, attachment, hasDetail, prodDispName, orderNumber, storageOrgUnitDisp, materialId, orderId, sort);
    }

    public void AddCalcDetailLog(String materialId, String orderId, String allocErrorInfo, String possibleReason, String adviceHandle) {
        this.get_logSqlCacheByRank().append("INSERT INTO T_NCM_OrderCalcLogEntry(FID,FParentId,FErrorInfo,FPossibleReason,FAdviceHandle)").append('\n').append("SELECT newbosid('D31FD95D')As FID,S.FID As FParentId,'").append(allocErrorInfo).append("','").append(possibleReason).append("','").append(adviceHandle).append("' ").append("FROM T_NCM_OrderCalcLog S ").append("WHERE FMaterialID='").append(materialId).append("' AND FOrderID = '").append(orderId).append("' ").append('\n').append("\t AND S.FCompanyID='").append(this._calcParam.getCompanyId()).append("' AND S.FPeriodId= '").append(this._calcParam.getPeriodId()).append("';");
    }

    public void AddCalcLog_Head(int dispRank) throws BOSException {
        String rankStr = MessageFormat.format(CalcUtils.getCalcAppResource(this._calcParam.getCtx(), "Calc_Report_Rank"), String.valueOf(dispRank));
        String calcItem = CalcUtils.getCalcAppResource(this._calcParam.getCtx(), "Calc_Report_CostCal");
        String status = CalcUtils.getCalcAppResource(this._calcParam.getCtx(), "Calc_Report_BeginCal");
        this._writeLog(rankStr, calcItem, status, "", 0, " ", " ", " ", " ", " ", 0);
    }

    public void AddCalcLog_PreSet(int rank, int DispRank) throws BOSException {
        String rankStr = MessageFormat.format(CalcUtils.getCalcAppResource(this._calcParam.getCtx(), "Calc_Report_Rank"), String.valueOf(DispRank));
        String calcItem = CalcUtils.getCalcAppResource(this._calcParam.getCtx(), "Calc_Report_AllocWIP");
        String status = CalcUtils.getCalcAppResource(this._calcParam.getCtx(), "Calc_Report_Sucess");
        String tbl_DataByOrder = this._calcParam.get_Tbl_DataByOrder();
        this.get_logSqlCacheByRank().append("INSERT INTO T_NCM_OrderCalcLog (FID,FCompanyID,FPeriodId,FCreatorID,FCreateTime,").append("\tFCalcRank,FCalcItem,FStatus,FAttachment,FHasDetailLog,FProdDispName,FOrderNumber,FStorageOrgUnitDisp,FMaterialId,FOrderId)").append('\n').append("SELECT newbosid('B5688415'),'").append(this._calcParam.getCompanyId()).append("' As FCompanyID,'").append(this._calcParam.getPeriodId()).append("' As FPeriodId,").append("\t'").append(this._calcParam.getUserId()).append("' As FCreatorID, GetDate(),").append("\t'").append(rankStr).append("' As FCalcRank, ").append("\t'").append(calcItem).append("' As FCalcItem,'").append(status).append("' As FStatus,'' As FAttachment, 0 As FHasDetailLog, SUBT.FProdDispName, SUBT.FOrderNumber, SUBT.FStorageOrgUnitDisp, SUBT.FMaterialID, SUBT.FOrderID ").append('\n').append("FROM (").append('\n').append(" \tSELECT DISTINCT B.FMaterialID,M.FName_" + this._calcParam.getLocale() + " || '(' || M.FNumber || ')' As FProdDispName, ").append('\n').append(" \t\tOD.FID As FOrderID, OD.FNumber As FOrderNumber, B.FRank, M.FNumber as FMaterialNumber,  ").append('\n').append(" \t\tST.FName_" + this._calcParam.getLocale() + " || '(' || ST.FNumber || ')' As FStorageOrgUnitDisp ").append('\n').append(" \tFROM T_NCM_OrderRank A ").append('\n').append(" \tLEFT OUTER JOIN T_NCM_OrderRankEntry B ON A.FID = B.FPARENTID").append('\n').append(" \tLEFT JOIN T_BD_Material M ON M.FID = B.FMaterialID").append('\n').append(" \tLEFT JOIN T_BD_MaterialCompanyInfo mc ON mc.FCompanyID=A.FCOMPANYORG AND mc.FMaterialID = B.FMaterialID").append('\n').append(" \tINNER JOIN T_MM_ManufactureOrder OD ON B.FMaterialID=OD.FMaterialID").append('\n').append(" \tINNER JOIN ").append(tbl_DataByOrder).append(" DT ON DT.FCompanyID=A.FCompanyOrg AND DT.FCalculatePeriodID=A.FCalculatePeriod AND DT.FOrderID=OD.FID").append('\n').append(" \tLEFT OUTER JOIN T_ORG_STORAGE ST ON OD.FSTORAGEORGUNITID = ST.FID").append('\n').append(" \tWHERE A.FBillStatus =4 AND B.FRank = ").append(String.valueOf(rank)).append(" AND A.FCOMPANYORG ='").append(this._calcParam.getCompanyId()).append("' AND A.FCalculatePeriod = '").append(this._calcParam.getPeriodId()).append("' ").append('\n').append(" \t\tAND (  ").append('\n').append("  \t\t\t\t(mc.FAccountType = 5 AND Isnull(B.FMatBatchNo,N' ') = Isnull(OD.FLot,N' ')) ").append('\n').append("  \t\t\t\tOR mc.FAccountType <> 5) ").append('\n').append(" ) AS SUBT ").append('\n').append("ORDER BY SUBT.FRank DESC, SUBT.FMaterialNumber, SUBT.FOrderNumber ;");
    }

    public void UpdatePreSetCalcLog(int dispRank) throws BOSException {
        String rankStr = MessageFormat.format(CalcUtils.getCalcAppResource(this._calcParam.getCtx(), "Calc_Report_Rank"), String.valueOf(dispRank));
        String status = CalcUtils.getCalcAppResource(this._calcParam.getCtx(), "Calc_Report_Fail");
        String attachment = CalcUtils.getCalcAppResource(this._calcParam.getCtx(), "Calc_Report_ErrorLog");
        String calcItem = CalcUtils.getCalcAppResource(this._calcParam.getCtx(), "Calc_Report_AllocWIP");
        this.get_logSqlCacheByRank().append("UPDATE T_NCM_OrderCalcLog AS D SET (FStatus,FAttachment,FHasDetailLog ,FCalcItem)=(").append("\tSelect top 1 '").append(status).append("' As FStatus,'").append(attachment).append("' As FAttachment,1,'").append(calcItem).append("'").append("  FROM T_NCM_OrderCalcLogEntry S ").append("  WHERE S.FParentId=D.FID ").append(" ) ").append("WHERE D.FCalcRank = '").append(rankStr).append("' AND D.FCompanyID='").append(this._calcParam.getCompanyId()).append("' AND D.FPeriodId= '").append(this._calcParam.getPeriodId()).append("';");
    }

    public OrderCalcLogCollection GetCalcLogData() {
        try {
            return CalcExceptionLog.GetCalcLogData(this._calcParam.getCtx(), this._calcParam.getCompanyId(), this._calcParam.getPeriodId());
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            return null;
        }
    }

    public static OrderCalcLogCollection GetCalcLogData(Context ctx, String companyId, String periodId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT calcRank, calcItem, status, attachment, hasDetailLog, createTime, sort,").append("status, attachment, hasDetailLog, sort, createTime, entries.seq, entries.errorInfo,").append("entries.possibleReason, entries.adviceHandle,prodDispName,orderNumber,storageOrgUnitDisp,creator.* ").append("WHERE company.id = '").append(companyId).append("' AND period.id='").append(periodId).append("' ").append(" order by calcRank, sort, prodDispName, orderNumber, entries.errorInfo ");
        return OrderCalcLogFactory.getLocalInstance(ctx).getOrderCalcLogCollection(sb.toString());
    }

    private void _writeLog(String calcRank, String calcItem, String status, String attachment, int hasDetailLog, String prodDispName, String orderNumber, String storageOrgUnitDisp, String materialId, String orderId, int sort) throws BOSException {
        this.get_logSqlCacheByRank().append("INSERT INTO T_NCM_OrderCalcLog (FID,FCompanyID,FPeriodId,FCreatorID,FCreateTime,").append("\tFCalcRank,FCalcItem,FStatus,FAttachment,FHasDetailLog,FProdDispName,FOrderNumber,FStorageOrgUnitDisp,FMaterialID,FOrderID,FSort)").append('\n').append("VALUES(newbosid('B5688415'),'").append(this._calcParam.getCompanyId()).append("','").append(this._calcParam.getPeriodId()).append("','").append(this._calcParam.getUserId()).append("',GetDate(),'").append(calcRank).append("','").append(calcItem).append("','").append(status).append("','").append(attachment).append("',").append(hasDetailLog).append(",'").append(prodDispName).append("','").append(orderNumber).append("','").append(storageOrgUnitDisp).append("','").append(materialId).append("','").append(orderId).append("',").append(String.valueOf(sort)).append(");").append('\n');
    }
}

