/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultInfo;
import com.kingdee.eas.ncm.order.fact.cal.app.OrderCalChecker;
import com.kingdee.eas.ncm.order.fact.cal.utils.app.CalcAppUntil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class ActivityFeeUnAssignedChecher
extends OrderCalChecker {
    private static Logger logger = Logger.getLogger((String)ActivityFeeUnAssignedChecher.class.getName());
    private static final char CLF = '\n';
    private OrderCheckResultCollection rc;

    @Override
    public OrderCheckResultCollection calChecker(Context ctx, String CompanyOrgID, String PeriodId) throws BOSException, EASBizException {
        this.rc = new OrderCheckResultCollection();
        this.checktable(ctx, CompanyOrgID, PeriodId);
        return this.rc;
    }

    private void checktable(Context ctx, String companyId, String periodId) throws BOSException {
        String tblAllocResult = null;
        try {
            tblAllocResult = DynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)periodId, (String)"T_NCM_OCCC2ActivityAlloc");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT DISTINCT Top 100 B.FNumber,E.FSeq").append('\n').append(" FROM T_NCM_OrderCCFeeBill B ").append('\n').append(" INNER JOIN T_NCM_OrderCCFeeBillEntry E ON B.FID = E.FParentID").append('\n').append(" LEFT JOIN ").append(tblAllocResult).append(" S ON S.FSourceBillID=B.FID AND S.FSourceBillEntryID=E.FID AND S.FCompanyID=B.FCompanyOrg AND S.FCalculatePeriodID=B.FCalculatePeriod ").append('\n').append(" WHERE B.FBillStatus=? AND B.FCalculatePeriod= ? AND B.FCompanyOrg=? AND S.FID is null ").append('\n');
        Object[] params = new Object[]{String.valueOf(4), periodId, companyId};
        IRowSet rs = null;
        String descrip = CalcAppUntil.getOrderCheckResource(ctx, "CheckErrDescription_ActivityFeeUnAssignedChecher");
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rs.next()) {
                OrderCheckResultInfo rinfo = new OrderCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(descrip, rs.getString("FNumber"), rs.getString("FSeq")));
                rinfo.setReason(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrReason_ActivityFeeUnAssignedChecher"));
                rinfo.setSuggestOperation(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrSuggest_ActivityFeeUnAssignedChecher"));
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }
}

