/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultInfo;
import com.kingdee.eas.ncm.order.fact.cal.app.OrderCalChecker;
import com.kingdee.eas.ncm.order.fact.cal.utils.app.CalcAppUntil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.apache.log4j.Logger;

public class InnCCFeeUnAssignedChecher
extends OrderCalChecker {
    private static Logger logger = Logger.getLogger((String)InnCCFeeUnAssignedChecher.class.getName());
    private static final char CLF = '\n';
    private OrderCheckResultCollection rc;

    @Override
    public OrderCheckResultCollection calChecker(Context ctx, String CompanyOrgID, String PeriodId) throws BOSException, EASBizException {
        this.rc = new OrderCheckResultCollection();
        this.checktable(ctx, CompanyOrgID, PeriodId);
        return this.rc;
    }

    private void checktable(Context ctx, String companyId, String periodId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct Top 100 B.FNumber,E.FSeq").append('\n').append("FROM T_NCM_OrderCCOFeeBill B").append('\n').append("LEFT OUTER JOIN T_NCM_OrderCCOFeeEntryBill E ON B.FID = E.FParentID").append('\n').append("WHERE B.FBillStatus=? AND B.FCalculatePeriod= ? AND B.FCompanyOrg=? ").append('\n').append("\tAND NOT EXISTS(").append('\n').append("  \t\tSELECT 1").append('\n').append("\t\tFROM T_NCM_OrderCCFeeBill BB ").append('\n').append("\t\tLEFT OUTER JOIN T_NCM_OrderCCFeeBillEntry EE ON BB.FID = EE.FParentID").append('\n').append("\t\tWHERE BB.FSourceBillID=E.FID AND BB.FCompanyOrg=B.FCompanyOrg AND BB.FCalculatePeriod=B.FCalculatePeriod ").append('\n').append("\t)").append('\n');
        Object[] params = new Object[]{String.valueOf(4), periodId, companyId};
        IRowSet rs = null;
        String descrip = CalcAppUntil.getOrderCheckResource(ctx, "CheckErrDescription_InnCCFeeUnAssignedChecher");
        try {
            rs = NCMDbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            while (rs.next()) {
                OrderCheckResultInfo rinfo = new OrderCheckResultInfo();
                rinfo.setDescription(MessageFormat.format(descrip, rs.getString("FNumber"), rs.getString("FSeq")));
                rinfo.setReason(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrReason_InnCCFeeUnAssignedChecher"));
                rinfo.setSuggestOperation(CalcAppUntil.getOrderCheckResource(ctx, "CheckErrSuggest_InnCCFeeUnAssignedChecher"));
                this.rc.add(rinfo);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }
}

