/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultCollection;
import com.kingdee.eas.ncm.order.fact.cal.OrderCheckResultInfo;
import com.kingdee.eas.ncm.order.fact.cal.app.OrderCalChecker;
import com.kingdee.eas.ncm.order.fact.cal.utils.app.CalcAppUntil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;

public class PeriodChecker
extends OrderCalChecker {
    @Override
    public OrderCheckResultCollection calChecker(Context ctx, String CompanyOrgID, String PeriodId) throws BOSException, EASBizException {
        String isStart_Stock = "";
        String currentPeriodId_Stock = "";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT PARENT.FIsStart,PARENT.FStartPeriodID,PARENT.FCurrentPeriodID,").append("PARENT.FIsClosedAccount FROM T_BD_SystemStatusCtrol AS PARENT LEFT JOIN T_BD_SystemStatus AS ENTRY ").append("ON PARENT.FSystemStatusID = ENTRY.FID WHERE PARENT.FCOMPANYID='").append(CompanyOrgID).append("' AND ENTRY.FName = ").append(2);
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                isStart_Stock = this.getString(rs.getString(1));
                currentPeriodId_Stock = this.getString(rs.getString(3));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        OrderCheckResultCollection aOrderCheckResultCollection = new OrderCheckResultCollection();
        OrderCheckResultInfo aOrderCheckResultInfo = new OrderCheckResultInfo();
        if (isStart_Stock != null && ("0".equals(isStart_Stock) || !PeriodId.equals(currentPeriodId_Stock))) {
            IPeriod period = null;
            PeriodInfo periodinfo_Cost = null;
            PeriodInfo periodinfo_Stock = null;
            try {
                period = PeriodFactory.getLocalInstance((Context)ctx);
                ObjectStringPK periodpk_Cost = new ObjectStringPK(PeriodId);
                periodinfo_Cost = period.getPeriodInfo((IObjectPK)periodpk_Cost);
                ObjectStringPK periodpk_Stock = new ObjectStringPK(currentPeriodId_Stock);
                periodinfo_Stock = period.getPeriodInfo((IObjectPK)periodpk_Stock);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            ICompanyOrgUnit company = null;
            CompanyOrgUnitInfo companyInfo = null;
            try {
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                ObjectStringPK companyPk = new ObjectStringPK(CompanyOrgID);
                companyInfo = company.getCompanyOrgUnitInfo((IObjectPK)companyPk);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            String des = MessageFormat.format(CalcAppUntil.getSrvCalcResource(ctx, "PeriodChecker_Description"), companyInfo.getName(), String.valueOf(periodinfo_Cost.getPeriodYear()), String.valueOf(periodinfo_Cost.getPeriodNumber()), String.valueOf(periodinfo_Stock.getPeriodYear()), String.valueOf(periodinfo_Stock.getPeriodNumber()));
            aOrderCheckResultInfo.setDescription(des);
            aOrderCheckResultInfo.setReason(CalcAppUntil.getSrvCalcResource(ctx, "PeriodChecker_Reason"));
            aOrderCheckResultInfo.setSuggestOperation(CalcAppUntil.getSrvCalcResource(ctx, "PeriodChecker_SuggestOperation"));
            aOrderCheckResultCollection.add(aOrderCheckResultInfo);
        }
        return aOrderCheckResultCollection;
    }

    public String getString(String name) {
        String xname = "";
        if (name != null) {
            xname = name;
        }
        return xname;
    }
}

