/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.ncm.TimeUnitTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OCActivityHourCostReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.order.fact.report.app.OCActivityHourCostReport");

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("company")).getId().toString();
        String activityDataTbl = this.createActivityDataSQL(reportID, filter);
        String stdPriceTbl = this.createActivityStdPrice(reportID, filter);
        String orderData = this.getManufactrueData(reportID, filter);
        String sTmpTblName = this.createTmpTableSQL();
        StringBuffer sbSQL = new StringBuffer();
        sbSQL.append(" INSERT INTO ").append(sTmpTblName + "\n").append("    (FCompanyOrg, \n").append("    FCostTypeID,FCostTypeNumber,FCostTypeName, \n").append("    FManufactureOrderID,FManufactureOrderNumber,FManufactureOrderName, \n").append("    FProductID,FProductNumber,FProductName,FProductModel, \n").append("    FProjectID,FProjectNumber,FProjectName, \n").append("    FTrackID,FTrackNumber,FTrackName, \n").append("    FActivityChainID,FActivityChainNumber,FActivityChainName, \n").append("    FActivityID,FActivityNumber,FActivityName,FActivityUnitName, \n").append("    FTimeUnit,FTimeUnitName, \n").append("    FActActivityQty,FStdActivityQty,FStdPrice, \n").append("    FActCost,FStdCost,FPrepareInputCost,\n").append("    FActCostRatio, \n").append("    FTotalRow,FTotalRow2,FIsTotalRow, \n").append("    FTotalCostTypeRow,FTotalManufactureRow,FTotalProductRow,FTotalActivityChainRow,FTotalActivityRow, \n").append("    FActivityQtyPrecision,FAmountPrecision) \n");
        sbSQL.append("SELECT '" + companyID + "' as FCompanyOrg, \n").append("    costType.FID as FCostTypeID,costType.FNumber as FCostTypeNumber,costType.FName_l2 as FCostTypeName, \n").append("    t1.FManufactureOrderID as FManufactureOrderID, manufac.FNumber as FManufactureOrderNumber,manufac.FNumber as FManufactureOrderName, \n").append("    product.FID as FProductID,product.FNumber as FProductNumber,product.FName_l2 as FProductName,product.FModel as FProductModel, \n").append("    project.FID as FProjectID, project.FNumber as FProjectNumber,project.FName_l2 as FProjectName, \n").append("    track.FID as FTrackID,track.FNumber as FTrackNumber,track.FName_l2 as FTrackName, \n").append("    chain.FID as FActivityChainID,chain.FNumber as FActivityChainNumber,chain.FName_l2 as FActivityChainName, \n").append("    activity.FID as FActivityID,activity.FNumber as FActivityNumber, activity.FName_l2 as FActivityName,unit.FName_l2 as FActivityUnitName, \n").append("    activity.FTimeUnit as FTimeUnit, \n").append("\tcase when activity.FTimeUnit = 10 then '" + TimeUnitTypeEnum.hour.getAlias() + "' \n").append("\t     when activity.FTimeUnit = 20 then '" + TimeUnitTypeEnum.minute.getAlias() + "' \n").append("\t     when activity.FTimeUnit = 30 then '" + TimeUnitTypeEnum.second.getAlias() + "' \n").append("\t     else ' ' \n").append("\tend  as FTimeUnitName, \n").append("\tcase when activity.FTimeUnit = 10 then t1.FActActivityQty/3600 \n").append("\t     when activity.FTimeUnit = 20 then t1.FActActivityQty/60 \n").append("\t     else t1.FActActivityQty \n").append("\tend  as FActActivityQty, \n").append("   orderData.FPlantQty*chainEntry.FIntegratedQty as FStdActivityQty,actpric.FStdPrice as FStdPrice, \n").append("    t1.FActActivityQty*actpric.FStdPrice as FActCost, \n").append("    orderData.FPlantQty*chainEntry.FIntegratedQty*actpric.FStdPrice as FStdCost, \n ").append("    isnull(orderData.FPlantQty*chainEntry.FIntegratedQty*actpric.FStdPrice,0) - isnull(t1.FActActivityQty*actpric.FStdPrice,0) as FPrepareInputCost,\n").append("    case when isnull(orderData.FPlantQty,0)*isnull(chainEntry.FIntegratedQty,0) = 0 then '0' else TO_Char(isnull(t1.FActActivityQty,0)/isnull(manufac.FQty,0)*isnull(chainEntry.FIntegratedQty,0)*100) end as FActCostRatio, \n").append("    0 as FTotalRow,0 as FTotalRow2,0 as FIsTotalRow, \n").append("    0 as FTotalCostTypeRow,0 as FTotalManufactureRow,0 as FTotalProductRow,0 as FTotalActivityChainRow,0 as FTotalActivityRow, \n").append("    2 as FActivityQtyPrecision,2 as FAmountPrecision \n").append("FROM ").append(stdPriceTbl).append(" actpric \n").append("    Inner Join T_NCM_ActivityChain chain on chain.FID = actpric.FActivityChainID \n").append("    Inner Join T_NCM_ActivityChainEntry chainEntry on chainEntry.FParentID = chain.FID \n").append("    Inner Join T_NCM_Activity activity on activity.FID = actpric.FActivityID and Activity.FID = chainEntry.FActivityID \n").append("    Left Join T_BD_MeasureUnit unit on activity.FBaseUnitID = unit.FID \n").append("    Inner Join ").append(orderData).append(" orderData on orderData.fproductID = actpric.FProductid \n").append("    Left Join ").append(activityDataTbl).append(" t1 on orderData.fOrderID = t1.FManufactureOrderID and  activity.fid = t1.FActivityID \n").append("    Left Join T_MM_ManufactureOrder manufac on manufac.Fid = orderData.FOrderID \n").append("    Left Join T_BD_Material product on product.fid = actpric.FProductID \n").append("    Left Join T_MM_Project project on project.fid = manufac.FProjectID \n").append("    Left Join T_MM_TrackNumber track on track.fid = manufac.FTrackID \n").append("    Inner Join T_NCM_CostType costType on costType.fid = actpric.FCostTypeID \n");
        sbSQL.append(" Where costType.FNumber = '").append(((CostTypeInfo)filter.getObject("costType")).getNumber() + "'");
        sbSQL.append(" and manufac.FBaseStatus = ").append(filter.getObject("billStatus") + "");
        sbSQL.append(this.getOrderFilter(filter));
        DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString());
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)("SELECT  * FROM " + sTmpTblName + " Order by FManufactureOrderNumber, FActivityChainNumber, FActivityNumber, FTotalRow , FTotalRow2 "));
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(sTmpTblName);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(activityDataTbl);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(stdPriceTbl);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(orderData);
        return rs;
    }

    private Set getPhysicalTableName(String companyID, RptParams filter) throws BOSException, EASBizException {
        HashSet<String> physicalTblNames = new HashSet<String>();
        String T_NCM_OrderCostCalActivityResult = null;
        Map T_NCM_OrderCostCalActivityResults = null;
        Integer toPeriod = new Integer(OrderCMUtils.getCurrentPeriod(this.getContext(), companyID).getNumber());
        Integer fromPeriod = new Integer(OrderCMUtils.getStartPeriod(this.getContext(), companyID).getNumber());
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)filter.getObject("company");
        String periodId2 = null;
        Set periodIds = OrderCMUtils.getPeriodIds(this.getContext(), companyInfo, fromPeriod, toPeriod);
        if (periodIds.size() <= 0) {
            return physicalTblNames;
        }
        try {
            T_NCM_OrderCostCalActivityResults = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyID, (Set)periodIds, (String)"T_NCM_OrderCostCalActivityResult");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        for (String periodId2 : periodIds) {
            T_NCM_OrderCostCalActivityResult = (String)T_NCM_OrderCostCalActivityResults.get(periodId2);
            physicalTblNames.add(T_NCM_OrderCostCalActivityResult);
        }
        return physicalTblNames;
    }

    private String createTmpTableSQL() throws BOSException {
        String sTmpTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table tmp_ActivityCostReport( ");
        createTable.append(" FCompanyOrg nvarchar(255) ");
        createTable.append(",FCostTypeID   varchar(44)  ");
        createTable.append(",FCostTypeName nvarchar(255) ");
        createTable.append(",FCostTypeNumber nvarchar(255) ");
        createTable.append(",FCostTypeNumberOrder varchar(255) ");
        createTable.append(",FManufactureOrderID varchar(44)  ");
        createTable.append(",FManufactureOrderName nvarchar(255)  ");
        createTable.append(",FManufactureOrderNumber nvarchar(255)  ");
        createTable.append(",FManufactureOrderNumberOrder nvarchar(255)  ");
        createTable.append(",FProductID varchar(44)");
        createTable.append(",FProductName nvarchar(255)");
        createTable.append(",FProductNumber nvarchar(255)");
        createTable.append(",FProductNumberOrder nvarchar(255)");
        createTable.append(",FProductModel nvarchar(255) ");
        createTable.append(",FProjectID varchar(44)  ");
        createTable.append(",FProjectName nvarchar(255)  ");
        createTable.append(",FProjectNumber nvarchar(255)  ");
        createTable.append(",FProjectNumberOrder nvarchar(255)  ");
        createTable.append(",FTrackID varchar(44)  ");
        createTable.append(",FTrackName nvarchar(255)  ");
        createTable.append(",FTrackNumber nvarchar(255)  ");
        createTable.append(",FTrackNumberOrder nvarchar(255)  ");
        createTable.append(",FActivityChainID varchar(44)  ");
        createTable.append(",FActivityChainName nvarchar(255)  ");
        createTable.append(",FActivityChainNumber nvarchar(255)  ");
        createTable.append(",FActivityChainNumberOrder nvarchar(255)  ");
        createTable.append(",FActivityID varchar(44)  ");
        createTable.append(",FActivityName nvarchar(255)  ");
        createTable.append(",FActivityNumber nvarchar(255)  ");
        createTable.append(",FActivityNumberOrder nvarchar(255)  ");
        createTable.append(",FActivityUnitName nvarchar(255)");
        createTable.append(" ,FTimeUnit int \n");
        createTable.append(" ,FTimeUnitName nvarchar(255) \n");
        createTable.append(",FActActivityQty numeric(28,10)");
        createTable.append(",FStdActivityQty numeric(28,10)");
        createTable.append(",FStdPrice numeric(28,10)");
        createTable.append(",FActCost numeric(28,10)");
        createTable.append(",FStdCost numeric(28,10)");
        createTable.append(",FStdPriceCost numeric(28,10)");
        createTable.append(",FPrepareInputCost numeric(28,10)");
        createTable.append(",FActCostRatio varchar(44)");
        createTable.append(",FTotalRow NUMERIC(17,4) ");
        createTable.append(",FTotalRow2 NUMERIC(17,4) ");
        createTable.append(" ,FIsTotalRow int not null default(1) ");
        createTable.append(" ,FTotalCostTypeRow int not null default(0) ");
        createTable.append(" ,FTotalManufactureRow int not null default(0) ");
        createTable.append(" ,FTotalProductRow int not null default(0) ");
        createTable.append(" ,FTotalActivityChainRow int not null default(0) ");
        createTable.append(" ,FTotalActivityRow int not null default(0) ");
        createTable.append(",FActivityQtyPrecision int default(0) ");
        createTable.append(",FAmountPrecision int default(0) ");
        createTable.append(" ) ");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    private String createActivityDataSQL(String reportID, RptParams filter) throws BOSException {
        Set physicalTblNames;
        String sTmpDataTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table tmp_ActivityCostDataReport( ");
        createTable.append(" FManufactureOrderID varchar(44)  ");
        createTable.append(" ,FProductID varchar(44)  ");
        createTable.append(" ,FActivityID varchar(44) ");
        createTable.append(",FActActivityQty numeric(28,10)");
        createTable.append(",FIsTotal  int default(0))");
        try {
            sTmpDataTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("company")).getId().toString();
        try {
            physicalTblNames = this.getPhysicalTableName(companyID, filter);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer insertSql = new StringBuffer();
        for (String currTable : physicalTblNames) {
            if (currTable != null) {
                insertSql.append(" Insert Into ").append(sTmpDataTblName);
                insertSql.append(" (FManufactureOrderID,FProductID,FActActivityQty,FActivityID) \n");
                insertSql.append(" Select t1.FOrderID as FManufactureOrderID, t1.FProductID as FProductID, \n");
                insertSql.append(" sum(isnull(t1.FEoPWIPQty,0)) + sum(isnull(t1.FFinishedQty,0)) as FActActivityQty,t1.FActivityID \n");
                insertSql.append(" From ").append(currTable).append(" t1 \n");
                insertSql.append(" group by FOrderID,FProductID,FActivityID \n");
                DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
                insertSql.delete(0, insertSql.length() - 1);
                continue;
            }
            return sTmpDataTblName;
        }
        insertSql.delete(0, insertSql.length() - 1);
        insertSql.append(" Insert Into ").append(sTmpDataTblName);
        insertSql.append(" (FManufactureOrderID,FProductID,FActActivityQty,FActivityID,FIsTotal) \n");
        insertSql.append(" Select t1.FManufactureOrderID as FManufactureOrderID, t1.FProductID as FProductID, \n");
        insertSql.append(" sum(t1.FActActivityQty) as FActActivityQty,t1.FActivityID, 1 as FIsTotal\n");
        insertSql.append(" From ").append(sTmpDataTblName).append(" t1 \n");
        insertSql.append(" group by t1.FManufactureOrderID,t1.FProductID,t1.FActivityID \n");
        DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
        String delete = "delete from " + sTmpDataTblName + " where FIsTotal = 0 ";
        DbUtil.execute((Context)this.getContext(), (String)delete);
        return sTmpDataTblName;
    }

    private String createActivityStdPrice(String reportID, RptParams filter) throws BOSException {
        String sTmpDataTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table tmp_ActivityStdPrice( ");
        createTable.append(" FOrderID varchar(44), \n");
        createTable.append(" FProductID varchar(44), \n");
        createTable.append(" FCostTypeID varchar(44), \n");
        createTable.append(" FActivityID varchar(44), \n");
        createTable.append(" FActivityChainID varchar(44), \n");
        createTable.append(" FStdPrice numeric(28,10)) \n");
        try {
            sTmpDataTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        Context ctx = this.getContext();
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("company")).getId().toString();
        StringBuffer insertSql = new StringBuffer();
        try {
            String T_NCM_OSActivityDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyID, (String)"T_NCM_OSActivityDetail");
            if (T_NCM_OSActivityDetail != null) {
                insertSql.append(" Insert Into ").append(sTmpDataTblName);
                insertSql.append("  (FOrderID,FProductID,FCostTypeID,FActivityID,FActivityChainID,FStdPrice) \n");
                insertSql.append("select FOrderID,FParentMaterialID, FCostTypeID,FActivityID,FActivityChainID,sum(FActStdPrice) \n");
                insertSql.append("  From " + T_NCM_OSActivityDetail + " \n");
                insertSql.append("  group by FOrderID,FParentMaterialID, FCostTypeID,FActivityID,FActivityChainID \n");
                DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
            }
        }
        catch (EASBizException ea) {
            logger.error((Object)ea.getMessage(), (Throwable)ea);
            throw new BOSException((Throwable)ea);
        }
        catch (SQLException es) {
            logger.error((Object)es.getMessage(), (Throwable)es);
            throw new BOSException((Throwable)es);
        }
        return sTmpDataTblName;
    }

    private String getManufactrueData(String reportID, RptParams filter) throws BOSException {
        OrgUnitCollection ccColl;
        String sTmpOrderDataTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table tmp_OrderData( ");
        createTable.append(" FOrderID varchar(44), \n");
        createTable.append(" FProductID varchar(44), \n");
        createTable.append(" FPlantQty numeric(28,10)) \n");
        try {
            sTmpOrderDataTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("company")).getId().toString();
        IOrgUnitRelation iOUR = OrgUnitRelationFactory.getLocalInstance((Context)this.getContext());
        try {
            ccColl = iOUR.getFromUnit(companyID, 1, 4);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        int ccSize = ccColl.size();
        if (ccSize == 0) {
            return sTmpOrderDataTblName;
        }
        HashSet<String> ccIDSet = new HashSet<String>(ccSize);
        for (int i = 0; i < ccSize; ++i) {
            ccIDSet.add(ccColl.get(i).getId().toString());
        }
        StringBuffer insertOrderData = new StringBuffer();
        insertOrderData.append(" insert into ").append(sTmpOrderDataTblName).append("    (FOrderID,FProductID,FPlantQty) \n").append("  select FID,FMaterialID,FQty From T_MM_ManufactureOrder").append("  where (FBaseStatus = 4 or FBaseStatus = 5 or FBaseStatus = 7 or FBaseStatus = 8 or FBaseStatus = 11) \n").append("         and FStorageorgUnitID in (?)");
        NCMServerUtils.executeSQLByBatch((Context)this.getContext(), (String)insertOrderData.toString(), null, ccIDSet, (int)1);
        return sTmpOrderDataTblName;
    }

    private String getOrderFilter(RptParams filter) {
        String filterSql = "";
        String orders = filter.getString("order");
        if (orders == null) {
            return filterSql;
        }
        orders = orders.replaceAll("; ", "', '");
        orders = "'" + orders + "'";
        filterSql = " and manufac.FNumber in (" + orders + ")";
        return filterSql;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("company");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_Tile_Company", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_Tile_CostType", (Locale)ctx.getLocale()) + ((CostTypeInfo)filter.getObject("costType")).getNumber());
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        Context ctx = this.getContext();
        int index = 0;
        reportHeader.addChild("FManufactureOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_Order", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FProductNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_PorductNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FProductName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_PorductName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FProductModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_Model", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FProjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_ProjectNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FTrackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_TrackNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FActivityChainNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_TActivityChainNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FActivityChainName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_TActivityChainName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FActivityNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_ActivityNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FActivityName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_ActivityName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FTimeUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_TimeUnit", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FActActivityQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_ActActivityQty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FActivityQtyPrecision");
        reportHeader.addChild("FStdActivityQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_StdActivityQty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FActivityQtyPrecision");
        ReportHeader stdPriceHeader = reportHeader.addChild("FStdPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_StdActivityPrice", (Locale)ctx.getLocale()), index++);
        stdPriceHeader.setAlign(3).setType(2).setDecimalField("FActivityQtyPrecision");
        stdPriceHeader.setWidth(120);
        reportHeader.addChild("FActCost", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_ActCost", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FActivityQtyPrecision");
        reportHeader.addChild("FStdCost", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_StdCost", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FActivityQtyPrecision");
        reportHeader.addChild("FPrepareInputCost", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_PrepareInputCost", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FActivityQtyPrecision");
        ReportHeader actRatioHeader = reportHeader.addChild("FActCostRatio", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_ActCostRatio", (Locale)ctx.getLocale()), index++);
        actRatioHeader.setAlign(3).setType(2).setDecimalField("FActivityQtyPrecision");
        actRatioHeader.setWidth(150);
        return reportHeader;
    }
}

