/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OCCCActivityFeeTotalReport
extends ReportServerBase {
    public static final String RES_CLASSNAME = "com.kingdee.eas.ncm.order.fact.report.OCMatAllocTotalReportResource";

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        String tempTable = this.buildReportDataTempTable(filter);
        String ksql = "select * from " + tempTable;
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTable);
        return rs;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tableName = this.buildReportDataTempTable(filter);
        this.setTablename(tableName);
        return super.getTablename();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = "where FIsTotalRow = 1 or FIsSubTotalRow = 1 \n";
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "desc" : "asc";
        StringBuffer ksql = new StringBuffer();
        ksql.append("select * from " + tableName + " \n");
        ksql.append(where);
        ksql.append("order by \n");
        ksql.append("FIsTotalRow " + orderByMode + ",");
        StringBuffer orderBy = new StringBuffer();
        List tblData = (List)filter.getObject("table");
        HashMap row = null;
        String field = null;
        for (int i = 0; i < tblData.size(); ++i) {
            row = (HashMap)tblData.get(i);
            field = (String)row.get("id");
            if ("FExpenseID".equalsIgnoreCase(field)) {
                orderBy.append(" FExpenseNumber, FIsExpenseTotalRow " + orderByMode + ",");
                continue;
            }
            if ("FCostCenterID".equalsIgnoreCase(field)) {
                orderBy.append(" FCostCenterNumber, FIsCostCenterTotalRow " + orderByMode + ",");
                continue;
            }
            if ("FCostItemID".equalsIgnoreCase(field)) {
                orderBy.append(" FCostItemNumber, FIsCostITemTotalRow " + orderByMode + ",");
                continue;
            }
            if ("FActivityID".equalsIgnoreCase(field)) {
                orderBy.append(" FActivityNumber, FIsActivityTotalRow " + orderByMode + ",");
                continue;
            }
            if (!"FOrderID".equalsIgnoreCase(field)) continue;
            orderBy.append(" FOrderNumber, FIsOrderTotalRow " + orderByMode + ",");
        }
        orderBy.deleteCharAt(orderBy.length() - 1);
        ksql.append(orderBy);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql.toString(), (int)start, (int)rows);
        return rs;
    }

    protected String createReportDataTempTable() throws BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T ( \n");
        ksql.append("     FExpenseID varchar(44), \n");
        ksql.append("     FExpenseNumber nvarchar(80), \n");
        ksql.append("     FExpenseName nvarchar(255), \n");
        ksql.append("     FCostCenterID varchar(44), \n");
        ksql.append("     FCostCenterNumber nvarchar(80), \n");
        ksql.append("     FCostCenterName nvarchar(255), \n");
        ksql.append("     FCostItemID varchar(44), \n");
        ksql.append("     FCostItemNumber nvarchar(80), \n");
        ksql.append("     FCostItemName nvarchar(255), \n");
        ksql.append("     FOrderID varchar(44), \n");
        ksql.append("     FOrderNumber nvarchar(80), \n");
        ksql.append("     FOrderStorageName nvarchar(255), \n");
        ksql.append("     FOrderProductName nvarchar(255), \n");
        ksql.append("     FOrderProductLot nvarchar(255), \n");
        ksql.append("     FActivityID varchar(44), \n");
        ksql.append("     FActivityNumber nvarchar(80), \n");
        ksql.append("     FActivityName nvarchar(255), \n");
        ksql.append("     FDepartmentID varchar(44), \n");
        ksql.append("     FDepartmentName nvarchar(255), \n");
        ksql.append("     FUnitID varchar(44), \n");
        ksql.append("     FUnitName nvarchar(255), \n");
        ksql.append("     FQty decimal(21,8), \n");
        ksql.append("     FQtyPrecision int not null default(4), \n");
        ksql.append("     FPrice decimal(21,8), \n");
        ksql.append("     FPricePrecision int not null default(4), \n");
        ksql.append("     FAmount decimal(17,4), \n");
        ksql.append("     FAmountPrecision int not null default(2), \n");
        ksql.append("     FIsExpenseTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsCostCenterTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsCostItemTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsActivityTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsOrderTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsSubTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsTotalRow NUMERIC(17,4) default(0) \n");
        ksql.append(") \n");
        String tempTable = null;
        try {
            tempTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(ksql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    protected String buildReportDataTempTable(RptParams filter) throws BOSException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)this.getContext());
        String companyId = company.getId().toString();
        int amountPrecision = 2;
        try {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId().toString()));
            amountPrecision = currency.getPrecision();
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        String pWhere = this.buildPeriodFilter(filter);
        String eWhere = this.buildExpenseFilter(filter);
        String ccWhere = this.buildCostCenterFilter(filter);
        String ciWhere = this.buildCostItemFilter(filter);
        String aWhere = this.buildActivityFilter(filter);
        String oWhere = this.buildOrderFilter(filter);
        String tempTable = this.createReportDataTempTable();
        StringBuffer ksql = new StringBuffer();
        ksql.append("insert into " + tempTable + " ( \n");
        ksql.append("     FExpenseID, \n");
        ksql.append("     FCostCenterID, \n");
        ksql.append("     FCostItemID, \n");
        ksql.append("     FActivityID, \n");
        ksql.append("     FOrderID, \n");
        ksql.append("     FDepartmentID, \n");
        ksql.append("     FQty, \n");
        ksql.append("     FQtyPrecision, \n");
        ksql.append("     FPrice, \n");
        ksql.append("     FPricePrecision, \n");
        ksql.append("     FAmount, \n");
        ksql.append("     FAmountPrecision, \n");
        ksql.append("     FIsSubTotalRow, \n");
        ksql.append("     FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("     b.FExpenseID FExpenseID, \n");
        ksql.append("     b.FCostCenterID FCostCenterID, \n");
        ksql.append("     be.FCostItemID FCostItemID, \n");
        ksql.append("     be.FActivityID FActivityID, \n");
        ksql.append("     be.FManufactureOrderID FOrderID, \n");
        ksql.append("     b.FDepartmentID FDepartmentID, \n");
        ksql.append("     sum(be.FQty) FQty, \n");
        ksql.append("     isnull(max(emu.FQtyPrecision), 4) FQtyPrecision, \n");
        ksql.append("     case when sum(be.FQty) = 0 then 0 else sum(be.FAmount)/sum(be.FQty) end FPrice, \n");
        ksql.append("     isnull(max(e.FPricePrecision), 4) FPricePrecision, \n");
        ksql.append("     sum(be.FAmount) FAmount, \n");
        ksql.append("     " + amountPrecision + " FAmountPrecision, \n");
        ksql.append("     0 FIsSubTotalRow, \n");
        ksql.append("     0 FIsTotalRow \n");
        ksql.append("from T_NCM_OrderCCFeeBill b \n");
        ksql.append("left join T_NCM_OrderCCFeeBillEntry be on be.FParentID = b.FID \n");
        if (pWhere.length() > 0) {
            ksql.append("left join T_BD_Period p on p.FID = b.FCalculatePeriod \n");
        }
        ksql.append("left join T_NCM_Expense e on e.FID = b.FExpenseID \n");
        ksql.append("left join T_BD_MeasureUnit emu on emu.FID = e.FUnitID \n");
        if (ccWhere.length() > 0) {
            ksql.append("left join T_ORG_CostCenter cc on cc.FID = b.FCostCenterID \n");
        }
        if (ciWhere.length() > 0) {
            ksql.append("left join T_NCM_CostItem ci on ci.FID = be.FCostItemID \n");
        }
        if (aWhere.length() > 0) {
            ksql.append("left join T_NCM_Activity a on a.FID = be.FActivityID \n");
        }
        if (oWhere.length() > 0) {
            ksql.append("left join T_MM_ManufactureOrder o on o.FID = be.FManufactureOrderID \n");
        }
        ksql.append("where FCompanyOrg = '" + companyId + "' \n");
        ksql.append("and FBillStatus = 4 \n");
        ksql.append(pWhere);
        ksql.append(eWhere);
        ksql.append(ccWhere);
        ksql.append(ciWhere);
        ksql.append(aWhere);
        ksql.append(oWhere);
        ksql.append(" \n");
        ksql.append("group by b.FExpenseID, b.FCostCenterID, be.FCostItemID, be.FActivityID, \n");
        ksql.append("    be.FManufactureOrderID, b.FDepartmentID \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        List tblData = (List)filter.getObject("table");
        Map row = null;
        String field = null;
        boolean isTotal = false;
        for (int rowIndex = 0; rowIndex < tblData.size(); ++rowIndex) {
            row = (Map)tblData.get(rowIndex);
            field = (String)row.get("id");
            isTotal = false;
            if (row.containsKey("isTotal") && row.get("isTotal") instanceof Boolean) {
                isTotal = (Boolean)row.get("isTotal");
            }
            if (!isTotal) continue;
            String insertTotalRow = "";
            String selectTotalRow = "";
            if ("FExpenseID".equalsIgnoreCase(field)) {
                insertTotalRow = "    FIsExpenseTotalRow, \n";
                selectTotalRow = "    1 FIsExpenseTotalRow, \n";
            } else if ("FCostCenterID".equalsIgnoreCase(field)) {
                insertTotalRow = "    FIsCostCenterTotalRow, \n";
                selectTotalRow = "    1 FIsCostCenterTotalRow, \n";
            } else if ("FCostItemID".equalsIgnoreCase(field)) {
                insertTotalRow = "    FIsCostItemTotalRow, \n";
                selectTotalRow = "    1 FIsCostItemTotalRow, \n";
            } else if ("FActivityID".equalsIgnoreCase(field)) {
                insertTotalRow = "    FIsActivityTotalRow, \n";
                selectTotalRow = "    1 FIsActivityTotalRow, \n";
            } else if ("FOrderID".equalsIgnoreCase(field)) {
                insertTotalRow = "    FIsOrderTotalRow, \n";
                selectTotalRow = "    1 FIsOrderTotalRow, \n";
            }
            StringBuffer fields = new StringBuffer();
            for (int i = 0; i <= rowIndex; ++i) {
                row = (HashMap)tblData.get(i);
                field = (String)row.get("id");
                if ("FExpenseID".equalsIgnoreCase(field)) {
                    fields.append("FExpenseID,");
                    continue;
                }
                if ("FCostCenterID".equalsIgnoreCase(field)) {
                    fields.append("FCostCenterID,");
                    continue;
                }
                if ("FCostItemID".equalsIgnoreCase(field)) {
                    fields.append("FCostItemID,");
                    continue;
                }
                if ("FActivityID".equalsIgnoreCase(field)) {
                    fields.append("FActivityID,");
                    continue;
                }
                if (!"FOrderID".equalsIgnoreCase(field)) continue;
                fields.append("FOrderID,");
            }
            fields.deleteCharAt(fields.length() - 1);
            ksql.append("insert into " + tempTable + " ( \n");
            ksql.append("    " + fields + ", \n");
            ksql.append("    FQty, \n");
            ksql.append("    FQtyPrecision, \n");
            ksql.append("    FPrice, \n");
            ksql.append("    FPricePrecision, \n");
            ksql.append("    FAmount, \n");
            ksql.append("    FAmountPrecision, \n");
            ksql.append(insertTotalRow);
            ksql.append("    FIsSubTotalRow, \n");
            ksql.append("    FIsTotalRow \n");
            ksql.append(") \n");
            ksql.append("select \n");
            ksql.append("    " + fields + ", \n");
            ksql.append("    sum(FQty) FQty, \n");
            ksql.append("    isnull(max(FQtyPrecision), 4) FQtyPrecision, \n");
            ksql.append("    case when sum(FQty) = 0 then 0 else to_decimal(sum(FAmount), 24, 12)/to_decimal(sum(FQty), 24, 12) end FPrice, \n");
            ksql.append("    isnull(max(FPricePrecision), 4) FPricePrecision, \n");
            ksql.append("    sum(FAmount) FAmount, \n");
            ksql.append("    " + amountPrecision + " FAmountPrecision, \n");
            ksql.append(selectTotalRow);
            ksql.append("    1 FIsSubTotalRow, \n");
            ksql.append("    0 FIsTotalRow \n");
            ksql.append("from " + tempTable + " \n");
            ksql.append("where FIsSubTotalRow = 0 \n");
            ksql.append("group by " + fields + " \n");
            ksql.append("; \n");
        }
        ksql.append("insert into " + tempTable + " ( \n");
        ksql.append("    FQty, \n");
        ksql.append("    FQtyPrecision, \n");
        ksql.append("    FPrice, \n");
        ksql.append("    FPricePrecision, \n");
        ksql.append("    FAmount, \n");
        ksql.append("    FAmountPrecision, \n");
        ksql.append("    FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("    sum(FQty) FQty, \n");
        ksql.append("    isnull(max(FQtyPrecision), 4) FQtyPrecision, \n");
        ksql.append("    case when sum(FQty) = 0 then 0 else to_decimal(sum(FAmount), 24, 12)/to_decimal(sum(FQty), 24, 12) end FPrice, \n");
        ksql.append("    isnull(max(FPricePrecision), 4) FPricePrecision, \n");
        ksql.append("    sum(FAmount) FAmount, \n");
        ksql.append("    " + amountPrecision + " FAmountPrecision, \n");
        ksql.append("    1 FIsTotalRow \n");
        ksql.append("from " + tempTable + " \n");
        ksql.append("where FIsSubTotalRow = 0 \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FExpenseNumber, FExpenseName, FUnitName) = ( \n");
        ksql.append("    select e.FNumber, e.FName_L2, u.FName_l2 \n");
        ksql.append("    from T_NCM_Expense e \n");
        ksql.append("    left join T_BD_MeasureUnit u on u.FID = e.FUnitID \n");
        ksql.append("    where e.FID = t.FExpenseID \n");
        ksql.append(") \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FCostCenterNumber, FCostCenterName) = ( \n");
        ksql.append("    select cc.FNumber, cc.FName_L2  \n");
        ksql.append("    from T_ORG_CostCenter cc \n");
        ksql.append("    where cc.FID = t.FCostCenterID \n");
        ksql.append(") \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FCostItemNumber, FCostItemName) = ( \n");
        ksql.append("    select ci.FNumber, ci.FName_L2  \n");
        ksql.append("    from T_NCM_CostItem ci \n");
        ksql.append("    where ci.FID = t.FCostItemID \n");
        ksql.append(") \n");
        ksql.append("; \n");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FActivityNumber, FActivityName) = ( \n");
        ksql.append("    select a.FNumber, a.FName_L2  \n");
        ksql.append("    from T_NCM_Activity a \n");
        ksql.append("    where a.FID = t.FActivityID \n");
        ksql.append(") \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FOrderNumber, FOrderStorageName) = ( \n");
        ksql.append("    select o.FNumber, s.FName_l2 \n");
        ksql.append("    from T_MM_ManufactureOrder o \n");
        ksql.append("    left join T_ORG_Storage s on s.FID = o.FStorageOrgUnitID \n");
        ksql.append("    where o.FID = t.FOrderID \n");
        ksql.append(") \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t set FExpenseName = '\u5c0f\u8ba1' where FIsExpenseTotalRow = 1; \n");
        ksql.append("update " + tempTable + " t set FCostCenterName = '\u5c0f\u8ba1' where FIsCostCenterTotalRow = 1; \n");
        ksql.append("update " + tempTable + " t set FCostItemName = '\u5c0f\u8ba1' where FIsCostItemTotalRow = 1; \n");
        ksql.append("update " + tempTable + " t set FActivityName = '\u5c0f\u8ba1' where FIsActivityTotalRow = 1; \n");
        ksql.append("update " + tempTable + " t set FOrderStorageName = '\u5c0f\u8ba1' where FIsOrderTotalRow = 1; \n");
        row = (Map)tblData.get(0);
        field = (String)row.get("id");
        String totalFieldName = null;
        if ("FExpenseID".equalsIgnoreCase(field)) {
            totalFieldName = "FExpenseNumber";
        } else if ("FCostCenterID".equalsIgnoreCase(field)) {
            totalFieldName = "FCostCenterNumber";
        } else if ("FCostItemID".equalsIgnoreCase(field)) {
            totalFieldName = "FCostItemNumber";
        } else if ("FActivityID".equalsIgnoreCase(field)) {
            totalFieldName = "FActivityNumber";
        } else if ("FOrderID".equalsIgnoreCase(field)) {
            totalFieldName = "FOrderNumber";
        }
        if (totalFieldName != null) {
            ksql.append("update " + tempTable + " t set " + totalFieldName + " = '\u5408\u8ba1' where FIsTotalRow = 1; \n");
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        return tempTable;
    }

    public boolean isOnlyDisplayTotal(RptParams filter) {
        return filter.getBoolean("isOnlyDisPalyTotal");
    }

    public boolean isTotalRowTop(RptParams filter) {
        return filter.getBoolean("isTotalRowTop");
    }

    private String buildPeriodFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String year = filter.getString("yearFrom");
        String month = filter.getString("periodFrom");
        if (!StringUtils.isEmpty((String)year) && !StringUtils.isEmpty((String)month)) {
            ksql.append(" and p.FNumber >= ").append(this.getPeriodNumber(year, month)).append("");
        }
        year = filter.getString("yearTo");
        month = filter.getString("periodTo");
        if (!StringUtils.isEmpty((String)year) && !StringUtils.isEmpty((String)month)) {
            ksql.append(" and p.FNumber <= ").append(this.getPeriodNumber(year, month)).append("");
        }
        return ksql.toString();
    }

    private String getPeriodNumber(String year, String month) {
        return year + (month.length() < 2 ? "0" + month : month);
    }

    private String buildExpenseFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("expenseFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and e.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("expenseTo")))) {
            ksql.append(" and e.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    private String buildCostCenterFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("costCenterFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and cc.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("costCenterTo")))) {
            ksql.append(" and cc.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    private String buildCostItemFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("costItemFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and ci.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("costItemTo")))) {
            ksql.append(" and ci.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    private String buildActivityFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("activityFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and a.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("activityTo")))) {
            ksql.append(" and a.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    private String buildOrderFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("orderFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and o.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("orderTo")))) {
            ksql.append(" and o.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.add("FIsSubTotalRow", 1, (Object)new BigDecimal(1), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FIsTotalRow", 1, (Object)new BigDecimal(1), a);
        return conditions;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        ReportTitles titles = new ReportTitles();
        Context ctx = this.getContext();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OrderCCFeeTotalReport_Title_Company", (Locale)ctx.getLocale()) + company.getName());
        String from = filter.getString("yearFrom");
        from = from + "\u5e74";
        from = from + filter.getString("periodFrom");
        from = from + "\u671f";
        String to = filter.getString("yearTo");
        to = to + "\u5e74";
        to = to + filter.getString("periodTo");
        to = to + "\u671f";
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_PeriodRange", (Locale)ctx.getLocale()) + from + " \u81f3 " + to);
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCCActivityFeeTotalReport_Expense_Range", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("expenseFrom"), filter.getString("expenseTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_CostCenterRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("costCenterFrom"), filter.getString("costCenterTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_CostItemRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("costItemFrom"), filter.getString("costItemTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostStatReport_ActivityRange", (Locale)ctx.getLocale()) + "\uff1a" + this.buildFilterRange(filter.getString("activityFrom"), filter.getString("activityTo")));
        titles.AddTitle(9, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_OrderRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("orderFrom"), filter.getString("orderTo")));
        return titles;
    }

    private String buildFilterRange(String from, String to) {
        Context ctx = this.getContext();
        if (StringUtils.isEmpty((String)from) && StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_All", (Locale)ctx.getLocale());
        }
        if (StringUtils.isEmpty((String)from)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_FirstFrom", (Locale)ctx.getLocale()) + to;
        }
        if (StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_From", (Locale)ctx.getLocale()) + from + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_ToEnd", (Locale)ctx.getLocale());
        }
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_From", (Locale)ctx.getLocale()) + from + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_To", (Locale)ctx.getLocale()) + to;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        int i;
        ReportHeader reportHeader = new ReportHeader();
        Context ctx = this.getContext();
        int index = 0;
        List tblData = (List)filter.getObject("table");
        ArrayList list = new ArrayList(tblData.size());
        for (i = 0; i < tblData.size(); ++i) {
            Map row = (Map)tblData.get(i);
            list.add(row.get("id"));
        }
        for (i = 0; i < list.size(); ++i) {
            if ("FExpenseID".equals(list.get(i))) {
                reportHeader.addChild("FExpenseNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OrderCCFeeTotalReport_ExpenseNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FExpenseName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OrderCCFeeTotalReport_ExpenseName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if ("FCostCenterID".equals(list.get(i))) {
                reportHeader.addChild("FCostCenterNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_CostCenterNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FCostCenterName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OrderCostCalcVchRep_FCostCenterName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if ("FCostItemID".equals(list.get(i))) {
                reportHeader.addChild("FCostItemNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_CostItemNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FCostItemName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_CostItemName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if ("FActivityID".equals(list.get(i))) {
                reportHeader.addChild("FActivityNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_ActivityNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FActivityName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_ActivityName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if (!"FOrderID".equals(list.get(i))) continue;
            reportHeader.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Order", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FOrderStorageName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCCActivityFeeTotalReport_OrderStorage", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        }
        reportHeader.addChild("FUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCCActivityFeeTotalReport_UnitName", (Locale)ctx.getLocale())).setAlign(1).setIndex(index++);
        reportHeader.addChild("FQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Qty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FQtyPrecision");
        reportHeader.addChild("FPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMatFeeTotalReport_Price", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FPricePrecision");
        reportHeader.addChild("FAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OrderCostCalcVchRep_FAmount", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        return reportHeader;
    }

    protected String getResource(String resName) {
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)this.getContext().getLocale());
    }
}

