/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.fact.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.NCMUtils;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OCMaterialCostStatReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ncm.cal.report.app.OCMaterialCostStatReport");

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.addBetween("FTotalRow2", (Object)new BigDecimal(99), (Object)new BigDecimal(104), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FTotalRow2", 1, (Object)new BigDecimal(105), a);
        return conditions;
    }

    private int getPeriodNumber(String companyId, String periodYear, String periodNumber) throws EASBizException, BOSException {
        int number = 0;
        if (periodYear == null || periodNumber == null || periodYear.length() != 4 || periodNumber.length() != 1 && periodNumber.length() != 2) {
            PeriodInfo currPeriod = NCMUtils.GetCurrentPeriod((Context)this.getContext(), (String)companyId);
            number = currPeriod.getNumber();
            return number;
        }
        if (periodNumber.length() == 1) {
            periodNumber = "0" + periodNumber;
        }
        String temp = periodYear + periodNumber;
        number = new Integer(temp);
        return number;
    }

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        Set periodIds;
        IRowSet rs = null;
        Context ctx = this.getContext();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String companyID = ((CompanyOrgUnitInfo)filter.getObject("companyorg")).getId().toString();
        String sTmpTblName = this.createTmpTableSQL();
        Integer fromPeriod = this.getFromPeriod(filter);
        Integer toPeriod = this.getToPeriod(filter);
        String periodId2 = null;
        try {
            periodIds = OrderCMUtils.getPeriodIds(this.getContext(), company, fromPeriod, toPeriod);
        }
        catch (EASBizException e1) {
            throw new BOSException((Throwable)e1);
        }
        if (periodIds.size() <= 0) {
            return rs;
        }
        String T_NCM_OrderBalance = null;
        Map T_NCM_OrderBalances = null;
        String T_NCM_OrderBalanceMaterial = null;
        Map T_NCM_OrderBalanceMaterials = null;
        String T_NCM_OrderBalanceMaterialEntry = null;
        Map T_NCM_OrderBalanceMaterialEntrys = null;
        String T_NCM_OrderCostCalMatDetailResult = null;
        Map T_NCM_OrderCostCalMatDetailResults = null;
        String T_NCM_DataByOrder = null;
        Map T_NCM_DataByOrders = null;
        try {
            T_NCM_OrderBalances = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyID, (Set)periodIds, (String)"T_NCM_OrderBalance");
            T_NCM_OrderBalanceMaterials = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyID, (Set)periodIds, (String)"T_NCM_OrderBalanceMaterial");
            T_NCM_OrderBalanceMaterialEntrys = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyID, (Set)periodIds, (String)"T_NCM_OrderBalanceMaterialEntry");
            T_NCM_OrderCostCalMatDetailResults = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyID, (Set)periodIds, (String)"T_NCM_OrderCostCalMatDetailResult");
            T_NCM_DataByOrders = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyID, (Set)periodIds, (String)"T_NCM_DataByOrder");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sbSQL = new StringBuffer();
        for (String periodId2 : periodIds) {
            T_NCM_OrderBalance = (String)T_NCM_OrderBalances.get(periodId2);
            T_NCM_OrderBalanceMaterial = (String)T_NCM_OrderBalanceMaterials.get(periodId2);
            T_NCM_OrderBalanceMaterialEntry = (String)T_NCM_OrderBalanceMaterialEntrys.get(periodId2);
            T_NCM_OrderCostCalMatDetailResult = (String)T_NCM_OrderCostCalMatDetailResults.get(periodId2);
            T_NCM_DataByOrder = (String)T_NCM_DataByOrders.get(periodId2);
            if (T_NCM_OrderBalance == null || T_NCM_OrderBalanceMaterial == null || T_NCM_OrderBalanceMaterialEntry == null || T_NCM_OrderCostCalMatDetailResult == null || T_NCM_DataByOrder == null) continue;
            sbSQL.append(" INSERT INTO ").append(sTmpTblName).append(" \t  (FTotalRow,FTotalRow2,FCompanyOrg,\n").append("      FPeriodID,FPeriodName,FPeriodNumber,\n").append("\t   FManufactureOrderID,FManufactureOrderName,FManufactureOrderNumber,\n").append("\t   FProductID,FProductName,FProductNumber,FProductModel,FLot,\n").append("      FBaseUnitName,FPlanQty,FFinishedProductQty, \n").append("\t   FCostCenterID,FCostCenterName,FCostCenterNumber,\n").append("\t   FCostItemID,FCostItemName,FCostItemNumber,\n").append("\t   FMaterialID,FMaterialName,FMaterialNumber,FMaterialModel,FMaterialShortName,\n").append("\t   FMaterialUnitName,FBaseMaterialUnitName,FAUXMaterialUnitName,FMaterialLot,\n").append("\t   FBoPQty,FBoPAmount,FCurInputQty,FCurInputAmount,FTotalInputQty,FTotalInputAmount,\n").append("\t   FFinishedQty,FFinishedAmount,FWIPQty,FWIPAmount,\n").append("\t   FUnitCostQty,FUnitCostAmount,FUnitCostRatio,\n").append("      FIsTotalRow,\n").append("      FTotalManufactureRow,FTotalProductRow,FTotalCostCenterRow,FTotalCostItemRow,FTotalMaterialRow, \n").append("      FProductQtyPrecision,FMatQtyPrecision,FAmountPrecision) \n").append("SELECT 0,0,t4.FCompanyID,\n").append("       t4.FCalculatePeriodID,t9.FNumber as FPeriodName, t9.FNumber as FPeriodNumber,\n").append("\t    t4.FOrderID,t5.FNumber as FManufactureOrderName, t5.FNumber as FManufactureOrderNumber,\n").append("\t    t4.FProductID,t10.FName_l2 as FProductName, t10.FNumber as FProductNumber,t10.FModel as FProductModel,t5.FLot as FLot,\n").append("       '' as FBaseUnitName,t5.FQty as FPlanQty, t11.FFinishedQty as FFinishedProductQty, \n").append("\t    t4.FCostCenterID,t6.FName_l2 as FCostCenterName,t6.FNumber as FCostCenterNumber,\n").append("\t    t4.FCostItemID,t8.FName_l2 as FCostItemName,t8.FNumber as FCostItemNumber,\n").append("\t    t4.FMaterialID,t9.FName_l2 as FMaterialName,t9.FNumber as FMaterialNumber,t9.FModel as FMaterialModel,\n").append("       t9.FShortName as FMaterialShortName, \n").append("\t    '' as FMaterialUnitName,'' as FBaseMaterialUnitName,'' as FAUXMaterialUnitName,t4.FMatBatchNo as FMaterialLot,\n").append("\t    t3.FQty as FBoPQty, t3.FAmount as FBoPAmount,\n").append("       t4.FEoPWIPQty + t4.FFinishedQty - isnull(t3.FQty,0) as FCurInputQty, \n").append("       t4.FEoPWIPAmount + t4.FFinishedAmount - isnull(t3.FAmount,0) as FCurInputAmount, \n").append("       t4.FEoPWIPQty + t4.FFinishedQty as FTotalInputQty, t4.FEoPWIPAmount + t4.FFinishedAmount FTotalInputAmount,").append("\t    t4.FFinishedQty as FFinishedQty,t4.FFinishedAmount as FFinishedAmount,t4.FEoPWIPQty as FWIPQty,t4.FEoPWIPAmount as FWIPAmount,\n").append("\t    case when t11.FFinishedQty = 0 then 0 else t4.FFinishedQty/t11.FFinishedQty end as FUnitCostQty,\n").append("       case when t11.FFinishedQty = 0 then 0 else t4.FFinishedAmount/t11.FFinishedQty end as FUnitCostAmount, 0 as FUnitCostRatio, \n").append("      0 as FIsTotalRow,\n").append("      0 FTotalManufactureRow,0 FTotalProductRow,0 FTotalCostCenterRow,0 FTotalCostItemRow,0 FTotalMaterialRow, \n").append("      0 FProductQtyPrecision,0 FMatQtyPrecision,0 FAmountPrecision \n").append("FROM ").append(T_NCM_OrderBalance).append(" t1\n").append("INNER JOIN ").append(T_NCM_OrderBalanceMaterial).append(" t2 on t2.FParentID=t1.FID\n").append("INNER JOIN ").append(T_NCM_OrderBalanceMaterialEntry).append(" t3 on t3.FParentID=t2.FID\n").append("full JOIN ").append(T_NCM_OrderCostCalMatDetailResult).append(" t4 on t1.FCompanyOrg=t4.FCompanyID\n").append("       AND t1.FCalculatePeriod=t4.FCalculatePeriodID\n").append("       AND t4.FOrderID=t1.FOrderID\n").append("       AND t4.FCostCenterID=t2.FCostCenterID\n").append("       AND t4.FCostItemID=t2.FCostItemID\n").append("       AND t4.FMaterialID=t3.FMaterialID \n").append("full JOIN ").append(T_NCM_DataByOrder).append(" t11 on t11.FCompanyID=t4.FCompanyID\n").append("       AND t11.FCalculatePeriodID=t4.FCalculatePeriodID\n").append("       AND t4.FOrderID=t11.FOrderID\n").append("INNER JOIN T_MM_ManufactureOrder t5 on t4.FOrderID=t5.FID\n").append("INNER JOIN T_ORG_CostCenter t6 on t4.FCostCenterID=t6.FID\n").append("INNER JOIN T_BD_Period t7 on t4.FCalculatePeriodID=t7.FID\n").append("INNER JOIN T_NCM_CostItem t8 on t4.FCostItemID=t8.FID and t8.FItemType='").append("1").append("' \n").append("INNER JOIN T_BD_Material t9 on t4.FMaterialID=t9.FID\n").append("INNER JOIN T_BD_Material t10 on t4.FProductID=t10.FID\n").append(" WHERE t4.FCompanyID=? \n");
            this.AppendPredicate(sbSQL, filter, true, "t7.FNumber", "", "");
            this.AppendPredicate(sbSQL, filter, false, "t6.FNumber", ">=", "costcenterFrom");
            this.AppendPredicate(sbSQL, filter, false, "t6.FNumber", "<=", "costcenterTo");
            this.AppendPredicate(sbSQL, filter, false, "t5.FNumber", ">=", "manufacturerOrderFrom");
            this.AppendPredicate(sbSQL, filter, false, "t5.FNumber", "<=", "manufacturerOrderTo");
            this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", ">=", "costitemFrom");
            this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", "<=", "costitemTo");
            this.AppendPredicate(sbSQL, filter, false, "t9.FNumber", ">=", "materialFrom");
            this.AppendPredicate(sbSQL, filter, false, "t9.FNumber", "<=", "materialTo");
            this.AppendPredicate(sbSQL, filter, false, "t10.FNumber", ">=", "productFrom");
            this.AppendPredicate(sbSQL, filter, false, "t10.FNumber", "<=", "productTo");
            DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString(), (Object[])new String[]{companyID});
            sbSQL.delete(0, sbSQL.length() - 1);
            sbSQL.append(" INSERT INTO ").append(sTmpTblName).append(" \t  (FTotalRow,FTotalRow2,FCompanyOrg,\n").append("      FPeriodID,FPeriodName,FPeriodNumber,\n").append("\t   FManufactureOrderID,FManufactureOrderName,FManufactureOrderNumber,\n").append("\t   FProductID,FProductName,FProductNumber,FProductModel,FLot,\n").append("      FBaseUnitName,FPlanQty,FFinishedProductQty, \n").append("\t   FCostCenterID,FCostCenterName,FCostCenterNumber,\n").append("\t   FCostItemID,FCostItemName,FCostItemNumber,\n").append("\t   FMaterialID,FMaterialName,FMaterialNumber,FMaterialModel,FMaterialShortName,\n").append("\t   FMaterialUnitName,FBaseMaterialUnitName,FAUXMaterialUnitName,FMaterialLot,\n").append("\t   FBoPQty,FBoPAmount,FCurInputQty,FCurInputAmount,FTotalInputQty,FTotalInputAmount,\n").append("\t   FFinishedQty,FFinishedAmount,FWIPQty,FWIPAmount,\n").append("\t   FUnitCostQty,FUnitCostAmount,FUnitCostRatio,\n").append("      FIsTotalRow,\n").append("      FTotalManufactureRow,FTotalProductRow,FTotalCostCenterRow,FTotalCostItemRow,FTotalMaterialRow, \n").append("      FProductQtyPrecision,FMatQtyPrecision,FAmountPrecision) \n").append("SELECT 0,0,t1.FCompanyOrg,\n").append("       t1.FCalculatePeriod,t9.FNumber as FPeriodName, t9.FNumber as FPeriodNumber,\n").append("\t    t1.FOrderID,t5.FNumber as FManufactureOrderName, t5.FNumber as FManufactureOrderNumber,\n").append("\t    t1.FOrderProductID,t10.FName_l2 as FProductName, t10.FNumber as FProductNumber,t10.FModel as FProductModel,t5.FLot as FLot,\n").append("       '' as FBaseUnitName,t5.FQty as FPlanQty, t11.FFinishedQty as FFinishedProductQty, \n").append("\t    t2.FCostCenterID,t6.FName_l2 as FCostCenterName,t6.FNumber as FCostCenterNumber,\n").append("\t    t2.FCostItemID,t8.FName_l2 as FCostItemName,t8.FNumber as FCostItemNumber,\n").append("\t    t3.FMaterialID,t9.FName_l2 as FMaterialName,t9.FNumber as FMaterialNumber,t9.FModel as FMaterialModel,\n").append("       t9.FShortName as FMaterialShortName, \n").append("\t    '' as FMaterialUnitName,'' as FBaseMaterialUnitName,'' as FAUXMaterialUnitName,t4.FMatBatchNo as FMaterialLot,\n").append("\t    t3.FQty as FBoPQty, t3.FAmount as FBoPAmount,\n").append("       t4.FEoPWIPQty + t4.FFinishedQty - isnull(t3.FQty,0) as FCurInputQty, \n").append("       t4.FEoPWIPAmount + t4.FFinishedAmount - isnull(t3.FAmount,0) as FCurInputAmount, \n").append("       t4.FEoPWIPQty + t4.FFinishedQty as FTotalInputQty, t4.FEoPWIPAmount + t4.FFinishedAmount FTotalInputAmount,").append("\t    t4.FFinishedQty as FFinishedQty,t4.FFinishedAmount as FFinishedAmount,t4.FEoPWIPQty as FWIPQty,t4.FEoPWIPAmount as FWIPAmount,\n").append("\t    case when t11.FFinishedQty = 0 then 0 else t4.FFinishedQty/t11.FFinishedQty end as FUnitCostQty,\n").append("       case when t11.FFinishedQty = 0 then 0 else t4.FFinishedAmount/t11.FFinishedQty end as FUnitCostAmount, 0 as FUnitCostRatio, \n").append("      0 as FIsTotalRow,\n").append("      0 FTotalManufactureRow,0 FTotalProductRow,0 FTotalCostCenterRow,0 FTotalCostItemRow,0 FTotalMaterialRow, \n").append("      0 FProductQtyPrecision,0 FMatQtyPrecision,0 FAmountPrecision \n").append("FROM ").append(T_NCM_OrderBalance).append(" t1\n").append("INNER JOIN ").append(T_NCM_OrderBalanceMaterial).append(" t2 on t2.FParentID=t1.FID\n").append("INNER JOIN ").append(T_NCM_OrderBalanceMaterialEntry).append(" t3 on t3.FParentID=t2.FID\n").append("full JOIN ").append(T_NCM_OrderCostCalMatDetailResult).append(" t4 on t1.FCompanyOrg=t4.FCompanyID\n").append("       AND t1.FCalculatePeriod=t4.FCalculatePeriodID\n").append("       AND t4.FOrderID=t1.FOrderID\n").append("       AND t4.FCostCenterID=t2.FCostCenterID\n").append("       AND t4.FCostItemID=t2.FCostItemID\n").append("       AND t4.FMaterialID=t3.FMaterialID \n").append("full JOIN ").append(T_NCM_DataByOrder).append(" t11 on t11.FCompanyID=t4.FCompanyID\n").append("       AND t11.FCalculatePeriodID=t4.FCalculatePeriodID\n").append("       AND t4.FOrderID=t11.FOrderID\n").append("INNER JOIN T_MM_ManufactureOrder t5 on t1.FOrderID=t5.FID\n").append("INNER JOIN T_ORG_CostCenter t6 on t2.FCostCenterID=t6.FID\n").append("INNER JOIN T_BD_Period t7 on t1.FCalculatePeriod=t7.FID\n").append("INNER JOIN T_NCM_CostItem t8 on t2.FCostItemID=t8.FID and t8.FItemType='").append("1").append("' \n").append("INNER JOIN T_BD_Material t9 on t3.FMaterialID=t9.FID\n").append("INNER JOIN T_BD_Material t10 on t1.FOrderProductID=t10.FID\n").append(" WHERE t4.FFinishedQty is null and t4.FEoPWIPQty is null \n");
            this.AppendPredicate(sbSQL, filter, true, "t7.FNumber", "", "");
            this.AppendPredicate(sbSQL, filter, false, "t6.FNumber", ">=", "costcenterFrom");
            this.AppendPredicate(sbSQL, filter, false, "t6.FNumber", "<=", "costcenterTo");
            this.AppendPredicate(sbSQL, filter, false, "t5.FNumber", ">=", "manufacturerOrderFrom");
            this.AppendPredicate(sbSQL, filter, false, "t5.FNumber", "<=", "manufacturerOrderTo");
            this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", ">=", "costitemFrom");
            this.AppendPredicate(sbSQL, filter, false, "t8.FNumber", "<=", "costitemTo");
            this.AppendPredicate(sbSQL, filter, false, "t9.FNumber", ">=", "materialFrom");
            this.AppendPredicate(sbSQL, filter, false, "t9.FNumber", "<=", "materialTo");
            this.AppendPredicate(sbSQL, filter, false, "t10.FNumber", ">=", "productFrom");
            this.AppendPredicate(sbSQL, filter, false, "t10.FNumber", "<=", "productTo");
            DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString());
            sbSQL.delete(0, sbSQL.length() - 1);
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContext());
            TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, sTmpTblName);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        sbSQL = new StringBuffer();
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FBaseUnitName)=\n").append("  (SELECT t3.FName_L2 \n").append("      FROM T_BD_Material t2\n").append("      INNER JOIN t_BD_MeasureUnit t3 on t2.FBaseUnit=t3.FID\n").append("      WHERE t1.FProductID=t2.FID);\n");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FBaseMaterialUnitName)=\n").append("  (SELECT t3.FName_L2 \n").append("      FROM T_BD_Material t2\n").append("      INNER JOIN t_BD_MeasureUnit t3 on t2.FBaseUnit=t3.FID\n").append("      WHERE t1.FMaterialID=t2.FID);\n");
        String table = "T_IM_MaterialReqBillEntry";
        sbSQL.append(" update " + sTmpTblName + " as t1  set FMaterialUnitName   = (select  top 1 t3.FName_L2 \n");
        sbSQL.append(" from  " + table + " t2  \n");
        sbSQL.append("      left JOIN t_BD_MeasureUnit t3  on t2.FUnitID = t3.FID \n");
        sbSQL.append(" where t2.FMaterialID=t1.FMaterialID group by t2.FMaterialID,t3.FName_L2 )");
        sbSQL.append("\n\n");
        sbSQL.append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FAUXMaterialUnitName)=\n").append("  (SELECT t3.FName_L2 \n").append("      FROM T_BD_Material t2\n").append("      LEFT JOIN t_BD_MeasureUnit t3 on t2.FAssistUnit=t3.FID\n").append("      WHERE t1.FMaterialID=t2.FID);\n");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FProductQtyPrecision)=\n").append("  (SELECT t3.FQtyPrecision \n").append("      FROM T_MM_ManuFactureOrder t2\n").append("      LEFT JOIN t_BD_MeasureUnit t3 on t2.FBaseUnitID=t3.FID\n").append("      WHERE t1.FManufactureOrderID=t2.FID);\n");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1").append(" SET (FMatQtyPrecision)=\n").append("  (SELECT t3.FQtyPrecision \n").append("      FROM T_BD_Material t2\n").append("      LEFT JOIN t_BD_MeasureUnit t3 on t2.FBaseUnit=t3.FID\n").append("      WHERE t1.FMaterialID=t2.FID);\n");
        sbSQL.append("UPDATE ").append(sTmpTblName).append(" SET (FAmountPrecision)= \n").append("\t(SELECT t1.FPrecision \n").append("\tFROM T_BD_Currency t1 \n").append("\tINNER JOIN T_ORG_Company t2 ON t2.FBaseCurrencyID = t1.FID \n").append("\tWHERE t2.FID='").append(companyID).append("'); \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" as t1 \n").append("    SET (FUnitCostRatio)= \n").append(" (SELECT FSum \n").append("    FROM (SELECT FPeriodID FP,FManufactureOrderID FC,SUM(FFinishedAmount) FSum \n").append("            FROM  ").append(sTmpTblName).append("\n").append("            GROUP BY FPeriodID,FManufactureOrderID) as t2\n").append("   WHERE t1.FManufactureOrderID=t2.FC and t1.FPeriodID=t2.FP)");
        DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        sbSQL.append(" Update ").append(sTmpTblName).append("\n Set FUnitCostRatio= \n");
        this.AppendCaseSQLClause(sbSQL, "100*FFinishedAmount", "FUnitCostRatio", " \n\n;");
        DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString());
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        HashMap<String, Integer> totalrows = new HashMap<String, Integer>();
        int totalrow = 104;
        ArrayList tblData = (ArrayList)filter.getObject("table");
        sbSQL = new StringBuffer();
        StringBuffer orderBy = new StringBuffer();
        for (int i = 0; i < tblData.size(); ++i) {
            HashMap row = (HashMap)tblData.get(i);
            String fieldID = (String)row.get("id");
            if ("FPeriodID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FPeriodNumberOrder,FTotalPeriodRow " + orderByMode + ",");
            }
            if ("FManufactureOrderID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FManufactureOrderNumberOrder,FTotalManufactureRow " + orderByMode + ",");
            } else if ("FProductID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FProductNumberOrder,FTotalProductRow " + orderByMode + ",");
            } else if ("FCostCenterID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostCenterNumberOrder,FTotalCostCenterRow " + orderByMode + ",");
            } else if ("FCostItemID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FCostItemNumberOrder,FTotalCostItemRow " + orderByMode + ",");
            } else if ("FMaterialID".equalsIgnoreCase(fieldID)) {
                orderBy.append("FMaterialNumberOrder,FTotalMaterialRow " + orderByMode + ",");
            }
            if (!((Boolean)row.get("isTotal")).booleanValue()) continue;
            totalrows.put(fieldID, new Integer(totalrow--));
            StringBuffer fields = new StringBuffer();
            for (int k = 0; k <= i; ++k) {
                HashMap subrow = (HashMap)tblData.get(k);
                String subFieldID = (String)subrow.get("id");
                if ("FPeriodID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FPeriodID,");
                    continue;
                }
                if ("FManufactureOrderID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FManufactureOrderID,");
                    continue;
                }
                if ("FProductID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FProductID,FPlanQty,FFinishedProductQty,");
                    continue;
                }
                if ("FCostCenterID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FCostCenterID,");
                    continue;
                }
                if ("FCostItemID".equalsIgnoreCase(subFieldID)) {
                    fields.append("FCostItemID,");
                    continue;
                }
                if (!"FMaterialID".equalsIgnoreCase(subFieldID)) continue;
                fields.append("FMaterialID,");
            }
            fields.deleteCharAt(fields.length() - 1);
            sbSQL.append(" INSERT INTO ").append(sTmpTblName).append("\n").append("  (FCompanyOrg,FTotalRow,FTotalRow2,\n").append("  " + fields + ",\n");
            sbSQL.append(" FBoPAmount,FCurInputAmount,FTotalInputAmount,\n");
            sbSQL.append(" FFinishedAmount,FWIPAmount,FUnitCostAmount, \n");
            sbSQL.append(" FUnitCostRatio, FMatQtyPrecision, FAmountPrecision)");
            sbSQL.append(" SELECT FCompanyOrg, 0,").append(totalrows.get(fieldID)).append("\n").append("  ," + fields + ",\n");
            sbSQL.append("  SUM(FBoPAmount),SUM(FCurInputAmount),\n").append("  SUM(FTotalInputAmount),SUM(FFinishedAmount),\n").append("  SUM(FWIPAmount),SUM(FUnitCostAmount),\n");
            if ("FPeriodID".equals(fields.toString())) {
                sbSQL.append("  0,\n");
            } else {
                sbSQL.append("  sum(FUnitCostRatio),\n");
            }
            sbSQL.append("  max(FMatQtyPrecision),max(FAmountPrecision)\n").append(" FROM " + sTmpTblName + "\n").append(" WHERE FTotalRow2 = 0 \n");
            sbSQL.append(" GROUP BY FCompanyOrg, " + fields);
            sbSQL.append("\n\n").append(";");
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        String fieldID = "";
        String totalFieldName = "";
        if (tblData.size() > 0) {
            HashMap row = (HashMap)tblData.get(0);
            fieldID = (String)row.get("id");
        }
        if ("FPeriodID".equalsIgnoreCase(fieldID)) {
            totalFieldName = "FPeriodNumber";
        } else if ("FManufactureOrderID".equalsIgnoreCase(fieldID)) {
            totalFieldName = "FManufactureOrderNumber";
        } else if ("FProductID".equalsIgnoreCase(fieldID)) {
            totalFieldName = "FProductNumber";
        } else if ("FCostCenterID".equalsIgnoreCase(fieldID)) {
            totalFieldName = "FCostCenterName";
        } else if ("FCostItemID".equalsIgnoreCase(fieldID)) {
            totalFieldName = "FCostItemName";
        } else if ("FMaterialID".equalsIgnoreCase(fieldID)) {
            totalFieldName = "FMaterialNumber";
        }
        sbSQL = new StringBuffer();
        sbSQL.append(" INSERT INTO ").append(sTmpTblName).append("  (FTotalRow,FTotalRow2," + totalFieldName + ",").append("\t\t FBoPAmount,\n").append("\t\t FCurInputAmount,\n").append("        FTotalInputAmount,\n").append("        FFinishedAmount,\n").append("        FWIPAmount,FUnitCostAmount,\n").append("        FMatQtyPrecision, FAmountPrecision)").append(" SELECT 1,105, '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"180_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "',").append("  SUM(FBoPAmount),SUM(FCurInputAmount),\n").append("  SUM(FTotalInputAmount),SUM(FFinishedAmount),\n").append("  SUM(FWIPAmount),sum(FUnitCostAmount), \n").append("  max(FMatQtyPrecision), max(FAmountPrecision)").append(" FROM " + sTmpTblName + "\n").append(" where FTotalRow2 = 0 \n").append(";\n\n");
        DbUtil.execute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        for (int i = 0; i < tblData.size(); ++i) {
            HashMap map = (HashMap)tblData.get(i);
            String field = (String)map.get("id");
            String fieldName = field.substring(0, field.length() - 2) + "Name";
            String fieldNumber = field.substring(0, field.length() - 2) + "Number";
            String whichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FPeriodNumber")) {
                whichTotal = ", FTotalPeriodRow = 1 ";
                fieldName = fieldNumber;
            }
            if (fieldNumber.equalsIgnoreCase("FManufactureOrderNumber")) {
                whichTotal = ", FTotalManufactureRow = 1 ";
                fieldName = fieldNumber;
            }
            if (fieldNumber.equalsIgnoreCase("FProductNumber")) {
                whichTotal = ", FTotalProductRow = 1 ";
                fieldName = fieldNumber;
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumber")) {
                whichTotal = ", FTotalCostCenterRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumber")) {
                whichTotal = ", FTotalCostItemRow = 1 ";
            }
            if (fieldNumber.equalsIgnoreCase("FMaterialNumber")) {
                whichTotal = ", FTotalMaterialRow = 1 ";
                fieldName = fieldNumber;
            }
            if (!((Boolean)map.get("isTotal")).booleanValue()) continue;
            sbSQL.append(" UPDATE ").append(sTmpTblName).append("\n SET ").append(fieldName).append("= '" + ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"179_AUXOverheadDetailReport", (Locale)ctx.getLocale()) + "'\n").append(whichTotal).append(" WHERE FTotalRow2 = ").append(totalrows.get(field)).append("\n\n").append(";");
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        sbSQL = new StringBuffer();
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FCostCenterNumber,FCostCenterName) =(select  t2.FNumber, t2.FName_L2 \n").append(" FROM T_ORG_CostCenter t2 \n").append(" WHERE t1.FCostCenterID = t2.FID) ").append(" Where FTotalCostCenterRow <> 1 \n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FPeriodNumber) = (select TO_Char(t2.FNumber)\n").append(" FROM T_BD_Period t2 ").append(" WHERE t1.FPeriodID = t2.FID )").append(" where FTotalPeriodRow <> 1\n\n").append("\n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FCostItemNumber, FCostItemName )= (select  t2.FNumber,t2.FName_L2 \n").append(" FROM t_Ncm_Costitem t2 where  t1.FCostItemID = t2.FID ) ").append(" where FTotalCostItemRow <> 1\n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FManufactureOrderNumber, FLot )= (select  t2.FNumber,t2.FLot \n").append(" FROM t_MM_ManufactureOrder t2 where  t1.FManufactureOrderID = t2.FID ) ").append(" where FTotalManufactureRow <> 1 \n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FProductName, FProductNumber,FProductModel,FBaseUnitName )= (select  t2.FName_l2, t2.FNumber, t2.FModel, t3.FName_l2 \n").append(" FROM T_BD_Material t2 \n").append(" INNER JOIN t_BD_MeasureUnit t3 on t2.FBaseUnit=t3.FID where  t1.FProductID = t2.FID ) ").append(" where FTotalProductRow <> 1 \n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET FPlanQty = null, FFinishedProductQty = null \n").append(" where FTotalProductRow = 1 \n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FPeriodNumberOrder) = (select TO_Char(t2.FNumber)\n").append(" FROM T_BD_Period t2 ").append(" WHERE t1.FPeriodID = t2.FID )").append("\n\n").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FManufactureOrderNumberOrder)= (select  t2.FNumber\n").append(" FROM t_MM_ManufactureOrder t2 where  t1.FManufactureOrderID = t2.FID ) ").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FProductNumberOrder)= (select t2.FNumber\n").append(" FROM T_BD_Material t2 \n").append(" where  t1.FProductID = t2.FID ) ").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FCostCenterNumberOrder) =(select  t2.FNumber\n").append(" FROM T_ORG_CostCenter t2 \n").append(" WHERE t1.FCostCenterID = t2.FID) ").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FCostItemNumberOrder)= (select  t2.FNumber \n").append(" FROM t_Ncm_Costitem t2 where  t1.FCostItemID = t2.FID ) ").append(";");
        sbSQL.append(" UPDATE ").append(sTmpTblName).append(" AS t1").append(" SET (FMaterialNumberOrder)= (select t2.FNumber\n").append(" FROM T_BD_Material t2 \n").append(" where  t1.FMaterialID = t2.FID ) ").append(";");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)sbSQL.toString());
        String sql = this.buildDataSql(filter, sTmpTblName);
        rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(sTmpTblName);
        return rs;
    }

    private String getPeriodNumber(String year, String period) {
        return year + (period.length() < 2 ? "0" + period : period);
    }

    private void AppendCaseSQLClause(StringBuffer sb, String sNumerator, String sDenominator, String sAlias) {
        sb.append("CASE ").append(sDenominator).append(" WHEN 0 THEN 0 ").append(" ELSE TO_Decimal(").append(sNumerator).append(",21,8)").append("     /TO_Decimal(").append(sDenominator).append(",21,8) END ").append(sAlias);
    }

    private void AppendPredicate(StringBuffer sb, RptParams filter, boolean bIsPeriod, String sFieldName, String sOP, String sFilterName) {
        if (bIsPeriod) {
            this.AppendPredicateString(sb, false, sFieldName, ">=", this.getPeriodNumber(filter.getString("yearFrom"), filter.getString("periodFrom")));
            this.AppendPredicateString(sb, false, sFieldName, "<=", this.getPeriodNumber(filter.getString("yearTo"), filter.getString("periodTo")));
        } else {
            String sFilterValue = filter.getString(sFilterName);
            if (sFilterValue != null && !"".equals(sFilterValue)) {
                this.AppendPredicateString(sb, true, sFieldName, sOP, sFilterValue);
            }
        }
    }

    private void AppendPredicateString(StringBuffer sb, boolean bIsString, String sFieldName, String sOP, String sValue) {
        sb.append(" AND ");
        sb.append(sFieldName);
        sb.append(sOP);
        if (bIsString) {
            sb.append("'");
        }
        sb.append(sValue);
        if (bIsString) {
            sb.append("' ");
        } else {
            sb.append(" ");
        }
    }

    private ArrayList getGroupByList(ArrayList list) {
        ArrayList<HashMap> newList = new ArrayList<HashMap>();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            if (sb.length() > 0) {
                sb.append(",");
            }
            String fieldID = (String)map.get("id");
            sb.append(fieldID);
            map.put("groupby", sb.toString());
            map.put("totalrow", new Integer(104 - i));
            newList.add(map);
        }
        return newList;
    }

    private String createTmpTableSQL() throws BOSException {
        String sTmpTblName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table tmp_MatCostCalcReport( ");
        createTable.append(" FCompanyOrg nvarchar(255) ");
        createTable.append(",FPeriodID   varchar(44)  ");
        createTable.append(",FPeriodName nvarchar(255) ");
        createTable.append(",FPeriodNumber nvarchar(255) ");
        createTable.append(",FPeriodNumberOrder nvarchar(255) ");
        createTable.append(",FManufactureOrderID varchar(44)  ");
        createTable.append(",FManufactureOrderName nvarchar(255)  ");
        createTable.append(",FManufactureOrderNumber nvarchar(255)  ");
        createTable.append(",FManufactureOrderNumberOrder nvarchar(255)  ");
        createTable.append(",FProductID varchar(44)");
        createTable.append(",FProductName nvarchar(255)");
        createTable.append(",FProductNumber nvarchar(255)");
        createTable.append(",FProductNumberOrder nvarchar(255)");
        createTable.append(",FProductModel nvarchar(255) ");
        createTable.append(",FLot nvarchar(80) ");
        createTable.append(",FBaseUnitName nvarchar(255)");
        createTable.append(",FPlanQty numeric(28,10)");
        createTable.append(",FFinishedProductQty numeric(28,10)");
        createTable.append(",FCostCenterID varchar(44)");
        createTable.append(",FCostCenterName nvarchar(255)");
        createTable.append(",FCostCenterNumber nvarchar(255)");
        createTable.append(",FCostCenterNumberOrder nvarchar(255)");
        createTable.append(",FCostItemID varchar(44)");
        createTable.append(",FCostItemName nvarchar(255)");
        createTable.append(",FCostItemNumber nvarchar(255)");
        createTable.append(",FCostItemNumberOrder nvarchar(255)");
        createTable.append(",FMaterialID varchar(44)");
        createTable.append(",FMaterialName nvarchar(255)");
        createTable.append(",FMaterialNumber nvarchar(255)");
        createTable.append(",FMaterialNumberOrder nvarchar(255)");
        createTable.append(",FMaterialModel nvarchar(255)");
        createTable.append(",FMaterialShortName nvarchar(255)");
        createTable.append(",FMaterialUnitName nvarchar(255)");
        createTable.append(",FBaseMaterialUnitName nvarchar(255)");
        createTable.append(",FAUXMaterialUnitName nvarchar(255)");
        createTable.append(",FMaterialLot nvarchar(80)");
        createTable.append(",FBoPQty NUMERIC(21,10) ");
        createTable.append(",FBoPAmount NUMERIC(17,4) ");
        createTable.append(",FCurInputQty NUMERIC(21,10) ");
        createTable.append(",FCurInputAmount NUMERIC(17,4) ");
        createTable.append(",FTotalInputQty NUMERIC(21,10)");
        createTable.append(",FTotalInputAmount NUMERIC(17,4)");
        createTable.append(",FFinishedQty NUMERIC(21,10) ");
        createTable.append(",FFinishedAmount NUMERIC(17,4) ");
        createTable.append(",FWIPQty NUMERIC(21,10) ");
        createTable.append(",FWIPAmount NUMERIC(17,4) ");
        createTable.append(",FUnitCostQty NUMERIC(21,10) ");
        createTable.append(",FUnitCostAmount NUMERIC(17,4) ");
        createTable.append(",FUnitCostRatio NUMERIC(17,2) ");
        createTable.append(",FTotalRow NUMERIC(17,4) ");
        createTable.append(",FTotalRow2 NUMERIC(17,4) ");
        createTable.append(" ,FIsTotalRow int not null default(1) ");
        createTable.append(" ,FTotalPeriodRow int not null default(0) ");
        createTable.append(" ,FTotalManufactureRow int not null default(0) ");
        createTable.append(" ,FTotalProductRow int not null default(0) ");
        createTable.append(" ,FTotalCostCenterRow int not null default(0) ");
        createTable.append(" ,FTotalCostItemRow int not null default(0) ");
        createTable.append(" ,FTotalMaterialRow int not null default(0) ");
        createTable.append(",FProductQtyPrecision int default(0) ");
        createTable.append(",FMatQtyPrecision int default(0) ");
        createTable.append(",FAmountPrecision int default(0) ");
        createTable.append(" ) ");
        try {
            sTmpTblName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return sTmpTblName;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        Context ctx = this.getContext();
        ReportTitles titles = new ReportTitles();
        CompanyOrgUnitInfo info = (CompanyOrgUnitInfo)filter.getObject("companyorg");
        String number = "";
        number = info == null ? ResourceBase.getString((String)"com.kingdee.eas.ncm.cal.report.REPORTAutoGenerateResource", (String)"0_AuxFeeAllocResultReport", (Locale)ctx.getLocale()) : info.getName();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_Company", (Locale)ctx.getLocale()) + number);
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_PeriodRange", (Locale)ctx.getLocale()) + filter.getString("yearFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_Year", (Locale)ctx.getLocale()) + filter.getString("periodFrom") + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_PeriodFrom", (Locale)ctx.getLocale()) + filter.getString("yearTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_Year", (Locale)ctx.getLocale()) + filter.getString("periodTo") + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_Month", (Locale)ctx.getLocale()));
        titles.AddTitle(3, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_OrderRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("manufacturerOrderFrom"), filter.getString("manufacturerOrderTo")));
        titles.AddTitle(5, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_ProductRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("productFrom"), filter.getString("productTo")));
        titles.AddTitle(6, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_CostCenterRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("costcenterFrom"), filter.getString("costcenterTo")));
        titles.AddTitle(8, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_CostItemRange", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("costitemFrom"), filter.getString("costitemTo")));
        titles.AddTitle(9, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_Material", (Locale)ctx.getLocale()) + this.buildFilterRange(filter.getString("materialFrom"), filter.getString("materialTo")));
        return titles;
    }

    private Integer getFromPeriod(RptParams filter) {
        Integer result = null;
        String year = filter.getString("yearFrom");
        String month = filter.getString("periodFrom");
        if (!StringUtils.isEmpty((String)year) && !StringUtils.isEmpty((String)month)) {
            String period = this.getPeriodNumber(year, month);
            try {
                result = new Integer(Integer.parseInt(period));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private Integer getToPeriod(RptParams filter) {
        Integer result = null;
        String year = filter.getString("yearTo");
        String month = filter.getString("periodTo");
        if (!StringUtils.isEmpty((String)year) && !StringUtils.isEmpty((String)month)) {
            String period = this.getPeriodNumber(year, month);
            try {
                result = new Integer(Integer.parseInt(period));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        int i;
        ReportHeader reportHeader = new ReportHeader();
        Context ctx = this.getContext();
        int index = 0;
        List tblData = (List)filter.getObject("table");
        ArrayList list = new ArrayList(tblData.size());
        for (i = 0; i < tblData.size(); ++i) {
            Map row = (Map)tblData.get(i);
            list.add(row.get("id"));
        }
        for (i = 0; i < list.size(); ++i) {
            if ("FPeriodID".equals(list.get(i))) {
                reportHeader.addChild("FPeriodNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Period", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            }
            if ("FManufactureOrderID".equals(list.get(i))) {
                reportHeader.addChild("FManufactureOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_OrderNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FLot", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Lot", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if ("FProductID".equals(list.get(i))) {
                reportHeader.addChild("FProductNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_ProductNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FProductName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_PorductName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FProductModel", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Model", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                reportHeader.addChild("FBaseUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_BaseUnit", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                ReportHeader planQtyCol = reportHeader.addChild("FPlanQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_PlanQty", (Locale)ctx.getLocale()), index++);
                planQtyCol.setAlign(1).setType(2).setDecimalField("FProductQtyPrecision");
                planQtyCol.setMergeable(true);
                ReportHeader finishedQtyCol = reportHeader.addChild("FFinishedProductQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_FinishedProductQty", (Locale)ctx.getLocale()), index++);
                finishedQtyCol.setAlign(1).setType(2).setDecimalField("FProductQtyPrecision");
                finishedQtyCol.setMergeable(true);
                continue;
            }
            if ("FCostCenterID".equals(list.get(i))) {
                reportHeader.addChild("FCostCenterName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_CostCenter", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if ("FCostItemID".equals(list.get(i))) {
                reportHeader.addChild("FCostItemName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_CostItem", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
                continue;
            }
            if (!"FMaterialID".equals(list.get(i))) continue;
            reportHeader.addChild("FMaterialNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_MaterialNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FMaterialName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_MaterialName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FMaterialShortName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_MaterialShortName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FMaterialUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_MatUnit", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FBaseMaterialUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_MatBaseUnit", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FAUXMaterialUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_MatAUXUnit", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FMaterialLot", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_MatLot", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        }
        ReportHeader bopHeader = reportHeader.addChild("FBopBalance", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_BopBalance", (Locale)ctx.getLocale()), index++);
        bopHeader.addChild("FBoPQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_BoPBaseQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FMatQtyPrecision");
        bopHeader.addChild("FBoPAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Cost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        ReportHeader curHeader = reportHeader.addChild("FCurInput", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_CurInput", (Locale)ctx.getLocale()), index++);
        curHeader.addChild("FCurInputQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_BoPBaseQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FMatQtyPrecision");
        curHeader.addChild("FCurInputAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Cost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        ReportHeader totalHeader = reportHeader.addChild("FTotalInput", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_TotalInput", (Locale)ctx.getLocale()), index++);
        totalHeader.addChild("FTotalInputQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_BoPBaseQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FMatQtyPrecision");
        totalHeader.addChild("FTotalInputAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Cost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        ReportHeader finishedHeader = reportHeader.addChild("FFinishedProduct", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_FinishedProduct", (Locale)ctx.getLocale()), index++);
        finishedHeader.addChild("FFinishedQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_BoPBaseQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FMatQtyPrecision");
        finishedHeader.addChild("FFinishedAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Cost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        ReportHeader wipHeader = reportHeader.addChild("Fwip", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_WIPProduct", (Locale)ctx.getLocale()), index++);
        wipHeader.addChild("FWIPQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_BoPBaseQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FMatQtyPrecision");
        wipHeader.addChild("FWIPAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Cost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        ReportHeader unitCostHeader = reportHeader.addChild("FUnitCost", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_UnitCost", (Locale)ctx.getLocale()), index++);
        unitCostHeader.addChild("FUnitCostQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_BoPBaseQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FMatQtyPrecision");
        unitCostHeader.addChild("FUnitCostAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_Cost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("FAmountPrecision");
        unitCostHeader.addChild("FUnitCostRatio", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_ColName_UnitCostRatio", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        return reportHeader;
    }

    private String buildFilterRange(String from, String to) {
        Context ctx = this.getContext();
        if (StringUtils.isEmpty((String)from) && StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_All", (Locale)ctx.getLocale());
        }
        if (StringUtils.isEmpty((String)from)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_FirstFrom", (Locale)ctx.getLocale()) + " " + to;
        }
        if (StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_From", (Locale)ctx.getLocale()) + " " + from + " " + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_ToEnd", (Locale)ctx.getLocale());
        }
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_From", (Locale)ctx.getLocale()) + " " + from + " " + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_To", (Locale)ctx.getLocale()) + " " + to;
    }

    private String buildDataSql(RptParams filter, String tempTableName) {
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = " Where FIsTotalRow = 1 ";
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "DESC" : "ASC";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT  * FROM ");
        sql.append(tempTableName);
        sql.append(where);
        sql.append(" Order by  FTotalRow " + orderByMode);
        ArrayList list = this.getGroupByList((ArrayList)filter.getObject("table"));
        for (int i = 0; i < list.size(); ++i) {
            HashMap map = (HashMap)list.get(i);
            String field = (String)map.get("id");
            String fieldNumber = field.substring(0, field.length() - 2) + "NumberOrder";
            String orderByWhichTotal = "";
            if (fieldNumber.equalsIgnoreCase("FPeriodNumberOrder")) {
                orderByWhichTotal = ", FTotalPeriodRow " + orderByMode;
                fieldNumber = "FPeriodNumberOrder";
            }
            if (fieldNumber.equalsIgnoreCase("FManufactureOrderNumberOrder")) {
                orderByWhichTotal = ", FTotalManufactureRow " + orderByMode;
                fieldNumber = "FManufactureOrderNumberOrder";
            }
            if (fieldNumber.equalsIgnoreCase("FProductNumberOrder")) {
                orderByWhichTotal = ", FTotalProductRow " + orderByMode;
                fieldNumber = "FProductNumberOrder";
            }
            if (fieldNumber.equalsIgnoreCase("FCostCenterNumberOrder")) {
                orderByWhichTotal = ", FTotalCostCenterRow " + orderByMode;
                fieldNumber = "FCostCenterNumberOrder";
            }
            if (fieldNumber.equalsIgnoreCase("FMaterialNumberOrder")) {
                orderByWhichTotal = ", FTotalMaterialRow " + orderByMode;
                fieldNumber = "FMaterialNumberOrder";
            }
            if (fieldNumber.equalsIgnoreCase("FCostItemNumberOrder")) {
                orderByWhichTotal = ", FTotalCostItemRow " + orderByMode;
                fieldNumber = "FCostItemNumberOrder";
            }
            sql.append("," + fieldNumber);
            sql.append(orderByWhichTotal);
        }
        return sql.toString();
    }
}

