/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.ncm.ActivityInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BomInfo;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.mo.ManufactureOrderFactory;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.ncm.common.BillBaseStatusEnum;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeLevelEnum;
import com.kingdee.eas.ncm.order.std.bill.IOSCostAdjustReqBill;
import com.kingdee.eas.ncm.order.std.bill.OSCostAdjustReqBillEntryCollection;
import com.kingdee.eas.ncm.order.std.bill.OSCostAdjustReqBillEntryInfo;
import com.kingdee.eas.ncm.order.std.bill.OSCostAdjustReqBillFactory;
import com.kingdee.eas.ncm.order.std.bill.OSCostAdjustReqBillInfo;
import com.kingdee.eas.ncm.order.std.bill.StorageTypeEnum;
import com.kingdee.eas.ncm.order.std.cal.OSCalcTaskEnum;
import com.kingdee.eas.ncm.order.std.cal.OSCostCalcParam;
import com.kingdee.eas.ncm.order.std.cal.OSCostCalcResult;
import com.kingdee.eas.ncm.order.std.cal.OSCostDetailEntrylInfo;
import com.kingdee.eas.ncm.order.std.cal.OSCostDetailInfo;
import com.kingdee.eas.ncm.order.std.cal.app.AbstractOSCostCalcFacadeControllerBean;
import com.kingdee.eas.ncm.order.std.cal.task.app.IServerCalcTask;
import com.kingdee.eas.ncm.order.std.cal.task.app.factory.CalcTaskFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class OSCostCalcFacadeControllerBean
extends AbstractOSCostCalcFacadeControllerBean {
    private static final long serialVersionUID = 4695707986102184019L;
    private static Logger logger = Logger.getLogger((String)OSCostCalcFacadeControllerBean.class.getName());

    @Override
    protected OSCostCalcResult _exeCalcTask(Context ctx, OSCostCalcParam calcParam) throws BOSException, EASBizException {
        Assert.that((calcParam != null ? 1 : 0) != 0);
        Assert.that((calcParam.getCompanyId() != null ? 1 : 0) != 0);
        Assert.that((calcParam.getCostType() != null ? 1 : 0) != 0);
        Assert.that((calcParam.getCalcTaskEnum() != null ? 1 : 0) != 0);
        OSCalcTaskEnum calcTaskEnum = calcParam.getCalcTaskEnum();
        IServerCalcTask calTasker = CalcTaskFactory.getCalcTask(ctx, calcTaskEnum);
        OSCostCalcResult calResult = new OSCostCalcResult();
        calResult = calTasker.execute(calcParam, calResult);
        return calResult;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected OSCostDetailInfo _queryDetail(Context ctx, String companyId, String costTypeId, String orderId, String materialId) throws BOSException, EASBizException {
        Assert.that((companyId != null ? 1 : 0) != 0);
        Assert.that((costTypeId != null ? 1 : 0) != 0);
        Assert.that((materialId != null ? 1 : 0) != 0);
        OSCostDetailInfo detail = new OSCostDetailInfo();
        CostTypeInfo costType = null;
        MaterialInfo material = null;
        ManufactureOrderInfo order = null;
        BomInfo bom = null;
        String batchNo = null;
        ProjectInfo project = null;
        TrackNumberInfo trackNumber = null;
        boolean isOrderLevel = false;
        costType = CostTypeFactory.getLocalInstance(ctx).getCostTypeInfo((IObjectPK)new ObjectUuidPK(costTypeId));
        if (CostTypeLevelEnum.order.equals((Object)costType.getLevel())) {
            Assert.that((orderId != null ? 1 : 0) != 0);
            isOrderLevel = true;
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("lot"));
            sic.add(new SelectorItemInfo("bomID"));
            sic.add(new SelectorItemInfo("bomNum"));
            sic.add(new SelectorItemInfo("project.id"));
            sic.add(new SelectorItemInfo("project.number"));
            sic.add(new SelectorItemInfo("trackNumber.id"));
            sic.add(new SelectorItemInfo("trackNumber.number"));
            order = ManufactureOrderFactory.getLocalInstance((Context)ctx).getManufactureOrderInfo((IObjectPK)new ObjectUuidPK(orderId), sic);
            batchNo = order.getLot();
            project = order.getProject();
            trackNumber = order.getTrackNumber();
            bom = new BomInfo();
            if (order.getBomID() != null) {
                bom.setId(BOSUuid.read((String)order.getBomID()));
                bom.setNumber(order.getBomNum());
                bom.setName(order.getBomNum());
            }
        }
        material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(materialId));
        detail.setCostType(costType);
        detail.setOrder(order);
        detail.setProduct(material);
        detail.setBom(bom);
        detail.setProject(project);
        detail.setTrackNumber(trackNumber);
        detail.setBatchNo(batchNo);
        String materialNumber = material.getNumber();
        IRowSet rst = null;
        String TMP_NCM_OSCostDetailRpt = null;
        try {
            String T_NCM_OSMaterialDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OSMaterialDetail");
            String T_NCM_OSActivityDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OSActivityDetail");
            StringBuffer kSql = new StringBuffer();
            if (!isOrderLevel) {
                kSql.setLength(0);
                kSql.append(" select FID,FNumber,FName_" + ctx.getLocale() + " \n");
                kSql.append("   from T_MM_Bom \n");
                kSql.append("  where fid in ( ");
                kSql.append("                select top 1 FBomID \n");
                kSql.append("                  from  " + T_NCM_OSMaterialDetail + " \n");
                kSql.append("                 where FParentMaterialID = ? \n");
                kSql.append("                   and FCostTypeId = ? \n");
                kSql.append("                   and FBomID is not null \n");
                kSql.append("                ) \n");
                rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new String[]{materialId, costTypeId});
                if (rst.next()) {
                    BomInfo mainBom = new BomInfo();
                    mainBom.setId(BOSUuid.read((String)rst.getString(1)));
                    mainBom.setNumber(rst.getString(2));
                    mainBom.setName(rst.getString(3));
                    detail.setBom(mainBom);
                }
            }
            kSql.setLength(0);
            kSql.append("create table TMP_NCM_OSCostDetailRpt(");
            kSql.append(" \tFSpreadPath     nvarchar(1200),");
            kSql.append(" \tpMatID          varchar(44),");
            kSql.append(" \tpMatNumber \t    nvarchar(255),");
            kSql.append(" \tpMatName \t\tnvarchar(255),");
            kSql.append(" \tcMatNumber \t    nvarchar(255),");
            kSql.append(" \tcMatName \t    nvarchar(255),");
            kSql.append(" \tcostItemNumber  nvarchar(255),");
            kSql.append(" \tcostItemName    nvarchar(255),");
            kSql.append(" \tmeasureUnitName nvarchar(255),");
            kSql.append(" \tFModel          nvarchar(255),");
            kSql.append(" \tFStdPrice \t    NUMERIC(21,8),");
            kSql.append(" \tFChildQty \t    NUMERIC(21,8),");
            kSql.append(" \tFChildStdPrice  NUMERIC(21,8),");
            kSql.append(" \tFChildAmount    NUMERIC(21,8),");
            kSql.append(" \tFType \t        INT,");
            kSql.append(" \tFIsLeaf \t    INT ");
            kSql.append(" ) ");
            TMP_NCM_OSCostDetailRpt = TempTablePool.getInstance((Context)ctx).createTempTable(kSql.toString());
            kSql.setLength(0);
            kSql.append(" INSERT INTO " + TMP_NCM_OSCostDetailRpt + " \n");
            kSql.append("            (FSpreadPath,\n");
            kSql.append("             pMatID,\n");
            kSql.append("             pMatNumber,\n");
            kSql.append("             pMatName,\n");
            kSql.append("             cMatNumber,\n");
            kSql.append("             cMatName,\n");
            kSql.append("             costItemNumber,\n");
            kSql.append("             costItemName,\n");
            kSql.append(" \t          measureUnitName,\n");
            kSql.append(" \t          FModel,\n");
            kSql.append("             FStdPrice,\n");
            kSql.append("             FChildQty,\n");
            kSql.append("             FChildStdPrice,\n");
            kSql.append("             FChildAmount,\n");
            kSql.append("             FType,\n");
            kSql.append("             FIsLeaf)\n");
            kSql.append(" SELECT   FSpreadPath,\n");
            kSql.append("          pMatID,\n");
            kSql.append("          pMatNumber,\n");
            kSql.append("          pMatName,\n");
            kSql.append("          cMatNumber,\n");
            kSql.append("          cMatName,\n");
            kSql.append("          costItemNumber,\n");
            kSql.append("          costItemName,\n");
            kSql.append(" \t       measureUnitName,\n");
            kSql.append(" \t       FModel,\n");
            kSql.append("          FStdPrice,\n");
            kSql.append("          FChildQty,\n");
            kSql.append("          FChildStdPrice,\n");
            kSql.append("          FChildAmount,\n");
            kSql.append("          FType,\n");
            kSql.append("          FIsLeaf\n");
            kSql.append(" FROM     (SELECT DISTINCT \n");
            kSql.append("                  to_char(rollMat.FSpreadPath) as FSpreadPath,\n");
            kSql.append("                  pMat.FID AS pMatID,\n");
            kSql.append("                  pMat.FNumber AS pMatNumber,\n");
            kSql.append("                  pMat.FName_" + ctx.getLocale() + " AS pMatName,\n");
            kSql.append("                  cMat.FNumber AS cMatNumber,\n");
            kSql.append("                  cMat.FName_" + ctx.getLocale() + " AS cMatName,\n");
            kSql.append("                  ci.FNumber AS costItemNumber,\n");
            kSql.append("                  ci.FName_" + ctx.getLocale() + " AS costItemName,\n");
            kSql.append(" \t               mu.FName_" + ctx.getLocale() + " AS measureUnitName,\n");
            kSql.append(" \t               cMat.FModel AS FModel,\n");
            kSql.append("                  rollMat.FStdPrice,\n");
            kSql.append("                  rollMat.FChildQty,\n");
            kSql.append("                  rollMat.FChildStdPrice,\n");
            kSql.append("                  rollMat.FChildAmount,\n");
            kSql.append("                  1 AS FType,\n");
            kSql.append("                  CASE \n");
            kSql.append("                    WHEN FBomEntryID IS NULL THEN 1\n");
            kSql.append("                    ELSE 0\n");
            kSql.append("                  END AS FIsLeaf\n");
            kSql.append("           FROM   " + T_NCM_OSMaterialDetail + " rollMat\n");
            kSql.append("                  LEFT OUTER JOIN T_BD_Material pMat\n");
            kSql.append("                    ON rollMat.FParentMaterialID = pMat.FID\n");
            kSql.append("                  LEFT OUTER JOIN T_BD_Material cMat\n");
            kSql.append("                    ON rollMat.FMaterialID = cMat.FID\n");
            kSql.append("                  LEFT OUTER JOIN T_NCM_CostItem ci\n");
            kSql.append("                    ON rollMat.FChildCostItemID = ci.FID\n");
            kSql.append("                  LEFT OUTER JOIN T_BD_MeasureUnit mu \n");
            kSql.append("                    ON rollMat.FMeasureUnitID = mu.FID \n");
            kSql.append("           WHERE  rollMat.FCostTypeID = '" + costTypeId + "'\n");
            kSql.append("                  AND CHARINDEX('" + materialNumber + "'||',',rollMat.FSpreadPath) = 1\n");
            if (isOrderLevel) {
                kSql.append("              AND rollMat.FOrderID = '" + orderId + "' \n");
            }
            kSql.append("           UNION ALL\n");
            kSql.append("           SELECT to_char((rollMat.FSpreadPath || ',zzz' || act.FNumber || ',' || ci.FNumber)) AS FSpreadPath,\n");
            kSql.append("                  pMat.FID AS pMatID,\n");
            kSql.append("                  pMat.FNumber AS pMatNumber,\n");
            kSql.append("                  pMat.FName_" + ctx.getLocale() + " AS pMatName,\n");
            kSql.append("                  act.FNumber AS cMatNumber,\n");
            kSql.append("                  act.FName_" + ctx.getLocale() + " AS cMatName,\n");
            kSql.append("                  ci.FNumber AS costItemNumber,\n");
            kSql.append("                  ci.FName_" + ctx.getLocale() + " AS costItemName,\n");
            kSql.append(" \t               mu.FName_" + ctx.getLocale() + " AS measureUnitName,\n");
            kSql.append(" \t               NULL AS FModel,\n");
            kSql.append("                  rollAct.FStdPrice AS FStdPrice,\n");
            kSql.append("                  rollAct.FActQty AS FChildQty,\n");
            kSql.append("                  rollAct.FActStdPrice AS FChildStdPrice,\n");
            kSql.append("                  rollAct.FActAmount AS FChildAmount,\n");
            kSql.append("                  0 AS FType,\n");
            kSql.append("                  0 AS FIsLeaf\n");
            kSql.append("           FROM   " + T_NCM_OSActivityDetail + " rollAct\n");
            kSql.append("                  INNER JOIN (SELECT DISTINCT FParentMaterialID,\n");
            kSql.append("                                              FStorageOrgUnitID,\n");
            kSql.append("                                              LEFT(FSpreadPath,(CHARINDEX(','|| cMat.FNumber,FSpreadPath)- 1)) AS FSpreadPath\n");
            kSql.append("                              FROM   " + T_NCM_OSMaterialDetail + " \n");
            kSql.append("                                     LEFT OUTER JOIN T_BD_Material cMat\n");
            kSql.append("                                       ON FMaterialID = cMat.FID\n");
            kSql.append("                              WHERE  FCostTypeID = '" + costTypeId + "'\n");
            if (isOrderLevel) {
                kSql.append("                                 AND FOrderID = '" + orderId + "' \n");
            }
            kSql.append("                                     AND CHARINDEX('" + materialNumber + "'||',',FSpreadPath) = 1) rollMat\n");
            kSql.append("                    ON rollAct.FParentMaterialID = rollMat.FParentMaterialID\n");
            kSql.append("                       AND rollAct.FStorageOrgUnitID = rollMat.FStorageOrgUnitID\n");
            kSql.append("                  LEFT OUTER JOIN T_BD_Material pMat\n");
            kSql.append("                    ON rollAct.FParentMaterialID = pMat.FID\n");
            kSql.append("                  LEFT OUTER JOIN T_NCM_Activity act\n");
            kSql.append("                    ON rollAct.FActivityID = act.FID\n");
            kSql.append("                  LEFT OUTER JOIN T_NCM_CostItem ci\n");
            kSql.append("                    ON rollAct.FActCostItemID = ci.FID\n");
            kSql.append("                  LEFT OUTER JOIN T_BD_MeasureUnit mu \n");
            kSql.append("                    ON rollAct.FActMeasureUnitID = mu.FID \n");
            kSql.append("           WHERE  rollAct.FCostTypeID = '" + costTypeId + "' \n");
            if (isOrderLevel) {
                kSql.append("              AND rollAct.FOrderID = '" + orderId + "' \n");
            }
            kSql.append("          ) s\n");
            kSql.append(" ORDER BY s.FSpreadPath ASC,\n");
            kSql.append("          s.FType DESC\n");
            DbUtil.execute((Context)ctx, (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" INSERT INTO " + TMP_NCM_OSCostDetailRpt + " \n");
            kSql.append("            (FSpreadPath,\n");
            kSql.append("             pMatID,\n");
            kSql.append("             pMatNumber,\n");
            kSql.append("             pMatName,\n");
            kSql.append("             cMatNumber,\n");
            kSql.append("             cMatName,\n");
            kSql.append("             costItemNumber,\n");
            kSql.append("             costItemName,\n");
            kSql.append(" \t          measureUnitName,\n");
            kSql.append(" \t          FModel,\n");
            kSql.append("             FStdPrice,\n");
            kSql.append("             FChildQty,\n");
            kSql.append("             FChildStdPrice,\n");
            kSql.append("             FChildAmount,\n");
            kSql.append("             FType,\n");
            kSql.append("             FIsLeaf)\n");
            kSql.append("      SELECT MIN(to_char(FSpreadPath)) AS FSpreadPath,\n");
            kSql.append("             pMatID,\n");
            kSql.append("             pMatNumber,\n");
            kSql.append("             pMatName,\n");
            kSql.append("             '\u6750\u6599\u6210\u672c' AS cMatNumber,\n");
            kSql.append("             NULL AS cMatName,\n");
            kSql.append("             NULL AS costItemNumber,\n");
            kSql.append("             NULL AS costItemName,\n");
            kSql.append(" \t          NULL AS measureUnitName,\n");
            kSql.append(" \t          NULL AS FModel,\n");
            kSql.append("             0 AS FStdPrice,\n");
            kSql.append("             0 AS FChildQty,\n");
            kSql.append("             0 AS FChildStdPrice,\n");
            kSql.append("             SUM(FChildAmount) AS FChildAmount,\n");
            kSql.append("             2 AS FType,\n");
            kSql.append("             0 AS FIsLeaf\n");
            kSql.append("        FROM " + TMP_NCM_OSCostDetailRpt + " \n");
            kSql.append("       WHERE FType = 1 \n");
            kSql.append("         AND pMatID = '" + materialId + "' \n");
            kSql.append("         GROUP BY pMatID,pMatNumber,pMatName \n");
            DbUtil.execute((Context)ctx, (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" INSERT INTO " + TMP_NCM_OSCostDetailRpt + " \n");
            kSql.append("            (FSpreadPath,\n");
            kSql.append("             pMatID,\n");
            kSql.append("             pMatNumber,\n");
            kSql.append("             pMatName,\n");
            kSql.append("             cMatNumber,\n");
            kSql.append("             cMatName,\n");
            kSql.append("             costItemNumber,\n");
            kSql.append("             costItemName,\n");
            kSql.append(" \t          measureUnitName,\n");
            kSql.append(" \t          FModel,\n");
            kSql.append("             FStdPrice,\n");
            kSql.append("             FChildQty,\n");
            kSql.append("             FChildStdPrice,\n");
            kSql.append("             FChildAmount,\n");
            kSql.append("             FType,\n");
            kSql.append("             FIsLeaf)\n");
            kSql.append("      SELECT MIN(to_char(FSpreadPath)) AS FSpreadPath,\n");
            kSql.append("             pMatID,\n");
            kSql.append("             pMatNumber,\n");
            kSql.append("             pMatName,\n");
            kSql.append("             '\u4f5c\u4e1a\u6210\u672c' AS cMatNumber,\n");
            kSql.append(" \t          NULL AS measureUnitName,\n");
            kSql.append(" \t          NULL AS FModel,\n");
            kSql.append("             NULL AS cMatName,\n");
            kSql.append("             NULL AS costItemNumber,\n");
            kSql.append("             NULL AS costItemName,\n");
            kSql.append("             0 AS FStdPrice,\n");
            kSql.append("             0 AS FChildQty,\n");
            kSql.append("             0 AS FChildStdPrice,\n");
            kSql.append("             SUM(FChildAmount) AS FChildAmount,\n");
            kSql.append("             3 AS FType,\n");
            kSql.append("             0 AS FIsLeaf\n");
            kSql.append("        FROM " + TMP_NCM_OSCostDetailRpt + " \n");
            kSql.append("       WHERE FType = 0 \n");
            kSql.append("         AND pMatID = '" + materialId + "' \n");
            kSql.append("         GROUP BY pMatID,pMatNumber,pMatName \n");
            DbUtil.execute((Context)ctx, (String)kSql.toString());
            String curMaterilNumber = materialNumber;
            kSql.setLength(0);
            kSql.append(" select FSpreadPath, \n");
            kSql.append("        FChildQty \n");
            kSql.append("   from " + TMP_NCM_OSCostDetailRpt + " \n");
            kSql.append("  where '" + curMaterilNumber + "' || ','|| cMatNumber = FSpreadPath \n");
            rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
            while (rst.next()) {
                String spreadPath = rst.getString("FSpreadPath");
                BigDecimal parentQty = rst.getBigDecimal("FChildQty");
                this.processChildren(ctx, TMP_NCM_OSCostDetailRpt, spreadPath, parentQty);
            }
            kSql.setLength(0);
            kSql.append(" update " + TMP_NCM_OSCostDetailRpt + " childAct \n");
            kSql.append("    set FChildQty = (  \n");
            kSql.append("               \t  select childAct.FChildQty * parentMat.FChildQty \n");
            kSql.append("                       from " + TMP_NCM_OSCostDetailRpt + " parentMat \n");
            kSql.append("                      where parentMat.FType = 1 \n");
            kSql.append("                        and parentMat.FSpreadPath || ',zzz'|| childAct.cMatNumber || ',' || childAct.costItemNumber = childAct.FSpreadPath \n");
            kSql.append("                     )  \n");
            kSql.append("  where childAct.FType = 0 \n");
            kSql.append("    and exists (\n");
            kSql.append("                select 1 \n");
            kSql.append("                  from " + TMP_NCM_OSCostDetailRpt + " \n");
            kSql.append("                 where FType = 1 \n");
            kSql.append("                   and FSpreadPath || ',zzz'|| childAct.cMatNumber || ',' || childAct.costItemNumber = childAct.FSpreadPath \n");
            kSql.append("               )\n");
            DbUtil.execute((Context)ctx, (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" update " + TMP_NCM_OSCostDetailRpt + " \n");
            kSql.append("  set FChildAmount = FChildQty * FChildStdPrice \n");
            kSql.append("  where FType = 0 \n");
            DbUtil.execute((Context)ctx, (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" select  FSpreadPath,\n");
            kSql.append("         pMatID,\n");
            kSql.append("         pMatNumber,\n");
            kSql.append("         pMatName,\n");
            kSql.append("         cMatNumber,\n");
            kSql.append("         cMatName,\n");
            kSql.append("         costItemName,\n");
            kSql.append(" \t      measureUnitName,\n");
            kSql.append(" \t      FModel,\n");
            kSql.append("         FStdPrice,\n");
            kSql.append("         FChildQty,\n");
            kSql.append("         FChildStdPrice,\n");
            kSql.append("         FChildAmount,\n");
            kSql.append("         FType,\n");
            kSql.append("         FIsLeaf \n");
            kSql.append("    from " + TMP_NCM_OSCostDetailRpt + " \n");
            kSql.append(" order by FSpreadPath ASC,\n");
            kSql.append("          FType DESC\n");
            rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
            OSCostDetailEntrylInfo[] entrys = new OSCostDetailEntrylInfo[rst.size()];
            int pointer = 0;
            while (rst.next()) {
                OSCostDetailEntrylInfo entry = new OSCostDetailEntrylInfo();
                entry.setSpreadPath(rst.getString("FSpreadPath"));
                entry.setParentMaterialId(rst.getString("pMatID"));
                entry.setParentMaterialNumber(rst.getString("pMatNumber"));
                entry.setParentMaterialName(rst.getString("pMatName"));
                entry.setMaterialNumber(rst.getString("cMatNumber"));
                entry.setMaterialName(rst.getString("cMatName"));
                entry.setCostItemName(rst.getString("costItemName"));
                entry.setStdPrice(rst.getBigDecimal("FStdPrice"));
                entry.setChildQty(rst.getBigDecimal("FChildQty"));
                entry.setChildStdPrice(rst.getBigDecimal("FChildStdPrice"));
                entry.setChildAmount(rst.getBigDecimal("FChildAmount"));
                entry.setIsMat(rst.getInt("FType"));
                entry.setLeaf(rst.getInt("FIsLeaf") == 1);
                entry.setModel(rst.getString("FModel"));
                entry.setMeasureUnitName(rst.getString("measureUnitName"));
                entrys[pointer++] = entry;
            }
            detail.setEntry(entrys);
            if (TMP_NCM_OSCostDetailRpt == null) return detail;
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
                catch (Exception exc2) {
                    logger.error((Object)exc2.getMessage(), (Throwable)exc2);
                    throw new BOSException((Throwable)exc2);
                }
            }
            catch (Throwable throwable) {
                if (TMP_NCM_OSCostDetailRpt == null) throw throwable;
                TempTablePool.getInstance((Context)ctx).releaseTable(TMP_NCM_OSCostDetailRpt);
                throw throwable;
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(TMP_NCM_OSCostDetailRpt);
        return detail;
    }

    private void processChildren(Context ctx, String TMP_NCM_OSCostDetailRpt, String spreadPath, BigDecimal parentQty) throws BOSException {
        StringBuffer kSql = new StringBuffer();
        kSql.setLength(0);
        kSql.append(" update " + TMP_NCM_OSCostDetailRpt + " \n");
        kSql.append("    set FChildQty = FChildQty * " + parentQty + "\n");
        kSql.append("  where '" + spreadPath + "' || ','|| cMatNumber = FSpreadPath \n");
        kSql.append("    and FType = 1 \n");
        DbUtil.execute((Context)ctx, (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" update " + TMP_NCM_OSCostDetailRpt + " \n");
        kSql.append("  set FChildAmount = FChildQty * FChildStdPrice \n");
        kSql.append("  where '" + spreadPath + "' || ','|| cMatNumber = FSpreadPath \n");
        kSql.append("    and FType = 1 \n");
        DbUtil.execute((Context)ctx, (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" select FSpreadPath,\n");
        kSql.append("        FChildQty \n");
        kSql.append("   from " + TMP_NCM_OSCostDetailRpt + " \n");
        kSql.append("  where '" + spreadPath + "' || ','|| cMatNumber = FSpreadPath \n");
        kSql.append("    and FType = 1 \n");
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
        try {
            while (rst.next()) {
                String childPath = rst.getString("FSpreadPath");
                BigDecimal childQty = rst.getBigDecimal("FChildQty");
                this.processChildren(ctx, TMP_NCM_OSCostDetailRpt, childPath, childQty);
            }
        }
        catch (SQLException exc) {
            logger.error((Object)exc.getMessage(), (Throwable)exc);
            throw new BOSException((Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _generateAdjustReqBill(Context ctx, String costTypeId) throws BOSException, EASBizException {
        Connection conn;
        IRowSet rst;
        String TEMP_NCM_MatCostData;
        ArrayList bills;
        block55: {
            StringBuffer kSql;
            String T_NCM_OSActivityDetail;
            int periodNumber;
            int periodYear;
            CostTypeInfo costType;
            String costTypeName;
            CompanyOrgUnitInfo company;
            String companyId;
            block53: {
                ArrayList arrayList;
                block54: {
                    String T_NCM_OSMaterialDetail;
                    block51: {
                        ArrayList arrayList2;
                        block52: {
                            block49: {
                                ArrayList arrayList3;
                                block50: {
                                    bills = new ArrayList();
                                    if (StringUtils.isEmpty((String)costTypeId)) {
                                        return bills;
                                    }
                                    companyId = null;
                                    company = null;
                                    costTypeName = null;
                                    costType = new CostTypeInfo();
                                    costType.setId(BOSUuid.read((String)costTypeId));
                                    periodYear = -1;
                                    periodNumber = -1;
                                    T_NCM_OSMaterialDetail = null;
                                    T_NCM_OSActivityDetail = null;
                                    TEMP_NCM_MatCostData = null;
                                    kSql = new StringBuffer();
                                    rst = null;
                                    conn = null;
                                    kSql.setLength(0);
                                    kSql.append("SELECT FCompanyID,FName_" + ctx.getLocale() + " AS FName FROM T_NCM_CostType WHERE FID = ?");
                                    rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{costTypeId});
                                    if (rst.next()) {
                                        companyId = rst.getString("FCompanyID");
                                        costTypeName = rst.getString("FName");
                                        company = new CompanyOrgUnitInfo();
                                        company.setId(BOSUuid.read((String)companyId));
                                        SQLUtils.cleanup((ResultSet)rst);
                                        break block49;
                                    }
                                    arrayList3 = bills;
                                    if (TEMP_NCM_MatCostData == null) break block50;
                                    try {
                                        TempTablePool.getInstance((Context)ctx).releaseTable(TEMP_NCM_MatCostData);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    SQLUtils.cleanup(conn);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                try {
                                    SQLUtils.cleanup((ResultSet)rst);
                                    return arrayList3;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return arrayList3;
                            }
                            kSql.setLength(0);
                            kSql.append(" SELECT period.FBeginDate    AS beginDate, \n");
                            kSql.append("        period.FPeriodYear   AS FPeriodYear, \n");
                            kSql.append("        period.FPeriodNumber AS FPeriodNumber \n");
                            kSql.append(" FROM   T_BD_SystemStatusCtrol sysCtrl \n");
                            kSql.append("        LEFT OUTER JOIN T_BD_SystemStatus stsSta \n");
                            kSql.append("          ON sysCtrl.FSystemStatusID = stsSta.FID \n");
                            kSql.append("        LEFT OUTER JOIN T_BD_Period period \n");
                            kSql.append("          ON sysCtrl.FCurrentPeriodID = period.FID \n");
                            kSql.append(" WHERE  sysCtrl.FCompanyID = ? \n");
                            kSql.append("        AND stsSta.FName = 2 \n");
                            rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{companyId});
                            if (rst.next()) {
                                periodYear = rst.getInt("FPeriodYear");
                                periodNumber = rst.getInt("FPeriodNumber");
                                break block51;
                            }
                            arrayList2 = bills;
                            if (TEMP_NCM_MatCostData == null) break block52;
                            try {
                                TempTablePool.getInstance((Context)ctx).releaseTable(TEMP_NCM_MatCostData);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        try {
                            SQLUtils.cleanup(conn);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            SQLUtils.cleanup((ResultSet)rst);
                            return arrayList2;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return arrayList2;
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    kSql.setLength(0);
                    kSql.append(" Create Table TEMP_NCM_MatCostData (  \n");
                    kSql.append(" \t  FID              VARCHAR(44) NOT NULL, \n");
                    kSql.append("     FCompanyID       VARCHAR(44), \n");
                    kSql.append("     FCostTypeID      VARCHAR(44), \n");
                    kSql.append("     FMaterialID      VARCHAR(44), \n");
                    kSql.append("     FUnitID          VARCHAR(44), \n");
                    kSql.append("     FNewUnitStdPrice NUMERIC(28,10), \n");
                    kSql.append("     FOldUnitStdPrice NUMERIC(28,10) \n");
                    kSql.append("  ) \n");
                    TEMP_NCM_MatCostData = TempTablePool.getInstance((Context)ctx).createTempTable(kSql.toString());
                    TempTablePool.getInstance((Context)ctx).createIndex(TEMP_NCM_MatCostData, "FID", false, false);
                    TempTablePool.getInstance((Context)ctx).createIndex(TEMP_NCM_MatCostData, "FCostTypeID,FMaterialID", false, false);
                    kSql.setLength(0);
                    kSql.append(" DELETE FROM " + TEMP_NCM_MatCostData);
                    DbUtil.execute((Context)ctx, (String)kSql.toString());
                    T_NCM_OSMaterialDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OSMaterialDetail");
                    T_NCM_OSActivityDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OSActivityDetail");
                    kSql.setLength(0);
                    kSql.append(" INSERT INTO " + TEMP_NCM_MatCostData + " \n");
                    kSql.append("            (FID, \n");
                    kSql.append("             FCompanyID, \n");
                    kSql.append("             FCostTypeID, \n");
                    kSql.append("             FMaterialID, \n");
                    kSql.append("             FUnitID, \n");
                    kSql.append("             FNewUnitStdPrice, \n");
                    kSql.append("             FOldUnitStdPrice) \n");
                    kSql.append(" SELECT NEWBOSID('6F0F3353') AS FID, \n");
                    kSql.append("        '" + companyId + "' AS FCompanyID, \n");
                    kSql.append("        '" + costTypeId + "' AS FCostTypeID, \n");
                    kSql.append("        costData.FParentMaterialID AS FMaterialID, \n");
                    kSql.append("        costData.FMeasureUnitID AS FUnitID, \n");
                    kSql.append("        costData.FStdPrice AS FNewUnitStdPrice, \n");
                    kSql.append("        ISNULL(matCompany.FStandardCost,0) AS FOldUnitStdPrice \n");
                    kSql.append(" FROM  (SELECT DISTINCT FParentMaterialID,\n");
                    kSql.append("                        FStdPrice, \n");
                    kSql.append("                        FMeasureUnitID \n");
                    kSql.append("          FROM " + T_NCM_OSMaterialDetail + " \n");
                    kSql.append("              LEFT OUTER JOIN T_BD_Material pMat \n");
                    kSql.append("                ON FParentMaterialID = pMat.FID \n");
                    kSql.append("         WHERE FCostTypeID = ? \n");
                    kSql.append("           AND CHARINDEX(pMat.FNumber ||',', FSpreadPath) = 1\n");
                    kSql.append("           AND FStdPrice IS NOT NULL  \n");
                    kSql.append("        ) costData \n");
                    kSql.append("        INNER JOIN T_BD_Material mat \n");
                    kSql.append("          ON costData.FParentMaterialID = mat.FID \n");
                    kSql.append("        INNER JOIN T_BD_MaterialCompanyInfo matCompany \n");
                    kSql.append("          ON matCompany.FMaterialID = mat.FID \n");
                    kSql.append("             AND matCompany.FCompanyID = ? \n");
                    DbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{costTypeId, companyId});
                    kSql.setLength(0);
                    kSql.append(" INSERT INTO " + TEMP_NCM_MatCostData + " \n");
                    kSql.append("            (FID, \n");
                    kSql.append("             FCompanyID, \n");
                    kSql.append("             FCostTypeID, \n");
                    kSql.append("             FMaterialID, \n");
                    kSql.append("             FUnitID, \n");
                    kSql.append("             FNewUnitStdPrice, \n");
                    kSql.append("             FOldUnitStdPrice) \n");
                    kSql.append(" SELECT NEWBOSID('6F0F3353') AS FID, \n");
                    kSql.append("        '" + companyId + "' AS FCompanyID, \n");
                    kSql.append("        '" + costTypeId + "' AS FCostTypeID, \n");
                    kSql.append("        costData.FMaterialID AS FMaterialID, \n");
                    kSql.append("        mat.FBaseUnit AS FUnitID, \n");
                    kSql.append("        costData.FStdPrice AS FNewUnitStdPrice, \n");
                    kSql.append("        ISNULL(matCompany.FStandardCost,0) AS FOldUnitStdPrice \n");
                    kSql.append(" FROM  (SELECT DISTINCT FMaterialID,\n");
                    kSql.append("                        FStdPrice \n");
                    kSql.append("          FROM T_NCM_STDPriceMaterial \n");
                    kSql.append("         WHERE FCostTypeID = ? \n");
                    kSql.append("           AND FStdPrice IS NOT NULL  \n");
                    kSql.append("           AND FMaterialID NOT IN(  \n");
                    kSql.append("                                 SELECT  FMaterialID \n");
                    kSql.append("                                   FROM  " + TEMP_NCM_MatCostData + " \n");
                    kSql.append("                                  )  \n");
                    kSql.append("        ) costData \n");
                    kSql.append("        INNER JOIN T_BD_Material mat \n");
                    kSql.append("          ON costData.FMaterialID = mat.FID \n");
                    kSql.append("        INNER JOIN T_BD_MaterialCompanyInfo matCompany \n");
                    kSql.append("          ON matCompany.FMaterialID = mat.FID \n");
                    kSql.append("             AND matCompany.FCompanyID = ? \n");
                    DbUtil.execute((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{costTypeId, companyId});
                    kSql.setLength(0);
                    kSql.append(" SELECT COUNT(FID) AS fidCount FROM " + TEMP_NCM_MatCostData);
                    rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
                    if (rst.next() && rst.getInt("fidCount") > 0) break block53;
                    arrayList = bills;
                    if (TEMP_NCM_MatCostData == null) break block54;
                    try {
                        TempTablePool.getInstance((Context)ctx).releaseTable(TEMP_NCM_MatCostData);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    SQLUtils.cleanup(conn);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    SQLUtils.cleanup((ResultSet)rst);
                    return arrayList;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return arrayList;
            }
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, TEMP_NCM_MatCostData);
            String std001Id2333332 = OrderCMUtils.getSTD_001Pk(ctx, companyId, false);
            kSql.setLength(0);
            kSql.append(" SELECT adjBill.FMaterialID AS FMaterialID, \n");
            kSql.append("        NULL AS FActivityID, \n");
            kSql.append("        adjBill.FUnitID AS FUnitID, \n");
            kSql.append("        adjBill.FNewUnitStdPrice AS FNewUnitStdPrice, \n");
            kSql.append("        adjBill.FOldUnitStdPrice AS FOldUnitStdPrice, \n");
            kSql.append("        ISNULL(invBal.FBaseQty,0) AS FBaseQty, \n");
            kSql.append("        (ISNULL(invBal.FBaseQty,0) * ISNULL(adjBill.FNewUnitStdPrice,0)) AS FNewStandardAmount, \n");
            kSql.append("        (ISNULL(invBal.FBaseQty,0) * ISNULL(adjBill.FOldUnitStdPrice,0)) AS FOldStandardAmount, \n");
            kSql.append("        (ISNULL(adjBill.FNewUnitStdPrice,0)- ISNULL(adjBill.FOldUnitStdPrice,0)) AS FDiffPrice, \n");
            kSql.append("        ((ISNULL(invBal.FBaseQty,0)* ISNULL(adjBill.FNewUnitStdPrice,0)) \n");
            kSql.append("           - \n");
            kSql.append("          (ISNULL(invBal.FBaseQty,0)* ISNULL(adjBill.FOldUnitStdPrice,0)) \n");
            kSql.append("         ) AS FDiffAmount, \n");
            kSql.append("         1 AS FType \n");
            kSql.append(" FROM   " + TEMP_NCM_MatCostData + " adjBill \n");
            kSql.append("        LEFT OUTER JOIN (SELECT   FMaterialID, \n");
            kSql.append("                                  ISNULL(SUM(FPeriodBeginQty),0) AS FBaseQty \n");
            kSql.append("                         FROM     T_IM_InventoryBalance \n");
            kSql.append("                         WHERE    FCompanyOrgUnitID = ? \n");
            kSql.append("                                  AND FIsCalculate = 1 \n");
            kSql.append("                                  AND FPeriod = ? \n");
            kSql.append("                                  AND FYear = ? \n");
            kSql.append("                         GROUP BY FMaterialID,FStorageOrgUnitID) invBal \n");
            kSql.append("          ON adjBill.FMaterialID = invBal.FMaterialID \n");
            kSql.append("        INNER JOIN T_BD_MaterialCompanyInfo matCompany \n");
            kSql.append("          ON matCompany.FMaterialID = adjBill.FMaterialID \n");
            kSql.append("            AND matCompany.FCompanyID = ? \n");
            kSql.append(" UNION\u3000ALL \n");
            kSql.append(" SELECT NULL AS FMaterialID, \n");
            kSql.append("        actStdPrice.FActivityID AS FActivityID, \n");
            kSql.append("        act.FBaseUnitID AS FUnitID, \n");
            kSql.append("        ISNULL(SUM(actStdPrice.FStdPrice),0) AS FNewUnitStdPrice, \n");
            kSql.append("        ISNULL(SUM(actDetail.FActStdPrice),0) AS FOldUnitStdPrice, \n");
            kSql.append("        0 AS FBaseQty, \n");
            kSql.append("        0 AS FNewStandardAmount, \n");
            kSql.append("        0 AS FOldStandardAmount, \n");
            kSql.append("        (ISNULL(SUM(actStdPrice.FStdPrice),0)- ISNULL(SUM(actDetail.FActStdPrice),0)) AS FDiffPrice, \n");
            kSql.append("        0 AS FDiffAmount, \n");
            kSql.append("        0 AS FType \n");
            kSql.append("  FROM  T_NCM_OSActivityStdPrice actStdPrice \n");
            kSql.append("        INNER JOIN T_NCM_Activity act \n");
            kSql.append("          ON actStdPrice.FActivityID = act.FID \n");
            kSql.append("        LEFT OUTER JOIN  \n");
            kSql.append("       \t(SELECT DISTINCT FActivityID,\n");
            kSql.append("                    \t     FActCostItemID,\n");
            kSql.append("                    \t     FActStdPrice \n");
            kSql.append("          \t  FROM " + T_NCM_OSActivityDetail + " \n");
            kSql.append("        \t WHERE FCostTypeID = ? \n");
            kSql.append("         \t   AND FActStdPrice IS NOT NULL  \n");
            kSql.append("        \t ) actDetail \n");
            kSql.append("          ON actStdPrice.FActivityID = actDetail.FActivityID \n");
            kSql.append("            AND actStdPrice.FCostItemID = actDetail.FActCostItemID \n");
            kSql.append(" WHERE  actStdPrice.FCostTypeID = ? \n");
            kSql.append(" GROUP BY actStdPrice.FActivityID,act.FBaseUnitID \n");
            rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString(), (Object[])new Object[]{companyId, new Integer(periodNumber), new Integer(periodYear), companyId, std001Id2333332, costTypeId});
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            boolean isExistNumberRule = codingRuleManager.isExist((IObjectValue)new OSCostAdjustReqBillInfo(), companyId);
            IOSCostAdjustReqBill iAdjBill = OSCostAdjustReqBillFactory.getLocalInstance(ctx);
            OSCostAdjustReqBillEntryCollection entryCol = new OSCostAdjustReqBillEntryCollection();
            while (rst.next()) {
                OSCostAdjustReqBillEntryInfo entryInfo = new OSCostAdjustReqBillEntryInfo();
                int type = rst.getInt("FType");
                entryInfo.setType(type);
                if (type == 1) {
                    MaterialInfo matrial = new MaterialInfo();
                    matrial.setId(BOSUuid.read((String)rst.getString("FMaterialID")));
                    entryInfo.setMaterial(matrial);
                    entryInfo.setActivity(null);
                    entryInfo.setStorageType(StorageTypeEnum.BOP);
                } else {
                    ActivityInfo activity = new ActivityInfo();
                    activity.setId(BOSUuid.read((String)rst.getString("FActivityID")));
                    entryInfo.setMaterial(null);
                    entryInfo.setActivity(activity);
                    entryInfo.setStorageType(null);
                }
                String muid = rst.getString("FUnitID");
                if (muid != null) {
                    MeasureUnitInfo mu = new MeasureUnitInfo();
                    mu.setId(BOSUuid.read((String)muid));
                    entryInfo.setUnit(mu);
                }
                entryInfo.setBaseQty(rst.getBigDecimal("FBaseQty"));
                entryInfo.setNewStandardPrice(rst.getBigDecimal("FNewUnitStdPrice"));
                entryInfo.setOldStandardPrice(rst.getBigDecimal("FOldUnitStdPrice"));
                entryInfo.setNewStandardAmount(rst.getBigDecimal("FNewStandardAmount"));
                entryInfo.setOldStandardAmount(rst.getBigDecimal("FOldStandardAmount"));
                entryInfo.setDiffPrice(rst.getBigDecimal("FDiffPrice"));
                entryInfo.setDiffAmount(rst.getBigDecimal("FDiffAmount"));
                entryInfo.setRemark(costTypeName);
                entryCol.add(entryInfo);
            }
            OSCostAdjustReqBillInfo adjBillInfo = new OSCostAdjustReqBillInfo();
            adjBillInfo.setBizDate(new Date());
            company.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            adjBillInfo.setCompanyOrg(company);
            adjBillInfo.setCostType(costType);
            adjBillInfo.setBillStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            adjBillInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            String number = null;
            if (isExistNumberRule) {
                number = codingRuleManager.getNumber((IObjectValue)adjBillInfo, companyId);
                if (StringUtils.isEmpty((String)number)) {
                    number = "OSCostAdj-" + SysUtil.getAppServerTime((Context)ctx).getTime();
                }
            } else {
                number = "OSCostAdj-" + SysUtil.getAppServerTime((Context)ctx).getTime();
            }
            adjBillInfo.setNumber(number);
            adjBillInfo.getEntry().addCollection(entryCol);
            IObjectPK pk = iAdjBill.addnew(adjBillInfo);
            HashMap<String, String> id2number = new HashMap<String, String>();
            id2number.put(pk.toString(), number);
            bills.add(id2number);
            if (TEMP_NCM_MatCostData == null) break block55;
            try {
                TempTablePool.getInstance((Context)ctx).releaseTable(TEMP_NCM_MatCostData);
            }
            catch (Exception std001Id2333332) {
                // empty catch block
            }
        }
        try {
            SQLUtils.cleanup((Connection)conn);
        }
        catch (Exception std001Id2333332) {
            // empty catch block
        }
        try {
            SQLUtils.cleanup((ResultSet)rst);
            return bills;
        }
        catch (Exception std001Id2333332) {
            return bills;
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
                catch (Exception exc2) {
                    logger.error((Object)exc2.getMessage(), (Throwable)exc2);
                    throw new BOSException((Throwable)exc2);
                }
            }
            catch (Throwable throwable) {
                if (TEMP_NCM_MatCostData != null) {
                    try {
                        TempTablePool.getInstance((Context)ctx).releaseTable(TEMP_NCM_MatCostData);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    SQLUtils.cleanup(conn);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }
}

