/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.cal.app.checker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.order.std.cal.CheckStatusEnum;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckParam;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultDetailCollection;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultDetailInfo;
import com.kingdee.eas.ncm.order.std.cal.OSCostCheckResultInfo;
import com.kingdee.eas.ncm.order.std.cal.app.IOSCostChecker;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class OSBomNestedChecker
implements IOSCostChecker {
    private static Logger logger = Logger.getLogger((String)OSBomNestedChecker.class.getName());

    @Override
    public OSCostCheckResultInfo calChecker(Context ctx, OSCostCheckParam checkParam, OSCostCheckResultInfo costCheckResultInfo) throws BOSException, EASBizException {
        Assert.that((checkParam != null ? 1 : 0) != 0);
        Assert.that((checkParam.getCostType() != null ? 1 : 0) != 0);
        Assert.that((checkParam.getCompanyId() != null ? 1 : 0) != 0);
        Assert.that((costCheckResultInfo != null ? 1 : 0) != 0);
        String companyId = checkParam.getCompanyId();
        costCheckResultInfo.setCheckStatus(CheckStatusEnum.succeed);
        costCheckResultInfo.getDetail().addCollection(new OSCostCheckResultDetailCollection());
        StringBuffer kSql = new StringBuffer();
        IRowSet rst = null;
        try {
            String T_NCM_OSBomPath = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)companyId, (String)"T_NCM_OSBomPath");
            kSql.setLength(0);
            kSql.append(" SELECT DISTINCT bom.FNumber AS FBomNumber, \n");
            kSql.append("                 bom.FName_" + ctx.getLocale() + " AS FBomName, \n");
            kSql.append("                 mat.FNumber AS FMatNumber, \n");
            kSql.append("                 mat.FName_" + ctx.getLocale() + " AS FMatName, \n");
            kSql.append("                 bomPath.FBomPath as FBomPath \n");
            kSql.append(" FROM   " + T_NCM_OSBomPath + " bomPath  \n");
            kSql.append("        INNER JOIN T_MM_Bom bom  \n");
            kSql.append("          ON bom.Fid = bomPath.FBomID  \n");
            kSql.append("        INNER JOIN T_BD_Material mat  \n");
            kSql.append("          ON mat.Fid = bomPath.FParentMaterialID  \n");
            kSql.append(" WHERE  bomPath.FIsNest = 1  \n");
            rst = DbUtil.executeQuery((Context)ctx, (String)kSql.toString());
            while (rst.next()) {
                String materialNumber = rst.getString("FMatNumber");
                String materialName = rst.getString("FMatName");
                String bomPatch = rst.getString("FBomPath");
                String costObjectName = materialNumber + " " + materialName;
                String description = "\u3010" + costObjectName + "\u3011\u548c\u3010" + costObjectName + "\u3011\u5d4c\u5957,\u5d4c\u5957\u8def\u5f84\u4e3a\uff1a\u3010" + bomPatch + "\u3011";
                String reason = "BOM\u8bbe\u7f6e\u9519\u8bef";
                String suggestOperation = "\u8bf7\u5728\u3010\u529f\u80fd\u83dc\u5355-\u751f\u4ea7\u5236\u9020-\u751f\u4ea7\u6570\u636e\u7ba1\u7406-\u4ea7\u54c1\u6570\u636e\u3011\u91cc\u68c0\u67e5\u5e76\u8bbe\u7f6eBOM";
                OSCostCheckResultDetailInfo detail = new OSCostCheckResultDetailInfo();
                detail.setDescription(description);
                detail.setReason(reason);
                detail.setSuggestOperation(suggestOperation);
                costCheckResultInfo.setCheckStatus(CheckStatusEnum.lost);
                costCheckResultInfo.getDetail().add(detail);
            }
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return costCheckResultInfo;
    }
}

