/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.cal.task.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.order.std.cal.OSCostCalcParam;
import com.kingdee.eas.ncm.order.std.cal.OSCostCalcResult;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class MatBOMRollUpCalculator {
    private static Logger logger = Logger.getLogger((String)MatBOMRollUpCalculator.class.getName());
    Context ctx = null;
    OSCostCalcParam calcParam = null;
    OSCostCalcResult calcResult = null;
    String T_NCM_OSBomPath = null;
    String T_NCM_OSMaterialRollUp = null;
    String T_NCM_OSActivityRollUp = null;
    SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    Date today = null;

    private MatBOMRollUpCalculator() {
    }

    public MatBOMRollUpCalculator(Context ctx, OSCostCalcParam calcParam, OSCostCalcResult calcResult) throws Exception {
        this();
        Assert.that((calcParam != null ? 1 : 0) != 0);
        Assert.that((calcParam.getCompanyId() != null ? 1 : 0) != 0);
        Assert.that((calcParam.getCostType() != null ? 1 : 0) != 0);
        Assert.that((calcResult != null ? 1 : 0) != 0);
        Assert.that((ctx != null ? 1 : 0) != 0);
        this.ctx = ctx;
        this.calcParam = calcParam;
        this.calcResult = calcResult;
        this.T_NCM_OSBomPath = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)calcParam.getCompanyId(), (String)"T_NCM_OSBomPath");
        this.T_NCM_OSMaterialRollUp = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)calcParam.getCompanyId(), (String)"T_NCM_OSMaterialRollUp");
        this.T_NCM_OSActivityRollUp = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)ctx, (String)calcParam.getCompanyId(), (String)"T_NCM_OSActivityRollUp");
        this.today = new Date();
    }

    public OSCostCalcResult rollUp(int rank) throws BOSException, EASBizException {
        boolean isIncludeYieldRatio = this.calcParam.getCostType().isIsIncludeYieldRatio();
        boolean isIncludeScrapRatio = this.calcParam.getCostType().isIsIncludeScrapRatio();
        StringBuffer kSql = new StringBuffer();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            kSql.setLength(0);
            kSql.append(" UPDATE " + this.T_NCM_OSMaterialRollUp + "\n");
            kSql.append(" SET    FChildQty = \n");
            kSql.append(" \t\t\t(SELECT CASE  \n");
            kSql.append("          \t\t\tWHEN bomEntry.FOutputType = 10740 OR bomEntry.FOutputType = 0 \n");
            kSql.append("          \t\t\t\tTHEN (CASE  \n");
            kSql.append("                     \t\t\tWHEN bomEntry.FConsumeType = 20  \n");
            kSql.append(" \t\t\t\t\t\t\t\t\tTHEN (CASE WHEN matPlan.FScrapRateExpression= 10620 \n");
            kSql.append("         \t\t\t\t\t\t\t\t \tTHEN \n");
            kSql.append("         \t\t\t    \t\t\t\t\t\t(ISNULL(bomEntry.FConsumeFixBaseQty,0)/ISNULL(bom.FProductBaseQty,1)) \n");
            kSql.append("         \t\t\t    \t\t\t\t\t\t* \n");
            if (isIncludeScrapRatio) {
                kSql.append("         \t\t\t\t\t\t\t\t\t(1+(ISNULL(bomEntry.FScrapRatio,0)/100)) \n");
            } else {
                kSql.append("         \t\t\t\t\t\t\t\t\t1 \n");
            }
            kSql.append("         \t\t\t\t\t\t\t\t\t    / \n");
            if (isIncludeYieldRatio) {
                kSql.append("         \t\t\t\t\t\t\t \t\t(ISNULL(bom.FYield,100)/100) \n");
            } else {
                kSql.append("         \t\t\t\t\t\t\t\t\t1 \n");
            }
            kSql.append("      \t\t\t\t\t\t\t\t       ELSE  ");
            kSql.append("         \t\t\t    \t\t\t\t\t\t(ISNULL(bomEntry.FConsumeFixBaseQty,0)/ISNULL(bom.FProductBaseQty,1)) \n");
            kSql.append("         \t\t\t    \t\t\t\t\t\t/ \n");
            if (isIncludeScrapRatio) {
                kSql.append("         \t\t\t\t\t\t\t\t\t(1-(ISNULL(bomEntry.FScrapRatio,0)/100)) ");
            } else {
                kSql.append("         \t\t\t\t\t\t\t\t\t1 \n");
            }
            kSql.append("         \t\t\t\t\t\t\t\t\t    / \n");
            if (isIncludeYieldRatio) {
                kSql.append("         \t\t\t\t\t\t\t\t\t(ISNULL(bom.FYield,100)/100) \n");
            } else {
                kSql.append("         \t\t\t\t\t\t\t\t\t1 \n");
            }
            kSql.append(" \t\t\t\t\t\t\t\t\t    END) \n");
            kSql.append("                     \t\t\tWHEN bomEntry.FConsumeType = 30  \n");
            kSql.append(" \t\t\t\t\t\t\t\t\tTHEN (CASE WHEN matPlan.FScrapRateExpression= 10620 \n");
            kSql.append("         \t\t\t\t\t\t\t\t \tTHEN \n");
            kSql.append("         \t\t\t    \t\t\t\t\t\t(ISNULL(bomEntry.FBaseProportion,0)/100)/ISNULL(bom.FProductBaseQty,1) \n");
            kSql.append("         \t\t\t    \t\t\t\t\t\t* \n");
            if (isIncludeScrapRatio) {
                kSql.append("         \t\t\t\t\t\t\t\t\t(1+(ISNULL(bomEntry.FScrapRatio,0)/100)) \n");
            } else {
                kSql.append("         \t\t\t\t\t\t\t\t\t1 \n");
            }
            kSql.append("         \t\t\t\t\t\t\t\t\t    / \n");
            if (isIncludeYieldRatio) {
                kSql.append("         \t\t\t\t\t\t\t \t\t(ISNULL(bom.FYield,100)/100) \n");
            } else {
                kSql.append("         \t\t\t\t\t\t\t\t\t1 \n");
            }
            kSql.append("      \t\t\t\t\t\t\t\t     ELSE  ");
            kSql.append("         \t\t\t    \t\t\t\t\t\t(ISNULL(bomEntry.FBaseProportion,0)/100)/ISNULL(bom.FProductBaseQty,1) \n");
            kSql.append("         \t\t\t    \t\t\t\t\t\t/ \n");
            if (isIncludeScrapRatio) {
                kSql.append("         \t\t\t\t\t\t\t\t\t(1-(ISNULL(bomEntry.FScrapRatio,0)/100)) ");
            } else {
                kSql.append("         \t\t\t\t\t\t\t\t\t1 \n");
            }
            kSql.append("         \t\t\t\t\t\t\t\t\t    / \n");
            if (isIncludeYieldRatio) {
                kSql.append("         \t\t\t\t\t\t\t\t\t(ISNULL(bom.FYield,100)/100) \n");
            } else {
                kSql.append("         \t\t\t\t\t\t\t\t\t1 \n");
            }
            kSql.append(" \t\t\t\t\t\t\t\t\tEND) \n");
            kSql.append("                     \t\t\tELSE 0 \n");
            kSql.append("                      END) \n");
            kSql.append("          \t\t\tELSE 0 \n");
            kSql.append("        \t\t\tEND AS FQty \n");
            kSql.append("            FROM   " + this.T_NCM_OSMaterialRollUp + " rollMat \n");
            kSql.append("                   INNER JOIN " + this.T_NCM_OSBomPath + " bomPath \n");
            kSql.append("                     ON rollMat.FParentMaterialID = bomPath.FParentMaterialID \n");
            kSql.append("                        AND rollMat.FMaterialID = bomPath.FMaterialID \n");
            kSql.append(" \t\t \t\t\t     AND rollMat.FSpreadPath = bomPath.FBomPath \n");
            kSql.append("                        AND  ISNULL(rollMat.FOrderID,' ') = ISNULL(bomPath.FOrderID,' ') \n");
            kSql.append("                        AND  ISNULL(rollMat.FProjectID,' ') = ISNULL(bomPath.FProjectID,' ') \n");
            kSql.append("                        AND  ISNULL(rollMat.FTrackID,' ') = ISNULL(bomPath.FTrackID,' ') \n");
            kSql.append("                   INNER JOIN T_MM_Bom bom \n");
            kSql.append("                     ON bom.FID = bomPath.FBomID \n");
            kSql.append("                   INNER JOIN T_MM_BOMEntry bomEntry \n");
            kSql.append("                     ON bomPath.FBomEntryID = bomEntry.FID \n");
            kSql.append("\t\t\t\t\tINNER JOIN T_BD_Material childMat \n");
            kSql.append("  \t\t\t\t\t  ON rollMat.FMaterialID = childMat.FID \n");
            kSql.append("                   LEFT OUTER JOIN T_BD_MaterialPlan matPlan \n");
            kSql.append("                     ON matPlan.FMaterialID = childMat.FID \n");
            kSql.append("                        AND matPlan.FOrgUnit = bom.FStorageOrgUnitID \n");
            kSql.append("            WHERE  FLowLevelCode = ? \n");
            kSql.append("                   AND rollMat.fid = " + this.T_NCM_OSMaterialRollUp + ".fid \n");
            kSql.append("           ) \n");
            kSql.append(" WHERE  FLowLevelCode = ? \n");
            ps = conn.prepareStatement(kSql.toString());
            ps.setInt(1, rank);
            ps.setInt(2, rank);
            ps.executeUpdate();
            kSql.setLength(0);
            kSql.append(" UPDATE " + this.T_NCM_OSMaterialRollUp + " \n");
            kSql.append(" SET    FChildQty = (SELECT CASE  \n");
            kSql.append("                              WHEN bomEntry.FEffectiveDate IS NOT NULL  \n");
            kSql.append("                                   AND bomEntry.FDisableDate IS NOT NULL \n");
            kSql.append("                                   AND (TO_DATE('" + this.dateFormate.format(this.today) + "') > bomEntry.FDisableDate \n");
            kSql.append("                                         OR TO_DATE('" + this.dateFormate.format(this.today) + "') < bomEntry.FEffectiveDate \n");
            kSql.append("                                        ) \n");
            kSql.append("                                 THEN 0 \n");
            kSql.append("                              ELSE rollMat.FChildQty \n");
            kSql.append("                            END AS FChildQty \n");
            kSql.append("                     FROM   " + this.T_NCM_OSMaterialRollUp + " rollMat \n");
            kSql.append("                            INNER JOIN " + this.T_NCM_OSBomPath + " bomPath \n");
            kSql.append("                              ON rollMat.FParentMaterialID = bomPath.FParentMaterialID \n");
            kSql.append("                                 AND rollMat.FMaterialID = bomPath.FMaterialID \n");
            kSql.append(" \t\t \t\t\t              AND rollMat.FSpreadPath = bomPath.FBomPath \n");
            kSql.append("                                 AND  ISNULL(rollMat.FOrderID,' ') = ISNULL(bomPath.FOrderID,' ') \n");
            kSql.append("                                 AND  ISNULL(rollMat.FProjectID,' ') = ISNULL(bomPath.FProjectID,' ') \n");
            kSql.append("                                 AND  ISNULL(rollMat.FTrackID,' ') = ISNULL(bomPath.FTrackID,' ') \n");
            kSql.append("                            INNER JOIN T_MM_BOMEntry bomEntry \n");
            kSql.append("                              ON bomPath.FBomEntryID = bomEntry.FID \n");
            kSql.append("                     WHERE  rollMat.FLowLevelCode = ? \n");
            kSql.append("                            AND rollMat.fid = " + this.T_NCM_OSMaterialRollUp + ".fid \n");
            kSql.append("                     ) \n");
            kSql.append(" WHERE  FLowLevelCode = ? \n");
            SQLUtils.cleanup((Statement)ps);
            ps = conn.prepareStatement(kSql.toString());
            ps.setInt(1, rank);
            ps.setInt(2, rank);
            ps.executeUpdate();
            kSql.setLength(0);
            kSql.append(" UPDATE " + this.T_NCM_OSMaterialRollUp + " \n");
            kSql.append(" SET    FChildAmount = ISNULL(FChildQty,0) * ISNULL(FChildStdPrice,0) \n");
            kSql.append(" WHERE  FLowLevelCode = ? \n");
            SQLUtils.cleanup((Statement)ps);
            ps = conn.prepareStatement(kSql.toString());
            ps.setInt(1, rank);
            ps.executeUpdate();
            kSql.setLength(0);
            kSql.append(" UPDATE " + this.T_NCM_OSActivityRollUp + " \n");
            kSql.append(" SET    FStdPrice = (SELECT TO_DECIMAL(rollAct.FStdPrice,24,12) \n");
            kSql.append("                       FROM   (SELECT   FParentMaterialID, \n");
            kSql.append("                                        FStorageOrgUnitID, \n");
            kSql.append("                                        FOrderID, \n");
            kSql.append("                                        FProjectID, \n");
            kSql.append("                                        FTrackID, \n");
            kSql.append("                                        SUM(ISNULL(FActAmount,0)) AS FStdPrice \n");
            kSql.append("                               FROM     " + this.T_NCM_OSActivityRollUp + " \n");
            kSql.append("                               GROUP BY FParentMaterialID,FStorageOrgUnitID,FOrderID,FProjectID,FTrackID) rollAct \n");
            kSql.append("                       WHERE  rollAct.FParentMaterialID = " + this.T_NCM_OSActivityRollUp + ".FParentMaterialID \n");
            kSql.append("                         AND  rollAct.FStorageOrgUnitID = " + this.T_NCM_OSActivityRollUp + ".FStorageOrgUnitID \n");
            kSql.append("                         AND  ISNULL(rollAct.FOrderID,' ') = ISNULL(" + this.T_NCM_OSActivityRollUp + ".FOrderID,' ') \n");
            kSql.append("                         AND  ISNULL(rollAct.FProjectID,' ') = ISNULL(" + this.T_NCM_OSActivityRollUp + ".FProjectID,' ') \n");
            kSql.append("                         AND  ISNULL(rollAct.FTrackID,' ') = ISNULL(" + this.T_NCM_OSActivityRollUp + ".FTrackID,' ')) \n");
            kSql.append(" WHERE  FParentMaterialID in ( \n");
            kSql.append("                               SELECT FParentMaterialID \n");
            kSql.append("                                 FROM " + this.T_NCM_OSMaterialRollUp + " \n");
            kSql.append("                                WHERE FLowLevelCode = ? ) \n");
            SQLUtils.cleanup((Statement)ps);
            ps = conn.prepareStatement(kSql.toString());
            ps.setInt(1, rank);
            ps.executeUpdate();
            kSql.setLength(0);
            kSql.append(" UPDATE " + this.T_NCM_OSActivityRollUp + " \n");
            kSql.append(" SET FStdPrice = (SELECT ISNULL(" + this.T_NCM_OSActivityRollUp + ".FStdPrice,0) + ISNULL(rollMat.sumChildAmount,0) \n");
            kSql.append("                            FROM   (SELECT FParentMaterialID,FStorageOrgUnitID,FOrderID,FProjectID,FTrackID,\n");
            kSql.append("                                           SUM(ISNULL(FChildAmount,0)) AS sumChildAmount \n");
            kSql.append("                                    FROM   (SELECT  DISTINCT FParentMaterialID, \n");
            kSql.append("                                                             FStorageOrgUnitID, \n");
            kSql.append("                                                             FMaterialID, \n");
            kSql.append("                                                             FOrderID, \n");
            kSql.append("                                                             FProjectID, \n");
            kSql.append("                                                             FTrackID, \n");
            kSql.append("                                                             FChildAmount \n");
            kSql.append("                                              FROM " + this.T_NCM_OSMaterialRollUp + " \n");
            kSql.append("                                             WHERE FLowLevelCode = ?) rollMats\n");
            kSql.append("                                    GROUP BY rollMats.FParentMaterialID,rollMats.FStorageOrgUnitID,rollMats.FOrderID,rollMats.FProjectID,rollMats.FTrackID) rollMat \n");
            kSql.append("                       WHERE  rollMat.FParentMaterialID = " + this.T_NCM_OSActivityRollUp + ".FParentMaterialID \n");
            kSql.append("                         AND  rollMat.FStorageOrgUnitID = " + this.T_NCM_OSActivityRollUp + ".FStorageOrgUnitID \n");
            kSql.append("                         AND  ISNULL(rollMat.FOrderID,' ') = ISNULL(" + this.T_NCM_OSActivityRollUp + ".FOrderID,' ') \n");
            kSql.append("                         AND  ISNULL(rollMat.FProjectID,' ') = ISNULL(" + this.T_NCM_OSActivityRollUp + ".FProjectID,' ') \n");
            kSql.append("                         AND  ISNULL(rollMat.FTrackID,' ') = ISNULL(" + this.T_NCM_OSActivityRollUp + ".FTrackID,' ')) \n");
            kSql.append(" WHERE  EXISTS (SELECT 1 \n");
            kSql.append("                FROM   " + this.T_NCM_OSMaterialRollUp + " \n");
            kSql.append("                WHERE  FParentMaterialID = " + this.T_NCM_OSActivityRollUp + ".FParentMaterialID \n");
            kSql.append("                  AND  FStorageOrgUnitID = " + this.T_NCM_OSActivityRollUp + ".FStorageOrgUnitID \n");
            kSql.append("                  AND  ISNULL(FOrderID,' ') = ISNULL(" + this.T_NCM_OSActivityRollUp + ".FOrderID,' ') \n");
            kSql.append("                  AND  ISNULL(FProjectID,' ') = ISNULL(" + this.T_NCM_OSActivityRollUp + ".FProjectID,' ') \n");
            kSql.append("                  AND  ISNULL(FTrackID,' ') = ISNULL(" + this.T_NCM_OSActivityRollUp + ".FTrackID,' ') \n");
            kSql.append("                  AND  FLowLevelCode = ?) \n");
            kSql.append("         AND FParentMaterialID in ( \n");
            kSql.append("                                   SELECT FParentMaterialID \n");
            kSql.append("                                     FROM " + this.T_NCM_OSMaterialRollUp + " \n");
            kSql.append("                                    WHERE FLowLevelCode = ? ) \n");
            SQLUtils.cleanup((Statement)ps);
            ps = conn.prepareStatement(kSql.toString());
            ps.setInt(1, rank);
            ps.setInt(2, rank);
            ps.setInt(3, rank);
            ps.executeUpdate();
            kSql.setLength(0);
            kSql.append(" UPDATE " + this.T_NCM_OSMaterialRollUp + " \n");
            kSql.append(" SET    FStdPrice = (SELECT ISNULL(FStdPrice,0) \n");
            kSql.append("                     FROM   (SELECT DISTINCT FCostTypeID,\n");
            kSql.append("                                             FParentMaterialID,\n");
            kSql.append("                                             FStorageOrgUnitID, \n");
            kSql.append("                                             FOrderID, \n");
            kSql.append("                                             FProjectID, \n");
            kSql.append("                                             FTrackID, \n");
            kSql.append("                                             FStdPrice\n");
            kSql.append("                               FROM  " + this.T_NCM_OSActivityRollUp + ") rollAct \n");
            kSql.append("                     WHERE  rollAct.FCostTypeID = " + this.T_NCM_OSMaterialRollUp + ".FCostTypeID \n");
            kSql.append("                            AND rollAct.FParentMaterialID = " + this.T_NCM_OSMaterialRollUp + ".FParentMaterialID \n");
            kSql.append("                            AND rollAct.FStorageOrgUnitID = " + this.T_NCM_OSMaterialRollUp + ".FStorageOrgUnitID \n");
            kSql.append("                            AND ISNULL(rollAct.FOrderID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FOrderID,' ') \n");
            kSql.append("                            AND ISNULL(rollAct.FProjectID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FProjectID,' ') \n");
            kSql.append("                            AND ISNULL(rollAct.FTrackID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FTrackID,' ')) \n");
            kSql.append(" WHERE  FLowLevelCode = ? \n");
            kSql.append("        AND EXISTS (SELECT 1 \n");
            kSql.append("                    FROM   " + this.T_NCM_OSActivityRollUp + " \n");
            kSql.append("                   WHERE  FCostTypeID = " + this.T_NCM_OSMaterialRollUp + ".FCostTypeID \n");
            kSql.append("                     AND  FParentMaterialID = " + this.T_NCM_OSMaterialRollUp + ".FParentMaterialID \n");
            kSql.append("                     AND  FStorageOrgUnitID = " + this.T_NCM_OSMaterialRollUp + ".FStorageOrgUnitID \n");
            kSql.append("                     AND  ISNULL(FOrderID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FOrderID,' ') \n");
            kSql.append("                     AND  ISNULL(FProjectID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FProjectID,' ') \n");
            kSql.append("                     AND  ISNULL(FTrackID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FTrackID,' ')) \n");
            SQLUtils.cleanup((Statement)ps);
            ps = conn.prepareStatement(kSql.toString());
            ps.setInt(1, rank);
            ps.executeUpdate();
            kSql.setLength(0);
            kSql.append(" UPDATE " + this.T_NCM_OSMaterialRollUp + " \n");
            kSql.append(" SET    FStdPrice = (SELECT sumChildAmount \n");
            kSql.append("                     FROM   (SELECT   FParentMaterialID AS FParentMaterialID, \n");
            kSql.append("                                      FStorageOrgUnitID AS FStorageOrgUnitID, \n");
            kSql.append("                                      FOrderID AS FOrderID, \n");
            kSql.append("                                      FProjectID AS FProjectID, \n");
            kSql.append("                                      FTrackID AS FTrackID, \n");
            kSql.append("                                      SUM(ISNULL(FChildAmount,0)) AS sumChildAmount \n");
            kSql.append("                             FROM     (SELECT DISTINCT FParentMaterialID,\n");
            kSql.append("                                                       FStorageOrgUnitID, \n");
            kSql.append("                                                       FMaterialID, \n");
            kSql.append("                                             \t\t\tFOrderID, \n");
            kSql.append("                                             \t\t\tFProjectID, \n");
            kSql.append("                                             \t\t\tFTrackID, \n");
            kSql.append("                                                       FChildAmount \n");
            kSql.append("                                         FROM " + this.T_NCM_OSMaterialRollUp + " \n");
            kSql.append("                                        WHERE FLowLevelCode = ? ) rollMats \n");
            kSql.append("                             GROUP BY rollMats.FParentMaterialID,rollMats.FStorageOrgUnitID,rollMats.FOrderID,rollMats.FProjectID,rollMats.FTrackID) rollMat \n");
            kSql.append("                     WHERE  rollMat.FParentMaterialID = " + this.T_NCM_OSMaterialRollUp + ".FParentMaterialID \n");
            kSql.append("                       AND  rollMat.FStorageOrgUnitID = " + this.T_NCM_OSMaterialRollUp + ".FStorageOrgUnitID \n");
            kSql.append("                       AND  ISNULL(rollMat.FOrderID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FOrderID,' ') \n");
            kSql.append("                       AND  ISNULL(rollMat.FProjectID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FProjectID,' ') \n");
            kSql.append("                       AND  ISNULL(rollMat.FTrackID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FTrackID,' ')) \n");
            kSql.append(" WHERE  FLowLevelCode = ? \n");
            kSql.append("        AND NOT EXISTS (SELECT 1 \n");
            kSql.append("                    \t   FROM   " + this.T_NCM_OSActivityRollUp + " act \n");
            kSql.append("                    \t  WHERE act.FParentMaterialID = " + this.T_NCM_OSMaterialRollUp + ".FParentMaterialID \n");
            kSql.append("                           AND act.FStorageOrgUnitID = " + this.T_NCM_OSMaterialRollUp + ".FStorageOrgUnitID \n");
            kSql.append("                           AND ISNULL(act.FOrderID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FOrderID,' ') \n");
            kSql.append("                           AND ISNULL(act.FProjectID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FProjectID,' ') \n");
            kSql.append("                           AND ISNULL(act.FTrackID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FTrackID,' ')) \n");
            SQLUtils.cleanup((Statement)ps);
            ps = conn.prepareStatement(kSql.toString());
            ps.setInt(1, rank);
            ps.setInt(2, rank);
            ps.executeUpdate();
            kSql.setLength(0);
            kSql.append(" UPDATE " + this.T_NCM_OSMaterialRollUp + " \n");
            kSql.append(" SET    FChildStdPrice = (SELECT DISTINCT ISNULL(rollMat.FSTDPrice,0) \n");
            kSql.append("                          FROM   " + this.T_NCM_OSMaterialRollUp + " rollMat\n");
            kSql.append("                          WHERE  rollMat.FLowLevelCode = ? \n");
            kSql.append("                                 AND rollMat.FStorageOrgUnitID = " + this.T_NCM_OSMaterialRollUp + ".FStorageOrgUnitID \n");
            kSql.append("                                 AND rollMat.FParentMaterialID = " + this.T_NCM_OSMaterialRollUp + ".FMaterialID \n");
            kSql.append("                                 AND ISNULL(rollMat.FOrderID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FOrderID,' ') \n");
            kSql.append("                                 AND ISNULL(rollMat.FProjectID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FProjectID,' ') \n");
            kSql.append("                                 AND ISNULL(rollMat.FTrackID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FTrackID,' ')) \n");
            kSql.append(" WHERE  \n");
            kSql.append("        EXISTS (SELECT 1 \n");
            kSql.append("                  FROM   " + this.T_NCM_OSMaterialRollUp + " rollMat\n");
            kSql.append("                 WHERE  rollMat.FParentMaterialID = " + this.T_NCM_OSMaterialRollUp + ".FMaterialID \n");
            kSql.append("                        AND rollMat.FStorageOrgUnitID = " + this.T_NCM_OSMaterialRollUp + ".FStorageOrgUnitID \n");
            kSql.append("                        AND ISNULL(rollMat.FOrderID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FOrderID,' ') \n");
            kSql.append("                        AND ISNULL(rollMat.FProjectID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FProjectID,' ') \n");
            kSql.append("                        AND ISNULL(rollMat.FTrackID,' ') = ISNULL(" + this.T_NCM_OSMaterialRollUp + ".FTrackID,' ') \n");
            kSql.append("                        AND rollMat.FLowLevelCode = ?) \n");
            DbUtil.execute((Context)this.ctx, (String)kSql.toString(), (Object[])new Object[]{new Integer(rank), new Integer(rank)});
        }
        catch (Exception exc) {
            try {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return this.calcResult;
    }
}

