/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.mo.ManufactureOrderInfo;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeLevelEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Assert;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MaterialCostDiffReport
extends ReportServerBase {
    private static Logger logger = Logger.getLogger(MaterialCostDiffReport.class);

    protected IRowSet getReportData(String reportID, RptParams filter) throws BOSException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BOSException {
        CompanyOrgUnitInfo company = null;
        if (filter.getObject("company") instanceof CompanyOrgUnitInfo) {
            company = (CompanyOrgUnitInfo)filter.getObject("company");
        }
        CostTypeInfo costTypeInfo = null;
        if (filter.getObject("costType") instanceof CostTypeInfo && (costTypeInfo = (CostTypeInfo)filter.getObject("costType")).getLevel() == null) {
            try {
                costTypeInfo = CostTypeFactory.getLocalInstance(this.getContext()).getCostTypeInfo((IObjectPK)new ObjectUuidPK(costTypeInfo.getId().toString()));
            }
            catch (Exception exc) {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
        }
        Assert.that((company != null ? 1 : 0) != 0);
        Assert.that((costTypeInfo != null ? 1 : 0) != 0);
        String companyId = String.valueOf(company.getId());
        String costTypeId = String.valueOf(costTypeInfo.getId());
        String TEMP_OSMatDiffRpt = null;
        String T_NCM_OSMaterialDetail = null;
        Connection conn = null;
        try {
            StringBuffer kSql = new StringBuffer();
            kSql.setLength(0);
            kSql.append(" create table TEMP_OSMatDiffRpt ( \n");
            kSql.append("    orderID         varchar(44),\n");
            kSql.append("    orderNumber     nvarchar(255),\n");
            kSql.append("    projectID       varchar(44),\n");
            kSql.append("    projectNumber   nvarchar(255),\n");
            kSql.append("    trackID         varchar(44),\n");
            kSql.append("    trackNumber     nvarchar(255),\n");
            kSql.append("    orderLot        nvarchar(255),\n");
            kSql.append("    prdID           varchar(44),\n");
            kSql.append("    prdNumber       nvarchar(255),\n");
            kSql.append("    prdName         nvarchar(255),\n");
            kSql.append("    prdMuID         varchar(44),\n");
            kSql.append("    prdMuName       nvarchar(255),\n");
            kSql.append("    storageQty      decimal(21,8) default(0),\n");
            kSql.append("    matID           varchar(44),\n");
            kSql.append("    matNumber       nvarchar(255),\n");
            kSql.append("    matName         nvarchar(255),\n");
            kSql.append("    stdChildQty     decimal(21,8) default(0),\n");
            kSql.append("    stdChildPrice   decimal(21,8) default(0),\n");
            kSql.append("    stdChildAmount  decimal(21,8) default(0),\n");
            kSql.append("    diffPrice       decimal(21,8) default(0),\n");
            kSql.append("    diffQty         decimal(21,8) default(0),\n");
            kSql.append("    actChildQty     decimal(21,8) default(0),\n");
            kSql.append("    actChildPrice   decimal(21,8) default(0),\n");
            kSql.append("    actChildAmount  decimal(21,8) default(0),\n");
            kSql.append("    totalDiffQty    decimal(21,8) default(0),\n");
            kSql.append("    totalDiffPrice  decimal(21,8) default(0),\n ");
            kSql.append("    totalDiffTotal  decimal(21,8) default(0),\n ");
            kSql.append("    priceDecimal    int default(2) \n ");
            kSql.append("  )\n ");
            TEMP_OSMatDiffRpt = TempTablePool.getInstance((Context)this.getContext()).createTempTable(kSql.toString());
            TempTablePool.getInstance((Context)this.getContext()).createIndex(TEMP_OSMatDiffRpt, "prdID,orderID,matID", false, false);
            T_NCM_OSMaterialDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_OSMaterialDetail");
            if (CostTypeLevelEnum.order.equals((Object)costTypeInfo.getLevel())) {
                this.fillOrderLevelData(filter, company, costTypeId, TEMP_OSMatDiffRpt, T_NCM_OSMaterialDetail);
            } else {
                this.fillProdectLevelData(filter, company, costTypeId, TEMP_OSMatDiffRpt, T_NCM_OSMaterialDetail);
            }
            conn = EJBFactory.getConnection((Context)this.getContext());
            TempTablePool.getInstance((Context)this.getContext()).analyzeTable(conn, TEMP_OSMatDiffRpt);
            kSql.setLength(0);
            kSql.append(" update " + TEMP_OSMatDiffRpt + " \n");
            kSql.append("    set stdChildQty = stdChildQty * storageQty \n");
            kSql.append("  where storageQty is not null \n");
            kSql.append("    and storageQty <> 0 \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" update " + TEMP_OSMatDiffRpt + " \n");
            kSql.append("    set stdChildAmount = stdChildAmount * storageQty \n");
            kSql.append("  where storageQty is not null \n");
            kSql.append("    and storageQty <> 0 \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" update " + TEMP_OSMatDiffRpt + " \n");
            kSql.append("    set diffPrice = stdChildQty*(actChildPrice-stdChildPrice) \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" update " + TEMP_OSMatDiffRpt + " \n");
            kSql.append("    set diffQty = actChildPrice*(actChildQty-stdChildQty) \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" update " + TEMP_OSMatDiffRpt + " \n");
            kSql.append("    set totalDiffQty = (actChildQty-stdChildQty) \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" update " + TEMP_OSMatDiffRpt + " \n");
            kSql.append("    set totalDiffPrice = (actChildPrice-stdChildPrice) \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" update " + TEMP_OSMatDiffRpt + " \n");
            kSql.append("    set totalDiffTotal = (actChildAmount-stdChildAmount) \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
            kSql.setLength(0);
            kSql.append(" delete from " + TEMP_OSMatDiffRpt + " \n");
            kSql.append("  where storageQty is null or storageQty = 0 \n");
            DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        }
        catch (Exception exc) {
            try {
                logger.error((Object)exc.getMessage(), (Throwable)exc);
                throw new BOSException((Throwable)exc);
            }
            catch (Throwable throwable) {
                try {
                    SQLUtils.cleanup(conn);
                    throw throwable;
                }
                catch (Throwable exc2) {
                    logger.error((Object)exc2.getMessage(), exc2);
                }
                throw throwable;
            }
        }
        try {
            SQLUtils.cleanup((Connection)conn);
            return TEMP_OSMatDiffRpt;
        }
        catch (Throwable exc) {
            logger.error((Object)exc.getMessage(), exc);
            return TEMP_OSMatDiffRpt;
        }
    }

    private void fillOrderLevelData(RptParams filter, CompanyOrgUnitInfo company, String costTypeId, String TEMP_OSMatDiffRpt, String T_NCM_OSMaterialDetail) throws Exception {
        Locale loc = this.getContext().getLocale();
        String companyId = company.getId().toString();
        PeriodInfo startPeriod = OrderCMUtils.getStartPeriod(this.getContext(), companyId);
        PeriodInfo currPeriod = OrderCMUtils.getCurrentPeriod(this.getContext(), companyId);
        Integer startPeriodNumber = new Integer(startPeriod.getNumber());
        Integer currPeriodNumber = new Integer(currPeriod.getNumber());
        Set periodIds = OrderCMUtils.getPeriodIds(this.getContext(), company, startPeriodNumber, currPeriodNumber);
        Map dataByOrderTbls = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyId, (Set)periodIds, (String)"T_NCM_DataByOrder");
        Map orderCostCalMatDetailResultTbls = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyId, (Set)periodIds, (String)"T_NCM_OrderCostCalMatDetailResult");
        String T_NCM_DataByOrder = "(" + DynamicTableManager.unionPhysicalTblNames((Map)dataByOrderTbls) + ")";
        String T_NCM_OrderCostCalMatDetailResult = "(" + DynamicTableManager.unionPhysicalTblNames((Map)orderCostCalMatDetailResultTbls) + ")";
        StringBuffer kSql = new StringBuffer();
        kSql.setLength(0);
        kSql.append(" insert into " + TEMP_OSMatDiffRpt + " ( \n");
        kSql.append("    orderID,\n");
        kSql.append("    orderNumber,\n");
        kSql.append("    projectID,\n");
        kSql.append("    projectNumber,\n");
        kSql.append("    trackID,\n");
        kSql.append("    trackNumber,\n");
        kSql.append("    orderLot,\n");
        kSql.append("    prdID,\n");
        kSql.append("    prdNumber,\n");
        kSql.append("    prdName,\n");
        kSql.append("    prdMuID,\n");
        kSql.append("    prdMuName,\n");
        kSql.append("    storageQty,\n");
        kSql.append("    matID,\n");
        kSql.append("    matNumber,\n");
        kSql.append("    matName,\n");
        kSql.append("    stdChildQty,\n");
        kSql.append("    stdChildPrice,\n");
        kSql.append("    stdChildAmount,\n");
        kSql.append("    diffPrice,\n");
        kSql.append("    diffQty,\n");
        kSql.append("    actChildQty,\n");
        kSql.append("    actChildPrice,\n");
        kSql.append("    actChildAmount,\n");
        kSql.append("    totalDiffQty,\n");
        kSql.append("    totalDiffPrice,\n ");
        kSql.append("    totalDiffTotal,\n ");
        kSql.append("    priceDecimal\n ");
        kSql.append("  )\n ");
        kSql.append(" select \n");
        kSql.append("    \tstdMatDetail.FOrderID as orderID,\n");
        kSql.append("    \tmOrder.FNumber as orderNumber,\n");
        kSql.append("    \tproject.FID as projectID,\n");
        kSql.append("    \tproject.FNumber as projectNumber,\n");
        kSql.append("    \ttrackNum.FID as trackID,\n");
        kSql.append("    \ttrackNum.FNumber as trackNumber,\n");
        kSql.append("    \tmOrder.FLot as orderLot,\n");
        kSql.append("    \tstdMatDetail.FParentMaterialID as prdID,\n");
        kSql.append("    \tpMat.FNumber as prdNumber,\n");
        kSql.append("    \tpMat.FName_" + loc + " as prdName,\n");
        kSql.append("    \tpMat.FBaseUnit as prdMuID,\n");
        kSql.append("    \tmu.FName_" + loc + " as prdMuName,\n");
        kSql.append("    \t0 as storageQty,\n");
        kSql.append("    \tstdMatDetail.FMaterialID as matID,\n");
        kSql.append("    \tcMat.FNumber as matNumber,\n");
        kSql.append("    \tcMat.FName_" + loc + " as matName,\n");
        kSql.append("    \tstdMatDetail.FChildQty as stdChildQty,\n");
        kSql.append("    \tstdMatDetail.FChildStdPrice as stdChildPrice,\n");
        kSql.append("    \tstdMatDetail.FChildAmount as stdChildAmount,\n");
        kSql.append("    \t0 as diffPrice,\n");
        kSql.append("    \t0 as diffQty,\n");
        kSql.append("    \t0 as actChildQty,\n");
        kSql.append("    \t0 as actChildPrice,\n");
        kSql.append("    \t0 as actChildAmount,\n");
        kSql.append("    \t0 as totalDiffQty,\n");
        kSql.append("    \t0 as totalDiffPrice,\n ");
        kSql.append("    \t0 as totalDiffTotal,\n ");
        kSql.append("    \tpMat.FPricePrecision as priceDecimal\n ");
        kSql.append("  from  " + T_NCM_OSMaterialDetail + " stdMatDetail \n ");
        kSql.append(" \t\t inner join T_MM_ManufactureOrder mOrder \n");
        kSql.append("   \t\ton stdMatDetail.FOrderID = mOrder.FID \n");
        kSql.append("        left outer join T_MM_Project project  \n");
        kSql.append("           on mOrder.FProjectID = project.FID \n");
        kSql.append("        left outer join T_MM_TrackNumber trackNum  \n");
        kSql.append("           on mOrder.FTrackID = trackNum.FID \n");
        kSql.append("        inner join T_BD_Material pMat  \n");
        kSql.append("   \t\ton stdMatDetail.FParentMaterialID = pMat.FID \n");
        kSql.append("        inner join T_BD_MeasureUnit mu \n");
        kSql.append("           on pMat.FBaseUnit = mu.FID \n");
        kSql.append(" \t\t inner join T_BD_Material cMat  \n");
        kSql.append("   \t\ton stdMatDetail.FMaterialID = cMat.FID \n");
        kSql.append(" where stdMatDetail.FCostTypeId = '" + costTypeId + "' \n");
        kSql.append("   and stdMatDetail.FSpreadPath = pMat.FNumber || ',' || cMat.FNumber");
        kSql.append("   " + this.buildOrderFilter(filter, "mOrder"));
        kSql.append("   and mOrder.FBaseStatus = 11 ");
        kSql.append(" order by mOrder.FNumber,pMat.FNumber,cMat.FNumber \n");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" update " + TEMP_OSMatDiffRpt + " rstData  \n");
        kSql.append("    set storageQty =   \n");
        kSql.append("    (  \n");
        kSql.append("     select FFinishedQty \n");
        kSql.append("       from  \n");
        kSql.append("           (  \n");
        kSql.append("            select actDataByOrder.FProductID,  \n");
        kSql.append("                   actDataByOrder.FOrderID,  \n");
        kSql.append("                   sum(isnull(actDataByOrder.FFinishedQty, 0)) as FFinishedQty  \n");
        kSql.append("              from " + T_NCM_DataByOrder + " actDataByOrder  \n");
        kSql.append("              group by actDataByOrder.FProductID,  \n");
        kSql.append("                       actDataByOrder.FOrderID \n");
        kSql.append("             ) actData  \n");
        kSql.append("       where actData.FProductID = rstData.prdID  \n");
        kSql.append("         and actData.FOrderID = rstData.orderID  \n");
        kSql.append("    )   \n");
        kSql.append(" where exists (  \n");
        kSql.append("              select 1  \n");
        kSql.append("                from " + T_NCM_DataByOrder + "  \n");
        kSql.append("               where FProductID = rstData.prdID  \n");
        kSql.append("                 and FOrderID = rstData.orderID   \n");
        kSql.append("              )  \n");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" update " + TEMP_OSMatDiffRpt + " rstData \n");
        kSql.append("    set (actChildQty, actChildPrice, actChildAmount) =  \n");
        kSql.append("    ( \n");
        kSql.append("     select FFinishedQty,FFinishedPrice,FFinishedAmount \n");
        kSql.append("       from \n");
        kSql.append("           ( \n");
        kSql.append("            select actMatDetail.FProductID, \n");
        kSql.append("                   actMatDetail.FOrderID, \n");
        kSql.append("                   actMatDetail.FMaterialID, \n");
        kSql.append("                   sum(isnull(actMatDetail.FFinishedQty, 0)) as FFinishedQty, \n");
        kSql.append("                   case \n");
        kSql.append("                      when sum(isnull(actMatDetail.FFinishedQty, 0)) = 0 then 0 \n");
        kSql.append("                      else \n");
        kSql.append("                        sum(isnull(actMatDetail.FFinishedAmount, 0))  \n");
        kSql.append("                        / \n");
        kSql.append("                        sum(isnull(actMatDetail.FFinishedQty, 0)) \n");
        kSql.append("                   end as FFinishedPrice, \n");
        kSql.append("                   sum(isnull(actMatDetail.FFinishedAmount, 0)) as FFinishedAmount \n");
        kSql.append("              from " + T_NCM_OrderCostCalMatDetailResult + " actMatDetail \n");
        kSql.append("              group by actMatDetail.FProductID, \n");
        kSql.append("                       actMatDetail.FOrderID, \n");
        kSql.append("                       actMatDetail.FMaterialID \n");
        kSql.append("             ) actData \n");
        kSql.append("       where actData.FProductID = rstData.prdID \n");
        kSql.append("         and actData.FOrderID = rstData.orderID \n");
        kSql.append("         and actData.FMaterialID = rstData.matID \n");
        kSql.append("    )  \n");
        kSql.append(" where exists ( \n");
        kSql.append("              select 1 \n");
        kSql.append("                from " + T_NCM_OrderCostCalMatDetailResult + " \n");
        kSql.append("               where FProductID = rstData.prdID \n");
        kSql.append("                 and FOrderID = rstData.orderID  \n");
        kSql.append("                 and FMaterialID = rstData.matID \n");
        kSql.append("              ) \n");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
    }

    private void fillProdectLevelData(RptParams filter, CompanyOrgUnitInfo company, String costTypeId, String TEMP_OSMatDiffRpt, String T_NCM_OSMaterialDetail) throws Exception {
        Locale loc = this.getContext().getLocale();
        PeriodInfo periodInfo = null;
        if (filter.getObject("period") instanceof PeriodInfo) {
            periodInfo = (PeriodInfo)filter.getObject("period");
        }
        Assert.that((periodInfo != null ? 1 : 0) != 0);
        String companyId = company.getId().toString();
        String T_NCM_DataByOrder = DynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)String.valueOf(periodInfo.getId()), (String)"T_NCM_DataByOrder");
        String T_NCM_OrderCostCalMatDetailResult = DynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)periodInfo.getId().toString(), (String)"T_NCM_OrderCostCalMatDetailResult");
        StringBuffer kSql = new StringBuffer();
        kSql.setLength(0);
        kSql.append(" insert into " + TEMP_OSMatDiffRpt + " ( \n");
        kSql.append("    orderID,\n");
        kSql.append("    orderNumber,\n");
        kSql.append("    projectID,\n");
        kSql.append("    projectNumber,\n");
        kSql.append("    trackID,\n");
        kSql.append("    trackNumber,\n");
        kSql.append("    orderLot,\n");
        kSql.append("    prdID,\n");
        kSql.append("    prdNumber,\n");
        kSql.append("    prdName,\n");
        kSql.append("    prdMuID,\n");
        kSql.append("    prdMuName,\n");
        kSql.append("    storageQty,\n");
        kSql.append("    matID,\n");
        kSql.append("    matNumber,\n");
        kSql.append("    matName,\n");
        kSql.append("    stdChildQty,\n");
        kSql.append("    stdChildPrice,\n");
        kSql.append("    stdChildAmount,\n");
        kSql.append("    diffPrice,\n");
        kSql.append("    diffQty,\n");
        kSql.append("    actChildQty,\n");
        kSql.append("    actChildPrice,\n");
        kSql.append("    actChildAmount,\n");
        kSql.append("    totalDiffQty,\n");
        kSql.append("    totalDiffPrice,\n ");
        kSql.append("    totalDiffTotal,\n ");
        kSql.append("    priceDecimal\n ");
        kSql.append("  )\n ");
        kSql.append(" select \n");
        kSql.append("    \tNULL as orderID,\n");
        kSql.append("    \tNULL as orderNumber,\n");
        kSql.append("    \tNULL as projectID,\n");
        kSql.append("    \tNULL as projectNumber,\n");
        kSql.append("    \tNULL as trackID,\n");
        kSql.append("    \tNULL as trackNumber,\n");
        kSql.append("    \tNULL as orderLot,\n");
        kSql.append("    \tstdMatDetail.FParentMaterialID as prdID,\n");
        kSql.append("    \tpMat.FNumber as prdNumber,\n");
        kSql.append("    \tpMat.FName_" + loc + " as prdName,\n");
        kSql.append("    \tpMat.FBaseUnit as prdMuID,\n");
        kSql.append("    \tmu.FName_" + loc + " as prdMuName,\n");
        kSql.append("    \t0 as storageQty,\n");
        kSql.append("    \tstdMatDetail.FMaterialID as matID,\n");
        kSql.append("    \tcMat.FNumber as matNumber,\n");
        kSql.append("    \tcMat.FName_" + loc + " as matName,\n");
        kSql.append("    \tstdMatDetail.FChildQty as stdChildQty,\n");
        kSql.append("    \tstdMatDetail.FChildStdPrice as stdChildPrice,\n");
        kSql.append("    \tstdMatDetail.FChildAmount as stdChildAmount,\n");
        kSql.append("    \t0 as diffPrice,\n");
        kSql.append("    \t0 as diffQty,\n");
        kSql.append("    \t0 as actChildQty,\n");
        kSql.append("    \t0 as actChildPrice,\n");
        kSql.append("    \t0 as actChildAmount,\n");
        kSql.append("    \t0 as totalDiffQty,\n");
        kSql.append("    \t0 as totalDiffPrice,\n ");
        kSql.append("    \t0 as totalDiffTotal,\n ");
        kSql.append("    \tpMat.FPricePrecision as priceDecimal\n ");
        kSql.append("  from  " + T_NCM_OSMaterialDetail + " stdMatDetail \n ");
        kSql.append("        inner join T_BD_Material pMat  \n");
        kSql.append("   \t\ton stdMatDetail.FParentMaterialID = pMat.FID \n");
        kSql.append("        inner join T_BD_MeasureUnit mu \n");
        kSql.append("           on pMat.FBaseUnit = mu.FID \n");
        kSql.append(" \t\t inner join T_BD_Material cMat  \n");
        kSql.append("   \t\ton stdMatDetail.FMaterialID = cMat.FID \n");
        kSql.append(" where stdMatDetail.FCostTypeId = '" + costTypeId + "' \n");
        kSql.append("   and stdMatDetail.FSpreadPath = pMat.FNumber || ',' || cMat.FNumber");
        kSql.append("   " + this.buildProductFilter(filter, "pMat"));
        kSql.append(" order by pMat.FNumber,cMat.FNumber \n");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" update " + TEMP_OSMatDiffRpt + " rstData  \n");
        kSql.append("    set storageQty =   \n");
        kSql.append("    (  \n");
        kSql.append("     select FFinishedQty \n");
        kSql.append("       from  \n");
        kSql.append("           (  \n");
        kSql.append("            select actDataByOrder.FProductID,  \n");
        kSql.append("                   sum(isnull(actDataByOrder.FFinishedQty, 0)) as FFinishedQty  \n");
        kSql.append("              from " + T_NCM_DataByOrder + " actDataByOrder  \n");
        kSql.append("              group by actDataByOrder.FProductID \n");
        kSql.append("             ) actData  \n");
        kSql.append("       where actData.FProductID = rstData.prdID  \n");
        kSql.append("    )   \n");
        kSql.append(" where exists (  \n");
        kSql.append("              select 1  \n");
        kSql.append("                from " + T_NCM_DataByOrder + "  \n");
        kSql.append("               where FProductID = rstData.prdID  \n");
        kSql.append("              )  \n");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
        kSql.setLength(0);
        kSql.append(" update " + TEMP_OSMatDiffRpt + " rstData \n");
        kSql.append("    set (actChildQty, actChildPrice, actChildAmount) =  \n");
        kSql.append("    ( \n");
        kSql.append("     select FFinishedQty,FFinishedPrice,FFinishedAmount \n");
        kSql.append("       from \n");
        kSql.append("           ( \n");
        kSql.append("            select actMatDetail.FProductID, \n");
        kSql.append("                   actMatDetail.FMaterialID, \n");
        kSql.append("                   sum(isnull(actMatDetail.FFinishedQty, 0)) as FFinishedQty, \n");
        kSql.append("                   case \n");
        kSql.append("                      when sum(isnull(actMatDetail.FFinishedQty, 0)) = 0 then 0 \n");
        kSql.append("                      else \n");
        kSql.append("                        to_decimal(sum(isnull(actMatDetail.FFinishedAmount, 0)),24,12)  \n");
        kSql.append("                        / \n");
        kSql.append("                        to_decimal(sum(isnull(actMatDetail.FFinishedQty, 0)),24,12) \n");
        kSql.append("                   end as FFinishedPrice, \n");
        kSql.append("                   sum(isnull(actMatDetail.FFinishedAmount, 0)) as FFinishedAmount \n");
        kSql.append("              from " + T_NCM_OrderCostCalMatDetailResult + " actMatDetail \n");
        kSql.append("              group by actMatDetail.FProductID, \n");
        kSql.append("                       actMatDetail.FMaterialID \n");
        kSql.append("             ) actData \n");
        kSql.append("       where actData.FProductID = rstData.prdID \n");
        kSql.append("         and actData.FMaterialID = rstData.matID \n");
        kSql.append("    )  \n");
        kSql.append(" where exists ( \n");
        kSql.append("              select 1 \n");
        kSql.append("                from " + T_NCM_OrderCostCalMatDetailResult + " \n");
        kSql.append("               where FProductID = rstData.prdID \n");
        kSql.append("                 and FMaterialID = rstData.matID \n");
        kSql.append("              ) \n");
        DbUtil.execute((Context)this.getContext(), (String)kSql.toString());
    }

    private StringBuffer buildOrderFilter(RptParams filter, String orderTblAlias) {
        ManufactureOrderInfo orderFrom = null;
        if (filter.getObject("orderFrom") instanceof ManufactureOrderInfo) {
            orderFrom = (ManufactureOrderInfo)filter.getObject("orderFrom");
        }
        ManufactureOrderInfo orderTo = null;
        if (filter.getObject("orderTo") instanceof ManufactureOrderInfo) {
            orderTo = (ManufactureOrderInfo)filter.getObject("orderTo");
        }
        StringBuffer fiterString = new StringBuffer("");
        if (orderFrom != null && orderFrom.getNumber() != null) {
            fiterString.append(" and " + orderTblAlias + ".FNumber >='" + orderFrom.getNumber() + "' \n");
        }
        if (orderTo != null && orderTo.getNumber() != null) {
            fiterString.append(" and " + orderTblAlias + ".FNumber <='" + orderTo.getNumber() + "' \n");
        }
        return fiterString;
    }

    private StringBuffer buildProductFilter(RptParams filter, String matTblAlias) {
        MaterialInfo materialFrom = null;
        if (filter.getObject("productFrom") instanceof MaterialInfo) {
            materialFrom = (MaterialInfo)filter.getObject("productFrom");
        }
        MaterialInfo materialTo = null;
        if (filter.getObject("productTo") instanceof MaterialInfo) {
            materialTo = (MaterialInfo)filter.getObject("productTo");
        }
        StringBuffer fiterString = new StringBuffer("");
        if (materialFrom != null && materialFrom.getNumber() != null) {
            fiterString.append(" and " + matTblAlias + ".FNumber >='" + materialFrom.getNumber() + "' \n");
        }
        if (materialTo != null && materialTo.getNumber() != null) {
            fiterString.append(" and " + matTblAlias + ".FNumber <='" + materialTo.getNumber() + "' \n");
        }
        return fiterString;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BOSException {
        ReportTitles titles = new ReportTitles();
        Context ctx = this.getContext();
        String companyName = "";
        if (filter.getObject("company") instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)filter.getObject("company");
            companyName = company.getName();
        }
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_Company", (Locale)ctx.getLocale()) + companyName);
        String costTypeName = "";
        if (filter.getObject("costType") instanceof CostTypeInfo) {
            CostTypeInfo costTypeInfo = (CostTypeInfo)filter.getObject("costType");
            costTypeName = costTypeInfo.getName();
        }
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCenterFeeDiffReport_CostType", (Locale)ctx.getLocale()) + costTypeName);
        String periodNumber = "";
        if (filter.getObject("period") instanceof PeriodInfo) {
            PeriodInfo periodInfo = (PeriodInfo)filter.getObject("period");
            periodNumber = String.valueOf(periodInfo.getNumber());
        }
        titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostDiffReport_Period", (Locale)ctx.getLocale()) + periodNumber);
        return titles;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        Context ctx = this.getContext();
        reportHeader.addChild("orderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OrderCostCalcVchRep_FOrderNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(0);
        reportHeader.addChild("projectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_ProjectNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(1);
        reportHeader.addChild("trackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_TrackNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(2);
        reportHeader.addChild("orderLot", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Lot", (Locale)ctx.getLocale())).setAlign(1).setIndex(3);
        reportHeader.addChild("prdNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_PorductNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(4);
        reportHeader.addChild("prdName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_PorductName", (Locale)ctx.getLocale())).setAlign(1).setIndex(5);
        reportHeader.addChild("prdMuName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCCActivityFeeTotalReport_UnitName", (Locale)ctx.getLocale())).setAlign(1).setIndex(6);
        reportHeader.addChild("storageQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"MaterialCostDiffReport_StorageQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        reportHeader.setIndex(7);
        reportHeader.addChild("matNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_matNumber", (Locale)ctx.getLocale())).setAlign(1).setIndex(8);
        reportHeader.addChild("matName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostTypeDiffReport_matName", (Locale)ctx.getLocale())).setAlign(1).setIndex(9);
        ReportHeader stdHeader = reportHeader.addChild("STD", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCenterFeeDiffReport_StdCost", (Locale)ctx.getLocale()));
        stdHeader.addChild("stdChildQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"MaterialCostDiffReport_StdChildQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        reportHeader.setIndex(10);
        stdHeader.addChild("stdChildPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"MaterialCostDiffReport_StdChildPrice", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("priceDecimal");
        reportHeader.setIndex(11);
        stdHeader.addChild("stdChildAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"MaterialCostDiffReport_StdChildAmount", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        reportHeader.setIndex(12);
        reportHeader.addChild("diffPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"MaterialCostDiffReport_DiffPrice", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        reportHeader.setIndex(13);
        reportHeader.addChild("diffQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"MaterialCostDiffReport_DiffQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        reportHeader.setIndex(14);
        ReportHeader actHeader = reportHeader.addChild("ACT", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCenterFeeDiffReport_ActualCost", (Locale)ctx.getLocale()));
        actHeader.addChild("actChildQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"MaterialCostDiffReport_ActChildQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        reportHeader.setIndex(15);
        actHeader.addChild("actChildPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"MaterialCostDiffReport_ActChildPrice", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("priceDecimal");
        reportHeader.setIndex(16);
        actHeader.addChild("actChildAmount", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"MaterialCostDiffReport_ActChildAmount", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        reportHeader.setIndex(17);
        reportHeader.addChild("totalDiffQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"MaterialCostDiffReport_TotalDiffQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        reportHeader.setIndex(18);
        reportHeader.addChild("totalDiffPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"MaterialCostDiffReport_TotalDiffPrice", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimalField("priceDecimal");
        reportHeader.setIndex(19);
        reportHeader.addChild("totalDiffTotal", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"MaterialCostDiffReport_TotalDiffTotal", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        reportHeader.setIndex(20);
        return reportHeader;
    }
}

