/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.order.std.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.base.report.app.ReportServerBase;
import com.kingdee.eas.base.report.formatcondition.Appearance;
import com.kingdee.eas.base.report.formatcondition.ReportFormatConditions;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.ncm.TimeUnitTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.ncm.common.dyntbl.app.DynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMDynamicTableManager;
import com.kingdee.eas.ncm.common.utils.app.NCMServerUtils;
import com.kingdee.eas.ncm.order.common.utils.OrderCMUtils;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeCollection;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeFactory;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeInfo;
import com.kingdee.eas.ncm.order.std.basedata.CostTypeLevelEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OCActivityCostDiffReport
extends ReportServerBase {
    public static final String RES_CLASSNAME = "com.kingdee.eas.ncm.order.fact.report.OCMatAllocTotalReportResource";
    private static Logger logger = Logger.getLogger(OCActivityCostDiffReport.class);

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        String tempTable = this.buildReportDataTempTable(filter);
        String ksql = "select * from " + tempTable;
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(tempTable);
        return rs;
    }

    protected String buildReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String tableName = this.buildReportDataTempTable(filter);
        this.setTablename(tableName);
        return super.getTablename();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        boolean isOnlyDisplayTotal = filter.getBoolean("isOnlyDisPalyTotal");
        String where = "";
        if (isOnlyDisplayTotal) {
            where = "where FIsTotalRow = 1 or FIsSubTotalRow = 1 \n";
        }
        String orderByMode = null;
        boolean isTotalRowTop = filter.getBoolean("isTotalRowTop");
        orderByMode = isTotalRowTop ? "desc" : "asc";
        StringBuffer ksql = new StringBuffer();
        ksql.append("select * from " + tableName + " \n");
        ksql.append(where);
        ksql.append("order by \n");
        ksql.append("FIsTotalRow " + orderByMode + ",");
        StringBuffer orderBy = new StringBuffer();
        if (this.isProductCostType(filter)) {
            orderBy.append("FProductNumber,");
        } else {
            orderBy.append("FOrderNumber,");
        }
        orderBy.append("FActivityNumber,");
        ksql.append(orderBy);
        ksql.deleteCharAt(ksql.length() - 1);
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)ksql.toString(), (int)start, (int)rows);
        return rs;
    }

    protected String createReportDataTempTable() throws BOSException {
        StringBuffer ksql = new StringBuffer();
        ksql.append("create table T ( \n");
        ksql.append("     FCalculatePeriodID varchar(44), \n");
        ksql.append("     FOrderID varchar(44), \n");
        ksql.append("     FOrderNumber varchar(80), \n");
        ksql.append("     FOrderName varchar(255), \n");
        ksql.append("     FProjectNumber varchar(80), \n");
        ksql.append("     FTrackNumber varchar(80), \n");
        ksql.append("     FLot nvarchar(255), \n");
        ksql.append("     FProductID varchar(44), \n");
        ksql.append("     FProductNumber varchar(80), \n");
        ksql.append("     FProductName nvarchar(255), \n");
        ksql.append("     FFinishedQty decimal(21,8) default(0), \n");
        ksql.append("     FQtyPrecision int default(4), \n");
        ksql.append("     FActivityID varchar(44), \n");
        ksql.append("     FActivityNumber varchar(80), \n");
        ksql.append("     FActivityName nvarchar(255), \n");
        ksql.append("     FTimeUnit int, \n");
        ksql.append("     FTimeUnitName nvarchar(255), \n");
        ksql.append("     FSCIntegratedQty decimal(21,8) default(0), \n");
        ksql.append("     FSCIntegratedRate decimal(21,8) default(0), \n");
        ksql.append("     FSCActivityCost decimal(21,8) default(0), \n");
        ksql.append("     FDiffPrice decimal(21,8) default(0), \n");
        ksql.append("     FDiffQty decimal(21,8) default(0), \n");
        ksql.append("     FFCActivityQty decimal(21,8) default(0), \n");
        ksql.append("     FFCActivityUnitCost decimal(21,8) default(0), \n");
        ksql.append("     FFCActivityCost decimal(21,8) default(0), \n");
        ksql.append("     FDiffPrice2 decimal(21,8) default(0), \n");
        ksql.append("     FDiffQty2 decimal(21,8) default(0), \n");
        ksql.append("     FDiffCost2 decimal(21,8) default(0), \n");
        ksql.append("     FIsSubTotalRow NUMERIC(17,4) default(0), \n");
        ksql.append("     FIsTotalRow NUMERIC(17,4) default(0) \n");
        ksql.append(") \n");
        String tempTable = null;
        try {
            tempTable = TempTablePool.getInstance((Context)this.getContext()).createTempTable(ksql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    protected String buildReportDataTempTable(RptParams filter) throws BOSException, EASBizException {
        if (this.isProductCostType(filter)) {
            return this.buildReportDataTempTableForProduct(filter);
        }
        return this.buildReportDataTempTableForOrder(filter);
    }

    protected String buildReportDataTempTableForProduct(RptParams filter) throws BOSException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)this.getContext());
        String companyId = company.getId().toString();
        String tempTable = this.createReportDataTempTable();
        CostTypeInfo costType = this.getCostType(filter);
        if (costType == null) {
            return tempTable;
        }
        String costTypeId = costType.getId().toString();
        PeriodInfo period = this.getPeriodInfo(company, filter);
        if (period == null) {
            return tempTable;
        }
        String periodId = period.getId().toString();
        String T_NCM_OSActivityDetail = null;
        String T_NCM_OrderCostCalActivityResult = null;
        String T_NCM_OrderCostCalActivityDetailResult = null;
        String T_NCM_DataByOrder = null;
        try {
            T_NCM_OSActivityDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_OSActivityDetail");
            T_NCM_OrderCostCalActivityResult = DynamicTableManager.getPhysicalTblName((Context)this.getContext(), (String)companyId, (String)periodId, (String)"T_NCM_OrderCostCalActivityResult");
            T_NCM_OrderCostCalActivityDetailResult = DynamicTableManager.getPhysicalTblName((Context)this.getContext(), (String)companyId, (String)periodId, (String)"T_NCM_OrderCostCalActivityDetailResult");
            T_NCM_DataByOrder = DynamicTableManager.getPhysicalTblName((Context)this.getContext(), (String)companyId, (String)periodId, (String)"T_NCM_DataByOrder");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        if (T_NCM_OSActivityDetail == null || T_NCM_OrderCostCalActivityDetailResult == null) {
            return tempTable;
        }
        String assistTable = this.createReportDataTempTable();
        String pWhere = this.buildProductFilter(filter);
        StringBuffer ksql = new StringBuffer();
        ksql.append("insert into " + assistTable + " ( \n");
        ksql.append("     FProductID, \n");
        ksql.append("     FActivityID, \n");
        ksql.append("     FSCIntegratedQty, \n");
        ksql.append("     FSCIntegratedRate, \n");
        ksql.append("     FSCActivityCost, \n");
        ksql.append("     FIsSubTotalRow, \n");
        ksql.append("     FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("     r.FParentMaterialID FProductID, \n");
        ksql.append("     r.FActivityID FActivityID, \n");
        ksql.append("     r.FActQty FSCIntegratedQty, \n");
        ksql.append("     r.FActStdPrice FSCIntegratedRate, \n");
        ksql.append("     r.FActAmount FSCActivityCost, \n");
        ksql.append("     0 FIsSubTotalRow, \n");
        ksql.append("     0 FIsTotalRow \n");
        ksql.append("from " + T_NCM_OSActivityDetail + " r \n");
        if (pWhere.length() > 0) {
            ksql.append("left join T_BD_Material p on p.FID = r.FParentMaterialID \n");
        }
        ksql.append("where 1 = 1 \n");
        ksql.append("and FCompanyID = '" + companyId + "' \n");
        ksql.append("and FCostTypeID = '" + costTypeId + "' \n");
        ksql.append(pWhere);
        ksql.append(" \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into " + assistTable + " ( \n");
        ksql.append("     FProductID, \n");
        ksql.append("     FActivityID, \n");
        ksql.append("     FFCActivityQty, \n");
        ksql.append("     FFCActivityUnitCost, \n");
        ksql.append("     FFCActivityCost, \n");
        ksql.append("     FIsSubTotalRow, \n");
        ksql.append("     FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("     r.FProductID FProductID, \n");
        ksql.append("     r.FActivityID FActivityID, \n");
        ksql.append("     0 FFCActivityQty, \n");
        ksql.append("     0 FFCActivityUnitCost, \n");
        ksql.append("     sum(r.FFinishedAmount) FFCActivityCost, \n");
        ksql.append("     0 FIsSubTotalRow, \n");
        ksql.append("     0 FIsTotalRow \n");
        ksql.append("from " + T_NCM_OrderCostCalActivityDetailResult + " r \n");
        if (pWhere.length() > 0) {
            ksql.append("left join T_BD_Material p on p.FID = r.FProductID \n");
        }
        ksql.append("where 1 = 1 \n");
        ksql.append("and FCompanyID = '" + companyId + "' \n");
        ksql.append("and FCalculatePeriodID = '" + periodId + "' \n");
        ksql.append(pWhere);
        ksql.append(" \n");
        ksql.append("group by r.FProductID, r.FActivityID \n");
        ksql.append("; \n");
        ksql.append("update " + assistTable + " t \n");
        ksql.append("set FFCActivityQty = isnull(( \n");
        ksql.append("    select sum(r.FFinishedQty) \n");
        ksql.append("    from " + T_NCM_OrderCostCalActivityResult + " r \n");
        ksql.append("    where r.FCompanyID = '" + companyId + "' \n");
        ksql.append("    and r.FCalculatePeriodID = '" + periodId + "' \n");
        ksql.append("    and r.FProductID = t.FProductID \n");
        ksql.append("    and r.FActivityID = t.FActivityID \n");
        ksql.append("), 0) \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("insert into " + tempTable + " ( \n");
        ksql.append("     FProductID, \n");
        ksql.append("     FActivityID, \n");
        ksql.append("     FSCIntegratedQty, \n");
        ksql.append("     FSCIntegratedRate, \n");
        ksql.append("     FSCActivityCost, \n");
        ksql.append("     FFCActivityQty, \n");
        ksql.append("     FFCActivityUnitCost, \n");
        ksql.append("     FFCActivityCost, \n");
        ksql.append("     FIsSubTotalRow, \n");
        ksql.append("     FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("     r.FProductID FProductID, \n");
        ksql.append("     r.FActivityID FActivityID, \n");
        ksql.append("     max(r.FSCIntegratedQty) FSCIntegratedQty, \n");
        ksql.append("     sum(r.FSCIntegratedRate) FSCIntegratedRate, \n");
        ksql.append("     sum(r.FSCActivityCost) FSCActivityCost, \n");
        ksql.append("     max(FFCActivityQty) FFCActivityQty, \n");
        ksql.append("     sum(FFCActivityUnitCost) FFCActivityUnitCost, \n");
        ksql.append("     sum(FFCActivityCost) FFCActivityCost, \n");
        ksql.append("     0 FIsSubTotalRow, \n");
        ksql.append("     0 FIsTotalRow \n");
        ksql.append("from " + assistTable + " r \n");
        ksql.append(" \n");
        ksql.append("group by r.FProductID, r.FActivityID \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set FFinishedQty = isnull(( \n");
        ksql.append("    select sum(r.FFinishedQty) \n");
        ksql.append("    from " + T_NCM_DataByOrder + " r \n");
        ksql.append("    where r.FProductID = t.FProductID \n");
        ksql.append("), 0) \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FTimeUnit, FTimeUnitName, FFCActivityQty) = ( \n");
        ksql.append("    select \n");
        ksql.append("        activity.FTimeUnit FTimeUnit, \n");
        ksql.append("\t     case when activity.FTimeUnit = 10 then '" + TimeUnitTypeEnum.hour.getAlias() + "' \n");
        ksql.append("\t         when activity.FTimeUnit = 20 then '" + TimeUnitTypeEnum.minute.getAlias() + "' \n");
        ksql.append("\t         when activity.FTimeUnit = 30 then '" + TimeUnitTypeEnum.second.getAlias() + "' \n");
        ksql.append("\t         else ' ' \n");
        ksql.append("\t     end as FTimeUnitName, \n");
        ksql.append("\t     case when activity.FTimeUnit = 10 then t.FFCActivityQty/3600 \n");
        ksql.append("\t         when activity.FTimeUnit = 20 then t.FFCActivityQty/60 \n");
        ksql.append("\t         else t.FFCActivityQty \n");
        ksql.append("\t     end as FFCActivityQty \n");
        ksql.append("    from T_NCM_Activity activity \n");
        ksql.append("    where activity.FID = t.FActivityID \n");
        ksql.append(") \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set FSCIntegratedQty = FFinishedQty * FSCIntegratedQty, \n");
        ksql.append("    FSCActivityCost = FFinishedQty * FSCActivityCost, \n");
        ksql.append("    FFCActivityUnitCost = ( \n");
        ksql.append("        case when FFCActivityQty <= 0 then 0 \n");
        ksql.append("        else FFCActivityCost/FFCActivityQty end \n");
        ksql.append("    ) \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set FDiffPrice = ( \n");
        ksql.append("        case when (FFCActivityQty = 0 and FFCActivityCost = 0) then 0 \n");
        ksql.append("        when FFCActivityQty = 0 then 0 \n");
        ksql.append("        when FFCActivityCost = 0 then FFCActivityCost - FSCActivityCost \n");
        ksql.append("        else FSCIntegratedQty * (FFCActivityUnitCost - FSCIntegratedRate) end \n");
        ksql.append("    ), \n");
        ksql.append("    FDiffQty = (  \n");
        ksql.append("        case when (FFCActivityQty = 0 and FFCActivityCost = 0) then 0 \n");
        ksql.append("        when FFCActivityQty = 0 then FFCActivityCost - FSCActivityCost \n");
        ksql.append("        when FFCActivityCost = 0 then 0 \n");
        ksql.append("        else FFCActivityUnitCost * (FFCActivityQty - FSCIntegratedQty) end \n");
        ksql.append("    ), \n");
        ksql.append("    FDiffQty2 = FFCActivityQty - FSCIntegratedQty, \n");
        ksql.append("    FDiffPrice2 = FFCActivityUnitCost - FSCIntegratedRate, \n");
        ksql.append("    FDiffCost2 = FFCActivityCost - FSCActivityCost \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FProductNumber, FProductName, FQtyPrecision) = ( \n");
        ksql.append("    select m.FNumber, m.FName_L2, mu.FQtyPrecision \n");
        ksql.append("    from T_BD_Material m \n");
        ksql.append("    left join T_BD_MeasureUnit mu on mu.FID = m.FBaseUnit \n");
        ksql.append("    where m.FID = t.FProductID \n");
        ksql.append(") \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FActivityNumber, FActivityName) = ( \n");
        ksql.append("    select a.FNumber, a.FName_L2 \n");
        ksql.append("    from T_NCM_Activity a \n");
        ksql.append("    where a.FID = t.FActivityID \n");
        ksql.append(") \n");
        ksql.append(";");
        ksql.append("delete from " + tempTable + " where FFinishedQty <= 0 or FFinishedQty is null \n");
        ksql.append(";");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(assistTable);
        return tempTable;
    }

    protected String buildReportDataTempTableForOrder(RptParams filter) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)this.getContext());
        String companyId = company.getId().toString();
        StringBuffer ksql = new StringBuffer();
        String tempTable = this.createReportDataTempTable();
        CostTypeInfo costType = this.getCostType(filter);
        if (costType == null) {
            return tempTable;
        }
        String costTypeId = costType.getId().toString();
        String orderFrom = filter.getString("orderFrom");
        String orderTo = filter.getString("orderTo");
        String oWhere = this.buildOrderFilter(filter);
        String assistTable = this.createReportDataTempTable();
        String assistTable2 = this.createReportDataTempTable();
        String T_NCM_OSActivityDetail = null;
        try {
            T_NCM_OSActivityDetail = NCMDynamicTableManager.getPhysicalTblNameWithCreate((Context)this.getContext(), (String)companyId, (String)"T_NCM_OSActivityDetail");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        ksql.append("insert into " + assistTable + " ( \n");
        ksql.append("     FOrderID, \n");
        ksql.append("     FActivityID, \n");
        ksql.append("     FSCIntegratedQty, \n");
        ksql.append("     FSCIntegratedRate, \n");
        ksql.append("     FSCActivityCost, \n");
        ksql.append("     FIsSubTotalRow, \n");
        ksql.append("     FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("     r.FOrderID FOrderID, \n");
        ksql.append("     r.FActivityID FActivityID, \n");
        ksql.append("     r.FActQty FSCIntegratedQty, \n");
        ksql.append("     r.FActStdPrice FSCIntegratedRate, \n");
        ksql.append("     r.FActAmount FSCActivityCost, \n");
        ksql.append("     0 FIsSubTotalRow, \n");
        ksql.append("     0 FIsTotalRow \n");
        ksql.append("from " + T_NCM_OSActivityDetail + " r \n");
        ksql.append("left join T_MM_ManufactureOrder o on o.FID = r.FOrderID \n");
        ksql.append("where 1 = 1 \n");
        ksql.append("and FCompanyID = '" + companyId + "' \n");
        ksql.append("and FCostTypeID = '" + costTypeId + "' \n");
        ksql.append("and o.FBaseStatus = 11 \n");
        ksql.append(oWhere);
        ksql.append(" \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        HashSet periodIds = new HashSet();
        HashSet<Integer> orderStatuses = new HashSet<Integer>();
        orderStatuses.add(new Integer(11));
        String periodId2 = null;
        Map map = OrderCMUtils.getPeriodIds(this.getContext(), company, null, orderFrom, orderTo, orderStatuses);
        if (map != null && map.size() > 0) {
            periodIds.addAll(map.values());
        }
        String T_NCM_OrderCostCalActivityResult = null;
        Map T_NCM_OrderCostCalActivityResults = null;
        String T_NCM_OrderCostCalActivityDetailResult = null;
        Map T_NCM_OrderCostCalActivityDetailResults = null;
        String T_NCM_DataByOrder = null;
        Map T_NCM_DataByOrders = null;
        if (periodIds.size() > 0) {
            try {
                T_NCM_OrderCostCalActivityResults = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyId, periodIds, (String)"T_NCM_OrderCostCalActivityResult");
                T_NCM_OrderCostCalActivityDetailResults = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyId, periodIds, (String)"T_NCM_OrderCostCalActivityDetailResult");
                T_NCM_DataByOrders = DynamicTableManager.getPhysicalTblNames((Context)this.getContext(), (String)companyId, periodIds, (String)"T_NCM_DataByOrder");
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            for (String periodId2 : periodIds) {
                T_NCM_OrderCostCalActivityDetailResult = (String)T_NCM_OrderCostCalActivityDetailResults.get(periodId2);
                T_NCM_OrderCostCalActivityResult = (String)T_NCM_OrderCostCalActivityResults.get(periodId2);
                if (T_NCM_OrderCostCalActivityDetailResult == null || T_NCM_OrderCostCalActivityResult == null) continue;
                ksql.append("insert into " + assistTable2 + " ( \n");
                ksql.append("     FCalculatePeriodID, \n");
                ksql.append("     FOrderID, \n");
                ksql.append("     FActivityID, \n");
                ksql.append("     FFCActivityQty, \n");
                ksql.append("     FFCActivityUnitCost, \n");
                ksql.append("     FFCActivityCost, \n");
                ksql.append("     FIsSubTotalRow, \n");
                ksql.append("     FIsTotalRow \n");
                ksql.append(") \n");
                ksql.append("select \n");
                ksql.append("     r.FCalculatePeriodID FCalculatePeriodID, \n");
                ksql.append("     r.FOrderID FOrderID, \n");
                ksql.append("     r.FActivityID FActivityID, \n");
                ksql.append("     0 FFCActivityQty, \n");
                ksql.append("     0 FFCActivityUnitCost, \n");
                ksql.append("     r.FFinishedAmount FFCActivityCost, \n");
                ksql.append("     0 FIsSubTotalRow, \n");
                ksql.append("     0 FIsTotalRow \n");
                ksql.append("from " + T_NCM_OrderCostCalActivityDetailResult + " r \n");
                ksql.append("left join T_MM_ManufactureOrder o on o.FID = r.FOrderID \n");
                ksql.append("where 1 = 1 \n");
                ksql.append("and FCompanyID = '" + companyId + "' \n");
                ksql.append("and FCalculatePeriodID = '" + periodId2 + "' \n");
                ksql.append("and o.FBaseStatus = 11 \n");
                ksql.append(oWhere);
                ksql.append(" \n");
                ksql.append("; \n");
                ksql.append("update " + assistTable2 + " t \n");
                ksql.append("set FFCActivityQty = isnull(( \n");
                ksql.append("    select sum(r.FFinishedQty) \n");
                ksql.append("    from " + T_NCM_OrderCostCalActivityResult + " r \n");
                ksql.append("    where r.FCompanyID = '" + companyId + "' \n");
                ksql.append("    and r.FCalculatePeriodID = '" + periodId2 + "' \n");
                ksql.append("    and r.FOrderID = t.FOrderID \n");
                ksql.append("    and r.FActivityID = t.FActivityID \n");
                ksql.append("), 0) \n");
                ksql.append("where FCalculatePeriodID = '" + periodId2 + "' \n");
                ksql.append("; \n");
                NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
                ksql.setLength(0);
            }
        }
        ksql.append("insert into " + assistTable + " ( \n");
        ksql.append("     FOrderID, \n");
        ksql.append("     FActivityID, \n");
        ksql.append("     FSCIntegratedQty, \n");
        ksql.append("     FSCIntegratedRate, \n");
        ksql.append("     FSCActivityCost, \n");
        ksql.append("     FFCActivityQty, \n");
        ksql.append("     FFCActivityUnitCost, \n");
        ksql.append("     FFCActivityCost, \n");
        ksql.append("     FIsSubTotalRow, \n");
        ksql.append("     FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("     r.FOrderID FOrderID, \n");
        ksql.append("     r.FActivityID FActivityID, \n");
        ksql.append("     0 FSCIntegratedQty, \n");
        ksql.append("     0 FSCIntegratedRate, \n");
        ksql.append("     0 FSCActivityCost, \n");
        ksql.append("     sum(FFCActivityQty) FFCActivityQty, \n");
        ksql.append("     sum(FFCActivityUnitCost) FFCActivityUnitCost, \n");
        ksql.append("     sum(FFCActivityCost) FFCActivityCost, \n");
        ksql.append("     0 FIsSubTotalRow, \n");
        ksql.append("     0 FIsTotalRow \n");
        ksql.append("from " + assistTable2 + " r \n");
        ksql.append(" \n");
        ksql.append("group by r.FOrderID, r.FActivityID \n");
        ksql.append("; \n");
        ksql.append("insert into " + tempTable + " ( \n");
        ksql.append("     FOrderID, \n");
        ksql.append("     FActivityID, \n");
        ksql.append("     FSCIntegratedQty, \n");
        ksql.append("     FSCIntegratedRate, \n");
        ksql.append("     FSCActivityCost, \n");
        ksql.append("     FFCActivityQty, \n");
        ksql.append("     FFCActivityUnitCost, \n");
        ksql.append("     FFCActivityCost, \n");
        ksql.append("     FIsSubTotalRow, \n");
        ksql.append("     FIsTotalRow \n");
        ksql.append(") \n");
        ksql.append("select \n");
        ksql.append("     r.FOrderID FOrderID, \n");
        ksql.append("     r.FActivityID FActivityID, \n");
        ksql.append("     max(r.FSCIntegratedQty) FSCIntegratedQty, \n");
        ksql.append("     sum(r.FSCIntegratedRate) FSCIntegratedRate, \n");
        ksql.append("     sum(r.FSCActivityCost) FSCActivityCost, \n");
        ksql.append("     max(FFCActivityQty) FFCActivityQty, \n");
        ksql.append("     sum(FFCActivityUnitCost) FFCActivityUnitCost, \n");
        ksql.append("     sum(FFCActivityCost) FFCActivityCost, \n");
        ksql.append("     0 FIsSubTotalRow, \n");
        ksql.append("     0 FIsTotalRow \n");
        ksql.append("from " + assistTable + " r \n");
        ksql.append(" \n");
        ksql.append("group by r.FOrderID, r.FActivityID \n");
        ksql.append("; \n");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        if (T_NCM_DataByOrders != null) {
            for (String periodId2 : periodIds) {
                T_NCM_DataByOrder = (String)T_NCM_DataByOrders.get(periodId2);
                if (T_NCM_DataByOrder == null) continue;
                ksql.append("update " + tempTable + " t \n");
                ksql.append("set FFinishedQty = isnull(t.FFinishedQty, 0) + isnull(( \n");
                ksql.append("    select sum(r.FFinishedQty) \n");
                ksql.append("    from " + T_NCM_DataByOrder + " r \n");
                ksql.append("    where r.FOrderID = t.FOrderID \n");
                ksql.append("), 0) \n");
                ksql.append(";");
            }
        }
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set FSCIntegratedQty = FFinishedQty * FSCIntegratedQty, \n");
        ksql.append("    FSCActivityCost = FFinishedQty * FSCActivityCost, \n");
        ksql.append("    FFCActivityUnitCost = ( \n");
        ksql.append("        case when FFCActivityQty <= 0 then 0 \n");
        ksql.append("        else FFCActivityCost/FFCActivityQty end \n");
        ksql.append("    ) \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set FDiffPrice = ( \n");
        ksql.append("        case when (FFCActivityQty = 0 and FFCActivityCost = 0) then 0 \n");
        ksql.append("        when FFCActivityQty = 0 then 0 \n");
        ksql.append("        when FFCActivityCost = 0 then FFCActivityCost - FSCActivityCost \n");
        ksql.append("        else FSCIntegratedQty * (FFCActivityUnitCost - FSCIntegratedRate) end \n");
        ksql.append("    ), \n");
        ksql.append("    FDiffQty = (  \n");
        ksql.append("        case when (FFCActivityQty = 0 and FFCActivityCost = 0) then 0 \n");
        ksql.append("        when FFCActivityQty = 0 then FFCActivityCost - FSCActivityCost \n");
        ksql.append("        when FFCActivityCost = 0 then 0 \n");
        ksql.append("        else FFCActivityUnitCost * (FFCActivityQty - FSCIntegratedQty) end \n");
        ksql.append("    ), \n");
        ksql.append("    FDiffQty2 = FFCActivityQty - FSCIntegratedQty, \n");
        ksql.append("    FDiffPrice2 = FFCActivityUnitCost - FSCIntegratedRate, \n");
        ksql.append("    FDiffCost2 = FFCActivityCost - FSCActivityCost \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FOrderNumber, FProjectNumber, FTrackNumber, FLot, FProductNumber, FProductName, FQtyPrecision) = ( \n");
        ksql.append("    select o.FNumber, project.FNumber, track.FNumber, o.FLot, m.FNumber, m.FName_l2, mu.FQtyPrecision \n");
        ksql.append("    from T_MM_ManufactureOrder o \n");
        ksql.append("    left join T_MM_Project project on project.FID = o.FProjectID \n");
        ksql.append("    left join T_MM_TrackNumber track on track.FID = o.FTrackID \n");
        ksql.append("    left join T_BD_Material m on m.FID = o.FMaterialID \n");
        ksql.append("    left join T_BD_MeasureUnit mu on mu.FID = m.FBaseUnit \n");
        ksql.append("    where o.FID = t.FOrderID \n");
        ksql.append(") \n");
        ksql.append(";");
        ksql.append("update " + tempTable + " t \n");
        ksql.append("set (FActivityNumber, FActivityName) = ( \n");
        ksql.append("    select a.FNumber, a.FName_L2 \n");
        ksql.append("    from T_NCM_Activity a \n");
        ksql.append("    where a.FID = t.FActivityID \n");
        ksql.append(") \n");
        ksql.append(";");
        ksql.append("delete from " + tempTable + " where FFinishedQty <= 0 or FFinishedQty is null \n");
        ksql.append(";");
        NCMServerUtils.BatchSqlExecute((Context)this.getContext(), (String)ksql.toString());
        ksql.setLength(0);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(assistTable);
        TempTablePool.getInstance((Context)this.getContext()).releaseTable(assistTable2);
        return tempTable;
    }

    public boolean isOnlyDisplayTotal(RptParams filter) {
        return filter.getBoolean("isOnlyDisPalyTotal");
    }

    public boolean isTotalRowTop(RptParams filter) {
        return filter.getBoolean("isTotalRowTop");
    }

    private PeriodInfo getPeriodInfo(CompanyOrgUnitInfo company, RptParams filter) {
        PeriodInfo result = null;
        String period = filter.getString("period");
        if (!StringUtils.isEmpty((String)period)) {
            try {
                Integer periodNumber = new Integer(Integer.parseInt(period));
                result = OrderCMUtils.getPeriodInfo(this.getContext(), company, periodNumber);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    private String buildProductFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("productFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and p.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("productTo")))) {
            ksql.append(" and p.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    private String buildOrderFilter(RptParams filter) {
        StringBuffer ksql = new StringBuffer();
        String temp = filter.getString("orderFrom");
        if (!StringUtils.isEmpty((String)temp)) {
            ksql.append(" and o.FNumber >= '").append(temp).append("'");
        }
        if (!StringUtils.isEmpty((String)(temp = filter.getString("orderTo")))) {
            ksql.append(" and o.FNumber <= '").append(temp).append("'");
        }
        return ksql.toString();
    }

    protected ReportFormatConditions buildReportFormatConditions(String reportID) throws Exception {
        ReportFormatConditions conditions = new ReportFormatConditions();
        Appearance a = new Appearance();
        a.backColor = new Color(255, 255, 164);
        conditions.add("FIsSubTotalRow", 1, (Object)new BigDecimal(1), a);
        a = new Appearance();
        a.backColor = new Color(190, 250, 198);
        conditions.add("FIsTotalRow", 1, (Object)new BigDecimal(1), a);
        return conditions;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        ReportTitles titles = new ReportTitles();
        Context ctx = this.getContext();
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCMaterialCostStatReport_Title_Company", (Locale)ctx.getLocale()) + company.getName());
        titles.AddTitle(1, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCenterFeeDiffReport_CostType", (Locale)ctx.getLocale()) + filter.getString("costType"));
        if (this.isProductCostType(filter)) {
            titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostDiffReport_Period", (Locale)ctx.getLocale()) + filter.getString("period"));
        }
        return titles;
    }

    public boolean isProductCostType(RptParams filter) throws BOSException {
        CostTypeInfo costType = this.getCostType(filter);
        return costType != null && costType.getLevel().equals((Object)CostTypeLevelEnum.product);
    }

    public CostTypeInfo getCostType(RptParams filter) throws BOSException {
        Object temp = filter.getObject("costTypeInfo");
        if (temp != null && temp instanceof CostTypeInfo) {
            return (CostTypeInfo)temp;
        }
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)this.getContext());
        String number = filter.getString("costType");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        view.setFilter(filterInfo);
        CostTypeCollection coll = CostTypeFactory.getLocalInstance(this.getContext()).getCostTypeCollection(view);
        if (coll.size() > 0) {
            temp = coll.get(0);
            filter.setObject("costTypeInfo", temp);
            return (CostTypeInfo)temp;
        }
        return null;
    }

    protected String buildFilterRange(String from, String to) {
        Context ctx = this.getContext();
        if (StringUtils.isEmpty((String)from) && StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_All", (Locale)ctx.getLocale());
        }
        if (StringUtils.isEmpty((String)from)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_FirstFrom", (Locale)ctx.getLocale()) + to;
        }
        if (StringUtils.isEmpty((String)to)) {
            return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_From", (Locale)ctx.getLocale()) + from + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_ToEnd", (Locale)ctx.getLocale());
        }
        return ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_From", (Locale)ctx.getLocale()) + from + ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_Title_To", (Locale)ctx.getLocale()) + to;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader reportHeader = new ReportHeader();
        ReportHeader childHeader = null;
        int index = 0;
        Context ctx = this.getContext();
        if (this.isProductCostType(filter)) {
            reportHeader.addChild("FProductNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_PorductNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FProductName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_PorductName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        } else {
            reportHeader.addChild("FOrderNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OrderCostCalcVchRep_FOrderNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FProjectNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_ProjectNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FTrackNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_TrackNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FLot", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivitCostStatReport_ColName_Lot", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FProductNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_PorductNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
            reportHeader.addChild("FProductName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_PorductName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        }
        childHeader = reportHeader.addChild("FFinishedQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OrderCostCalcVchRep_FTotalFinishedQty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2);
        childHeader.setDecimalField("FQtyPrecision");
        childHeader.setMergeable(true);
        reportHeader.addChild("FActivityNumber", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_ActivityNumber", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FActivityName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_ActivityName", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        reportHeader.addChild("FTimeUnitName", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityHourCostReport_ColName_TimeUnit", (Locale)ctx.getLocale()), index++).setAlign(1).setMergeable(true);
        ReportHeader scHeader = reportHeader.addChild("FSC", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCenterFeeDiffReport_StdCost", (Locale)ctx.getLocale()), index++);
        scHeader.addChild("FSCIntegratedQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostDiffReport_SCIntegratedQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        scHeader.addChild("FSCIntegratedRate", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostDiffReport_SCIntegratedRate", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        scHeader.addChild("FSCActivityCost", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostDiffReport_SCActivityCost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        reportHeader.addChild("FDiffPrice", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostDiffReport_DiffPrice", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimal(2);
        reportHeader.addChild("FDiffQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostDiffReport_DiffQty", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimal(2);
        ReportHeader fcHeader = reportHeader.addChild("FFC", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCCostCenterFeeDiffReport_ActualCost", (Locale)ctx.getLocale()), index++);
        fcHeader.addChild("FFCActivityQty", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostDiffReport_FCActivityQty", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        fcHeader.addChild("FFCActivityUnitCost", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostDiffReport_FCActivityUnitCost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        fcHeader.addChild("FFCActivityCost", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostDiffReport_FCActivityCost", (Locale)ctx.getLocale())).setAlign(3).setType(2).setDecimal(2);
        reportHeader.addChild("FDiffPrice2", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostDiffReport_DiffPrice2", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimal(2);
        reportHeader.addChild("FDiffQty2", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostDiffReport_DiffQty2", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimal(2);
        reportHeader.addChild("FDiffCost2", ResourceBase.getString((String)"com.kingdee.eas.ncm.order.fact.report.ReportResource", (String)"OCActivityCostDiffReport_DiffCost2", (Locale)ctx.getLocale()), index++).setAlign(3).setType(2).setDecimal(2);
        return reportHeader;
    }

    protected String getResource(String resName) {
        return ResourceBase.getString((String)RES_CLASSNAME, (String)resName, (Locale)this.getContext().getLocale());
    }
}

