/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ncm.std.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.BOMUsageEnum;
import com.kingdee.eas.ncm.common.utils.app.NCMDbUtil;
import com.kingdee.eas.ncm.std.basedata.STCostBOMQueueCollection;
import com.kingdee.eas.ncm.std.basedata.STCostBOMQueueInfo;
import com.kingdee.eas.ncm.std.basedata.app.AbstractSTCostBOMQueueControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class STCostBOMQueueControllerBean
extends AbstractSTCostBOMQueueControllerBean {
    private static final long serialVersionUID = -3871347901802909897L;
    private static Logger logger = Logger.getLogger((String)STCostBOMQueueControllerBean.class.getName());

    @Override
    protected void _generate(Context ctx, boolean isCover) throws BOSException, EASBizException {
        if (!isCover) {
            IRowSet rst = NCMDbUtil.executeQuery((Context)ctx, (String)" select count(fid) as fidCount from T_NCM_SCBOMQueue ");
            try {
                if (rst.next() && rst.getInt("fidCount") > 0) {
                    return;
                }
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        NCMDbUtil.execute((Context)ctx, (String)" delete from T_NCM_SCBOMQueue ");
        ArrayList<BOMUsageEnum> enums = new ArrayList<BOMUsageEnum>();
        enums.add(BOMUsageEnum.Master);
        int size = enums.size();
        String[] valueList = new String[size];
        String[] aliasList = new String[size];
        for (int i = 0; i < size; ++i) {
            BOMUsageEnum iEnum = (BOMUsageEnum)enums.get(i);
            valueList[i] = String.valueOf(iEnum.getValue());
            aliasList[i] = iEnum.getAlias();
        }
        ArrayList numberQueue = new ArrayList();
        ArrayList valueQueue = new ArrayList();
        ArrayList aliasQueue = new ArrayList();
        this.perform(valueList, aliasList, 0, size - 1, numberQueue, valueQueue, aliasQueue);
        STCostBOMQueueCollection col = new STCostBOMQueueCollection();
        for (int i = 0; i < numberQueue.size(); ++i) {
            String number = this.getNumber(i + 1);
            String value = valueQueue.get(i).toString();
            String aliase = aliasQueue.get(i).toString();
            STCostBOMQueueInfo info = new STCostBOMQueueInfo();
            info.setNumber(number);
            info.setValueQueue(value);
            info.setAliasQueue(aliase);
            col.add(info);
            this._addnew(ctx, (IObjectValue)info);
        }
    }

    private void perform(String[] valueList, String[] aliasList, int u, int v, List numberQueue, List valueQueue, List aliasQueue) {
        if (u > v) {
            StringBuffer sbValue = new StringBuffer();
            StringBuffer sbAlias = new StringBuffer();
            for (int i = 0; i <= v; ++i) {
                sbValue.append(valueList[i]).append("\u3001");
                sbAlias.append(aliasList[i]).append("\u3001");
            }
            if (sbValue.length() > 0) {
                sbValue.setLength(sbValue.length() - 1);
                sbAlias.setLength(sbAlias.length() - 1);
            }
            numberQueue.add(null);
            valueQueue.add(sbValue.toString());
            aliasQueue.add(sbAlias.toString());
        } else {
            for (int i = u; i <= v; ++i) {
                this.swap(valueList, u, i);
                this.swap(aliasList, u, i);
                this.perform(valueList, aliasList, u + 1, v, numberQueue, valueQueue, aliasQueue);
                this.swap(valueList, u, i);
                this.swap(aliasList, u, i);
            }
        }
    }

    private void swap(String[] list, int i, int j) {
        String temp = list[i];
        list[i] = list[j];
        list[j] = temp;
    }

    private String getNumber(int i) {
        if (i < 1 || i > 9999) {
            return null;
        }
        String prefix = "STD";
        if (i < 10) {
            return prefix + "000" + i;
        }
        if (i < 100) {
            return prefix + "00" + i;
        }
        if (i < 1000) {
            return prefix + "0" + i;
        }
        return prefix + i;
    }
}

